function ueQuantityIncrementButtons(widgetId, addToCartId){  
  
  // Clases
  var addedClass, g_classDefaultInput, g_addToCartClass1, g_addToCartClass2, g_widgetClass;
  
  // Selectores
  var g_plusSelector, g_minusSelector, g_addToCartSelector1, g_addToCartSelector2, g_addToCartSelector3, g_inputNumberSelector, g_widgetSelector;
  
  // Objetos
  var g_objButtonsWidget, g_objMessage, g_objInputNumber, g_objFilterableGrid, g_objBody, g_objPlusButton, g_objMinusButton;
  
  // Atributos personalizados
  var g_dataQuatity;
  
  // Helpers
  var g_productQuantity;
  
  /**
   * Encontrar el padre que tiene el botón "Agregar al carrito"
   */
  function getProductItemParent(objButton) {
    var objParent = objButton.parent();
  
    while (objParent.length > 0) {
      var addToCartNum1 = objParent.find(g_addToCartSelector1).length;
      var addToCartNum2 = objParent.find(g_addToCartSelector2).length;
      var addToCartNum3 = objParent.find(g_addToCartSelector3).length;     
      var objOutOfStock1 = objParent.find(".stock.out-of-stock");
      var objOutOfStock2 = objParent.find(".outofstock");
      
      if(objOutOfStock1 && objOutOfStock1.length > 0 || objOutOfStock2 && objOutOfStock2.length > 0)
        g_objButtonsWidget.hide();

      if (addToCartNum1 > 0) 
        return(objParent); 
      
      if (addToCartNum2 > 0) 
        return(objParent);    
      
      objParent = objParent.parent();
    }
    
    // Mostrar error: no se encontró el botón "Agregar al carrito"
    g_objMessage.show();
    
    return(null);
  }
  
  /**
   * Obtener el botón de "Agregar al carrito"
   */
  function getAddToCart(objParentItem){
    var objAddToCartButton = objParentItem.find(g_addToCartSelector1);
    
    if(!objAddToCartButton.length)
      objAddToCartButton = objParentItem.find(g_addToCartSelector2);
    
    if(!objAddToCartButton.length)
      objAddToCartButton = objParentItem.find(g_addToCartSelector3);

    if(!objAddToCartButton.length)
      objAddToCartButton = jQuery(`#${addToCartId}`).find(g_addToCartSelector1);

    if(!objAddToCartButton.length)
      objAddToCartButton = jQuery(`#${addToCartId}`).find(g_addToCartSelector2);

    if(!objAddToCartButton.length)
      objAddToCartButton = jQuery(`#${addToCartId}`).find(g_addToCartSelector3);
    
    return(objAddToCartButton);
  }
  
  /**
   * Función para incrementar la cantidad
   */
  function plusItem(objButton){
    var objParentItem = getProductItemParent(objButton);    
    var objAddToCartButton = getAddToCart(objParentItem);

    // Incrementa la cantidad solo si ya está en el carrito
    if (g_productQuantity >= 5) {
        g_productQuantity++; // Incrementa en 1
    }

    // Actualiza el valor en el campo de entrada
    g_objInputNumber.val(g_productQuantity);

    // Actualiza el valor en el input predeterminado si existe
    var objDefaultInput = getDefaultInput();
    if (objDefaultInput != false) {
        objDefaultInput.val(g_productQuantity);
    }

    // Actualiza el atributo data-quantity del botón de agregar al carrito
    objAddToCartButton.attr(g_dataQuatity, g_productQuantity); 

    // Habilitar el botón de menos si la cantidad es mayor que 2
    g_objMinusButton.prop('disabled', false); 
} 

  /**
   * Función para disminuir la cantidad
   */
  function minusItem(objButton) {
    var objParentItem = getProductItemParent(objButton);    
    var objAddToCartButton = getAddToCart(objParentItem);

    // Decrementa la cantidad
    g_productQuantity--;

    // Asegurarse de que la cantidad no baje de 2
    if (g_productQuantity < 5) {
        g_productQuantity = 5; // La cantidad no puede ser menor que 2
    }

    // Actualiza el valor en el campo de entrada
    g_objInputNumber.val(g_productQuantity);

    // Actualiza el valor en el input predeterminado si existe
    var objDefaultInput = getDefaultInput();
    if (objDefaultInput != false) {
        objDefaultInput.val(g_productQuantity);
    }

    // Actualiza el atributo data-quantity del botón de agregar al carrito
    objAddToCartButton.attr(g_dataQuatity, g_productQuantity);

    // Deshabilita el botón de menos si la cantidad es 2
    if (g_productQuantity == 5) {
        g_objMinusButton.prop('disabled', true); 
    }
  }

  /**
   * Función cuando cambia el valor de la cantidad
   */
  function onQuantityInputChange(objInput) {
    var objParentItem = getProductItemParent(objInput);    
    var objAddToCartButton = getAddToCart(objParentItem);

    // Obtener el valor del campo de entrada
    g_productQuantity = parseInt(objInput.val());

    // Asegurarse de que la cantidad no baje de 2
    if (g_productQuantity < 5) {
        g_productQuantity = 5; // La cantidad no puede ser menor que 2
    }

    // Actualiza el atributo data-quantity del botón de agregar al carrito
    objAddToCartButton.attr(g_dataQuatity, g_productQuantity); 

    // Habilitar el botón de disminución si la cantidad es mayor que 2
    g_objMinusButton.prop('disabled', false); 

    // Actualiza el valor en el input predeterminado si existe
    var objDefaultInput = getDefaultInput();
    if (objDefaultInput != false) {
        objDefaultInput.val(g_productQuantity);
    }

    // Deshabilitar el botón de menos si la cantidad es 2
    if (g_productQuantity == 5) {
        g_objMinusButton.prop('disabled', true); 
    }
  }

  /**
   * Evento de agregado al carrito
   */
  function onAddedToCart(){
    var objParentItem = getProductItemParent(g_objInputNumber);    
    var objAddToCartButton = getAddToCart(objParentItem);

    // Restablecer la cantidad a 2 al agregar al carrito
    g_productQuantity = 5;
    g_objInputNumber.val(g_productQuantity);

    // Actualizar el atributo data-quantity
    objAddToCartButton.attr(g_dataQuatity, g_productQuantity); 

    // Mostrar el botón de "Agregar al carrito" si estaba oculto
    if(objAddToCartButton.hasClass(addedClass) == true)
        objAddToCartButton.show();    
    
    // Actualizar el valor en el input predeterminado si existe
    var objDefaultInput = getDefaultInput();
    if (objDefaultInput != false)
        objDefaultInput.val(g_productQuantity);
  }

  /**
   * Función para obtener el input predeterminado
   */
  function getDefaultInput(){
    var objParentItem = getProductItemParent(g_objInputNumber);    
    var objAddToCartButton = getAddToCart(objParentItem);
    var objDefaultInput = objAddToCartButton.prev().find("input");
    
    if(!objDefaultInput.length)
      return(false);

    return(objDefaultInput);
  }
  
  /**
   * Función para ocultar el input predeterminado
   */
  function hideDefaultInput(){
    var objDefaultInput = getDefaultInput();
    
    if(!objDefaultInput.length)
      return(false);
    
    objDefaultInput.hide();
  }
  
  /**
   * Función para quitar los eventos
   */
  function removeEventHandlers(){
    g_objPlusButton.unbind('click');
    g_objMinusButton.unbind('click');
    g_objInputNumber.unbind('input');
    g_objBody.unbind("added_to_cart", onAddedToCart);
  }
  
  /**
   * Función para restablecer la cantidad
   */
  function resetDataQuantity(){
    var objParentItem = getProductItemParent(g_objInputNumber);    
    var objAddToCartButton = getAddToCart(objParentItem);

    // Restablecer la cantidad a 2
    g_productQuantity = 5;
    g_objInputNumber.val(g_productQuantity);

    objAddToCartButton.attr(g_dataQuatity, g_productQuantity);

    var objDefaultInput = getDefaultInput();

    if (objDefaultInput != false)
      objDefaultInput.val(g_productQuantity);
  }
  
  /**
   * Inicializar las variables
   */
  function initVars(){
    // Clases
    addedClass = "added";
    g_classDefaultInput = "wcmmq-qty-input-box";

    var plusClass = "ue-count-buttons-plus";
    var minusClass = "ue-count-buttons-minus";
    var inputNumberClass = "ue-count-buttons-input";
    var addToCartClass1 = "add_to_cart_button";
    var addToCartClass2 = "single_add_to_cart_button";    
    var messageClass = "ue-message";
    var filterableGridClass = "uc-filterable-grid";

    // Atributo personalizado
    g_dataQuatity = "data-quantity";

    // Selectores
    var messageSelector = "."+messageClass;
    var filterableGridSelector = "."+filterableGridClass;

    g_plusSelector = "."+plusClass;
    g_minusSelector = "."+minusClass;
    g_addToCartSelector1 = "."+addToCartClass1;
    g_addToCartSelector2 = "."+addToCartClass2;
    g_addToCartSelector3 = '[name="add-to-cart"]';
    g_inputNumberSelector = "."+inputNumberClass;

    // Helpers
    g_productQuantity = 5;  // Establecer la cantidad inicial en 2

    // Objetos    
    g_objButtonsWidget = jQuery("#"+widgetId);  
    g_objMessage = g_objButtonsWidget.find(messageSelector);  
    g_objInputNumber = g_objButtonsWidget.find(g_inputNumberSelector);
    g_objFilterableGrid = g_objButtonsWidget.parents(filterableGridSelector); 
    g_objPlusButton = g_objButtonsWidget.find(g_plusSelector);
    g_objMinusButton = g_objButtonsWidget.find(g_minusSelector);
    g_objBody = jQuery("body"); 

    // Establecer 2 como valor predeterminado en el input
    g_objInputNumber.val(g_productQuantity);

    // Ocultar el input predeterminado si existe
    hideDefaultInput();

    // Restablecer data-quantity
    resetDataQuantity();
}
  
  /**
   * Inicializar los eventos
   */
  function initEvents(){
    g_objBody.on("added_to_cart", onAddedToCart);
    
    g_objPlusButton.on('click', function(){
      plusItem(jQuery(this));
    });
    
    g_objMinusButton.on('click', function(){
      minusItem(jQuery(this));
    });
    
    g_objInputNumber.on('input', function(){
      onQuantityInputChange(jQuery(this));
    });
  }
  
  /**
   * Verificar si el grid padre tiene filtros activados
   */
  function onAjaxRefreshed(){    
    removeEventHandlers();
  }
  
  /**
   * Inicializar los botones
   */
  function initQuantityButtons(){
    initVars();
    initEvents();       
  }
  
  // Inicializar el widget
  initQuantityButtons();
  
  if(!g_objFilterableGrid.length)
    return(false);
  
  g_objFilterableGrid.on("uc_ajax_refreshed", onAjaxRefreshed);
  
}
