<?php
include_once("includes/RafflePlayWoo_OptionsManager.php");

if (!defined('WP_UNINSTALL_PLUGIN')) {
    die;
}


global $wpdb;

$rpwoo_options = new RafflePlayWoo_OptionsManager();

$rpwoo_to_be_deleted = array(
    'ticket_count_starts_at',
    'last_ticket_no',
    'last_order_no',
    'started_orders',
    '_installed',
    '_version',
    'live_raffle',
    'last_debug_no',
    'ticket_prefix',
    'start_date',
    'start_time',
    'end_date',
    'end_time',
    'email_header',
    'email_body',
    'email_extra',
    'email_pos',
    'limit_tickets',
    'limit_tickets_no',
    'filter_status_view',
    'tables_created',
    'terminated',
    'msg_terminate',
    'msg_startdate',
    'msg_enddate',
    'msg_add_to_cart',
    'msg_add_to_cart_ex',
    'msg_update_cart_ex',
    'msg_will_enddate',
    'license',
    'token',
    'license_data',
    'new_version',
    'last_version_check',
    'raffle_name',
    'inc_name',
    'limit_order_per_raffle',
    'limit_order_per_raffle_txt',
    'license_valid',
    'custom_currency',
    'saved_statuses',
    'custom_cols',
    'custom_cols_ava',
    'enable_pdf_att',
    'pdf_template',
    'pdf_inc_add',
    'pdf_inc_prod',
    'pdf_page_or',
    'pdf_header_img',
    'pdf_filename_type',
    'pdf_business_info',
    'pdf_footer_info',
    'pdf_footer_height',
    'pdf_restrict',
    'pdf_extra_css',
    'enable_buy_product',
    'buy_out_product',
    'hide_terminated_raffles',
    'gen_random_tickets',
    'show_ticket_image',
    'ticket_image',
    'ticket_image_url',
    'acc_tab_raffle',
    'ticket_image_raffles',
    'acc_tab_info',
    'ignore_processing',
    'ignore_complete',
    'leading_zeros',
    'server_url',
    'last_raffle_view',
    'check_duplicates',
    'show_countdown',
    'history_tickets',
    'countdown',
    'countdown_card_pos',
    'show_countdown_card',
    'show_pb_prod',
    'pb_prod_pos',
    'show_pb_card',
    'pb_card_pos',
    'progressbar',
    'show_orders_table',
    'promo_settings',
    'gen_checkout',
    'gen_checkout_set',
    'woo_info',
    'raffle_gen_checkout',
    'order_status_gen_tickets',
    'user_search_tickets',
    'lucky_data',
    'product_raffle_tab',
    'user_pick_tickets',
    'user_pick_labels'    
);


foreach ($rpwoo_to_be_deleted as $key => $value) {
    $rpwoo_options->deleteOption( $value );
}

try {

    $rpwoo_main_tbl     = $wpdb->prefix .  strtolower($rpwoo_options->prefix('main'));
    $rpwoo_main_tbl_bk  = $wpdb->prefix .  strtolower($rpwoo_options->prefix('main_bk'));
    $rpwoo_audit_tbl    = $wpdb->prefix .  strtolower($rpwoo_options->prefix('audit'));
    $rpwoo_raffle_tbl   = $wpdb->prefix .  strtolower($rpwoo_options->prefix('raffle')); 
    $rpwoo_products_tbl = $wpdb->prefix .  strtolower($rpwoo_options->prefix('product'));
    $rpwoo_winners_tbl  = $wpdb->prefix .  strtolower($rpwoo_options->prefix('winners'));

    $rpwoo_ckb              = '_rpwoo_ckb';
    $rpwoo_var_prod         = '_rpwoo_var_prod';
    $rpwoo_ticket_no        = '_rpwoo_ticket_no';
    $rpwoo_raffle_type      = '_rpwoo_raffle_type';
    $variation_raffle_no    = '_variation_raffle_no';

    try {
        $query = $wpdb->get_results( "SELECT product_id from $rpwoo_products_tbl;");
        foreach( $query as $item ){
            $product_id = intval( $item->product_id );
            delete_post_meta( $product_id, $rpwoo_ckb );
            delete_post_meta( $product_id, $rpwoo_var_prod );
            delete_post_meta( $product_id, $rpwoo_ticket_no );
            delete_post_meta( $product_id, $rpwoo_raffle_type );
            delete_post_meta( $product_id, $variation_raffle_no );            
        }
        
    } catch (\Throwable $th) {
        //throw $th;
    }
    
    $wpdb->query("DROP TABLE IF EXISTS {$rpwoo_main_tbl}; ");
    $wpdb->query("DROP TABLE IF EXISTS {$rpwoo_main_tbl_bk}; ");
    $wpdb->query("DROP TABLE IF EXISTS {$rpwoo_audit_tbl}; ");
    
    $wpdb->query("DROP TABLE IF EXISTS {$rpwoo_raffle_tbl}; ");
    $wpdb->query("DROP TABLE IF EXISTS {$rpwoo_products_tbl}; ");
    $wpdb->query("DROP TABLE IF EXISTS {$rpwoo_winners_tbl}; ");

} catch (\Throwable $th) {
    RafflePlayWoo_error_log( $th->getMessage() );
}

?>