(function($){
    'use strict';

    var selected_row = -1;

    $(document).ready(function(){
        Init();

        ShowTable();
    });

    function Init(){
        $('.btn-add').on('click', function(){
            ResetModal();
            $('#modalSaveEdit').modal({
                show: true,
                backdrop: 'static'
            });

        });

        $('#btnSave').on('click', function(){
            let obj = getModalValues();

            if( obj.is_valid ){
                $('#modalSaveEdit').modal('hide');
                drp_request_data( obj );
            }

        });

        $('.btn-delete').on('click', function(){
            if( ! $('#raffle_winners_table tr').hasClass('active-row') ){
                $( '#navbarNavAltMarkup').bmp_message( rpwoo_local_lng.no_row_selected, 'danger' );   
                return;
            }

            let row_index = parseInt( $('#raffle_winners_table tr.active-row').attr('data-index') );

            if( ! isNaN( row_index ) ){
                let item = rpwoo_data[ row_index ];
                let obj = {
                    id : item.main_id,
                    action : 'delete'
                };
                
                obj.nonce_field_form_rpr = $('#nonce_field_form_rpr').val();

                let options = {
                    message : rpwoo_local_lng.delete_row_confirm 
                }

                $('#navbarNavAltMarkup').bmp_confirm( options, drp_request_data, obj );
            }
        });
    }

    function getModalValues(){

        let obj         = {};

        obj.prize       = $.trim( $('#prize_name').val() );
        obj.raffle      = $('#raffles_list option:selected').val();
        obj.ticket      = parseInt( $('#ticket_no').val() );
        obj.extra_info  = $.trim( $('#extra_info').val() );
        obj.is_valid    = true;
        obj.nonce_field_form_rpr = $('#nonce_field_form_rpr').val();
        obj.action      = 'add';

        if( isNaN( obj.ticket) || ( obj.ticket < 0 )){
            obj.is_valid = false;
            $( '#modalSaveEdit .modal-header').bmp_message( rpwoo_local_lng.invalid_ticket_no, 'danger' ); 
        }

        obj.extra_info = obj.extra_info.replace(/(?:\r\n|\r|\n)/g, 'br_nl')

        return obj;
    }

    function ResetModal(){
        $('#prize_name').val('');
        $('#raffles_list option:first').prop('selected', true );
        $('#ticket_no').val('');
        $('#extra_info').val('');
    }

    function drp_request_data( $obj, $callback ){
     
        $('#drpLoaderImg').show();
        var data_ajax = {
            action: 'drp_save_winners',
            type: 'POST',
            data: $obj,
            dataType: 'json', 
            contentType: 'application/json'
        }
        
        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: data_ajax,
            success: function(data){
                //should display a success/error message   

                try {
                    let new_data = JSON.parse( data );                                  
                   
                    if ( ( typeof new_data.error !== 'undefined') &&( new_data.error )){
                        $( '#navbarNavAltMarkup').bmp_message( new_data.message, 'danger' );   
                    }else{                        
                        rpwoo_data = new_data;
                        ShowTable();
                    }
                } catch (error) {
                    $( '#navbarNavAltMarkup').bmp_message( rpwoo_local_lng.error_parsing_data, 'danger' );                     
                } 
               
         
            },
            error: function( request, status, error ){              
                alert( 'Request ' + request + ' - Status: ' + status + ' - Error: ' + error);    
                $('#drpLoaderImg').hide(); 
            },
            complete: function(){                
                $('#drpLoaderImg').hide(); 
            }
        })
    };

    function replaceBreaks(){
        for( let i = 0; i < rpwoo_data.length; i++ ){
            let item = rpwoo_data[i];
            item.extra_info = item.extra_info.replace( /br_nl/g, '<br/>' );
            //check raffle name
            try {
                if( item.raffle_name == null ){                       
                    item.raffle_name = rpwoo_raffles[ parseInt( item.raffle_id ) ] || '';
                }
            } catch (error) {
                
            }
        }
    }

    function ShowTable(){
        selected_row = -1;
        replaceBreaks();    

        $('#raffle_winners_table').bootstrapTable('destroy').bootstrapTable({
            columns: [
                {
                    title : rpwoo_local_lng.id,
                    field : 'id',
                    align : 'center',                  
                    visible : false
                },
                {
                    title : rpwoo_local_lng.order_id,
                    field : 'order_id',
                    sortable : true
                },
                {
                    title : rpwoo_local_lng.prize,
                    field : 'prize',
                    sortable : true
                },                
                {
                    title : rpwoo_local_lng.ticket,
                    field : 'raffle_ticket',
                    sortable : true
                },
                {
                    title : rpwoo_local_lng.raffle_name,
                    field : 'raffle_name',
                    sortable : true,
                    formatter : function ( value, row ){                   

                        try {
                            if( row.raffle_id in rpwoo_raffles ){
                                return rpwoo_raffles[ row.raffle_id.toString() ];
                            }else{
                                return '(' + rpwoo_local_lng.not_found.toString() + ')';
                            }   
                        } catch (error) {
                            return value; 
                        }
                       
                    }
                },
                {
                    title : rpwoo_local_lng.first_name,
                    field : 'first_name'
                },

                {
                    title : rpwoo_local_lng.last_name,
                    field : 'last_name'
                },
                {
                    title : rpwoo_local_lng.phone,
                    field : 'phone'
                },

                {
                    title : rpwoo_local_lng.email,
                    field : 'email'
                },

                {
                    title : rpwoo_local_lng.address,
                    field : 'address_one',
                    formatter : function( value, row ){
                        if( row.address_two != null )
                            return row.address_one + ' ' + row.address_two;
                        else 
                            return row.address_one;
                    }
                },
                {
                    title : rpwoo_local_lng.address,
                    field : 'address_two',
                    visible : false
                },

                {
                    title : rpwoo_local_lng.country,
                    field : 'country'
                },

                {
                    title : rpwoo_local_lng.county,
                    field : 'county'
                },
                {
                    title : rpwoo_local_lng.extra_info,
                    field : 'extra_info',
                    align : 'center',
                    formatter : function( value, row ){                                       
                        let info = value                                         
                        return "<i data-toggle='tooltip' data-placement='right' title='"+ info.toString() + 
                                "' class='fas fa-info-circle text-info' style='cursor: pointer;''></i>";
                    }
                }

            ],
            data : rpwoo_data,
            onPostBody : function(){    
         
                $('[data-toggle="tooltip"]').tooltip({
                    trigger : 'hover',
                    placement : 'auto',
                    html : true
                });   
                
                $('#raffle_winners_table tbody tr').on('click', function(){
                    $('#raffle_winners_table tbody tr').removeClass('active-row');
                    $( this ).addClass('active-row');
                    selected_row = parseInt( $( this ).attr('data-index') ) + 1;
                   
                });               

                if( selected_row != -1 ){
                    $('#raffle_winners_table tbody tr:nth-child(' + selected_row +')').click();  
                }
            }

        });

        return false;
    }

})(this.jQuery);