

var rpd_loaded_iframe = false;
const rpd_local_columns = 'rpd_local_columns';
const view_tickets_order = 'view_tickets_order';
var all_tickets = [];
var tickets_history = [];

(function($){
    "use strict";
    var oData = null;
    var oRaffle = null;
    var data_duplicates = [];
    var filterObj = {
        from_date : '',
        from_time : '00:00:00',        
        to_date   : '',
        to_time   : '23:59:59',
        inc_deleted : false
    };

    var view_tickets_order = localStorage.getItem( view_tickets_order );

    if( view_tickets_order !== null ){
        view_tickets_order = (view_tickets_order == 'yes');
    }else{
        view_tickets_order = false;
    }

    var visibleColumns = localStorage.getItem( rpd_local_columns );
    

    if( visibleColumns !== null ){

        visibleColumns = JSON.parse( visibleColumns );

    }else{

        visibleColumns = {
            order_id: true,
            raffle_ticket: true,
            tickets_total: false,
            price: true,
            product_name: true,
            email: true,
            first_name: true,
            last_name: true,
            city: true,
            country: false,
            phone: true,
            created_at: true,     
            order_status: false       
        }

    }

    let obj_delete_tickets = {
        action : 'drp_get_data',
        action_delete : 'drp_delete_tickets',
        raffle_id : -1
    };

    $(document).ready(function(){
        let raffle_id = parseInt( $('#raffles_list option:selected').val() );

        if( isNaN( raffle_id )){
            raffle_id = -1;
        }

        $('#view_order_tickets').prop('checked', localStorage.getItem( view_tickets_order ) == 'yes' );

        let obj = {
            action     : 'drp_get_data',
            get_info   : 'get_info',
            live_data  : $('#ckbTypeData').prop('checked') ? 1 : 0,
            dates      : filterObj,
            inc_deleted : 0,
            is_completed : 1,
            is_processing : 1,
            raffle : raffle_id
        };    
             
        if( obj.live_data == 1)
            $('#ckbTypeData').bootstrapToggle('on');
      
        drp_request_data( obj); 
       
    
        $('.lds-default').show();
        $( "#datepicker_from, #datepicker_to" ).datepicker({
            yearRange : '2018:' + ( (new Date()).getFullYear() + 4),
            dateFormat : 'dd-mm-yy',
            changeMonth: true, 
            changeYear: true
        });

        $('#btn_print_tickets').on('click', ()=>{

            $('#inputTicketWidth').val( localStorage.getItem('ticket_width') == null ? 120 : localStorage.getItem('ticket_width') );
            $('#inputTicketHeight').val( localStorage.getItem('ticket_height') == null ? 82 : localStorage.getItem('ticket_height') );
            $('#inputLineHeight').val( localStorage.getItem('line_height') == null ? 68 : localStorage.getItem('line_height') );
            $('#inputTextSize').val( localStorage.getItem('text_size') == null ? 27 : localStorage.getItem('text_size') );
            $('#inputTextColor').val( localStorage.getItem('text_color') == null ? 'black' : localStorage.getItem('text_color') );

            $('#modalPrintTickets').modal({
                show : true,
                backdrop : true
            });

        });

        $('#btnPrint').on('click', ()=>{
            print_tickets();
        })

        $('#btnViewFilter').on('click', function(){
           
            $('#modalViewFilter').modal({
                show : true,
                backdrop: 'static'
            });
        });

        $('#btnFilterSave').on('click', function(){        
            let filterTxt = '';
            filterObj.from_date = DateToString( $('#datepicker_from').datepicker('getDate') );
            filterObj.to_date   = DateToString( $('#datepicker_to').datepicker('getDate') );
            filterObj.from_time = '00:00'; //  $('#timepicker_from').val();
            filterObj.to_time   = '23:59'; //$('#timepicker_to').val();                                                   

          
            $('#modalViewFilter').modal('hide');
            
            if( (filterObj.from_date !== '') ){
                filterTxt +='From: ' + DateStrToString( filterObj.from_date ) + ' ' + filterObj.from_time +  ' - ';
            }
            if( filterObj.to_date !== ''){
                filterTxt += 'To: '+ DateStrToString( filterObj.to_date ) + ' ' + filterObj.to_time;
            }

            if( filterObj.inc_deleted  == 1){
                filterTxt += ' Only Deleted';
            }

            if( filterTxt !== ''){
                $('#filterInfo').text( filterTxt );
                $('#mainFilterInfo').show();
            }

            obj.get_info        = 'filter_dates';
          
            obj.raffle          = $('#raffles_list option:selected').val(); 

            obj.is_pending      = $('#wc-pending').prop('checked') ? 1 : 0;
            obj.is_processing   = $('#wc-processing').prop('checked') ? 1 : 0;
            obj.is_on_hold      = $('#wc-on-hold').prop('checked') ? 1 : 0;
            obj.is_completed    = $('#wc-completed').prop('checked') ? 1 : 0;
            obj.is_cancelled    = $('#wc-cancelled').prop('checked') ? 1 : 0;
            obj.is_refunded     = $('#wc-refunded').prop('checked') ? 1 : 0;
            obj.is_failed       = $('#wc-failed').prop('checked') ? 1 : 0;
            
            drp_request_data( obj );
        });

        $('#ckbTypeData').on('change', function(){
             /*
            let _value = $(this).prop('checked');
            
            if( _value )
                obj.live_data = 1;
            else 
                obj.live_data = 0;

            drp_request_data( obj);    
            */
        });

        $('#raffles_list').on('change', function(){
            $('#btnFilterSave').trigger('click');
        });

        $('#div_filter_status input:checkbox').on('change', function(){
            $('#btnFilterSave').trigger('click');
        });

        $('#filterClear').on('click', function(){
            $('#mainFilterInfo').hide();
            $('#filterInfo').text( '');
            filterObj.from_date = '';
            filterObj.to_date   = '';
            filterObj.from_time = '00:00';
            filterObj.to_time   = '23:59';
            filterObj.inc_deleted = 0;
            obj.inc_deleted = 0;
            ClearDateTimeFilter();
            drp_request_data( obj );
        });

        $('#btnFilterClear').on('click', function(){
            ClearDateTimeFilter();
        });

        $('#modalViewOrder').on('hidden.bs.modal', function () {
            $('#view_order_frame').prop('src', '#');
            $('#drpLoaderImg').hide(); 
        });   

        $('#btnBackup').on('click', function(){
            $('#modalBackup').modal({
                show : true,
                backdrop : 'static'
            });
        });

        $("[data-toggle='tooltip']").tooltip({
            trigger : 'hover',
        //    placement : 'auto',
            html : true
        });

        $('#view_order_tickets').on('change', function(){
            localStorage.setItem( view_tickets_order, $(this).prop('checked') ? 'yes' : 'no' ); 
            $('#btnFilterSave').trigger('click');
        });

        $("#modalEditTicket #btn_close").on('click', ()=>{
            $('.change-ticket-to').val('');
            $('.div-available-tickets').text( rpwoo_local_lng.please_wait );
        });

        $('#modalEditTicket').on('click', '.div-available-tickets input[type="radio"]', function(){
            $('#modalEditTicket .change-ticket-to').val( $( this ).val() );
        });

        $('#btn_rand_ticket').on('click', ()=>{
            if( all_tickets.length > 0 ){
               let index = Math.floor( Math.random() * all_tickets.length );
               if( typeof all_tickets[ index ] === 'undefined'){
                    alert( rpwoo_local_lng.could_not_generate_random );
               }else{
                    $('.change-ticket-to').val( all_tickets[index]);
                    $('#ticket-' + all_tickets[index] ).prop('checked', true );
               }
            }
        });

        $('#btn_tickets_history').on('click', ()=>{
            let message = '';

            for( let i = tickets_history.length - 1 ; i > -1 ; i-- ){
                message += "<p>" + tickets_history[i].toString() + "</p>";
            }

            if( tickets_history.length == 0 ){
                message = "<p>" + rpwoo_local_lng.no_ticket_history + "</p>";
            }

            $('.wrap').bmp_confirm( {
                    message : message,
                    no : '',
                    yes : 'Ok'
                }
            );
        });

        $('#btn_duplicates').on('click', function(){
            $('#modalDuplicates').modal({
                show : true,
                backdrop : 'static'
            });

            let view_order_tickets = $('#view_order_tickets').prop('checked')

            let modal_content = '';
            let orders = [];
            for( let ticket in data_duplicates ){
                
                ticket = data_duplicates[ticket];
                modal_content += "<tr>";

                orders = [];
                for( let i of oData ){
                   
                    if( view_order_tickets){
                        if( i.raffle_ticket.indexOf( ticket ) > -1 ){
                            orders.push( i.order_id );
                        }
                    }else{
                        if( ticket == i.raffle_ticket ){
                            orders.push( i.order_id );
                        }
                    }
                }

                modal_content +=`<td> ${ticket} </td> <td>[ ${orders.join(',')}] </td>`;

                modal_content += "</tr>";
            }

            $('.div-duplicates table tbody').html( modal_content );
        })

        $('#btnDeleteTickets').on('click', function(){
            let raffle_id   = $('#raffles_list option:selected').val();
            let raffle_name = $('#raffles_list option:selected').text();
            let message     = '<center><h4> ' + raffle_name + '</h4> </center> <br/> '
                               + '<b><p>' + rpwoo_local_lng.delete_raffle_tkts + '</p> </b>'
                               + '<p> Type the word DELETE in the input field <input type="text" autocomplete="off" placeholder="delete" id="delete_confirm_input" /> </p>';

            let options = {
                message : message
            }

            $('.wrap').bmp_confirm( options, function(){
                let input_delete = $('.wrap #delete_confirm_input').val();
                input_delete = input_delete.trim();

                if( input_delete !== '' ){

                    input_delete = input_delete.toLowerCase();

                    if( input_delete === 'delete'){
                        obj_delete_tickets.raffle_id = raffle_id;
                        drp_request_data( obj_delete_tickets );
                    }
                }

            });
        });


        $('#btn_change_ticket').on('click', function(){
            if( $.trim( $('.change-ticket-to').val()  ) == '' ){
                return false;
            }

            let message     = '<center><h4> ' + rpwoo_local_lng.confirm_change_ticket + '</h4> </center> <br/> '
                               + '<b><p>' + rpwoo_local_lng.change_raffle_tkts + '</p> </b>'
                               + '<p> Type the word CHANGE in the input field <input type="text" autocomplete="off" placeholder="change" id="change_confirm_input" /> </p>';

            let options = {
                message : message
            }

            $('.wrap').bmp_confirm( options, function(){

                var new_ticket = $.trim( $('.change-ticket-to').val() );            
            
                if( new_ticket == '' ){
                    return false;
                }

                let input_change = $('.wrap #change_confirm_input').val();
                input_change = input_change.trim();

                if( input_change !== '' ){

                    input_change = input_change.toLowerCase();                 

                    if( input_change === 'change'){

                        let order_id =  $('#change_order_id').val();
                        let raffle_id = $('#change_raffle_id').val();
                        let old_ticket = $('#change_old_ticket').val(); 
                        

                        let $obj = {
                            nonce_field_form_rpr :  $('#nonce_field_form_rpr').val(),
                            old_ticket : old_ticket,
                            new_ticket : new_ticket,
                            order_id   : order_id,
                            raffle_id  : raffle_id
                        };

                        let response = dropChangeTicket( $obj );

                        response.then( (value )=>{

                            try {
                                value = JSON.parse( value );
                                tickets_history = JSON.parse( value.history );   
                            } catch (error) {
                                console.log( error );
                            }

                            if( value.changed != 1 ){
                                $('.wrap').bmp_confirm( {
                                            message : rpwoo_local_lng.could_not_change_ticket,
                                            no : '',
                                            yes : 'Ok'
                                        }
                                );
    
                                return;
                            }else{
                                $('.wrap').bmp_confirm( {
                                        message : rpwoo_local_lng.ticket_changed,
                                        no : '',
                                        yes : 'Ok'
                                    }
                                );
                            }
                            
                            let item = null;
                            for( let i = 0; i < oData.length; i++ ){
                                item = oData[ i ];
                                if( item.raffle_ticket == value.old_ticket ){
                                    item.raffle_ticket = value.new_ticket;
                                    i = oData.length;
                                }
                            }

                            drp_populate_table();
                            drp_check_duplicates();

                        });

                    }
                }

            });
        });

        $('.clockpicker').clockpicker();
    });

    async function dropChangeTicket( $obj ){
        $('#drpLoaderImg').show(); 
        var data_ajax = {
            action: 'drp_change_ticket',
            type: 'POST',
            data: $obj,
            dataType: 'json', 
            contentType: 'application/json'
        };
        
        let response = await $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: data_ajax,
            success: function(data){
            },
            error: function( request, status, error ){              
                alert( 'Request ' + request + ' - Status: ' + status + ' - Error: ' + error);    
                $('#drpLoaderImg').hide(); 
            },
            complete: function(){
                if( $obj.get_info != 'get_order_link')
                    $('#drpLoaderImg').hide(); 
            }
        });

        return response;
    }

    function ClearDateTimeFilter(){        
        $('#datepicker_from, #datepicker_to').val('');
        $('#timepicker_from').val('00:00');
        $('#timepicker_to').val('23:59');
       
    }

    function DateToString( $date ){
        let year, month, day;
        let $returnDate = '';
        if( $date !== null ){
            year = $date.getFullYear();
            month = $date.getMonth() + 1;
            if( month < 10 )
              month = '0' + month;
            day   = $date.getDate();
            if( day < 10 )
                day = '0' + day;
            $returnDate = year+'-'+ month + '-' + day;
        };

        return $returnDate;
    }

    function OpenOrderToNewWindow( order_url, order_no ){
        
        $('#view_order_frame').prop('src', order_url ).css('visibility', 'hidden')     
       
        let iframe = document.getElementById( 'view_order_frame');

        if( iframe !== null ){     
            iframe.height = '';
            iframe.height = window.innerHeight - 250 + 'px';    
            
            $('#modalViewOrder').modal({
                show : true,
                backdrop: 'static'
            });
            
            if( ! rpd_loaded_iframe ){
                iframe.onload = function(){    
                    rpd_loaded_iframe = true;
                    $('#drpLoaderImg').show();            
                    $(iframe.contentDocument ).find('#adminmenumain, #wpadminbar, .woocommerce-layout, .notice, #side-sortables, ' +
                    ' .wrap h1:first, .wrap a:first, #screen-meta-links').hide();            
                    $('#view_order_frame').css('visibility', 'visible');                                
                    $('#drpLoaderImg').hide();                                     
                };       
            }

            if( typeof order_no !== 'undefined')                      
                $('#modalViewOrder .modal-title').text('Order View ' + order_no); 
            else 
                $('#modalViewOrder .modal-title').text('Order View ');      
        }else{
            $('#drpLoaderImg').hide(); 
        }
    }

    function DateStrToString( $date ){
        
        let $return = '';
        if( $date.indexOf('-') > 0 ){
            let arrDate = $date.split('-');
          
            if( Array.isArray( arrDate ) && (arrDate.length > 1 )){
                $return =  arrDate[2]  + '-' +arrDate[1]  + '-' +  arrDate[0] ;
            }
        }

        return $return;
    }

    function drp_request_data( $obj, $callback ){
        $('#drpLoaderImg').show();
        $obj['nonce_field_form_rpr'] = $('#nonce_field_form_rpr').val();
        $('#raffles_list').prop('disabled', true );
        $obj['view_order_tickets'] = $('#view_order_tickets').prop('checked') ? 'yes' : 'no';
        $('#view_order_tickets').prop('disabled', true);

        var data_ajax = {
            action: $obj.action,
            type: 'POST',
            data: $obj,
            dataType: 'json', 
            contentType: 'application/json'
        }
        
        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: data_ajax,
            success: function(data){
                //should display a success/error message              
                
                try {
                    if( (typeof  $obj.action_delete !== 'undefined') && ($obj.action_delete == "drp_delete_tickets") ){
                        let message = rpwoo_local_lng.records_deleted + ' ' + data;
                    
                        $('.panel-heading').bmp_message( message );
                        $('#raffles_list').trigger('change');
                        return;
                    }

                    if( $obj.get_info === 'get_order_link'){
                        data = decodeURIComponent(data );
                        data = data.replace( /&amp;/g, '&');

                        if( typeof $callback !=='undefined'){
                            let view_on_modal = $('#view_order_modal').prop('checked');
                            if( view_on_modal )
                                $callback( data, $obj.order_id );
                            else
                                window.location.href = data;
                        }
                    }else{
                        let rec_data = JSON.parse( data );
                        oData = rec_data.tickets;                                                                      
                        drp_populate_table();
                        drp_check_duplicates();
                        oRaffle = rec_data.raffle;                    
                    }
                } catch (error) {
                    $( '.bmp-pins-new-panel .panel-heading').bmp_message( rpwoo_local_lng.error_parsing_data, 'danger' );                     
                } 
               
         
            },
            error: function( request, status, error ){              
                alert( 'Request ' + request + ' - Status: ' + status + ' - Error: ' + error);    
                $('#drpLoaderImg').hide(); 

                $('#raffles_list').prop('disabled', false );
                $('#view_order_tickets').prop('disabled', false);
            },
            complete: function(){
                if( $obj.get_info != 'get_order_link')
                    $('#drpLoaderImg').hide(); 

                $('#raffles_list').prop('disabled', false );
                $('#view_order_tickets').prop('disabled', false);
            }
        })
    };

    function print_tickets(){
        var tickets = [];
        let order_by_tkt = $('#view_order_tickets').prop('checked');

        let ticket_width    = parseInt( $('#inputTicketWidth').val() );
        let ticket_height   = parseInt( $('#inputTicketHeight').val() );
        let line_height     = parseInt( $('#inputLineHeight').val() );
        let text_size       = parseInt( $('#inputTextSize').val() );
        let text_color      = $('#inputTextColor').val().trim();

        if( isNaN( ticket_width )){ ticket_width = 42; }
        if( isNaN( ticket_height)){ ticket_height = 80; }
        if( isNaN( line_height )){ line_height = 45; }
        if( isNaN( text_size )){ text_size = 27; }
        if( text_color == ''){ text_color = '#000';}

        let inc_prefix      = $('#ckbIncludePrefix').prop('checked');
        let inc_zero        = $('#ckbIncludeZero').prop('checked');     

        localStorage.setItem('ticket_width',    ticket_width );
        localStorage.setItem('ticket_height',   ticket_height );
        localStorage.setItem('line_height',     line_height );
        localStorage.setItem('text_size',       text_size );
        localStorage.setItem('text_color',      text_color );


        var print_c = {};
               
        oData.forEach(el => {
          
            if( order_by_tkt ){
                let tkt_arr = el.raffle_ticket.split(',');         
                tickets = tickets.concat( tkt_arr );
            }else{
                tickets.push( el.raffle_ticket );

                if( typeof print_c[ el.order_id ] === 'undefined' ){
                    print_c[ el.order_id ] = {
                        price : 0,
                        first_name : '',
                        last_name : ''
                    };
                }

                print_c[ el.order_id ].first_name = el.first_name;
                print_c[ el.order_id ].last_name = el.last_name;

                if( typeof print_c[ el.order_id ][ el.product_name ]  === 'undefined' ){
                    print_c[ el.order_id ][ el.product_name ] = {
                        tickets : [],
                        total   : 0
                    }
                }

                print_c[ el.order_id ][ el.product_name ].tickets.push( parseInt( el.raffle_ticket ) );
                print_c[ el.order_id ][ el.product_name ].total = el.tickets_total;
                print_c[ el.order_id ].price = el.price;

            }
        });

        tickets = tickets.map( (val)=>{
            return parseInt( val );
        });

        tickets.sort((a, b) => { return a - b;});

        let show_bg_img = false;
        let bg_img = '';

        try {
            let tck_img = oRaffle.tck_img_raffles[ oRaffle.raffle_id ] || false;
            if( tck_img && tck_img.show == 'yes' ){
                show_bg_img = true;

                if( tck_img.ticket_image == 'custom' ){
                    bg_img += ` style="background-image: url('${tck_img.ticket_image_url}');" `;
                }else{
                    let img_url = oRaffle.img_url + 'ticket-image-' + tck_img.ticket_image + '.png';
                    bg_img += ` style="background-image: url('${img_url}'); no-repeat; background-size:100% 100%;" `;
                }
            }

        } catch (error) {
            console.error( error );  
        }

        let tckts_td = '';
        let t = '';
        tickets.forEach( el =>{
            t = el.toString();
            if( inc_zero ){
                t = t.padStart( parseInt( oRaffle.leading_zero ), '0');
            }

            if( inc_prefix ){
                t = oRaffle.prefix.toString() + t;
            }


            tckts_td += `<div class='div-ticket-wrapper' ${bg_img} > ${t} </div>`;
        });
        

        let content = `<table style='width: 100%; font-weight: 600; border-collapse: collapse;' class='shop_table additional_info'>
                        <tbody>
                            <tr>                          
                            <td >
                                ${ tckts_td }
                            </td>
                            </tr>
                        </tbody
                       </table>
                    `;

        const printWindow = window.open('', '_blank');
        printWindow.document.write(`<html><head><title>Print Raffle Tickets</title>
            <style>
                table tbody td{
                    vertical-align: middle;
                    padding: 12px;
                    text-align: center;                    
                    border:1px solid #e5e5e5;                              
                }
                .div-ticket-wrapper{
                    background-repeat: no-repeat;
                    background-size: 100%;
                    text-align: center;
                    display: inline-block;
                    margin-left: 6px;
                    height: ${ticket_height}px;
                    width: ${ticket_width}px;
                    line-height: ${line_height}px;
                    transform: rotate( 0deg );
                    margin-top: 4px;
                    margin-bottom: 4px;
                    font-size: ${text_size}px;
                    color: ${text_color};
                }
            </style>

        </head><body>`);
        printWindow.document.write(content);
        printWindow.document.write('</body></html>');
        printWindow.document.close();
        setTimeout(()=>{
            printWindow.print();
        }, 500 );
        
    }


    function drp_check_duplicates(){

        let view_order_tickets = $('#view_order_tickets').prop('checked');

        let arr = [];
        let tickets = [];
        for( let obj of oData ){
            if( view_order_tickets ){
                tickets = obj.raffle_ticket.split(',');
                arr = arr.concat( tickets );
            }else{
                arr.push( parseInt( obj.raffle_ticket ) );
            }            
        }
      
        data_duplicates = arr.filter(function(value,index,self){ return (self.indexOf(value) !== index )});

        if( data_duplicates.length > 0 ){
            $('#btn_duplicates .dup-no').text('(' + data_duplicates.length + ')' );
            $('#btn_duplicates').addClass('btn-outline-danger').removeClass('btn-secondary');
        }else{
            $('#btn_duplicates .dup-no').text('');
            $('#btn_duplicates').addClass('btn-secondary').removeClass('btn-outline-danger');
        }

    }



    function drp_populate_table(){
        let drp_boot_table = $('#tbl_view');     
        let view_order_tickets = $('#view_order_tickets').prop('checked');   
        let reserved_txt = '';      

        drp_boot_table.bootstrapTable('destroy').bootstrapTable({
            columns :[
                {
                    title : rpwoo_local_lng.order_id,
                    field : 'order_id',
                    align : 'center',
                    sortable : true,                 
                    formatter : function(value, row ){
                        
                        return '<div>' + value + ' <i class="fa fa-eye view-order-link"></i> ' + ' x ' + row.tickets_total +' </div>';                        
                    },
                    events :{
                        'click .view-order-link' : function( e, value, row ){
                            let $obj = {  
                                action : 'drp_get_data',                              
                                get_info : 'get_order_link',
                                order_id : value
                            };
                          drp_request_data( $obj, OpenOrderToNewWindow );                                                 
                        }
                    }
                },
                {
                    title : rpwoo_local_lng.raffle_ticket,
                    field : 'raffle_ticket',
                    align : 'center',
                    sortable : true,
                    formatter: ( value, row)=>{

                        if( view_order_tickets ){
                            return `<div class='div-view-order-tickets' title='${value}' >  ${value}</div>`;   
                        }

                        reserved_txt = '';                

                        if( row.reserved == 1 ){
                            reserved_txt = '<i class="fa fa-hand" title="User Picked"></i> ';
                        }

                        return `<div> <i class="fa fa-edit edit-ticket-raffle"></i>  ${value} ${reserved_txt} </div>`;
                    },

                    events :{
                        'click .edit-ticket-raffle' : (e, value, row ) => {
                            editRaffleTicket( row );
                        }
                    }
                },
                {
                    title : rpwoo_local_lng.total_tickets,
                    field : 'tickets_total',
                    hide: true
                },
                {
                    title : rpwoo_local_lng.order_sale,
                    field : 'price'
                },
                {
                    title : rpwoo_local_lng.product,
                    field : 'product_name',
                    class : ['product-view-class']
                },
                {
                    title : rpwoo_local_lng.first_name,
                    field : 'first_name',
                    sortable : true
                },
                {
                    title : rpwoo_local_lng.last_name,
                    field : 'last_name',
                    sortable : true
                },
                {
                    title : rpwoo_local_lng.email,
                    field : 'email',
                    sortable : true
                },
                {
                    title : rpwoo_local_lng.phone,
                    field : 'phone',
                    sortable : true
                },
                {
                    title : rpwoo_local_lng.city,
                    field : 'city',
                    sortable : true
                },

                {
                    title : rpwoo_local_lng.country,
                    field : 'country',
                    sortable : true,
                    hide: true
                },

                {
                    title : rpwoo_local_lng.order_status,
                    field : 'order_status',
                    sortable : true,
                    hide: true,
                    formatter : function(value, row ){                                           
                        try {
                            return RPWOO_ORDER_STATUSES[ value ] || '';
                        } catch (error) {
                            return '';
                        }
 
                    },
                },

                {
                    title : rpwoo_local_lng.order_date_time,
                    field : 'created_at'
                }
            ],
            "footer" :{
                id : "footer",
                name : 'footer_name'
            },
            data : oData,
            cache : false,
            search : true,            
            showColumns: true, 
            showExport: true,
            showFooter : false,
            exportTypes: ['csv', 'txt', 'excel'],
            pagination: true,
            pageSize: 50,
            pageList: [50, 100, 300, 600, 1000, 2500, 5000, 8000, 10000, 15000],
            exportOptions : {
                'fileName' : $('#raffles_list option:selected').text() + '-' + todayDateFormat()
            },
            onPostBody : function(){               
                //$('[data-toggle="popover"]').popover();  
                $('#tbl_view tr').on('click', function(){
                    $('#tbl_view tr').removeClass('active-row');
                    $( this ).addClass('active-row');
                });    
                   
            }
                 
        });

       drp_boot_table.bootstrapTable( 'hideColumn', columnsToHide() );      
     

        $('.columns-right .dropdown-item input[type="checkbox"]').on('click', function(){
            let is_checked = $( this ).prop('checked');
            let name = $( this ).data('field');
            if( typeof visibleColumns[ name ]  !== 'undefined' ){
                visibleColumns[ name ] = is_checked;
                localStorage.setItem( rpd_local_columns, JSON.stringify( visibleColumns ));
            }
        });

    }

    function editRaffleTicket( $obj ){

        $('#modalEditTicket').modal({
            show : true,
            backdrop: 'static'
        });

        $('#ticketHeader').text( $obj.raffle_ticket );
        $('.modal-order-id').text( $obj.order_id );

        $('#change_order_id').val( $obj.order_id );
        $('#change_raffle_id').val( $obj.raffle_id );
        $('#change_old_ticket').val( $obj.raffle_ticket ); 

    //    $('#modalEditTicket .div-edit-ticket').text( "<p> " + JSON.stringify( $obj ) + "</p>");

        let obj_data = {
            raffle_id : $obj.raffle_id
        };
        
        var respData = getAvailbleTickets( obj_data );

        respData.then( ( value )=>{       
           
            let serv_data = JSON.parse( value );
            all_tickets = JSON.parse( serv_data.tickets );
            tickets_history = JSON.parse( serv_data.history );

            let radios = [];
            let tickt = null;
            for( let i = 0; i < all_tickets.length; i++ ){
                tickt = all_tickets[i];
                radios.push( `<label for="ticket-${tickt}" class='lbl-ava-ticket'> <input name='raffle_tickets' class='aval-raffle-tickets' type='radio' id="ticket-${tickt}" value="${tickt}"/> ${tickt} </label>`);
            }

            if( all_tickets.length == 0){
                radios = [
                    "<p> <b>" + rpwoo_local_lng.no_available_tickets_found + "</b></p>"
                ]
            }

            $('.div-available-tickets').html( radios.join('') );
        });

    }

    async function getAvailbleTickets( $obj ){
        $('#drpLoaderImg').show();
        $obj['nonce_field_form_rpr'] = $('#nonce_field_form_rpr').val();
        
        var data_ajax = {
            action: 'drp_available_tickets',
            type: 'POST',
            data: $obj,
            dataType: 'json', 
            contentType: 'application/json'
        };
        
        let response = await $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: data_ajax,
            success: function(data){            
         
            },
            error: function( request, status, error ){              
                alert( 'Request ' + request + ' - Status: ' + status + ' - Error: ' + error);    
                $('#drpLoaderImg').hide(); 
            },
            complete: function(){
                if( $obj.get_info != 'get_order_link')
                    $('#drpLoaderImg').hide(); 
            }
        });

        return response;
    
    }

    function columnsToHide(){
        
        let result = [];
           
        for( const i in visibleColumns ){
            if( ! visibleColumns[i] )
                result.push( i );
        }            

        return result;
    }

    function todayDateFormat(){
        let d = new Date();

        let datestring = d.getDate()  + "-" + (d.getMonth()+1) + "-" + d.getFullYear() + " " +
        d.getHours() + "-" + d.getMinutes();

        return datestring;
    }

    function rpd_raffle_tickets_formatter( row ){        
        let tickets = '';        
        let from = parseInt( row.ticket_from );
        let to = parseInt( row.ticket_to );
       
        while( from <= to ){
            tickets += '#'+from + ' ';
            from++;
        };
       
        let popover = ' data-toggle="popover" data-placement="auto" data-trigger="hover" data-content="'+tickets+'" '; 
        return '<div '+popover+' class="raffle-tickets-data"><a>' + row.ticket_from + ' - ' + row.ticket_to + '</a></div>'; 
    }

})(this.jQuery);