(function($){
    "use strict";
    var selected_row = -1;
    var current_date = 0;
    const D_FUTURE_2099 = 4073587200;

    $(document).ready(function(){
        
        Init();

        ShowTable();

        SetupModal();

    });

    function Init(){

        current_date = new Date();
        current_date.setSeconds( 0, 0);
        current_date = current_date.getTime() / 1000;
       
             
        $('.btn-add').on('click', function(){
            ResetModal();
            $('#modalSaveEdit .modal-title').text( rpwoo_local_lng.new_raffle );
            $('#modal_action').val('-1');
            $('#modalSaveEdit').modal({
                backdrop: 'static',
                show : true
            });
        });

        $('.btn-edit').on('click', function(){
            if( ! $('#raffle_product_table tr').hasClass('active-row') ){
                $( '#navbarNavAltMarkup').bmp_message( rpwoo_local_lng.no_raffle_selected, 'danger' );   
                return;
            }

            let row_index = parseInt( $('#raffle_product_table tr.active-row').attr('data-index') );
            if( ! isNaN( row_index ) ){
                let obj = rpwoo_data[row_index] || null;
                
                if( obj !== null ){
                    $('#modal_action').val(obj.id );
                    LoadModal( obj );
                }
            }           

            $('#modalSaveEdit .modal-title').text( rpwoo_local_lng.edit_raffle );
            $('#modalSaveEdit').modal({
                backdrop: 'static',
                show : true
            });
            
        });

        $('#email_extra_inherit').on('change', function(){
            
            if( $( this ).prop('checked') ){
               $('#email_extra').prop('readonly', true); 
            }else{
                $('#email_extra').prop('readonly', false );
            }
        });

        $('#btnSave').on('click', function(){
            let raffle = SaveNewRaffle();
            if( raffle.is_valid ){                
                $('#modalSaveEdit').modal('hide'); 
                drp_request_data( raffle );                 
            }
        });
        
        $('#is_live').bootstrapToggle('disable');


        $('#select_ticket_image').on('change', function(){
            let $value = $('#select_ticket_image option:selected').val();
   
            let img_url = $('#ticket_img_show').data('src');
            let ticket_img_url = '#';
            let img_prefix = 'images/ticket-image-';

            if( $value == 'custom'){
                $( '.div-custom-ticket-img').show();
                let $custom_ticket_url = $.trim( $('#ticket_image_url').val() );
                ticket_img_url = $custom_ticket_url !== '' ? $custom_ticket_url : '#';
                
            }else{
                $('.div-custom-ticket-img').hide();
                ticket_img_url = img_url + img_prefix + $value + '.png';
            }

            $('#ticket_img_show').attr('src', ticket_img_url );

        });

        $('#navbarNavAltMarkup .btn-delete').on('click', function(){

            let row_index = parseInt( $('#raffle_product_table tr.active-row').attr('data-index') );
            let raffle_obj = null;
            if( ! isNaN( row_index ) ){
                raffle_obj = rpwoo_data[row_index] || null;
            }   

            if( raffle_obj === null ) return;
           

            let message     = '<center><h4> </h4> </center> <br/> '
                               + '<b><p>PERMANENTLY Delete Raffle ' + ' : ' + raffle_obj.name.toString() + ' </p> </b>'
                               + '<b><p style="text-decoration:underline;"> ANY RAFFLE TICKETS FOR THIS RAFFLE WILL ALSO BE DELETED </p></b>'
                               + '<p> Type the word DELETE in the input <input type="text" autocomplete="off" placeholder="delete" id="delete_confirm_input" /> </p>';

            let options = {
                message : message
            }

            $('.wrap').bmp_confirm( options, function(){
                let input_delete = $('.wrap #delete_confirm_input').val();
                input_delete = input_delete.trim();

                if( input_delete !== '' ){

                    input_delete = input_delete.toLowerCase();

                    if( input_delete === 'delete'){
                        let row_index = parseInt( $('#raffle_product_table tr.active-row').attr('data-index') );
                        let obj = null;

                        if( ! isNaN( row_index ) ){
                            obj = rpwoo_data[row_index] || null;
                            
                            if( obj === null ){
                                alert('Could not find raffle obj');
                                return;
                            }
                        }else{
                            alert('Could not find raffle obj');
                            return;
                        }

                        let obj_data = {
                            id : obj.id,
                            action : 'delete_raffle',
                            nonce_field_form_rpr : $('#nonce_field_form_rpr').val()
                        }

                        drp_request_data( obj_data );
                    }
                }

            });
        });

        
        $('#load_ticket_img').on('click', function(e){        
            e.preventDefault();
         
    
            var frame;

            frame = wp.media({
                multiple: false
            });
            let _this = this;
    
            frame.on( 'select', function(){
               
                var attachment = frame.state().get('selection').first().toJSON();  

                $('#ticket_image_url').val( attachment.url ).change();
                $('#ticket_img_show').attr('src', attachment.url );              

            });
    
           frame.open();
        });  
    }


    function SetupModal(){
        $("input:radio[name=is_limited]").on('change', function(){
            if( $('#is_limited_yes').prop('checked') ){
                $('#limit_no').prop('disabled', false);
            }else{
                $('#limit_no').prop('disabled', true);
            }
        });


        $('#is_limited_no').prop('checked', true).change();

        $('#datepicker_from, #datepicker_to').datepicker({
            yearRange : '2018:' + ( (new Date()).getFullYear() + 4),
            dateFormat : 'dd-mm-yy',
            changeMonth: true, 
            changeYear: true
        });

        $('#timepicker_from, #timepicker_to').clockpicker({           
            autoclose : true          
        });

    }

    function LoadModal( $obj ){
        $('#raffle_name').val( $obj.name );
        $('#start_ticket').val( $obj.start_ticket );  
        $('#is_live').prop('checked', true ).change();
        $('#is_terminated').prop('checked', $obj.is_terminated ).change();
        $('#ticket_prefix').val( $obj.prefix );

        if( $obj.is_limit  )
            $('#is_limited_yes').prop('checked', true ).change();
        else
            $('#is_limited_no').prop('checked', true ).change();

        $('#limit_no').val( $obj.limit_no );
        $('#datepicker_from').val( $obj.start_date_str );
        $('#datepicker_to').val( $obj.end_date_str );
        $('#email_extra_inherit').prop('checked', $obj.extra_line_in ).change();
        $('#email_extra').val( $obj.email_extra_line );
        $('#timepicker_from').val( $obj.start_timestr);
        $('#timepicker_to').val( $obj.end_timestr );
        $('#rdp_enable_buy_product').prop('checked', $obj.buyout ).change();
        $('#buy_out_product option[value="'+ $obj.buyout_product+'"]').prop('selected', 'selected');
        $('#gen_random_tickets').prop('checked', $obj.gen_random_tickets == 1 ).change();
        $('#rdp_show_countdown').prop('checked', $obj.countdown_active == 1 ).change();
        $('#rdp_show_countdown_card').prop('checked', $obj.countdown_active_card == 1 ).change();
        $('#rdp_show_pb').prop('checked', $obj.pb_active == 1 ).change();
        $('#rdp_show_pb_card').prop('checked', $obj.pb_active_card == 1 ).change();
        $('#rdp_gen_checkout').prop('checked', ( (typeof rpwoo_gen_checkout[ $obj.id ] !== 'undefined' ) &&  rpwoo_gen_checkout[ $obj.id ] == 'yes') ).change();
        $('#rdp_user_pick_tickets').prop('checked', ( (typeof rpwoo_user_pick[ $obj.id ] !== 'undefined' ) &&  rpwoo_user_pick[ $obj.id ] == 'yes') ).change();

        $('#leading_zeros').val( $obj.leading_zeros );

        if( typeof rpwoo_ticket_image_raffles[ $obj.id ] === 'undefined' ){
            $('#show_ticket_image').prop('checked', false ).change();
            $('#select_ticket_image option[value="blue"').prop('selected', true ).trigger('change');
            $('#ticket_image_url').val(''); 
        }else{
            let img_selected = rpwoo_ticket_image_raffles[ $obj.id ].ticket_image;           
            $('#show_ticket_image').prop('checked', rpwoo_ticket_image_raffles[ $obj.id ].show == 'yes' ).change();                      
            $('#ticket_image_url').val( rpwoo_ticket_image_raffles[ $obj.id ].ticket_image_url );
            $('#select_ticket_image option[value="'+ img_selected +'"').prop('selected', true ).trigger('change');
        }
    }   

    function ResetModal(){
        $('#raffle_name, #datepicker_from, #datepicker_to, email_extra').val('');
        $('#start_ticket').val(1000);
        $('#is_live').prop('checked', true ).change();
        $('#is_terminated').prop('checked', false ).change();
        $('#ticket_prefix').val('Ticket-');
        $('#is_limited_no').prop('checked', true);
        $('#limit_no').val('');
        $('#email_extra_inherit').prop('checked', false ).change();
        $('#email_extra').val('').prop('readonly', false); 
        $('#timepicker_from, #timepicker_to').val( '');
        $('#show_ticket_image').prop('checked', false ).change();
        $('#select_ticket_image option[value="blue"').prop('selected', true ).trigger('change');
        $('#ticket_image_url').val('');
        $('#leading_zeros').val( 0 );
        $('#rdp_show_countdown').prop('checked', false ).change();
        $('#rdp_show_countdown_card').prop('checked', false ).change();
        $('#rdp_show_pb').prop('checked', false ).change();
        $('#rdp_show_pb_card').prop('checked', false ).change();
        $('#rdp_gen_checkout').prop('checked', false ).change();
        $('#rdp_user_pick_tickets').prop('checked', false ).change();
    }

    function SaveNewRaffle(){
        let raffle = {};
        raffle.id            = parseInt( $('#modal_action').val() );
        raffle.name          = $.trim( $('#raffle_name').val() );
        raffle.start_ticket  = parseInt( $('#start_ticket').val() );
        raffle.is_live       = 1;
        raffle.is_terminated = $('#is_terminated').prop('checked') ? 1 : 0;
        raffle.prefix        = $.trim( $('#ticket_prefix').val() );
        raffle.is_limited    = $('#is_limited_yes').prop('checked') ? 1 : 0;
        raffle.limited_no    = parseInt( $('#limit_no').val() );
        raffle.start_date    = $.trim( $('#datepicker_from').val() );
        raffle.end_date      = $.trim( $('#datepicker_to').val() );
        raffle.extra_line_in = $('#email_extra_inherit').prop('checked') ? 1 : 0;
        raffle.email_extra   = $.trim( $('#email_extra').val() );
        raffle.nonce_field_form_rpr = $('#nonce_field_form_rpr').val();
        raffle.start_time    = $.trim( $('#timepicker_from').val() );
        raffle.end_time      = $.trim( $('#timepicker_to').val() );
        raffle.is_valid      = false;
        raffle.buyout        = $('#rdp_enable_buy_product').prop('checked') ? 1 : 0;
        raffle.buyout_product   = $('#buy_out_product option:selected').val();        
        raffle.gen_random_tickets = $('#gen_random_tickets').prop('checked') ? 1 : 0;
        raffle.show_ticket_image  = $('#show_ticket_image').prop('checked') ? 'yes' : 'no';
        raffle.ticket_image       = $('#select_ticket_image option:selected').val();
        raffle.ticket_image_url   = $('#ticket_image_url').val();
        raffle.leading_zeros      = parseInt( $('#leading_zeros').val() );
        raffle.countdown_active   = $('#rdp_show_countdown').prop('checked') ? 1 : 0;
        raffle.countdown_active_card   = $('#rdp_show_countdown_card').prop('checked') ? 1 : 0;
        raffle.pb_active          = $('#rdp_show_pb').prop('checked') ? 1 : 0;
        raffle.pb_active_card     = $('#rdp_show_pb_card').prop('checked') ? 1 : 0;
        raffle.gen_checkout       = $('#rdp_gen_checkout').prop('checked') ? 'yes' : 'no';
        raffle.user_pick          = $('#rdp_user_pick_tickets').prop('checked') ? 'yes' : 'no';
        raffle.action             = 'save_raffle';

        if( isNaN( raffle.leading_zeros ) )
            raffle.leading_zeros = 0;

        if( raffle.name == '' ){        
            $( '#modalSaveEdit .modal-header').bmp_message( rpwoo_local_lng.raffle_name_required, 'danger' ); 
            return raffle;
        }

        if( isNaN( raffle.start_ticket) || ( raffle.start_ticket < 0 ) ){       
            $( '#modalSaveEdit .modal-header').bmp_message( rpwoo_local_lng.invalid_start_ticket, 'danger' ); 
            return raffle;  
        }

        if( raffle.is_limited == 1 ){

            if( isNaN( raffle.limited_no) || ( raffle.limited_no < 1 ) ){
                $( '#modalSaveEdit .modal-header').bmp_message( rpwoo_local_lng.invalid_limit_no, 'danger' ); 
                return raffle;   
            }
        }else{
            if( isNaN( raffle.limited_no )){
                raffle.limited_no = 0;
            }
        }

       raffle.is_valid = true;
       
       return raffle;

    }

    function drp_request_data( $obj, $callback ){
        $('#drpLoaderImg').show();
        var data_ajax = {
            action: 'drp_save_raffle',
            type: 'POST',
            data: $obj,
            dataType: 'json', 
            contentType: 'application/json'
        }
        
        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: data_ajax,
            success: function(data){
                //should display a success/error message  
                try {
                    let response = JSON.parse(  data );                  
                    rpwoo_data = response.raffles;                    
                    rpwoo_ticket_image_raffles = response.ticket_images;  
                    rpwoo_gen_checkout = response.gen_checkout;       
                    rpwoo_user_pick    = response.user_pick;                                     
                    ShowTable();
                } catch (error) {
                    $( '#navbarNavAltMarkup').bmp_message( rpwoo_local_lng.error_parsing_data, 'danger' );                     
                } 
               
         
            },
            error: function( request, status, error ){              
                alert( 'Request ' + request + ' - Status: ' + status + ' - Error: ' + error);    
                $('#drpLoaderImg').hide(); 
            },
            complete: function(){                
                $('#drpLoaderImg').hide(); 
            }
        })
    };

    function getRaffleInfo( raffle_id ){
      
        let wrapper = '<div class="min-width-120">';
        let raffle_item = null;
        for( let i = 0; i<rpwoo_data.length; i++ ){
            let item = rpwoo_data[i];
            if( item.id == raffle_id ){
                raffle_item = item;
                break;
            }
        }

        if( raffle_item !== null ){
          
            wrapper += '<p class="center-text"><b> ' + raffle_item.name  + '</b></p>';
            wrapper += '<p class="center-text"><b> ID:  ' + raffle_item.id + '</b></p>';
            wrapper += '<p> <span class="left-text" > ' + rpwoo_local_lng.last_ticket + '<span> - ' + ( ( raffle_item.extra_info.last_sold == '') ? 'N/A' : raffle_item.extra_info.last_sold ) + '</p>';
            wrapper += '<p> <span class="left-text" > ' + rpwoo_local_lng.sold_tickets + '<span> - ' + ( raffle_item.extra_info.sold_no)  + '</p>';
            wrapper += '<p> <span class="left-text" > ' + rpwoo_local_lng.buyout + '<span> - ' + ( raffle_item.buyout ? rpwoo_local_lng.yes : rpwoo_local_lng.no) + '</span> </p>';
            if( raffle_item.buyout )
                wrapper += '<p> <span class="left-text" > ' + rpwoo_local_lng.buyout_product + '<span> - ' + ( rpwoo_non_raffle_products[ raffle_item.buyout_product ]  || 'N/A ') + ' </span> </p>';
        }
        wrapper += '</div>';


        return wrapper;
    }

    function ShowTable(){

        $('#raffle_product_table').bootstrapTable('destroy').bootstrapTable({
            columns: [
                {
                    title : rpwoo_local_lng.id,
                    field : 'id',
                    align : 'center',                  
                    visible : true
                },
                {
                    title : rpwoo_local_lng.raffle_name,
                    field : 'name',
                    sortable : true,
                    formatter : function ( value, row ){
                        //
                        let valid_dates = isValidDates( row.start_datetime, row.end_datetime, row.now_time );

                        if( ! row.is_live )
                            value = "<i class='fa fa-tools'></i> " + value;
                        

                        if( row.is_terminated || ( ! valid_dates ) ) 
                            return "<div class='ended-raffle'></div> " +  value;
                        else
                            return "<div class='live-raffle'></div> " +  value;
                    }
                },
                {
                    title : rpwoo_local_lng.start_ticket,
                    field : 'start_ticket',
                    sortable : true
                },            

                {
                    title : rpwoo_local_lng.live,
                    field : 'is_live',
                    sortable : true,
                    formatter : function(value, row ){                   
                        if( value )
                            return rpwoo_local_lng.yes
                        else 
                            return rpwoo_local_lng.test
                    }
                },
                {
                    title : rpwoo_local_lng.terminated,
                    field : 'is_terminated',
                    sortable : true,
                    formatter : function(value, row ){                   
                        if( value )
                            return rpwoo_local_lng.yes
                        else 
                            return rpwoo_local_lng.no
                    }
                },  
                {
                    title : rpwoo_local_lng.prefix,
                    field : 'prefix'
                },

                {
                    title : rpwoo_local_lng.limited,
                    field : 'is_limit',
                    sortable : true,

                    formatter : function(value, row ){   
                       
                        let limit_no_txt = '';
                        if(row.is_limit && row.limit_no != 0 ){
                                                    
                            limit_no_txt = ' - ' + row.limit_no;

                            if( row.gen_random_tickets == 1 )  
                                limit_no_txt += ' - <i title="Generate Random Tickets" class="fa fa-random"></i>';

                            if( typeof rpwoo_user_pick[ row.id ] !== 'undefined' && rpwoo_user_pick[ row.id ] == 'yes' ){                              
                                limit_no_txt += ' - <i title="User Pick tickets" class="fa-solid fa-person-dots-from-line"></i>';
                            }
                        }
                        if( value )
                            return rpwoo_local_lng.yes + limit_no_txt;
                        else 
                            return rpwoo_local_lng.no + limit_no_txt;

                        
                    }
                },
                {
                    title : rpwoo_local_lng.limit_no,
                    field : 'limit_no',
                    sortable : true,
                    visible : false
                },
                {
                    title : rpwoo_local_lng.start_date,
                    field : 'start_date_str',
                    formatter : function( value, row ){
                        return value + ' ' + row.start_timestr;
                    }
                },
                {
                    title : rpwoo_local_lng.end_date,
                    field : 'end_date_str',
                    formatter : function( value, row ){                        
                        return value + ' ' + row.end_timestr;
                    }
                },
                {
                    title : rpwoo_local_lng.products,
                    field : 'products',
                    formatter : function( value, row ){
                        let products = [];
              
                        for( const prod in value ){
                            products.push( value[ prod.toString() ] );   
                        }
                        return products.join('<br/>').toString();
                    }
                },
                {
                    title : rpwoo_local_lng.shortcode + ' ' + shortcodeInfo(),
                    field : 'shortcode'
                },
                {
                    title : rpwoo_local_lng.info,
                    field : 'id',
                    align : 'center',                   
                    formatter : function( value, row ){                                       
                        let info = getRaffleInfo( value );                                          
                        return "<i data-toggle='tooltip' data-html='true' data-placement='right' title='"+ info.toString() + 
                                "' class='fas fa-info-circle text-info' style='cursor: pointer;''></i>";
                    }
                },

            ],
            data : rpwoo_data,
            onPostBody : function(){                              
              
                $('[data-toggle="tooltip"]').tooltip({
                    track: true,
                    content : function(){
                        return $(this).prop( 'title');
                    }
                });
                                                                        
                $('#raffle_product_table tbody tr').on('click', function(){
                    $('#raffle_product_table tbody tr').removeClass('active-row');
                    $( this ).addClass('active-row');
                    selected_row = parseInt( $( this ).attr('data-index') ) + 1;
                   
                }); 
                
                if( rpwoo_data.length > 0 ){
                    if( selected_row == -1 &&  $('#raffle_product_table tbody tr').length > 0 )
                        $('#raffle_product_table tbody tr:first').click(); 

                    if( selected_row != -1 ){
                        $('#raffle_product_table tbody tr:nth-child(' + selected_row +')').click();  
                    }
                }
                          
            }

        });

        return false;
    }

    function isValidDates( $start_date, $end_date, $now_time ){
        let result = false;

        $start_date = parseInt( $start_date );
        $end_date   = parseInt( $end_date );

        if( isNaN( $start_date ) || isNaN( $end_date ))
            return result;

        if( $end_date === 0 )
            $end_date = D_FUTURE_2099;                                  
                

        result = ( ( $now_time >= $start_date ) && ( $now_time <= $end_date) );

        return result;
    }
    function shortcodeInfo(){
        let info = rpwoo_local_lng.shortcode_info + "<p>[raffle name=\"msg\" id=\"99\" show_raffle_name=\"1\"]</p>" ;
        return "<i data-toggle='tooltip' data-placement='right' title='"+ info.toString() + 
        "' class='fas fa-info-circle text-info' style='cursor: pointer;''></i>";
    }



})(this.jQuery);