
const { createApp } = Vue;

const AJAX_PROM_ACTION = 'drp_prom_action';

const promotion_settings = createApp({
    data (){
        return {

            proms : {
            },

            rule : {
                active      : true,
                cart_value  : 0,
                inc_cat     : false,
                cat         : 0,
                cat_rule    : 'all',
                at_least    : 1,
                cart_tickets : 0,
                no_prods     : 1,
                message      : '',
                checkout    : '',
                order       : 0,
                from_date   : '',
                from_time   : ''
            },

            rule_reset :{
                active      : true,
                cart_value  : 0,
                inc_cat     : false,
                cat         : 0,
                cat_rule    : 'all',
                at_least    : 1,
                cart_tickets : 0,
                no_prods    : 1,
                message     : '',
                checkout    : '',
                order       : 0,
                active_date : '',
                active_time : ''
            },

            temp :{},
            active : false,
            saving : false,
            warn_msg : 'This is a promotional raffle, based on your cart value we award free entry tickets to raffle.',
            action : '',
            raffle_id : 0,
            symbol : '$',
            rule_action : 'add',
            name : '',
            cart_message : '',
            raffle_icon : '',
            prod_cats : {},
            cat_opts :{
                'all' : '(All)',
                'one' : '(One)'
            },

            updateIds : {
                raffle_id : 0,
                rule_id : 0
            }
        }
    },

    watch :{
        proms :{
            handler (){
            },

            deep : true
        },
    },

    methods : {
        actionRule : function( action, raffle_id  ){     
            this.action = action;
            if( action == 'edit'){
                
                this.$refs.raffles_lst.value = this.raffle_id;
                this.raffle_id = raffle_id;
                this.name = this.proms[ raffle_id ].name;
                this.active = this.proms[ raffle_id ].active;
                this.warn_msg = this.proms[ raffle_id ].warn_msg;
                this.temp = JSON.parse( JSON.stringify( this.proms[ raffle_id ] ));
                this.$refs.btn_modal.click();
                this.$refs.action_modal.textContent = rpwoo_local_lng[ action ] || 'Action';

            }else if( action == 'delete' ){
                this.deleteProm( raffle_id );
            }

        },

        getCatName : function( cat, cat_rule, no_prods  ){   
            if( cat_rule == 'all'){  
                return this.getCat( cat ).name + ' - ' + this.cat_opts[ cat_rule ];         
            }else{
                return this.getCat( cat ).name + ' - (' + no_prods +')'; 
            }
        },

        getCat : function( cat_id ){
            let item = null;

            for( const i in this.prod_cats ){
                if( this.prod_cats[i].term_id == cat_id ){
                    item = this.prod_cats[i];
                }
            }
       
            if( item == null ) 
                item = { 
                    name :   'Missing'
                };
                
            return item;            
        },

        addRule : function(){
            if(  this.rule.cart_tickets == 0){
                alert('Raffle ticket cannot be 0');
                return;
            }

            if( typeof this.proms[ this.raffle_id ] === 'undefined' ){
                this.proms[ this.raffle_id ] = {
                    name : this.name,
                    messag : this.cart_message,
                    active : false,
                    warn_msg : warn_msg,
                    rules : []
                }
            }

            let rule = {
                id : parseInt( Math.random() * 1000000000 )
            };
            
            rule = Object.assign( rule, this.rule );

            this.proms[ this.raffle_id ].rules.push( rule );

            this.proms[ this.raffle_id ].rules.sort( (a, b)=>{ return b.cart_tickets - a.cart_tickets; });

            //reset
            this.rule = Object.assign({}, this.rule_reset );

            this.$refs.cart_value.focus();
        },

        updateRule : function (){
            let index = this.getRuleIndex( this.updateIds.raffle_id, this.updateIds.rule_id );

            if( index > -1 ){
                this.proms[ this.updateIds.raffle_id ].rules[ index ] = Object.assign( {}, this.rule );
            }

            this.rule = Object.assign( {}, this.rule_reset );

            this.rule_action = 'add';

        },

        findRule : function ( raffle_id, rule_id ){

            for( let i = 0; i < this.proms[ raffle_id ].rules.length; i++ ){
                if( this.proms[ raffle_id ].rules[i].id == rule_id ){
                    return this.proms[ raffle_id ].rules[i];
                }
            }
        },

        editRule : function ( raffle_id, rule_id ) {

            this.updateIds.raffle_id = raffle_id;
            this.updateIds.rule_id   = rule_id;

            let rule_obj = this.findRule( raffle_id, rule_id );
           
            this.rule = Object.assign( {}, rule_obj );

            this.rule_action = 'edit';          
        },

        deleteRule : function( raffle_id, rule_id ){

            let obj = {
                raffle_id : raffle_id,
                rule_id : rule_id
            };        

            let options = {
                message : 'Delete Rule?'// rpwoo_local_lng.delete_row_confirm 
            }
    
            jQuery( function($){
                $('.promotion-page').bmp_confirm( options, confirmDel, obj );
                function confirmDel( obj ){                                   
                    promotion_settings.confirmDelete( obj.raffle_id, obj.rule_id );
                }
            });
             
        },

        deleteProm : function( raffle_id ){
            let obj = {
                raffle_id : raffle_id,
            };        

            let options = {
                message : 'Delete all Rules from Promotion?'// rpwoo_local_lng.delete_row_confirm 
            }
    
            jQuery( function($){
                $('.promotion-page').bmp_confirm( options, confirmDelP, obj );
                function confirmDelP( obj ){                                   
                    promotion_settings.confirmDeleteProm( obj.raffle_id );
                }
            });
        },

        confirmDeleteProm : function( raffle_id ){
            this.proms[ raffle_id ].rules = [];
            this.saveSettings();
        },

        cancelEdit : function(){
            this.rule_action = 'add';
            this.rule = Object.assign({}, this.rule_reset );
        },

        getRuleIndex : function ( raffle_id, rule_id ){
            let index_obj = -1;

            for( let i = 0; i < this.proms[ raffle_id ].rules.length; i++ ){
                if( this.proms[ raffle_id ].rules[i].id == rule_id ){
                    index_obj = i;
                }
            }

            return index_obj;
        },

        cancelEditProm :function(){
           
            //this.proms[ this.raffle_id ].rules = [];
            this.proms[ this.raffle_id ].rules =  JSON.parse( JSON.stringify ( this.temp.rules ));
        },

        confirmDelete : function ( raffle_id, rule_id){

            let index_obj = this.getRuleIndex( raffle_id, rule_id );                 

            if( index_obj > -1 ){
                this.proms[ raffle_id ].rules.splice( index_obj, 1 );   
            }                    
            
        },

        saveSettings : function ( ){

            if( this.action == 'edit' ){
                this.proms[ this.raffle_id ].name = this.name;
                this.proms[ this.raffle_id ].active = this.active;
                this.proms[ this.raffle_id ].warn_msg = this.warn_msg;
                this.temp = {};       
            }

            this.saving = true;
            let _wponce_val = document.querySelector('#nonce_field_form_rpr');
            let form = new FormData();       
            
            form.append( 'action', AJAX_PROM_ACTION );
            form.append( 'page_action', this.action );
            form.append( 'data', JSON.stringify( this.proms ) );
            form.append( 'nonce', _wponce_val.value || '' );       

            fetch( ajaxurl,{
                method : 'POST',
                body : form
            })
            .then( response => response.json() )
            .then( data => { 

                try {
                    if( data.fine ){
                        this.proms = Object.assign( {}, JSON.parse( data.data ));
                        jQuery( function($){
                            $('#modalSaveEdit').modal('hide');                     
                        });
                       
                    }else{
                        alert( 'Error Occured. Could not save.');
                    }
                } catch (error) {
                    console.error( error );
                    alert( 'Error Occured. Could not save.');
                }   

                this.saving = false;

            })
            .catch( error =>{
                this.saving = false;
                console.error( error );
            })
        },

        setInfoEditorContent2 : function(){

        },

        setInfoEditorContent : function(){
            try {
               
                setTimeout( ()=>{
                    if( typeof tinyMCE ==='undefined' && this.tinyCounter < this.tinyMCEsecs ){
                        this.tinyCounter += 1;
                        this.setInfoEditorContent();                       
                    }           

                    if( typeof tinyMCE.editors.tuskcode_info_editor !== 'undefined'){ 

                        tinyMCE.init({
                        
                            init_instance_callback: function(){
                                tinyMCE.editors.tuskcode_info_editor.setContent( 
                                    this.settings.info
                                );  
                            }
                        });                                                                      
                                            
                    }else{
                        console.log( 'Editor MCE editor is not defined');
                    } 
                
                    
                }, 1000 );

            } catch (error) {
                console.error( error );
            }
        }
    },

    beforeMount(){

        try {
            //remove deleted raffles
            for( const raffle_id in rpwoo_data ){
                if( typeof rpwoo_raffles[ raffle_id ] === 'undefined' ){
                    delete rpwoo_data[ raffle_id ];
                }
            }
        } catch (error) {
            console.error('Could not remove raffle: ' + error ); 
        }
        
        this.proms          = Object.assign({}, rpwoo_data );
        this.symbol         = rpwoo_symbol;
        this.raffle_icon    = raffle_icon;
        this.prod_cats      = categories;    
        this.rule.cat       = categories[0] ? categories[0].term_id : 0;
        this.rule_reset.cat = this.rule.cat;    

        const rev_keys = Object.keys( rpwoo_raffles ).reverse();        

        rev_keys.forEach( item =>{    

            if( typeof this.proms[ item ] === 'undefined' ){
               
                this.proms[ item ] = {
                    name : 'Promotion ' + ' - ' + rpwoo_raffles[ item ] ,
                    messag : '',
                    active : false,
                    rules : []
                }
            }
        });

    },

    mounted (){ 
        
        this.$refs.main_container.classList.add( 'show-loaded'); 

    }
}).mount('.promotion-page');
