(function($){
    "use strict";
    $(document).ready(function(){
        //save setting ajax
        const DRP_SAVE_ACTION = 'drp_save_settings';        
        var original_ticket_start_count_at = parseInt( $('#rdp_ticket_start_count_at').val() );
        var original_live_val              = ( $('#rdp_life_raffle').prop('checked') ? 1 : 0 );        
        
        $('.rdp_save_settings').on('click', function(e){
            e.preventDefault();
            let obj = {};
            let data = {};
            data.ticket_count_starts_at = parseInt( $('#rdp_ticket_start_count_at').val() );
            data.live_raffle            = 1;
            data.email_header           = $.trim( $('#rpwoo_email_header_lbl').val() );
            data.email_body             = $.trim( $('#rpwoo_email_body_lbl').val() );   
            data.ticket_prefix          = $.trim( $('#rpwoo_ticket_prefix').val() ); 
            data.limit_tickets          = ( $('#radio_limit_raffle_yes').prop('checked') ? 1 : 0 );
            data.limit_tickets_no       = parseInt( $('#limit_raffle_no_tickets').val() );

            data.start_date             = $.trim( $('#rpwoo_start_date').val() );
            data.end_date               = $.trim( $('#rpwoo_end_date').val() );

            data.start_time             = $.trim( $('#rpwoo_start_time').val() );
            data.end_time               = $.trim( $('#rpwoo_end_time').val() );
            data.email_extra            = $.trim( $('#rpwoo_email_body_extra_txt').val() );
            data.email_pos              = $('input:radio[name="rpwoo_email_data_pos"]:checked').val();  
            data.terminated             = $('#rdp_terminate_raffle').prop('checked') ? 'yes' : 'no';  

            data.msg_terminate          = $.trim( $('#msg_terminate').val() );
            data.msg_startdate          = $.trim( $('#msg_startdate').val() );
            data.msg_enddate            = $.trim( $('#msg_enddate').val() );
            data.msg_will_enddate       = $.trim( $('#msg_will_enddate').val() );
            data.msg_add_to_cart        = $.trim( $('#msg_add_to_cart').val() );
            data.msg_add_to_cart_ex     = $.trim( $('#msg_add_to_cart_ex').val() );
            data.msg_update_cart_ex     = $.trim( $('#msg_update_cart_ex').val() );
            data.raffle_name            = $.trim( $('#rpwoo_raffle_name').val() );
            data.inc_name               = $('#rpwoo_inc_name').prop('checked') ? 1 : 0;
            data.limit_order_per_raffle = $('#limit_order_per_raffle').prop('checked') ? 1 : 0;
            data.limit_order_per_raffle_txt = $.trim( $('#limit_order_per_raffle_txt').val() );

            //pdf
            data.enable_pdf_att         = $('#enable_pdf_att').prop('checked') ? 'yes': 'no';
            data.pdf_template           = $('#pdf_template option:selected').val();
            data.pdf_inc_prod           = $('#pdf_inc_prod').prop('checked') ? 'yes' : 'no';
            data.pdf_inc_add            = $('#pdf_inc_add').prop('checked') ? 'yes' : 'no';
            data.pdf_page_or            = $('#pdf_ori_port').prop('checked') ? 'portrait' : 'landscape';
            data.pdf_header_img         = $('#pdf_header_image').val();
            data.pdf_filename_type      = $('#pdf_filename_guid').prop('checked') ? 'guid' : 'name';
            data.pdf_business_info      = $.trim( $('#pdf_business_info').val().replace(/\n/g, 'br_nl') );
            data.pdf_footer_info        = $.trim( $('#pdf_footer_info').val().replace(/\n/g, 'br_nl') );
            data.pdf_footer_height      = $.trim( $('#pdf_footer_height').val() );
            data.pdf_restrict           = $('#pdf_restrict').prop('checked') ? 'yes' : 'no';
            data.pdf_extra_css          = $.trim( $('#pdf_extra_css').val().replace(/\n/g, 'br_nl') );
            data.enable_buy_product     = $('#rdp_enable_buy_product').prop('checked') ? 'yes' : 'no';
            data.buy_out_product        = $('#buy_out_product option:selected').val();
            data.hide_terminated_raffles = $('#hide_terminated_raffles').prop('checked') ? 'yes' : 'no';
            data.gen_random_tickets     = $('#gen_random_tickets').prop('checked') ? 'yes' : 'no';
            data.show_ticket_image      = $('#show_ticket_image').prop('checked') ? 'yes' : 'no';
            data.ticket_image           = $('#select_ticket_image option:selected').val();
            data.ticket_image_url       = $.trim( $('#ticket_image_url').val() ); 
            data.acc_tab_raffle         = $('#show_acc_tab').prop('checked') ? 'yes' : 'no';  
            data.acc_tab_info_tab       = $.trim( $('#acc_tab_info_tab').val() );   
            data.acc_tab_info_loc       = $('#acc_tab_info_loc option:selected').val();
            data.acc_tab_info_con       = $('#acc_tab_info_con option:selected').val();
            data.acc_tab_info_mes       = $.trim( $('#acc_tab_info_mes').val() );
            data.ignore_processing      = $('#rpwoo_checkout_ignore_order_processing').prop('checked') ? 'yes' : 'no';
            data.ignore_complete        = $('#rpwoo_checkout_ignore_order_complete').prop('checked') ? 'yes' : 'no';
            data.leading_zeros          = parseInt( $('#rpwoo_leading_zeros').val() );
            data.nonce_field_form_rpr   = $('#nonce_field_form_rpr').val();
            data.check_duplicates       = $('#rdp_check_duplicates').prop('checked') ? 'yes' : 'no';
            data.show_countdown         = $('#rdp_show_countdown').prop('checked') ? 'yes' : 'no';
            data.show_countdown_card    = $('#show_countdown_card').prop('checked') ? 'yes' : 'no';
            data.countdown_card_pos     = $('#countdown_card_pos option:selected').val();
            data.show_orders_table      = $('#show_orders_table').prop('checked') ? 'yes' : 'no';
            data.gen_checkout           = $('#rdp_gen_checkout').prop('checked') ? 'yes' : 'no';
            data.cart_block             = $('#cart_block').prop('checked') ? 'yes' : 'no';
            data.checkout_block         = $('#checkout_block').prop('checked') ? 'yes' : 'no';
            data.gen_c_set_time         = $('#gen_c_set_time').val();
            data.gen_c_set_countdown    = $('#gen_c_set_countdown').prop('checked') ? 'yes' : 'no';
            data.gen_c_set_location     = $('#gen_c_set_location option:selected').val();
            data.gen_c_set_location_block     = $('#gen_c_set_location_block option:selected').val();
            data.gen_c_set_countdown_lbl = $('#gen_c_set_countdown_lbl').val();
            data.gen_c_set_remove_checkout = $('#gen_c_set_remove_checkout').prop('checked') ? 'yes' : 'no';
            data.gen_c_set_cycles          = $('#gen_c_set_cycles').val();
            data.gen_c_msg_removed         = $('#gen_c_msg_removed').val();

            data.order_status_processing    = $('#rpwoo_checkout_order_processing').prop('checked') ? 'yes' : 'no';
            data.order_status_completed     = $('#rpwoo_checkout_order_completed').prop('checked') ? 'yes' : 'no';
            data.order_status_onhold        = $('#rpwoo_checkout_order_onhold').prop('checked') ? 'yes' : 'no';

            data.user_pick_tickets          = $('#rdp_user_pick_tickets').prop('checked') ? 'yes' : 'no';

            data.countdown              = {                
                'pos'       : $('#countdown_pos option:selected').val(),
                'hide_cart' : $('#countdown_hide_cart').prop('checked') ? 'yes' : 'no',
                'bg'        : $.trim( $('#countdown_bg').val() ),
                'color'     : $.trim( $('#countdown_color').val() ),
                'days'      : $.trim( $('#countdown_days').val() ),
                'hours'     : $.trim( $('#countdown_hours').val() ),
                'mins'      : $.trim( $('#countdown_mins').val() ),
                'secs'      : $.trim( $('#countdown_secs').val() ),
                'starts'    : $.trim( $('#countdown_starts').val() ),
                'ends'      : $.trim( $('#countdown_ends').val() )
            };  
            
            data.pb                     = {
                'show_pb_prod'  : $('#show_pb_prod').prop('checked') ? 'yes' : 'no',
                'pb_prod_pos'   : $('#pb_prod_pos option:selected').val(),
                'show_pb_card'  : $('#show_pb_card').prop('checked') ? 'yes' : 'no',
                'pb_card_pos'   : $('#pb_card_pos option:selected').val(),
                'hide'          : $('#pb_hide').prop('checked') ? 'yes' : 'no', 
                'text'          : $.trim( $('#pb_text').val() ),
                'color'         : $.trim( $('#pb_color').val() ), 
                'bg_color'      : $.trim( $('#pb_bg_color').val() ),
                'bar_color'     : $.trim( $('#pb_bar_color').val() ),
                'html_class'    : $.trim( $('#pb_html_class').val() ),  
                'only_limited'  : $('#pb_only_limited').prop('checked') ? 'yes' : 'no',           
            };

            data.prt = {
                'product_raffle_tab'    : $('#product_raffle_tab').prop('checked') ? 'yes' : 'no',
                'tab_name'              : $('#prt_tab_name').val(),
                'priority'              : $('#prt_priority').val(),
                'show_last_orders'      : $('#prt_show_last_orders').val(),
                'show_customer_name'    : $('#prt_show_customer_name').prop('checked') ? 'yes' : 'no',
                'show_customer_city'    : $('#prt_show_customer_city').prop('checked') ? 'yes' : 'no',
                'show_customer_country' : $('#prt_show_customer_country').prop('checked') ? 'yes' : 'no',
                'show_purchased_at'     : $('#prt_show_purchased_at').prop('checked') ? 'yes' : 'no',
                'show_data_table'       : $('#prt_show_data_table').prop('checked') ? 'yes' : 'no',
                'labels'                : {
                    'tickets'       : $('#prt_lbl_tickets').val(),
                    'customer_name' : $('#prt_lbl_customer_name').val(),
                    'city'          : $('#prt_lbl_city').val(),
                    'country'       : $('#prt_lbl_country').val(),
                    'purchased'     : $('#prt_lbl_purchased').val(),
                    'sold_time_hours'   : $('#prt_sold_time_hours').val(),
                    'sold_time_mins'    : $('#prt_sold_time_mins').val(),
                }
            };

            data.user_pick_lbls = {
                'max_show_no'               : $('#userpicklbl_max_show_no').val(),
                'search_btn'                : $('#userpicklbl_search_btn').val(),
                'placeholder_search_input'  : $('#userpicklbl_placeholder_search_input').val(),
                'change_to'                 : $('#userpicklbl_change_to').val(),
                'change_btn'                : $('#userpicklbl_change_btn').val(),
                'changing_btn'              : $('#userpicklbl_changing_btn').val(),
                'prev_btn'                  : $('#userpicklbl_prev_btn').val(),
                'next_btn'                  : $('#userpicklbl_next_btn').val(),
                'cancel_btn'                : $('#userpicklbl_cancel_btn').val(),
                'loading_msg'               : $('#userpicklbl_loading_msg').val(),
                'not_found_msg'             : $('#userpicklbl_not_found_msg').val(),
                'no_ticket_selected_msg'    : $('#userpicklbl_no_ticket_selected_msg').val(),
                'not_available_anymore'     : $('#userpicklbl_not_available_anymore').val(),
            };

            let ticket_width    = parseInt( $('#inputTicketWidth').val() );
            let ticket_height   = parseInt( $('#inputTicketHeight').val() );
            let line_height     = parseInt( $('#inputLineHeight').val() );
            let text_size       = parseInt( $('#inputTextSize').val() );
            let text_color      = $('#inputTextColor').val().trim();
    
            if( isNaN( ticket_width )){ ticket_width = 42; }
            if( isNaN( ticket_height)){ ticket_height = 80; }
            if( isNaN( line_height )){ line_height = 45; }
            if( isNaN( text_size )){ text_size = 27; }
            if( text_color == ''){ text_color = '#000';}

            data.ticket_width   = ticket_width;
            data.ticket_height  = ticket_height;
            data.line_height    = line_height;
            data.text_size      = text_size;
            data.text_color     = text_color;
            
            if( isNaN( data.leading_zeros ))
                data.leading_zeros = 0;
         
            if ( isNaN( data.limit_tickets_no ))
               data.limit_tickets_no = 0;
            else if ( data.limit_tickets_no < 0 )
               data.limit_tickets_no = 0;
            
            if( $('#rpwoo_resolved_issues').length > 0 ){
                if( $('#rpwoo_resolved_issues').prop('checked') ){
                    data.mark_issues = true;
                }
            }

            obj.action = DRP_SAVE_ACTION;
            obj.data = data;
            bmp_save_setting_ajax( obj  );
        });
      
        $('#rpwoo_ticket_prefix').on('keydown', function(){
            let input_val = $.trim( $(this).val() );
            if( input_val.length > 10 ){
                $( this ).val( input_val.substring( 0, 10 ) );
            }
        });      

        $( "#rpwoo_start_date, #rpwoo_end_date" ).datepicker({
            yearRange : '2018:' + ( (new Date()).getFullYear() + 4),
            dateFormat : 'dd-mm-yy',
            changeMonth: true, 
            changeYear: true
        });

        

        if( $('#rpwoo_db_health').length > 0 ){
            $('#rpwoo_db_health').on('click', function(){
                rpwoo_fixDB();
            });
        }

        $('#select_ticket_image').on('change', function(){
            let $value = $('#select_ticket_image option:selected').val();    
            let img_url = $('#ticket_img_show').data('src');
            let ticket_img_url = '#';
            let img_prefix = 'images/ticket-image-';

            if( $value == 'custom'){
                $( '.div-custom-ticket-img').show();
                let $custom_ticket_url = $.trim( $('#ticket_image_url').val() );
                ticket_img_url = $custom_ticket_url !== '' ? $custom_ticket_url : '#';
                
            }else{
                $('.div-custom-ticket-img').hide();
                ticket_img_url = img_url + img_prefix + $value + '.png';
            }

            $('#ticket_img_show').attr('src', ticket_img_url );

        });

        $('#radio_limit_raffle_no').on('change', function(){
            if( $( this ).prop('checked') ){
                $('#limit_raffle_no_tickets').prop('readonly', true );
                $('#gen_random_tickets').bootstrapToggle('disable')
            }
        });

        $('#radio_limit_raffle_yes').on('change', function(){
            if( $( this ).prop('checked') ){
                $('#limit_raffle_no_tickets').prop('readonly', false );
                $('#gen_random_tickets').bootstrapToggle('enable')
            }
        });

        if( $('#radio_limit_raffle_no').prop('checked')){
            $('#limit_raffle_no_tickets').prop('readonly', true ); 
            $('#gen_random_tickets').bootstrapToggle('disable')
        }

        

        $('.clockpicker_main').clockpicker({           
            autoclose : true          
        });

        
        $('[data-toggle="tooltip"]').tooltip({
           selector: false,
           trigger : 'hover'
        });

        $('#pdf_load_img, #load_ticket_img').on('click', function(e){        
            e.preventDefault();
         
    
            var frame;

            frame = wp.media({
                multiple: false
            });
            let _this = this;
    
            frame.on( 'select', function(){
               
                var attachment = frame.state().get('selection').first().toJSON();  
                if( _this.id == 'pdf_load_img'){
                    $('#pdf_header_image').val( attachment.url ).change();
                }else if( _this.id == 'load_ticket_img'){
                    $('#ticket_image_url').val( attachment.url ).change();
                    $('#ticket_img_show').attr('src', attachment.url );
                }


            });
    
           frame.open();
        });

        $('#pdf_header_image').on('change', function(){

            let url_split = $( this ).val().split('/');
            let extension = url_split[ url_split.length - 1 ] || '';
            extension     = extension.split('.');
            extension     = extension[ extension.length - 1 ] || '';
            extension    = extension.toLowerCase();
            if( extension == 'jpeg' || extension == 'jpg' ) {       
                //nothing to to  
            }else{
                $('#pdf_header_image').val( '' );
                $( '#pdf_load_img').first().bmp_message( "Only jpeg/jpg allowed for the moment", 'danger' );                    
            }
        }); 

        $('#select_ticket_image').trigger('change');
        $('#rdp_life_raffle').bootstrapToggle('disable');

        $('#gen_c_set_remove_checkout').on('change', function(){
            let val = $( this ).prop('checked');
            $('#gen_c_set_cycles').prop('disabled', ! val );
        });

        $('#gen_c_set_remove_checkout').trigger('change');

        $('#rpwoo_checkout_order_processing, #rpwoo_checkout_order_completed, #rpwoo_checkout_order_onhold').on('change, input', function(){
            check_order_status();
        });

        $("#searchby_order_id, #searchby_email, #searchby_phone, #searchby_first_name, #search_shortcode_id, #searchby_last_name, #user_search_no_found").on('change, input', function(){
            check_user_search();  
        });

        $('.btn-copy-shortcode').on('click', ()=>{
            navigator.clipboard.writeText( $.trim( $('#user_search_shortcode').val()) ).then(function () {
                alert('Copied')
            }, function () {
                alert('Failure to copy.');
            });
        });

        check_order_status();
        check_user_search();
    });

    function check_order_status(){
  
        let order_status_processing    = $('#rpwoo_checkout_order_processing').prop('checked') ? 'yes' : 'no';
        let order_status_completed     = $('#rpwoo_checkout_order_completed').prop('checked') ? 'yes' : 'no';
        let order_status_onhold        = $('#rpwoo_checkout_order_onhold').prop('checked') ? 'yes' : 'no';

        if( order_status_processing == 'no' && order_status_completed == 'no' && order_status_onhold == 'no' ){
            $('.alert-order-status').show();              
        }else{
            $('.alert-order-status').hide();
        }
    }

    function check_user_search(){
        let search_by = [];

        $('#search_shortcode_id').val( parseInt( Math.random()  * 1000 ) );

        let $order_id   = $('#searchby_order_id').prop('checked') ? 'order_id' : '';
        let $email      = $('#searchby_email').prop('checked') ? 'email' : '';
        let $firstname  = $('#searchby_first_name').prop('checked') ? 'first_name' : '';
        let $lastname   = $('#searchby_last_name').prop('checked') ? 'last_name' : '';
        let $phone      = $('#searchby_phone').prop('checked') ? 'phone' : '';
        let search_shortcode_id = $.trim( $('#search_shortcode_id').val() ).replace('/ /g', '_');

        let $not_found_lbl = $.trim( $('#user_search_no_found').val() );

        if( $order_id !== '' ) search_by.push( $order_id );
        if( $email !== '' ) search_by.push( $email );
        if( $firstname !== '' ) search_by.push( $firstname );
        if( $lastname !== '' ) search_by.push( $lastname );
        if( $phone !== '' ) search_by.push( $phone );

        $('#user_search_shortcode').val( `[RAFFLE_SEARCH id="${search_shortcode_id}" search_by="${search_by.join(',')}" not_found_lbl="${$not_found_lbl}"]` );
    }

    function bmp_save_setting_ajax( $obj, $callback ){
        $('#drpLoaderImg').show();
        var data_ajax = {
            action: $obj.action,
            type: 'POST',
            data: $obj.data,
            dataType: 'json', 
            contentType: 'application/json'
        }
        
        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: data_ajax,
            beforeSend: function(){              

              if( typeof $callback !== 'undefined'){
                  $callback();
              }
            }, 
            success: function(data){
                //should display a success/error message
            
                try {
                    data = JSON.parse( data );                  
                    let lRec = false;
                    if( typeof data.live_raffle !== 'undefined'){
                        $('#rdp_life_raffle').prop('checked', data.live_raffle );
                        lRec = true;
                    }                        
                    if( typeof data.count_start_at  !== 'undefined'){                                       
                        $('#rdp_ticket_start_count_at').val( data.count_start_at );
                        lRec = true;
                    }

                    if( typeof data.last_live_ticket !== 'undefined'){
                        $('#liveLastTicketNo').val( data.last_live_ticket);
                        lRec = true; 
                    }


                    if( lRec )
                      $( '.bmp-pins-new-panel .panel-heading').bmp_message( rpwoo_local_lng.saved, 'success' );
                              
                } catch (error) {
                    $( '.bmp-pins-new-panel .panel-heading').bmp_message( rpwoo_local_lng.error_parsing_data, 'danger' ); 
                }            

            },
            error: function( request, status, error ){
             
                alert( 'Request ' + request + ' - Status: ' + status + ' - Error: ' + error);    
            },
            complete: function(){
                $('#drpLoaderImg').hide();
            }
        })
    }

    function rpwoo_fixDB(){
        $('#drpLoaderImg').show();
        var data_ajax = {
            action: 'drp_fix_db',
            type: 'POST',
            data: 'fix_db',
            dataType: 'json', 
            contentType: 'application/json'
        }

        $.ajax({
            type: 'POST',
            url: ajaxurl,
            data: data_ajax,
            beforeSend: function(){              
            }, 
            success: function(data){                           
                
                if( data == 'changed'){
                    window.location.reload();
                }
                $('#drpLoaderImg').hide();
            },
            error: function( request, status, error ){
            },
            complete: function(){               
            }
        })
    }
})(this.jQuery);