
const { createApp } = Vue;

const AJAX_LUCKY_ACTION         = 'drp_lucky_action';
const LAST_RAFFLE_ACTIVE_NAME   = 'last_raffle_active';

const lucky_settings = createApp({
    data (){
        return {
            saving          : false,
            edit_id         : '',
            action          : '',
            action_page     : '',
            raffle_id       : 0,
            random_number   : 0,
            raffles         : rpwoo_raffles,
            ava_tickets     : [],
            admin_url       : rpwoo_admin_url,
            gen_checkout    : gen_at_checkout,
            raffles_data    : JSON.parse( JSON.stringify( rpwoo_data )),
            products        : JSON.parse( JSON.stringify( rpwoo_products )),
            tickets_img     : JSON.parse( JSON.stringify( rpwoo_ticket_img )),
            img_url         : rpwoo_url,
            lucky : {
                id          : '',
                active      : true,
                active_from : 0,
                active_to   : 0,
                name        : '',
                type        : 'manual',
                dilute_no   : 0,
                hidden_number : 0,
                number      : 0,
                purchased   : 0,
                product_id  : 0,
                bg_img      : 'none',
                value       : 0,
                custom_img  : '',
                message     : 'Congratulation, you have won a %product_link%. Contact us to claim your prize.',
                is_won      : false, 
                extra_one   : '',
                extra_two   : '',
                extra_three : '',
                no_one      : 0,
                no_two      : 0,
                no_three    : 0,            
                order_id_won : 0,  
                winner : {
                   first_name : '',
                   last_name : '',
                   email : '' 
                }
            },
            last_raffle_active : 0,
            product_id : 0,
            controls :{
                show_numbers : false,                
            },
            reason : [],
        }
    },

    watch : {
    },

    methods : {

        checkAbovePurchased : function(){
            try {
                
                let max_number = 0;
                let raffle = this.getRaffleById( this.raffle_id );
                if( raffle !=  null ){
                    max_number = parseInt( raffle.limit_no );
                }                 

                if( this.lucky.purchased > max_number ){
                    this.lucky.purchased = 0;        

                    jQuery( function($){
                        $('.lucky-page .content-lucky').bmp_message( rpwoo_local_lng.include_in_draw_after + ' - ' + max_number, 'danger' ); 
                    });
                }
            } catch (error) {
                console.log( error );
            }
        },

        soldRaffleTickets : function(){
            return this.getRaffleById( this.raffle_id ).extra_info.sold_no;
        },

        getRaffleById : function( $id ){
            let item = null;

            this.raffles.forEach( el => {
                if( el.id == $id ){
                    item = el;
                }
            });

            return item;

        },

        setLastRaffleActive : function(){
            localStorage.setItem( LAST_RAFFLE_ACTIVE_NAME, this.raffle_id );
        },

        checkAboveNumber : function (){
            try {                
                let max_number = 0;

                let raffle = this.getRaffleById( this.raffle_id );
                if( raffle !=  null ){
                    max_number = parseInt( raffle.limit_no );
                }      
      
                if( this.lucky.number > max_number ){
                    this.lucky.number = 0;                   
                    jQuery( function($){
                        $('.lucky-page .content-lucky').bmp_message( rpwoo_local_lng.lucky_number_above + ' - ' + max_number, 'danger' ); 
                    });
                }
            } catch (error) {
                console.log( error );
            } 
        },

        action_control : function ( $action ){

            if( $action == 'save' && this.action == 'new'){
                this.lucky.id = this.getRandomId(); 
                this.raffles_data[ this.raffle_id ].lucky.push( JSON.parse( JSON.stringify( this.lucky )) );

                this.reset_lucky();
            }

            if( $action == 'save' && this.action == 'edit'){                
                let $item = this.findLuckyById( this.edit_id );
                $item = Object.assign( $item, this.lucky );              
            }

            if( $action == 'new'){
                this.action = $action;
                this.reset_lucky();
            }
            else this.action = '';    
            
            if( $action == 'save' ){                
                this.saveSettings();                
            }

           

        },

        canAddLucky : function( $raffle_id ){

            let result = false;           
            this.reason = [];
            let raffle = null;

            this.raffles.forEach( el => {
                if( el.id == $raffle_id ){
                    raffle = el;
                }
            });

            if( raffle != null ){

                if( raffle.is_limit && (raffle.gen_random_tickets == '1') &&
                    ( typeof this.gen_checkout[ $raffle_id ] !==  'undefined') &&
                    ( this.gen_checkout[ $raffle_id ] == 'no' ) ){
                    result = true;
                    this.reason = [];
                    
                }else{      

                    if(  ( typeof this.gen_checkout[ $raffle_id ] !==  'undefined') &&
                        ( this.gen_checkout[ $raffle_id ] == 'yes' ) ){
                            this.reason.push( rpwoo_local_lng.tickets_generated_and_dis );
                        }

                    if( ! raffle.is_limit ){
                        this.reason.push( rpwoo_local_lng.not_have_limit_tickets ); 
                    }

                    if( raffle.gen_random_tickets != '1'){
                        this.reason.push( rpwoo_local_lng.tickets_not_random_gen ); 
                    }

                    result = false;
                }
            }

            return result;
        },

        findLuckyById : function( $id ){
            let item = null;

            this.raffles_data[ this.raffle_id ].lucky.forEach(element => {
                if( element.id == $id ){
                    item = element;
                } 
            });

            return item;
        },

        raffle_tab : function( $raffle_id ){

            this.action = '';
            this.raffle_id = $raffle_id;
            this.setLastRaffleActive();

            this.reset_lucky();
            this.$refs.block_numbers.innerHTML = '';

            this.ava_tickets = [];

            this.canAddLucky( $raffle_id );
        },

        edit_lucky : function( $id ){
            this.edit_id = $id;
            let item = this.findLuckyById( $id );            

            if( item != null ){
                this.action = 'edit';
                this.lucky = JSON.parse( JSON.stringify( item ));
            }else{
                alert('Item not found');
            }
            this.imgChanged();
        },

        delete_lucky : function ( $id ){
        
            let obj = {
                raffle_id : this.raffle_id,
                id : $id
            };  
            
            let $message =  rpwoo_local_lng.delete_lucky_number;
            let lucky = this.findLuckyById( $id );
            if( lucky != null ){
                if( lucky.is_won ){
                    $message += "<br/><strong>" +  rpwoo_local_lng.won_ticket_delete + "</strong>";
                }
            }

            let options = {
                message :  $message
            };

            jQuery( function($){
                $('.lucky-page').bmp_confirm( options, confirmDel, obj );
                function confirmDel( obj ){                                   
                    lucky_settings.confirmDelete( obj.raffle_id, obj.id );
                }
            });
        },

        confirmDelete : function( $raffle_id, $id ){
            let item_index = -1;
            this.raffles_data[ $raffle_id ].lucky.forEach( (element, index) => {
                if( element.id == $id ){
                    item_index = index;
                }
            });
      
            if( item_index > -1 ){
                this.raffles_data[ $raffle_id ].lucky.splice( item_index, 1 );
                this.saveSettings();
            }
        },

        getProductName : function( $product_id ){
            return this.products[ $product_id ] || '';
        },

        hideNumbers : function(){
            this.controls.show_numbers = false;
            this.$refs.block_numbers.innerHTML = '';
        },

        reset_lucky : function ( ){
            this.lucky = {
                id          : '',
                active      : true,
                active_from : 0,
                active_to   : 0,
                name        : '',
                type        : 'manual',
                dilute_no   : 0,
                number      : 0,
                purchased   : 0,
                product_id  : 0,
                bg_img      : 'none',
                custom_img  : '',
                message     : 'Congratulation, you have won a %product_link%. Contact us to claim your prize.',
                is_won      : false, 
                value       : 0,
                extra_one   : '',
                extra_two   : '',
                extra_three : '',
                no_one      : 0,
                no_two      : 0,
                no_three    : 0,
                order_id_won : 0,  
                winner : {
                    first_name : '',
                    last_name : '',
                    email : '',
                    phone : '' 
                 }          
            };
            
        },

        imgChanged : function( $target ){            

            if( this.lucky.bg_img == 'none'){
                this.$refs.ticket_img_show.src = '';
            }else if( this.lucky.bg_img == 'custom'){
                this.$refs.ticket_img_show.src = this.lucky.custom_img;
            }else{
                this.$refs.ticket_img_show.src = this.img_url + 'images/ticket-image-' + this.lucky.bg_img + '.png';
            }
        },

        getImg : function( $lucky ){
            if( $lucky.bg_img == 'none'){
                return '';
            }else if( $lucky.bg_img == 'custom'){
                return $lucky.custom_img;
            }else{
                return this.img_url + 'images/ticket-image-' + $lucky.bg_img + '.png';
            }
        },

        getRandom : function(){

            if( this.ava_tickets.length > 0 ){
                let max = this.ava_tickets.length - 1;
                let min = 0;
                let index = Math.floor(Math.random() * ( max - min + 1) + min);

                if( typeof this.ava_tickets[ index ] !== 'undefined' ){
                    this.lucky.number = this.ava_tickets[ index ];
                    document.querySelector('.block-show-numbers #ticket-' + this.lucky.number).checked = true;
                }else{
                    alert('Number not found in the tickets range');
                }
                
            }else{
                alert('No available raffle tickets found, look up numbers first');
            }
        },

        selectNumber : function(){           
            this.getAvailbleTickets();
        },

        getAvailbleTickets : function(){
            this.saving = true;
            let _wponce_val = document.querySelector('#nonce_field_form_rpr');
            let form = new FormData();              
            
            form.append( 'action', 'drp_available_tickets_lucky' );
            form.append( 'raffle_id', this.raffle_id );
            form.append( 'nonce', _wponce_val.value || '' );
            this.btns_visib_enabled();

            fetch( ajaxurl,{
                method : 'POST',
                body : form
            })
            .then( response => response.json() )
            .then( data => { 
                if( ! data.result ){
                    alert( data.message );
                    this.btns_visib_disabled();
                    return false;
                }   


                let radios = [];
                let tickt = null;
                let all_tickets = JSON.parse( data.tickets );
                this.ava_tickets = all_tickets;

                for( let i = 0; i < all_tickets.length; i++ ){
                    tickt = all_tickets[i];
                    radios.push( `<label for="ticket-${tickt}" class='lbl-ava-ticket'> 
                            <input onclick="lucky_settings.$data.lucky.number = this.value;" name='raffle_tickets'
                             class='aval-raffle-tickets' type='radio' id="ticket-${tickt}" value="${tickt}"/> ${tickt} </label>`);
                }
    
                if( all_tickets.length == 0){
                    radios = [
                        "<p> <b>" + rpwoo_local_lng.no_available_tickets_found + "</b></p>"
                    ]
                }
                this.controls.show_numbers = true;
           
                let block_numbers = document.querySelector('.block-show-numbers');
                block_numbers.innerHTML = radios.join(' '); 

                this.btns_visib_disabled();
                
            });
        },

        btns_visib_enabled : function(){
            this.$refs.btn_select_number.classList.add('disabled');
            this.$refs.btn_div.classList.add('loader-spinner');
        },

        getRandomId : function (){
            return this.raffle_id + '_' + Math.floor( Math.random() * 1000000000000 );
        },

        btns_visib_disabled : function(){
            this.$refs.btn_select_number.classList.remove('disabled');
            this.$refs.btn_div.classList.remove('loader-spinner');
        },

        saveSettings : function (){

            this.saving = true;
            let _wponce_val = document.querySelector('#nonce_field_form_rpr');
            let form = new FormData();       
            
            form.append( 'action', AJAX_LUCKY_ACTION );
            form.append( 'page_action', this.action );
            form.append( 'data',  JSON.stringify( this.raffles_data ) );
            form.append( 'nonce', _wponce_val.value || '' );       

            fetch( ajaxurl,{
                method : 'POST',
                body : form
            })
            .then( response => response.json() )
            .then( data => { 

                try {
                    if( data.fine ){

                        jQuery( function($){
                            $('.lucky-page').bmp_message( data.message, 'success' );                            
                            this.raffles_data = JSON.parse( JSON.stringify( data ));
                        });
                       
                    }else{
                        alert( 'Error Occured. Could not save.');
                    }
                } catch (error) {
                    console.error( error );
                    alert( 'Error Occured. Could not save.');
                }   

                this.saving = false;

            })
            .catch( error =>{
                this.saving = false;
                console.error( error );
            })
        },

    },

    beforeMount(){
        this.raffles.forEach(element => {
            let $concentrate = 0;
            let limit_no = parseInt( element.limit_no );
         
            try {
                if( limit_no != 0 ){                

                    if( limit_no <= 100 && limit_no >= 50 ){
                        $concentrate = parseInt( 10 );
                    }else if( limit_no <= 1000 ){
                        $concentrate = parseInt( 60 );
                    }else if( limit_no <= 10000 ){
                        $concentrate = parseInt( 100 );
                    }else if( limit_no <= 100000 ){
                        $concentrate = parseInt( 500 );
                    }
                    
                }
            } catch (error) {
                console.log( error );  
            }

            if( typeof this.raffles_data[ element.id ] === 'undefined' ){
                this.raffles_data[ element.id ] = {              
                    lucky : [],
                    concentrate : $concentrate,
                    extra_one : '',
                    extra_two : '',
                    extra_three : '',
                    extra_no_one : 0,
                    extra_no_two : 0,
                    extra_no_three : 0,
                    last_active : false
                }
            }
        });

        let last_raff_active = localStorage.getItem( LAST_RAFFLE_ACTIVE_NAME );
        this.last_raffle_active = ( last_raff_active == null ) ? 0 : last_raff_active;
    
    },

    mounted (){         
        this.$refs.main_container.classList.add( 'show-loaded');        
        this.raffle_id = this.last_raffle_active;
        this.canAddLucky( this.raffle_id );
    }
}).mount('.lucky-page');