<?php
    if( ! defined( 'ABSPATH') ) die('No Access here');

?>

<div class="tab-pane fade show active" 
    id="v-pills-general" role="tabpanel" 
    aria-labelledby="v-pills-general-tab">                               
                                
    <?php if( ! $settings['db_health']  ){ 
        
        ?>
        <div class='row bmp-set-row' >
            <div class="col-sm-5" style='display: inline-block; color: red; font-weight: 800'> 
                <?php esc_html_e('There are issues with the DB Tables', 'raffle-play-woo' );?> 
            </div>
        
            <div class="col-sm-7" style='display: inline-block'>                               
                <input type="button" id='rpwoo_db_health' class='button button-primary'  value="<?php esc_html_e('Run Fix', 'raffle-play-woo');?>" />
            </div>
        </div>

    <?php } ?>

    <div class='row bmp-set-row' >
        <div class="col-sm-5" style='display: inline-block'> 
            <label for="rpwoo_raffle_name"> <?php esc_html_e('Raffle Name', 'raffle-play-woo' );?> </label>
        </div>
    
        <div class="col-sm-7" style=''>                               
            <input type="text"  value="<?php esc_html_e( $settings['raffle_name']);?>" id='rpwoo_raffle_name' />       
        </div>
    </div>

    <div class='row bmp-set-row' >
        <div class="col-sm-5" style='display: inline-block'> 
            <label> <?php esc_html_e('Raffle Status', 'raffle-play-woo' );?> </label>
        </div>
    
        <div class="col-sm-7" style=''>       
            <div class="checkbox disabled">                        
                <input type="checkbox"  data-toggle="toggle" readonly data-size='small' 
                    <?php echo "checked";?> id='rdp_life_raffle'
                    data-on="<?php esc_html_e('Live', 'raffle-play-woo');?>"  
                    data-off="<?php esc_html_e('Live', 'raffle-play-woo');?>" />       
            </div>
        </div>
    </div>


    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
                <?php esc_html_e('Terminate Raffle Now', 'raffle-play-woo' );?> 
            <span data-toggle='tooltip' 
                title="<?php esc_html_e('No raffle products will be available at checkout while disabled.', 'raffle-play-woo' ); ?>" > 
                <i class="fa fa-info-circle text-info"></i> 

            </span>
        </div>
    
        <div class="col-sm-7" style=''>                               
            <input type="checkbox"  data-toggle="toggle" data-size='small' id='rdp_terminate_raffle'
                data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>"  data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" 
                <?php if( $settings['terminated'] ) echo 'checked'; ?>
            />       
        </div>
    </div>

    
    <div class='row bmp-set-row' >
        <div class="col-sm-5" style='display: inline-block'> 
            <?php esc_html_e('Live Ticket Starts At', 'raffle-play-woo' );?> 
        </div>
        <div class="col-sm-7" style='display: inline-block'> 
                <input  type="text"  name="rdp_ticket_start_count_at" class='' 
                        value="<?php echo ($settings['ticket_count_starts_at'] ) ? esc_html( $settings['ticket_count_starts_at'] ) : '0'; ?>"
                        id="rdp_ticket_start_count_at" placeholder="" />

                        <span data-toggle='tooltip' 
                title="<?php esc_html_e('If changing the ticket no while raffle is running, make sure is above the last used ticket.', 'raffle-play-woo' ); ?>" > 
                <i class="fa fa-info-circle text-info"></i> 

            </span>
                    
        </div>
    </div>
    
    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Limit Number or Raffle Tickets', 'raffle-play-woo' );?> 
        </div>
    
        <div class="col-sm-7" style='display: inline-block; margin-top: 3px'>   
            <label for="radio_limit_raffle_yes">                            
                <input type='radio' <?php if( $settings['is_limited'] ) echo 'checked'; ?>  id='radio_limit_raffle_yes' name='radio_limit_raffle' /> 
                <?php esc_html_e('Yes', 'raffle-play-woo' ); ?>                                      
            </label>
            <input type="number"   id="limit_raffle_no_tickets" min='1' 
                value="<?php echo esc_html( $settings['limit_no'] ); ?>" />

            <span class="spacer5"></span>
            <span data-toggle='tooltip' 
                title="<?php esc_html_e('Generate Random Tickets within the range created by start ticket plus number of tickets. ***IMPORTANT*** Do not change the raffle ticket system from random to inline after tickets have been purchased***', 'raffle-play-woo' ); ?>" > 
                <i class="fa fa-info-circle text-info"></i> 
            </span>

            <input type="checkbox"  data-toggle="toggle" data-size='small' id='gen_random_tickets'
                data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>"  data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" 
                <?php if( $settings['gen_random_tickets'] ) echo 'checked'; ?>
            />  

            <?php esc_html_e('Generate Random Tickets ', 'raffle-play-woo' ); ?>      

            <br />
            <label for="radio_limit_raffle_no">
                <input type='radio' <?php if( ! $settings['is_limited'] ) echo 'checked'; ?>  id='radio_limit_raffle_no' name='radio_limit_raffle' /> 
                    <?php esc_html_e('No', 'raffle-play-woo' ); ?> 
            </label>
        </div>
    </div>

    <div class='row bmp-set-row border border-success' >
        <div class="col-sm-5 " style='display: inline-block'> 
                <?php esc_html_e('Generate, Reserve, and Show Raffle tickets at checkout', 'raffle-play-woo' );?> 
            <span data-toggle='tooltip' 
                title="<?php esc_html_e('The tickets will be generated and shown at checkout page', 'raffle-play-woo' ); ?>" > 
                <i class="fa fa-info-circle text-info"></i> 

            </span>
        </div>
    
        <div class="col-sm-7" style=''>                               
            <input type="checkbox"  data-toggle="toggle" data-size='small' 
                id='rdp_gen_checkout'
                data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>"  
                data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" 
                <?php if( isset(  $settings['gen_checkout'][0]) && $settings['gen_checkout'][0] == 'yes' ) echo 'checked'; ?>
            />       
        </div>
    </div>

    <div class='row bmp-set-row border border-success' style='background-color: rgba(144, 238, 144, 0.4);' >
        <div class="col-sm-5 " style='display: inline-block'> 
                <?php esc_html_e('Let customers pick tickets at checkout', 'raffle-play-woo' );?> 
            <span data-toggle='tooltip' 
                title="<?php esc_html_e('This feature only works if tickets are generated at checkout. The customer can change the raffle tickets to the desired ones', 'raffle-play-woo' ); ?>" > 
                <i class="fa fa-info-circle text-info"></i> 

            </span>
            <span class='text-success badge badge-primary'>
                <?php esc_html_e('Enable Generate and Display tickets at checkout and add background image for ticket', 'raffle-play-woo' );?> 
            </span>
            <br/>
            <span>
                <i>
                    <a href="https://youtu.be/34FZ7mUxUy0" target='_blank'>
                        <?php esc_html_e('Watch setup video here', 'raffle-play-woo'); ?> 
                    </a>
                </i> 
            </span>
        </div>
    
        <div class="col-sm-7" style=''>                               
            <input type="checkbox"  data-toggle="toggle" data-size='small' 
                id='rdp_user_pick_tickets'
                data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>"  
                data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" 
                <?php if( isset(  $settings['user_pick_tickets'][0]) && $settings['user_pick_tickets'][0] == 'yes' ) echo 'checked'; ?>
            />       
        </div>
    </div>

    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Ticket Number Leading Zeros', 'raffle-play-woo' );?> 
            <span data-toggle='tooltip'
                title="<?php esc_html_e('Put leading zeros to the number, the prefix will be included', 'raffle-play-woo' ); ?>"> 
            <i class="fa fa-info-circle text-info"></i> </span>
        </div>
    
        <div class="col-sm-7" 
            style='display: inline-block'>                               
            <input type="number" 
                min='0'
                max='20'
                placeholder="0"  id="rpwoo_leading_zeros" 
                value="<?php echo esc_html( $settings['leading_zeros'] ); ?>" 
            />  

            <p style='display: inline'> 
                <i>                                                                                 
                    <?php 
                        esc_html_e('Eg: Leading zero set to 5, prefix T-, ticket is 12 => result: T-00012', 'raffle-play-woo');
                    ?>
                </i>
            </p>
        </div>
    </div>

    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Ticket Prefix', 'raffle-play-woo' );?> 
            <span data-toggle='tooltip'
                title="<?php esc_html_e('Leave empty if no prefix wanted. (eg: Ticket-10024)', 'raffle-play-woo' ); ?>"> 
            <i class="fa fa-info-circle text-info"></i> </span>
        </div>
    
        <div class="col-sm-7" style='display: inline-block'>                               
            <input type="text" placeholder="<?php esc_html_e('Ticket-', 'raffle-play-woo' );?>"  id="rpwoo_ticket_prefix" 
                value="<?php echo stripslashes( esc_html( $settings['ticket_prefix'] )); ?>" />                                    
        </div>
    </div>

    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Raffle Start Date Time', 'raffle-play-woo' );?> 
        </div>
    
        <div class="col-sm-7" style='display: inline-block'>                               
            <input type="text" placeholder='dd-mm-yyyy' id="rpwoo_start_date"  value="<?php echo $settings['start_date']; ?>" />   
            <input type="text" placeholder='hh:mm' class='clockpicker_main' id="rpwoo_start_time"  value="<?php echo $settings['start_time']; ?>" />                                  
        </div>
    </div>

    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Raffle End Date Time', 'raffle-play-woo' );?> 
        </div>
    
        <div class="col-sm-7" style='display: inline-block'>                               
            <input type="text"  placeholder='dd-mm-yyyy' id="rpwoo_end_date"  value="<?php echo $settings['end_date']; ?>" />    
            <input type="text" class='clockpicker_main'  placeholder='hh:mm' id="rpwoo_end_time"  value="<?php echo $settings['end_time']; ?>" />                                    
        </div>
    </div>

    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Last Live Used Ticket', 'raffle-play-woo' );?> 
        </div>
    
        <div class="col-sm-7" style='display: inline-block'>                               
            <input type="number" id="liveLastTicketNo" readonly value="<?php echo $settings['live_last_ticket']; ?>" />
        </div>
    </div>


    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Live Raffle Tickets Purchased', 'raffle-play-woo' );?> 
        </div>
    
        <div class="col-sm-7" style='display: inline-block'>                               
            <input type="number" id="liveTicketsPurchased" readonly value="<?php echo $settings['live_tickets_purchased']; ?>" />
        </div>
    </div>

    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Terminate Raffle on Buy Out Product', 'raffle-play-woo' );?> 
            <span data-toggle='tooltip'
                title="<?php esc_html_e('The raffle will be set to terminated if the "Buyout Product" is sold (out of stock). Terminate Raffle by selling a single not raffle product.', 'raffle-play-woo' ); ?>"> 
            <i class="fa fa-info-circle text-info"></i> </span>
        </div>
    
        <div class="col-sm-7" style=''>                               
            <input type="checkbox"  data-toggle="toggle" data-size='small' id='rdp_enable_buy_product'
                data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>"  data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" 
                <?php if( $settings['enable_buy_product'] ) echo 'checked'; ?>
            /> 
            <?php esc_html_e('Buy Out Product ', 'raffle-play-woo' );?>  
            <?php 
                echo "<select id='buy_out_product' class='form-control' style='display: inline-block; max-width: 150px'>";

                foreach( $settings['non_raffle_products'] as  $key=>$value ){
                    $selected = '';
                    if( $settings['buy_out_product'] == $key )
                        $selected = 'selected';

                    echo "<option $selected value='$key'> $value </option>";
                }

                if( sizeof( $settings['non_raffle_products'] ) == 0 ){                                                    
                    echo "<option value='-1'> None </option>";
                }

                echo "</select>";
                $selected_opt = $settings['buy_out_product'];
                if( isset( $settings[ 'non_raffle_products' ] [ $selected_opt ] ))
                    echo '<span>' . $settings[ 'non_raffle_products' ] [ $selected_opt ] . '</span>';
            ?>
        </div>
    </div>

    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Raffle Products', 'raffle-play-woo' );?> 
        </div>
    
        <div class="col-sm-7" style='display: inline-block'>   
            <?php
                $products_to_display = esc_html__('Default Raffle has no products', 'raffle-play-woo' );
                if( $no_products > 0)
                    $products_to_display = esc_html( implode( '&#13;&#10;', $settings['products'] ) );
            ?>

            <textarea name="" class="<?php echo $class_prod;?>" id="raffle_products" 
            cols="30" rows="<?php echo $no_products + 1;?>" 
            style="width: 100%;" readonly><?php echo $products_to_display; ?></textarea>                                        
        </div>
    </div>

    <div class='row bmp-set-row border border-success' style='background-color: rgba(144, 238, 144, 0.4);' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Generate Raffle Tickets for Order Status', 'raffle-play-woo' );?> 
            <span data-toggle='tooltip' 
                title="<?php esc_html_e('Raffle Tickets will only be generated for these statuses', 'raffle-play-woo' ); ?>"> 
            <i class="fa fa-info-circle text-info"></i> </span>
        </div>
    
        <div id='order_status_generate' class="col-sm-7" style='display: inline-block'>   
            <label style="cursor: pointer;"
                    title="<?php esc_html_e('Processing', 'raffle-play-woo' ); ?>">                            
                    <input type="checkbox" id="rpwoo_checkout_order_processing"  
                        <?php if( $settings['order_status_gen']['woocommerce_order_status_processing'] == 'yes') echo 'checked'; ?>
                    />
                        <?php esc_html_e('Processing', 'raffle-play-woo' );?>                                                                        
            </label>

            <label style='margin-left: 8px; cursor: pointer;'
                title="<?php esc_html_e('Completed', 'raffle-play-woo' ); ?>">                            
                <input type="checkbox" id="rpwoo_checkout_order_completed" 
                    <?php if( $settings['order_status_gen']['woocommerce_order_status_completed'] == 'yes') echo 'checked'; ?>
                /> 
                <?php esc_html_e('Completed', 'raffle-play-woo' );?>                                                                        
            </label>

            <label style='margin-left: 8px; cursor: pointer;'
                title="<?php esc_html_e('On Hold', 'raffle-play-woo' ); ?>">                            
                <input type="checkbox"  id="rpwoo_checkout_order_onhold" 
                    <?php if( $settings['order_status_gen']['woocommerce_order_status_on-hold'] == 'yes') echo 'checked'; ?>
                /> 
                <?php esc_html_e('On Hold', 'raffle-play-woo' );?>                                                                        
            </label>
            
            <span > 
                <i data-toggle='tooltip' 
                    title='<?php esc_html_e('Tickets will only be generated for these order statuses', 'raffle-play-woo' ); ?>' class="fa fa-info-circle text-info">
                </i> 
            </span>   
            
        </div>

        <div class="alert alert-danger alert-order-status" style='display: none' role="alert">
                <?php esc_html_e('No raffle tickets will be generated. You need to select at least one order status to generate tickets. Recommending to enable Processing and Completed', 'raffle-play-woo'); ?>
        </div>

    </div>

    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Do not generate Raffle Tickets for Orders with Status:', 'raffle-play-woo' );?> 
            <span data-toggle='tooltip' 
                title="<?php esc_html_e('It wont affect the order, raffle tickets won\'t be created', 'raffle-play-woo' ); ?>"> 
            <i class="fa fa-info-circle text-info"></i> </span>
            <p> <i>( 
                <?php
                    esc_html_e('Raffle tickets wont be generated if ticked on', 'raffle-play-woo');
                ?>
                )
            </i></p>
        </div>
    
        <div id='order_status_div' class="col-sm-7" style='display: inline-block'>   
            <p>
                <label 
                        title="<?php esc_html_e('Payment failed or was declined (unpaid)', 'raffle-play-woo' ); ?>">                            
                    <input type="checkbox" checked  disabled id="rpwoo_checkout_order_failed"   /> <?php esc_html_e('Failed', 'raffle-play-woo' );?>                                                                        
                </label>

                <label 
                        title="<?php esc_html_e('Cancelled by an admin or the customer – no further action required', 'raffle-play-woo' ); ?>"">                            
                    <input type="checkbox" checked disabled id="rpwoo_checkout_order_cancelled" /> <?php esc_html_e('Cancelled', 'raffle-play-woo' );?>                                                                        
                </label>
            
                <span > 
                    <i data-toggle='tooltip' 
                        title='<?php esc_html_e('At Checkout, do not assign raffle tickets to following orders', 'raffle-play-woo' ); ?>' class="fa fa-info-circle text-info">
                    </i> 
                </span>                                                                       
            </p>
            
            <p>
                <label>                                                                                  
                    <input type="checkbox" 
                        id="rpwoo_checkout_ignore_order_processing"
                            <?php
                                if( $settings['ignore_processing'] == 'yes') echo 'checked';
                            ?>
                        /> 
                        <?php esc_html_e('Processing', 'raffle-play-woo' );?>                                                                        
                </label>  
                <label>                                                                                  
                    <input type="checkbox" 
                        id="rpwoo_checkout_ignore_order_complete" 
                            <?php
                                if( $settings['ignore_complete'] == 'yes') echo 'checked';
                            ?>
                        /> 
                        <?php esc_html_e('Complete', 'raffle-play-woo' );?>                                                                        
                </label>  
                <p id='warning_msg_order'></p>

                <p> 
                    <strong>
                        <?php
                            esc_html_e('Deprecated functionality - use function above', 'raffle-play-woo');
                        ?>
                    </strong>
                </p>
            </p>

        </div>
    </div>

    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Raffle Duplicate Tickets', 'raffle-play-woo' );?> 
            <span data-toggle='tooltip' 
                title='<?php esc_html_e('Two customers buying raffle products at the same time, might cause the db to overlap the orders, and create duplicate tickets. Chances are minimal. But the system will spot any malfunctions ', 'raffle-play-woo' ); ?>'> 
            <i class="fa fa-info-circle text-info"></i> </span>
        </div>
        
        <div id='div_issue_block' class="col-sm-7" style='display: inline-block'>  
            <b>
            <?php esc_html_e('Functionality moved into "View Tickets" page - now checking per raffle', 'raffle-play-woo' );?>       
            </b>
        </div>
    </div>

    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Enable Duplicates Fixing after Order Created', 'raffle-play-woo' );?> 
            <span data-toggle='tooltip' 
                title='<?php esc_html_e('Are you getting duplicated tickets? Enable this option, and the system will check for duplicates, and fix them after the order is created', 'raffle-play-woo' ); ?>'> 
            <i class="fa fa-info-circle text-info"></i> </span>
        </div>
        
        <div class="col-sm-7" >                               
            <input type="checkbox"  data-toggle="toggle" data-size='small' 
                <?php if( $settings['check_duplicates'] == 'yes') echo "checked";?> 
                    id='rdp_check_duplicates'
                    data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>"  
                    data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" />       
        </div>
    </div>

    
    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Show Countdown on Product Page', 'raffle-play-woo' );?> 
            <span data-toggle='tooltip' 
                title='<?php esc_html_e('Show Countdown if Raffle has start date or end date set for the products linked to this raffle.', 'raffle-play-woo' ); ?>'> 
            <i class="fa fa-info-circle text-info"></i> </span>

        </div>
        
        <div class="col-sm-7" >  
            <div >                             
                <input type="checkbox"  data-toggle="toggle" data-size='small' 
                    <?php if( $settings['show_countdown'] == 'yes') echo "checked";?> 
                        id='rdp_show_countdown'
                        data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>"  
                        data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" />  
                        
                <span style='width: 205px; margin-left: 20px; margin-top: -3px;'>
                    <img width='200' style='max-width: 200px' 
                        src="<?php echo esc_url_raw( RAFFLE_PLAY_WOO_URL .'/images/countdown-image.png');?>" 
                        alt="<?php esc_html_e('Countdown Image', 'raffle-play-woo');?>" />
                </span>
            </div>

            <div>
                <hr />
                <?php esc_html_e('Position on Product page', 'raffle-play-woo'); ?>
                <br />
                <select name="countdown_pos" id="countdown_pos">                       
                    <?php

                        $options = array(
                            'woocommerce_before_single_product' 		=> esc_html__('Before Single Product', 'raffle-play-woo'),
                            'woocommerce_before_single_product_summary' => esc_html__('Before Single Product Summary', 'raffle-play-woo'),
                            'woocommerce_single_product_summary' 		=> esc_html__('Top of Single Product Summary', 'raffle-play-woo'),
                            'woocommerce_before_add_to_cart_form' 		=> esc_html__('Before Add to Cart Form', 'raffle-play-woo'),
                            'woocommerce_before_variations_form'        => esc_html__('Before Variations Form', 'raffle-play-woo'),
                            'woocommerce_before_add_to_cart_button'     => esc_html__('Before Add to Cart Button', 'raffle-play-woo'),
                            'woocommerce_before_single_variation'     	=> esc_html__('Before Single Variation', 'raffle-play-woo'),
                            'woocommerce_before_single_variation'    	=> esc_html__('Before Single Variation', 'raffle-play-woo'),
                            'woocommerce_before_add_to_cart_quantity' 	=> esc_html__('Before Add to Cart Quanitity', 'raffle-play-woo'),
                            'woocommerce_after_add_to_cart_quantity' 	=> esc_html__('After Add to Cart Quanitity', 'raffle-play-woo'),
                            'woocommerce_after_add_to_cart_button'      => esc_html__('After Add to Cart Button', 'raffle-play-woo'),
                            'woocommerce_after_add_to_cart_form'        => esc_html__('After Add to Cart Form', 'raffle-play-woo'),
                            'woocommerce_after_single_product_summary'  => esc_html__('After Single Product Summary', 'raffle-play-woo')
                        );

                        foreach( $options as $key => $val ){  
                            if( $settings['countdown']['pos'] == $key ){
                                echo "<option value='$key' selected> $val </option>";
                            }else{                                           
                                echo "<option value='$key'> $val </option>";
                            }
                        }
                    ?>
                </select>  
                <span>
                    <?php echo sprintf( esc_html__('View Positions %s', 'raffle-play-woo'), '<a href="https://www.businessbloomer.com/woocommerce-visual-hook-guide-single-product-page" target="_blank">' . 
                                esc_html__('Here', 'raffle-play-woo') . '</a>'); ?>
                </span>
                <p style='font-size:.8rem'>
                    <i>
                        <?php esc_html_e('The countdown does not show in the position you have selected? Some themes change the position of hooks with different style or html applied to the page.', 'raffle-play-woo' );?> 
                    </i>
                </p>
                
            </div>
        </div>
    </div>

    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Show Countdown on Shop Grid Cards', 'raffle-play-woo' );?> 
            <span data-toggle='tooltip' 
                title='<?php esc_html_e('Show Countdown if Raffle has start date or end date set for the products linked to this raffle.', 'raffle-play-woo' ); ?>'> 
                <i class="fa fa-info-circle text-info"></i> 
            </span>                                   

        </div>
        
        <div class="col-sm-7" >  
            <div >                             
                <input type="checkbox"  data-toggle="toggle" data-size='small' 
                    <?php if( $settings['show_countdown_card'] == 'yes') echo "checked";?> 
                        id='show_countdown_card'
                        data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>"  
                        data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" />  
                        
                <span style='width: 205px; margin-left: 20px; margin-top: -3px;'>
                    <img width='150' style='max-width: 150px' 
                        src="<?php echo esc_url_raw( RAFFLE_PLAY_WOO_URL .'/images/countdown-card-image.png');?>" 
                        alt="<?php esc_html_e('Countdown Image', 'raffle-play-woo');?>" />
                </span>
            </div>

            <div>
                <hr />
                <?php esc_html_e('Position on Grid Card', 'raffle-play-woo'); ?>
                <br />
                <select name="countdown_card_pos" id="countdown_card_pos">                       
                    <?php

                        $options = array(
                            'woocommerce_before_shop_loop_item' 		=> esc_html__('Before Loop Item', 'raffle-play-woo'),
                            'woocommerce_before_shop_loop_item_title'   => esc_html__('Before Loop Item Title', 'raffle-play-woo'),
                            'woocommerce_shop_loop_item_title' 		    => esc_html__('Shop Loop Item Title', 'raffle-play-woo'),
                            'woocommerce_after_shop_loop_item_title' 	=> esc_html__('After Loop Item Title', 'raffle-play-woo'),
                            'woocommerce_after_shop_loop_item'          => esc_html__('After Price Loop Item', 'raffle-play-woo')
                        );

                        foreach( $options as $key => $val ){  
                            if( $settings['countdown_card_pos'] == $key ){
                                echo "<option value='$key' selected> $val </option>";
                            }else{                                           
                                echo "<option value='$key'> $val </option>";
                            }
                        }
                    ?>
                </select>  
                <span>
                    <?php echo sprintf( esc_html__('View Positions %s', 'raffle-play-woo'), '<a href="https://www.businessbloomer.com/woocommerce-visual-hook-guide-archiveshopcat-page/" target="_blank">' . 
                                esc_html__('Here', 'raffle-play-woo') . '</a>'); ?>
                </span>
                <p style='font-size:.8rem'>
                    <i>
                        <?php esc_html_e('Some themes change the position of hooks with different style or html applied to the page.', 'raffle-play-woo' );?> 
                    </i>
                </p>
                
            </div>
        </div>
    </div>

    <!-- progress bar -->
    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Show Progress Bar on Product Page', 'raffle-play-woo' );?> 
            <span data-toggle='tooltip' 
                title='<?php esc_html_e('Show Progress Bar, if the raffle has limited number of tickets', 'raffle-play-woo' ); ?>'> 
            <i class="fa fa-info-circle text-info"></i> </span>

            
            
        </div>
        
        <div class="col-sm-7" >  
            <div >                             
                <input type="checkbox"  data-toggle="toggle" data-size='small' 
                    <?php if( $settings['pb']['show_pb_prod'] == 'yes') echo "checked";?> 
                        id='show_pb_prod'
                        data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>"  
                        data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" />  
                        
                <span style='width: 285px; margin-left: 20px; margin-top: -3px;'>
                    <img width='300' style='max-width: 300px' 
                        src="<?php echo esc_url_raw( RAFFLE_PLAY_WOO_URL .'/images/progress-bar-image.png');?>" 
                        alt="<?php esc_html_e('Progressbar Image', 'raffle-play-woo');?>" />
                </span>
            </div>

            <div>
                <hr />
                <?php esc_html_e('Position on Product page', 'raffle-play-woo'); ?>
                <br />
                <select name="pb_prod_pos" id="pb_prod_pos">                       
                    <?php

                        $options = array(
                            'woocommerce_before_single_product' 		=> esc_html__('Before Single Product', 'raffle-play-woo'),
                            'woocommerce_before_single_product_summary' => esc_html__('Before Single Product Summary', 'raffle-play-woo'),
                            'woocommerce_single_product_summary' 		=> esc_html__('Top of Single Product Summary', 'raffle-play-woo'),
                            'woocommerce_before_add_to_cart_form' 		=> esc_html__('Before Add to Cart Form', 'raffle-play-woo'),
                            'woocommerce_before_variations_form'        => esc_html__('Before Variations Form', 'raffle-play-woo'),
                            'woocommerce_before_add_to_cart_button'     => esc_html__('Before Add to Cart Button', 'raffle-play-woo'),
                            'woocommerce_before_single_variation'     	=> esc_html__('Before Single Variation', 'raffle-play-woo'),
                            'woocommerce_before_single_variation'    	=> esc_html__('Before Single Variation', 'raffle-play-woo'),
                            'woocommerce_before_add_to_cart_quantity' 	=> esc_html__('Before Add to Cart Quantity', 'raffle-play-woo'),
                            'woocommerce_after_add_to_cart_quantity' 	=> esc_html__('After Add to Cart Quantity', 'raffle-play-woo'),
                            'woocommerce_after_add_to_cart_button'      => esc_html__('After Add to Cart Button', 'raffle-play-woo'),
                            'woocommerce_after_add_to_cart_form'        => esc_html__('After Add to Cart Form', 'raffle-play-woo'),
                            'woocommerce_after_single_product_summary'  => esc_html__('After Single Product Summary', 'raffle-play-woo')
                        );

                        foreach( $options as $key => $val ){  
                            if( $settings['pb']['pb_prod_pos'] == $key ){
                                echo "<option value='$key' selected> $val </option>";
                            }else{                                           
                                echo "<option value='$key'> $val </option>";
                            }
                        }
                    ?>
                </select>  
                <span>
                    <?php echo sprintf( esc_html__('View Positions %s', 'raffle-play-woo'), '<a href="https://www.businessbloomer.com/woocommerce-visual-hook-guide-single-product-page" target="_blank">' . 
                                esc_html__('Here', 'raffle-play-woo') . '</a>'); ?>
                </span>
                <p style='font-size:.8rem'>
                    <i>
                        <?php esc_html_e('The Progress bar does not show in the position you have selected? Some themes change the position of hooks with different style or html applied to the page.', 'raffle-play-woo' );?> 
                    </i>
                </p>
                
            </div>
        </div>
    </div>

    <div class='row bmp-set-row' >
        <div class="col-sm-5 " style='display: inline-block'> 
            <?php esc_html_e('Show Progress Bar on Shop Grid Cards', 'raffle-play-woo' );?> 
            <span data-toggle='tooltip' 
                title='<?php esc_html_e('Show Progress bar if the raffle has limited number of tickets.', 'raffle-play-woo' ); ?>'> 
            <i class="fa fa-info-circle text-info"></i> </span>

        </div>
        
        <div class="col-sm-7" >  
            <div >                             
                <input type="checkbox"  data-toggle="toggle" data-size='small' 
                    <?php if( $settings['pb']['show_pb_card'] == 'yes') echo "checked";?> 
                        id='show_pb_card'
                        data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>"  
                        data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" />  
                        
                <span style='width: 180px; margin-left: 20px; margin-top: -3px;'>
                    <img width='150' style='max-width: 150px;' 
                        src="<?php echo esc_url_raw( RAFFLE_PLAY_WOO_URL .'/images/progress-bar-card-image.png');?>" 
                        alt="<?php esc_html_e('Progress Bar Image', 'raffle-play-woo');?>" />
                </span>
            </div>

            <div>
                <hr />
                <?php esc_html_e('Position on Grid Card', 'raffle-play-woo'); ?>
                <br />
                <select name="pb_card_pos" id="pb_card_pos">                       
                    <?php

                        $options = array(
                            'woocommerce_before_shop_loop_item' 		=> esc_html__('Before Loop Item', 'raffle-play-woo'),
                            'woocommerce_before_shop_loop_item_title'   => esc_html__('Before Loop Item Title', 'raffle-play-woo'),
                            'woocommerce_shop_loop_item_title' 		    => esc_html__('Shop Loop Item Title', 'raffle-play-woo'),
                            'woocommerce_after_shop_loop_item_title' 	=> esc_html__('After Loop Item Title', 'raffle-play-woo'),
                            'woocommerce_after_shop_loop_item'          => esc_html__('After Price Loop Item', 'raffle-play-woo')
                        );

                        foreach( $options as $key => $val ){  
                            if( $settings['pb']['pb_card_pos'] == $key ){
                                echo "<option value='$key' selected> $val </option>";
                            }else{                                           
                                echo "<option value='$key'> $val </option>";
                            }
                        }
                    ?>
                </select>  
                <span>
                    <?php echo sprintf( esc_html__('View Positions %s', 'raffle-play-woo'), '<a href="https://www.businessbloomer.com/woocommerce-visual-hook-guide-archiveshopcat-page/" target="_blank">' . 
                                esc_html__('Here', 'raffle-play-woo') . '</a>'); ?>
                </span>
                <p style='font-size:.8rem'>
                    <i>
                        <?php esc_html_e('Some themes change the position of hooks with different style or html applied to the page.', 'raffle-play-woo' );?> 
                    </i>
                </p>
                
            </div>
        </div>
    </div>

</div>