<?php

if( ! defined( 'ABSPATH') ){ die('No access to this page'); }

    include_once( RAFFLE_PLAY_WOO_DIR_PATH . '/includes/RafflePlayWoo_Includes.php');
    function drp_ViewPage( $settings ){
        RafflePlayWoo_Includes::rpwoo_loading_screen(); 

        try {
            $support_expiry = '';
            if( ( $settings['license'] != '') && isset( $settings['license']->data->expiresAt ) ){
                $support_expiry =  esc_html( $settings['license']->data->expiresAt );
                if( $support_expiry != '' ){
                    $support_expiry = strtotime( $support_expiry );
                    if( $support_expiry < time() ){
                        $support_expiry = true;
                    }else{
                        $support_expiry = false;
                    }
                }
            }
        } catch (\Throwable $th) {
            //throw $th;
        }

    ?>     
        <div class='wrap view-tickets-page'>
            <div class="container-fluid">
                <?php
                    RafflePlayWoo_Includes::rpwoo_contact_link();
                ?>

                <?php wp_nonce_field( 'nonce_field_form_rpr', 'nonce_field_form_rpr' ); ?>
           
                <div class="panel panel-default bmp-pins-new-panel">

                    <div class="panel-heading">                  
                        <h3 class='show-tooltip-ticket h4' data-toggle='tooltip' title=''> <?php esc_html_e('View Tickets', 'raffle-play-woo');?></h3>  
                        <?php
                            if( $support_expiry ){
                                echo '<span class="text-danger text-weight-bold">'. esc_html__('Expired support and updates - contact us', 'raffle-play-woo') . '</span>';
                            }
                        ?>                                                         
                    </div>
                    
                    <div class="panel-body">
                        <div class='row bmp-set-row' >
    
                            <div id="divViewFilter">
                                <div style='display: none;'>
                                    <input type="checkbox"  id="ckbTypeData" <?php echo 'checked';?> data-toggle="toggle"
                                        data-size='small'
                                        data-on='<?php esc_html_e('Live', 'raffle-play-woo');?>'
                                        data-off="<?php esc_html_e('Test', 'raffle-play-woo');?>" /> 
                                </div>

                                <button class='button button-primary' style='display: none;' id="btnBackup" ><?php esc_html_e('Backup', 'raffle-play-woo');?></button>
                                <button class='button button-primary' id="btnViewFilter" ><?php esc_html_e('Filter', 'raffle-play-woo');?></button>

                                <strong > <span id="mainFilterInfo"> <span id="filterInfo"> </span>
                                 <span id='filterClear' data-toggle='tooltip'  title="<?php esc_html_e('Clear Filter', 'raffle-play-woo' ) ?>"> <i class="fas fa-calendar-times"></i> </span> </span> </strong>
                        
                                <button class='btn btn-primary btn-small border-danger' style='float: right; margin-right: 43px; margin-top: -16px' id="btnDeleteTickets" >
                                    <?php esc_html_e('Delete All Raffle Tickets', 'raffle-play-woo');?>
                                </button>

                            </div>

                            <div id='p_view_order_modal'> 

                                <label for="view_order_modal" class='bmp-set-row'>
                                    <i class="fa fa-eye view-order-link"></i>  
                                    <input type="checkbox" checked name="" id="view_order_modal"> <?php esc_html_e('Order in Modal', 'raffle-play-woo' ); ?>
                                </label>

                                <label for="view_order_tickets" class='spacer5 bmp-set-row'>                                    
                                    <input type="checkbox" name="" id="view_order_tickets"> <?php esc_html_e('View Tickets by Order', 'raffle-play-woo' ); ?>
                                </label>

                                <?php
                                    echo "<span class='bmp-set-row spacer5'>";
                                   
                                    echo "<b>";
                                    esc_html_e('Raffle', 'raffle-play-woo' );
                                    echo "</b>";
                                    
                                    echo RafflePlayWoo_Includes::rpwoo_create_dropdown( $settings['raffles'], 'raffles_list', $settings['last_raffle_view'] );
                                    echo "</span>";
                                ?>
                            </div>

                            <div id='div_filter_status' class='bmp-set-row'>
                                    <p>
                                    <?php
                                    // to be implemented
                                        echo "<span id='order_status_filter_header'>";
                                        echo "<strong>";
                                        esc_html_e('Order Status ', 'raffle-play-woo' );
                                        echo " </strong>";
                                        echo "</span>";
                                        $title = esc_html__('wait to load after changing status', 'raffle-play-woo' );
                                        foreach( $settings['statuses'] as $key=>$value ){
                                                $checked = '';
                                                if( in_array( $key, $settings['saved_statuses']) )
                                                    $checked = 'checked';
                                                echo "<label title='{$title}' data-toggle='tooltip' data-placement='bottom' style='margin-right: 10px;'> <input {$checked} id='{$key}' class='form-control' type='checkbox' /> {$value}  </label> <span> </span>";
                                        }  
                                                                             
                                    ?>
                                  
                                    </p>

                                    
                                    <button id='btn_print_tickets' class='btn btn-secondary' type='submit'>                                                                            
                                        <?php esc_html_e('Print Tickets', 'raffle-play-woo' ); ?>
                                    </button>                                  
                                    
                                    <button id='btn_duplicates' class='btn btn-secondary'>
                                        <span class='dup-no'></span>                                        
                                        <?php esc_html_e('Duplicates', 'raffle-play-woo' ); ?>
                                    </button>
                                </div>



                            <table class="table table-striped" id="tbl_view"                              
                                data-show-export="true" >
                                <thead>

                                </thead>
                                <tbody class='bmp-set-row'>

                                </tbody>

                                <tfoot>

                                </tfoot>
                            </table>

                            <p class='text-info text-center h6'>
                                <?php esc_html_e('To export all raffle tickets go to Reports Tab > Export By Raffle Ticket', 'raffle-play-woo' );?>
                            </p>
                        </div>
                    
                    </div> 

                </div> 

            </div> <!-- /container-fluid -->
        </div> <!-- /wrap -->
        

          <!-- Modal -->
        <div class="modal" id="modalViewFilter"  tabindex="-1" role="dialog" >
            <div class="modal-dialog">
            <div class="modal-content">
                <div class='modal-headline'></div>

                <div class="modal-header">
                    <h4 class="modal-title"><?php esc_html_e('Filter', 'raffle-play-woo');?> </h4>
                        <button type="button" class="close modal-close-btn" id='modal_close_btn' data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>

                <div class="modal-body">

                    <div class="row">
                        <div class="col-sm-2">
                            <b> <?php esc_html_e('From', 'raffle-play-woo' );?> </b>
                        </div>
                        <div class="col-sm-9">    
                            <div class='modal-dates-wrapper'>                       
                                <input type="text" id="datepicker_from">  
                                <!--
                                <div class="input-group clockpicker" data-autoclose="true">
                                    <input type="text" id="timepicker_from" class="form-control" readonly value="00:00"  >
                                    <span class="input-group-addon">
                                        <span class="glyphicon glyphicon-time"></span>
                                    </span>
                                </div>
                                -->
                            </div>
                           
                        </div>
                    </div>
                    <p></p>
                    <div class="row">
                        <div class="col-sm-2">
                            <b> <?php esc_html_e('To', 'raffle-play-woo' );?> </b>
                        </div>
                        <div class="col-sm-9">                          
                            <div class='modal-dates-wrapper'>                       
                                <input type="text" id="datepicker_to">  
                                <!--
                                <div class="input-group clockpicker" data-autoclose="true">
                                    <input type="text" id="timepicker_to" class="form-control" readonly value="23:59"  >
                                    <span class="input-group-addon">
                                        <span class="glyphicon glyphicon-time"></span>
                                    </span>
                                </div>
                                -->
                            </div>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="button button-primary" id="btnFilterSave"><?php esc_html_e('Filter', 'raffle-play-woo');?></button>
                    <button type="button" class="button button-default" data-dismiss="modal"><?php esc_html_e('Cancel', 'raffle-play-woo');?></button>              
                    <button type="button" class="button button-secondary" id="btnFilterClear"><?php esc_html_e('Clear', 'raffle-play-woo');?></button>
                </div>
            </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->
        

        
        <!-- Modal -->
        <div class="modal" id="modalPrintTickets"  tabindex="-1" role="dialog" >
            <div class="modal-dialog">
            <div class="modal-content">
                <div class='modal-headline'></div>

                <div class="modal-header">
                    <h4 class="modal-title"><?php  esc_html_e('Print Options', 'raffle-play-woo'); ?> </h4>
                        <button type="button" class="close modal-close-btn" id='modal_close_btn' data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>

                <div class="modal-body">    
                    
                    <div class="row" style='font-size: .8rem;'>
                        <i>
                            <b>
                                <?php esc_html_e('When printing if the background image is not visible, go to print page -> More Settings and select "Background graphics" from the options.', 'raffle-play-woo'); ?>
                            </b>
                        </i>
                    </div>
                    
                    <p></p>

                    <div class="row">
                        <label for="inputTicketWidth" class="col-sm-5 col-form-label" > <?php esc_html_e('Ticket Width', 'raffle-play-woo') ?> (px)</label>
                        <div class="col-sm-5">
                        <input type="number" class="form-control" id="inputTicketWidth" value='120' >
                        </div>
                    </div>
                    

                    <p></p>

                    <div class="row">
                        <label for="inputTicketHeight" class="col-sm-5 col-form-label"> <?php esc_html_e('Ticket Height', 'raffle-play-woo') ?> (px) </label>
                        <div class="col-sm-5">
                        <input type="number" class="form-control" id="inputTicketHeight" value='82' >
                        </div>
                    </div>

                    <p></p>

                    <div class="row">
                        <label for="inputTicketHeight" class="col-sm-5 col-form-label"> <?php esc_html_e('Line Height', 'raffle-play-woo') ?> (px) </label>
                        <div class="col-sm-5">
                        <input type="number" class="form-control" id="inputLineHeight" value='68' >
                        </div>
                    </div>

                    <p></p>

                    <div class="row">
                        <label for="inputTextSize" class="col-sm-5 col-form-label"> <?php esc_html_e('Text Size', 'raffle-play-woo') ?> (px) </label>
                        <div class="col-sm-5">
                        <input type="number" class="form-control" id="inputTextSize"  value='27' >
                        </div>
                    </div>

                    <p></p>

                    <div class="row">
                        <label for="inputTextColor" class="col-sm-5 col-form-label"> 
                            <?php esc_html_e('Text Color', 'raffle-play-woo') ?> 
                        </label>
                        <div class="col-sm-5">
                            <input type="text" class="form-control" id="inputTextColor"  value='black' >
                        </div>
                    </div>

                    <p></p>

                    <div class="row">
                        <div class="col-sm-5"></div>
                        <div class="col-sm-5">
                        <div class="">
                            <input class="form-control" type="checkbox" checked id="ckbIncludePrefix">
                            <label for="ckbIncludePrefix">
                                <?php esc_html_e('Include Prefix', 'raffle-play-woo'); ?>
                            </label>
                        </div>
                        </div>
                    </div>
                    
                    <p></p>

                    <div class="row">
                        <div class="col-sm-5"></div>
                        <div class="col-sm-5">
                        <div class="">
                            <input class="form-control" type="checkbox" checked id="ckbIncludeZero">
                            <label  for="ckbIncludeZero">
                                <?php esc_html_e('Include Leading Zero', 'raffle-play-woo'); ?>
                            </label>
                        </div>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">                   
                    <button type="button" class="button button-default" data-dismiss="modal"><?php esc_html_e('Cancel', 'raffle-play-woo');?></button>    
                    <button type="button" class="button button-primary" id="btnPrint"><?php esc_html_e('Print', 'raffle-play-woo');?></button>                             
                </div>
            </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->
        

        <!-- Modal -->
        <div class="modal" id="modalViewOrder"  tabindex="-1" role="dialog" >
            <div class="modal-dialog modal-lg">
            <div class="modal-content" style="margin-top: -100px;">
                <div class='modal-headline'></div>
                
                <div class="modal-header">
                    <h4 class="modal-title"><?php esc_html_e('Filter', 'raffle-play-woo');?> </h4>
                        <button type="button" class="close modal-close-btn" id='modal_close_btn' data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>

                <div class="modal-body">
                    <iframe id='view_order_frame' 
                         frameborder="0" width='100%'></iframe>
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="btn btn-primary" id=""><?php esc_html_e('Close', 'raffle-play-woo');?></button>
                </div>
            </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->



        <!-- Modal -->
        <div class="modal" id="modalEditTicket"  tabindex="-1" role="dialog" >
            <div class="modal-dialog modal-lg">
            <div class="modal-content" style="margin-top: -100px;">
                <div class='modal-headline'></div>
                
                <div class="modal-header">
                    <h3 class="modal-title"><?php esc_html_e('Edit Ticket', 'raffle-play-woo');?> - <span id='ticketHeader'> </span> </h3>
                        <button type="button" class="close modal-close-btn" id='modal_close_btn' data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>

                <div class="modal-body">
                    <h3 class='text-danger h6 text-center'> <?php esc_html_e('After changing ticket, resend email order details to customer.', 'raffle-play-woo');?> </h3>
                    <p> <?php esc_html_e('Order Id', 'raffle-play-woo');?> - <span class="modal-order-id"></span> </p>
                    <p> 
                        <?php esc_html_e('Change Ticket Number to: ', 'raffle-play-woo');?>

                        <input type="number" class="change-ticket-to" />
                        <button class='btn btn-primary' id='btn_change_ticket'>
                            <?php esc_html_e('Change', 'raffle-play-woo');?>
                        </button>
                        <button class='btn btn-primary' id='btn_rand_ticket'
                            title="<?php esc_html_e('Random from available tickets', 'raffle-play-woo');?>">
                            <?php esc_html_e('Give Random', 'raffle-play-woo');?>
                        </button>

                        <button type='button' 
                            id='btn_tickets_history'
                            class='btn btn-primary'
                            style='float: right;'
                            >
                            <?php esc_html_e('History Changes', 'raffle-play-woo');?>
                        </button>
                    </p>

                    <div>
                        <p> 
                            <?php esc_html_e('Available Tickets', 'raffle-play-woo');?> 
                            <strong>
                                <i>   (<?php esc_html_e('up to 1000 random tickets will be displayed, can be increased, use filter ', 'raffle-play-woo');?> ) 
                                        <code> raffle_availabe_random_tickets </code>
                                </i>
                            </strong>
                        </p>
                        <hr />
                        <div class='div-available-tickets'>
                            <?php esc_html_e('Please Wait.', 'raffle-play-woo');?>
                        </div>
                    </div>

                    
                </div>
                <div class="modal-footer">
                    <input type="hidden" name="" id='change_order_id' />
                    <input type="hidden" name="" id='change_old_ticket' />
                    <input type="hidden" name="" id='change_raffle_id' />

                    <button type="button" data-dismiss="modal" class="btn btn-primary" 
                    id="btn_close"><?php esc_html_e('Close', 'raffle-play-woo');?></button>
                </div>
            </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->

        <!-- Modal -->
        <div class="modal" id="modalDuplicates"  tabindex="-1" role="dialog" >
            <div class="modal-dialog modal-lg">
            <div class="modal-content" style="margin-top: -100px;">
                <div class='modal-headline'></div>
                
                <div class="modal-header">
                    <h4 class="modal-title"><?php esc_html_e('Duplicates found in this raffle', 'raffle-play-woo');?> </h4>

                        <button type="button" class="close modal-close-btn" id='modal_close_btn' data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>

                <div class="modal-body">     
                    <div class="div-duplicates">

                        <div class="div-duplicates-info">
                            <span>
                                <i> <?php esc_html_e('Why Duplicates? Slow hosting, too many order requests at the same time (server cannot cope), caching issues.', 'raffle-play-woo');?> </i>
                            </span>
                            <span>
                                <i> <?php esc_html_e('In the next version you will be able to fix duplicates from this page.', 'raffle-play-woo');?> </i>
                            </span>
                        </div>

                        <table class='table'>
                            <thead>
                                <tr>
                                    <th> <?php esc_html_e('Ticket', 'raffle-play-woo');?></th>
                                    <th> <?php esc_html_e('Orders', 'raffle-play-woo');?></th>                                  
                                </tr>
                            </thead>
                            <tbody>
                                
                            </tbody>
                        </table>
                                        
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="btn btn-primary" id=""><?php esc_html_e('Close', 'raffle-play-woo');?></button>
                </div>
            </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->
      
        <!-- Modal -->
        <div class="modal" id="modalBackup"  tabindex="-1" role="dialog" >
            <div class="modal-dialog ">
            <div class="modal-content">
                <div class='modal-headline'></div>

                <div class="modal-header">
                <h4 class="modal-title"><?php esc_html_e('Backup Actions', 'raffle-play-woo');?> </h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <div class="modal-body">
                    <div class="row">
                        <div class="col-sm-5">
                            <label for="input_backup_name">
                                <?php esc_html_e('Backup Name (max 10 characters)*', 'raffle-play-woo' ); ?>
                            </label>
                        </div>
                        <div class="col-sm-5">                           
                            <input type='text' id='input_backup_name' class='form-control' />                            
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-5">
                            
                        </div>
                        <div class="col-sm-7" style='margin-top: 5px;'>
                            <label for="radio_backup_alldata">                          
                                <input type="radio" name="radio_backup_data" id="radio_backup_alldata"> <?php esc_html_e('Backup All Live Data','raffle-play-woo'); ?>
                            </label>

                            <label for="radio_backup_viewdata">
                                <input checked type="radio" name="radio_backup_data" id="radio_backup_viewdata"> <?php esc_html_e('Backup Data from Table View', 'raffle-play-woo'); ?>
                            </label>
                        </div>

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="button button-primary" id=""><?php esc_html_e('Execute', 'raffle-play-woo');?></button>
                    <button type="button" data-dismiss="modal" class="button button-secondary" id=""><?php esc_html_e('Cancel', 'raffle-play-woo');?></button>
                </div>
            </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->

        <script>
            try {
                var RPWOO_ORDER_STATUSES = <?php echo json_encode( $settings['statuses'] ); ?>;
                
            } catch (error) {
                
            }
          
        </script>


      <?php  
    }

?>