<?php

namespace W_RafflePlayWoo_Promotion;

if( ! defined('ABSPATH')) exit;

include_once( RAFFLE_PLAY_WOO_DIR_PATH . '/includes/RafflePlayWoo_Includes.php');

class W_RafflePlayWoo_Promotion{

    public static function drp_promotionPage( $data ){

        \RafflePlayWoo_Includes::rpwoo_loading_screen();
     
    ?> 
    
        <script>
            var rpwoo_data        = <?php echo $data['data'];?>;  
            var rpwoo_raffles     = <?php echo json_encode( $data['raffles'] );?>;       
            const rpwoo_symbol    = "<?php echo $data['currency']; ?>";
            const raffle_icon     = "<?php echo esc_url( $data['raffle_icon']);?>";
            const categories      = <?php echo json_encode( $data['categories'] );?>;  
        </script>


        

        <div class='wrap promotion-page'>

            <div class="container-fluid" 
                ref='main_container' style='visibility: hidden;'>

                <?php
                    \RafflePlayWoo_Includes::rpwoo_contact_link();
                ?>

                <div class="bmp-set-row">

                    <h3 class='h4'> <?php esc_html_e('Promotional Raffle', 'raffle-play-woo'); ?> </h3>
                    <p style='font-size: .85rem;'> 
                        <i> 
                            <?php esc_html_e('Create a promotional raffle with free tickets to boost your sales on your shop.', 'raffle-play-woo'); ?> 
                        </i> 
                    </p>
                    <p style='font-size: .85rem; margin-top: -7px;'> 
                        <i>
                            <?php esc_html_e('Reward customers with free raffle tickets for each purchase they make', 'raffle-play-woo'); ?> 
                        </i> 
                    </p>

                    <p style='font-size: .9rem; margin-top: -7px; font-weight: 600;'> 
                        <i>
                            <a href="https://youtu.be/QeSFjQ2zKvo" target='_blank'>
                                <?php esc_html_e('Watch promotional raffle setup video here', 'raffle-play-woo'); ?> 
                            </a>
                        </i> 
                    </p>

                    <div>                 

                        <table class='table table-bordered table-hover' id='tbl_prom'>
                            <thead>
                                <tr>
                                    <th> <?php esc_html_e('Action', 'raffle-play-woo'); ?>     </th>
                                    <th> <?php esc_html_e('Promotion Name', 'raffle-play-woo'); ?>       </th>
                                    <th> <?php esc_html_e('Rules', 'raffle-play-woo'); ?>      </th>
                                </tr>
                            </thead>
                                <tr v-for="(item, raffle_id ) in proms" style='margin: 13px;'
                                    :class="{'row-prom-inactive' : ! item.active, 'row-prom-active' : item.active }" >

                                    <td> <!-- Action icons -->
                                        <div>   

                                            <span class="nav-item text-primary btn-adit" 
                                                href="#" @click='actionRule("edit", raffle_id )' 
                                                style='width: 50px; cursor: pointer;'>
                                                <i class="fa fa-edit"></i>  
                                             
                                            </span>

                                            <span class="nav-item text-primary btn-delete" 
                                                href="#" @click='actionRule("delete", raffle_id)' 
                                                style='width: 50px; cursor: pointer;'>
                                                <i class="fa fa-trash-alt"></i> 
                                            </span>

                                        </div>
                                        
                                    </td>

                                    <td>
                                        {{ item.name }}
                                    </td>

                                    <td style='width: 550px'> <!-- rules display -->


                                        <div v-if="item.rules && (item.rules.length > 0)" > 
                                            <div>
                                                <button class="button button-primary" type="button" 
                                                    data-toggle="collapse" 
                                                    :data-target="'#multiCollapseExample'+ '' + raffle_id" 
                                                    aria-expanded="false" 
                                                    :aria-controls="'multiCollapseExample'+ '' + raffle_id">
                                                    <?php esc_html_e('Rules', 'raffle-play-woo'); ?> - ({{item.rules.length}})
                                                </button>
                                            </div>

                                            <div class="collapse multi-collapse" 
                                                :id="'multiCollapseExample' + '' + raffle_id">
                                                <div class="card card-body">
                                                    
                                                    <table class='table'>

                                                        <tbody>
                                                            <tr v-for='rule in item.rules'>
                                                                <td>
                                                                <span v-html="symbol"></span> 
                                                                    {{rule.cart_value}}
                                                                </td>

                                                                <td>

                                                                    <p>
                                                                        <span v-show="!rule.inc_cat"> - </span>
                                                                        <span v-show="rule.inc_cat" 
                                                                            v-text="getCatName( rule.cat, rule.cat_rule, rule.no_prods )"></span>                                                               
                                                                        
                                                                    </p>
                                                                </td>

                                                                <td>
                                                                    <img :src="raffle_icon" alt="">
                                                                        {{rule.cart_tickets}}
                                                                </td>
                                                            </tr>
                                                        </tbody>

                                                    </table>

                                                </div>
                                            </div>       


                                        </div>
                                        <div v-else>
                                            0
                                        </div>

                                    </td>
                                </tr>                            

                            <tbody>

                            </tbody>
                        </table>

                    </div>
                </div>

                <button type="button" v-show='false' 
                    class="btn btn-primary d-none" ref='btn_modal' data-toggle="modal" data-target="#modalSaveEdit">
                    Show Modal
                </button>


                <!-- Modal -->
                <div class="modal" id="modalSaveEdit" ref='modal_ref'
                     data-backdrop="static"  tabindex="-1" role="dialog" >
                    <div class="modal-dialog modal-lg" style='margin-top: 80px !important;'>
                    <div class="modal-content ">
                        <div class='modal-headline'></div>

                        <div class="modal-header" ref='modal_header'>
                            <h4 class="modal-title"> <span ref='action_modal' > </span> - <?php esc_html_e('Promotion', 'raffle-play-woo');?> </h4>                           

                                <button type="button" class="close modal-close-btn"
                                    @click='cancelEditProm'
                                    id='modal_close_btn' data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>

                        </div>
                        

                        <div class="modal-body">

                            <p style='font-size: .8rem;'>
                                <i> 
                                    <?php esc_html_e('Add / remove free raffle tickets to cart based on the rules', 'raffle-play-woo');?> 
                                </i> 
                            </p>

                            <div class="row bmp-set-row">
                                <div class="col-sm-5">
                                    <b> <?php esc_html_e('Promotion Name', 'raffle-play-woo' );?> </b>
                                    *
                                </div>
                                <div class="col-sm-7">    
                                    <input type="text" style='width: 100%' 
                                        name="" id="prize_name" v-model='name' 
                                        placeholder="<?php esc_html_e('Name', 'raffle-play-woo');?>">                           
                                </div>
                            </div>

                            <p></p>

                            <div class="row bmp-set-row">
                                <div class="col-sm-5">
                               
                                </div>
                                <div class="col-sm-7">  
                                    <label for="active_prom">
                                        <input type="checkbox" name="" v-model='active'
                                             id="active_prom">
                                        <b> <?php esc_html_e('Active Promotion (In use or not)', 'raffle-play-woo' );?> </b>

                                    </label>
                          
                                </div>
                            </div>

                            <div class="row bmp-set-row">
                                <div class="col-sm-5">
                                    <b> <?php esc_html_e('Update / Delete / Add to Cart Promotional Product message', 'raffle-play-woo' );?> </b> <br/>
                                    <i style='font-size: .7rem'> <?php esc_html_e('Customers are not allowed to add to cart, delete or update the promotional raffle product ', 'raffle-play-woo' );?> </i><br/>
                                    <i style='font-size: .7rem' > <?php esc_html_e('The system will do it automatically based on the rules', 'raffle-play-woo' );?> </i> <br />
                                    <i style='font-size: .7rem' > <?php esc_html_e('Show a message to explain in case someone will try.', 'raffle-play-woo' );?> </i>
                                </div>
                                <div class="col-sm-7">  
                                    <label for="warn_msg">
                                        <i style='font-size: .7rem'> <?php esc_html_e('Add [end] at the end to break the text into a new line', 'raffle-play-woo');?> </i>
                                        <textarea name="" id="warn_msg" cols="50" v-model="warn_msg" rows="5"
                                        placeholder="<?php esc_html_e('This is a promotional raffle, based on your cart value we award free entry tickets to raffle.', 'raffle-play-woo' );?>"
                                        ></textarea>
                                    </label>                          
                                </div>
                            </div>


                            <p></p>

                            <div class="row bmp-set-row d-none">
                                <div class="col-sm-5">
                                    <b> <?php esc_html_e('Raffle', 'raffle-play-woo' );?> </b>
                                </div>
                                <div class="col-sm-7">    
                                    <select name="" id="raffles_list" ref='raffles_lst'>
                                        <?php
                                            foreach( $data['raffles'] as $key=>$raffle ){
                                                echo "<option value='$key'> $raffle </option>";                                                
                                            }
                                        ?>   
                                    </select>                                    
                                </div>
                            </div>

                            <div class="row bmp-set-row" v-show='false'>
                                <div class="col-sm-5">
                                    <b> <?php esc_html_e('Added to cart message', 'raffle-play-woo' );?> </b>
                                </div>
                                <div class="col-sm-7">    
                                    <input type="text" style='width: 100%' name="" 
                                        id="prize_name" v-model="cart_message"
                                        placeholder="<?php esc_html_e('Congratulations, you are now entering the free raffle draw. Complete the purchase', 'raffle-play-woo');?>">                           
                                </div>
                            </div>

                            <p></p>

                            <div class="row bmp-set-row">
                                <div class="col-sm-5">
                                    <b> <?php esc_html_e('Rules', 'raffle-play-woo' );?> </b>
                                    <p></p>
                                </div>

                                <div>
                                    <div class="header-rules">



                                    </div>
                                    <div class="body-rules">
                                        <p></p>
                                        <p></p>
                                        <div>
                                            <table class='table table-bordered'>
                                                <thead>
                                                    <tr>
                                                        <th> <?php esc_html_e('Action', 'raffle-play-woo'); ?>              </th>                                                        
                                                        <th> <?php esc_html_e('Value Above', 'raffle-play-woo'); ?>          </th>
                                                        <th> <?php esc_html_e('Include Category', 'raffle-play-woo'); ?>    </th>                                                        
                                                        <th> <?php esc_html_e('Raffle Tickets', 'raffle-play-woo'); ?>      </th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td style='width: 120px'>
                                                            <div style='margin-top: 7px;'>
                                                                <span   class='nav-item' @click="addRule"
                                                                        v-show="((rule.cart_value != 0) || ( rule.inc_cat )) && (rule.cart_tickets != 0) && (rule_action == 'add')" 
                                                                        style='cursor: pointer'> 
                                                                    <i class="fa fa-check"  style='color: #009A34'></i>  
                                                                </span>

                                                                <span   class='nav-item' @click="updateRule"
                                                                        v-show="(rule_action == 'edit')"  
                                                                        style='cursor: pointer'> 
                                                                    <i class="fa fa-check"  style='color: #009A34'></i>  
                                                                </span>

                                                                <span class='nav-item' @click="cancelEdit()"
                                                                    v-show="(rule_action == 'edit')" 
                                                                    style='cursor: pointer' >
                                                                    <i class="fa fa-window-close" style='color: red;'></i>
                                                                </span>
                                                            </div>
                                                        </td>
                                                        
                                                        <td style='width: 100px;'>                                                         
                                                            <div class="input-group mb-3" style='width: 100px;'>
                                                                <div class="input-group-prepend">
                                                                    <span class="input-group-text" id="basic-addon1" v-html='symbol'></span>
                                                                </div>
                                                                <input type="number" ref='cart_value'
                                                                        
                                                                        min='0'
                                                                        v-on:keyup.enter="addRule"  
                                                                        v-model="rule.cart_value"
                                                                        class='form-control'
                                                                /> 
                                                            </div>
                                                        </td>

                                                        <td>
                                                            <label for="inc_cat" >                                                                
                                                                <input type="checkbox" v-model='rule.inc_cat' name="" 
                                                                    id="inc_cat">

                                                                <?php esc_html_e('Include Category', 'raffle-play-woo'); ?>
                                                            </label>

                                                            <p v-show='(rule.inc_cat == true)' class='mt-3'>
                                                                <label for="">
                                                                    <select v-model="rule.cat" >
                                                                        <option v-for="(item, index) in prod_cats" 
                                                                            :value="item.term_id"
                                                                            > {{ item.name}}</option>
                                                                    </select>
                                                                </label>
                                                            </p>

                                                            <p v-show='(rule.inc_cat == true) && ( rule.cat != "" )' >
                                                                <label for="all_cat_radio">
                                                                    <input type="radio" name="rule_cat_radio" 
                                                                        v-model='rule.cat_rule'
                                                                        id="all_cat_radio" value='all'>
                                                                    <?php esc_html_e(' All value from Category', 'raffle-play-woo'); ?>                                                                   
                                                                </label>

                                                                <br/>

                                                                <label for="least_cat_radio" class='mt-3' v-show='false' class='d-none'>
                                                                    <input type="radio" name="rule_cat_radio" 
                                                                        v-model='rule.cat_rule'
                                                                        id="least_cat_radio" value='one'>

                                                                    <?php esc_html_e('At least');?>

                                                                    <input type="number" min='1'  style='width: 50px'
                                                                        v-model="rule.no_prods"
                                                                    >
                                                                    
                                                                    <?php esc_html_e('Product from Category', 'raffle-play-woo'); ?>                                                                    
                                                                </label>

                                                            </p>
                                                        </td>

                                                        <td style='width: 100px' >                                                           
                                                            <input type="number" min='1' style='width: 100px'
                                                                v-on:keyup.enter="addRule"  
                                                                v-model="rule.cart_tickets" /> 
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div v-if="proms[raffle_id] && proms[raffle_id].rules">
                                            <table class='table'>
                                                <thead>
                                                    <tr>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="item in proms[raffle_id].rules">
                                                        <td style='width: 140px'>
                                                            <span class='nav-item' style='cursor: pointer'
                                                                @click="editRule(raffle_id, item.id)">
                                                                <i class="fa fa-edit"></i>   
                                                            </span>

                                                            <span class='nav-item' style='cursor: pointer' 
                                                                @click="deleteRule(raffle_id, item.id)">
                                                                <i class="fa fa-trash"></i>   
                                                            </span>
                                                        </td>

                                                        <td>
                                                           <span v-html="symbol"></span> {{item.cart_value}}
                                                        </td>

                                                        <td>
                                                            <p>
                                                                <span v-show="!item.inc_cat"> - </span>
                                                                <span v-show="item.inc_cat" 
                                                                    v-text="getCatName( item.cat, item.cat_rule, item.no_prods )"></span>                                                               
                                                                
                                                            </p>
                                                        </td>

                                                        <td>
                                                            <img :src="raffle_icon" alt="">
                                                                {{item.cart_tickets}}
                                                        </td>
                                                    </tr>
                                                </tbody>

                                            </table>
                                        </div>

                                    </div>
                                
                                </div>
                            </div>
                            

                            <p></p>               

                        </div>

                        <div class="modal-footer">
                            <input type="hidden" name="" value='-1' id='modal_action'>
                            <?php wp_nonce_field( 'nonce_field_form_rpr', 'nonce_field_form_rpr' ); ?>

                            <button type="button" :disabled='saving' ref='btn_cancel'
                                @click='cancelEditProm'
                                class="button button-default" data-dismiss="modal" > 
                                <?php esc_html_e('Cancel', 'raffle-play-woo');?> 
                            </button>
                            <button type="button" class="button button-primary" :disabled="saving"                                         
                                @click='saveSettings' id="btnSave"> 

                                <i class="fa fa-save" v-show='saving'></i> 

                                <?php esc_html_e('Save', 'raffle-play-woo');?> 
                            </button>                                                 
                        </div>

                    

                    </div><!-- /.modal-content -->
                    
                    </div><!-- /.modal-dialog -->
                </div><!-- /.modal -->   


            </div> <!-- /container-fluid -->
        </div> <!-- /wrap -->

      <?php  
    
    }
}