<?php

if( ! defined( 'ABSPATH') ){ die('No access to this page'); }

include_once( RAFFLE_PLAY_WOO_DIR_PATH . '/includes/RafflePlayWoo_Includes.php');
include_once( RAFFLE_PLAY_WOO_DIR_PATH . '/includes/RafflePlayWoo_Countdown.php' );

use RafflePlayWoo_Countdown\RafflePlayWoo_Countdown as RafflePlayWoo_Countdown;

    function drp_MainPage( $settings ){
        RafflePlayWoo_Includes::rpwoo_loading_screen();
        

        $date_format = array(
            'dd-mm-yyyy',
            'dd/mm/yyyy',
            'yyyy-mm-dd',
            'yyyy/mm/dd'
        );
        $no_products = sizeof( $settings['products'] );
        $class_prod = 'border-danger';
        if( $no_products > 0 )
            $class_prod = '';
      ?>
        
        <div class='wrap'>
            <div class="container-fluid">   
                
                <p style='text-align: right;'>
                    <strong> <?php esc_html_e('Version', 'raffle-play-woo'); ?> </strong>
                    <input type="text" readonly value="<?php esc_html_e( RAFFLE_PLAY_WOO_VERSION ); ?>">
                </p>
                    <?php
                        RafflePlayWoo_Includes::rpwoo_contact_link();
                    ?>

                    <div class='header-messages'>
                        <?php if( $settings['terminated'] ){ ?>
                            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                         
                                <strong> <?php esc_html_e('Raffle is Terminated', 'raffle-play-woo'); ?> </strong>
                           
                                <button style='float: right;' type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>

                            </div>

                        <?php } ?>
                       
                    </div>
                    <input type='submit' class="button button-primary rdp_save_settings" value="<?php esc_html_e('Save', 'raffle-play-woo' );?>" />  
                    <p></p>

                    <h5 class='default-header-text'>
                        <?php esc_html_e('Default Raffle (ID - 0)', 'raffle-play-woo');?>
                    </h5>      

                    <div class="row bmp-set-row">
                        <div class="col-2" style="min-width: 220px;">
                            <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">

                            <a class="nav-link active" id="v-pills-general-tab" data-toggle="pill" href="#v-pills-general" 
                                role="tab" aria-controls="v-pills-general" aria-selected="true">
                                <?php esc_html_e('General',  'raffle-play-woo' ); ?>
                            </a>


                            <a class="nav-link" id="v-pills-email-tab" data-toggle="pill" href="#v-pills-email" 
                                role="tab" aria-controls="v-pills-email" aria-selected="false">
                                <?php esc_html_e('Email Template & Thank you Page',  'raffle-play-woo' ); ?>
                            </a>

                            <a class="nav-link" id="v-pills-messages-tab" data-toggle="pill" href="#v-pills-messages" 
                                role="tab" aria-controls="v-pills-messages" aria-selected="false">
                                <?php esc_html_e('User Messages',  'raffle-play-woo' ); ?>
                            </a>

                            <a class="nav-link" id="v-pills-multiple-tab" data-toggle="pill" href="#v-pills-multiple" 
                                role="tab" aria-controls="v-pills-multiple" aria-selected="false">
                                <?php esc_html_e('Multiple Raffles',  'raffle-play-woo' ); ?>
                            </a>

                            <a class="nav-link" id="v-pills-pdf-tab" data-toggle="pill" href="#v-pills-pdf" 
                                role="tab" aria-controls="v-pills-pdf" aria-selected="false">
                                <?php esc_html_e('PDF Email Attachment',  'raffle-play-woo' ); ?>
                            </a>

                            <a class="nav-link" id="v-pills-extra-tab" data-toggle="pill" href="#v-pills-extra" 
                                role="tab" aria-controls="v-pills-extra" aria-selected="false">
                                <?php esc_html_e('Extra Settings',  'raffle-play-woo' ); ?>
                            </a>

                            <a class="nav-link" id="v-pills-acc-tab" data-toggle="pill" href="#v-pills-acc"
                                 role="tab" aria-controls="v-pills-acc" aria-selected="false">
                                <?php esc_html_e('Woocommerce Account',  'raffle-play-woo' ); ?>
                            </a>

                            <a class="nav-link" id="v-pills-shortinfo-tab" data-toggle="pill" href="#v-pills-shortinfo" 
                                role="tab" aria-controls="v-pills-shortinfo" aria-selected="false">
                                <?php esc_html_e('Shortcode Info Raffle',  'raffle-play-woo' ); ?>
                            </a>

                            <a class="nav-link" id="v-pills-countdown-tab" data-toggle="pill" href="#v-pills-countdown" 
                                role="tab" aria-controls="v-pills-countdown" aria-selected="false">
                                <?php esc_html_e('Countdown Settings',  'raffle-play-woo' ); ?>
                            </a>

                            <a class="nav-link" id="v-pills-progressbar-tab" data-toggle="pill" href="#v-pills-progressbar" 
                                role="tab" aria-controls="v-pills-progressbar" aria-selected="false">
                                <?php esc_html_e('Progress Bar Settings',  'raffle-play-woo' ); ?>
                            </a>

                            <a class="nav-link" id="v-pills-gencheckout-tab" data-toggle="pill" href="#v-pills-gencheckout" 
                                role="tab" aria-controls="v-pills-gencheckout" aria-selected="false">
                                <?php esc_html_e('Generated Tickets at Checkout',  'raffle-play-woo' ); ?>
                            </a>

                            <a class="nav-link" id="v-pills-user_search-tab" data-toggle="pill" href="#v-pills-user_search" 
                                role="tab" aria-controls="v-pills-user_search" aria-selected="false">
                                <?php esc_html_e('Customer Search Tickets',  'raffle-play-woo' ); ?>                                
                            </a>

                            <a class="nav-link" id="v-pills-producttab-tab" data-toggle="pill" href="#v-pills-producttab"                                
                                role="tab" aria-controls="v-pills-producttab" aria-selected="false">
                                <?php esc_html_e('Product Raffle Tab (Last Tickets Sold)',  'raffle-play-woo' ); ?>  
                                                            
                            </a>

                            <a class="nav-link" id="v-pills-userpickstab-tab" data-toggle="pill" href="#v-pills-userpickstab"                                
                                role="tab" aria-controls="v-pills-userpickstab" aria-selected="false">
                                <?php esc_html_e('User Picks Tickets at Checkout',  'raffle-play-woo' ); ?>                                                             
                            </a>

                            </div>
                        </div>
                        <div class="col-9 div-container-right" >
                            <div class="tab-content" id="v-pills-tabContent">
                                <!-- general tab -->
                                    <?php include_once( 'main/W_RafflePlayWoo_Main_General.php'); ?>
                                <!-- end of general tab -->

                                <!-- Woocommerce Info -->
                                    <?php include_once( 'main/W_RafflePlayWoo_Main_Woocomerce_Info.php'); ?>
                                <!-- end of Woocommerce Info -->

                                <!-- email -->
                                <div class="tab-pane fade" id="v-pills-email" role="tabpanel" aria-labelledby="v-pills-email-tab">
                                                                   
                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " style='display: inline-block'> 
                                            <?php esc_html_e('Header Text', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" style='display: inline-block'>                               
                                            <input type="text"   id="rpwoo_email_header_lbl" 
                                               value="<?php echo  stripslashes( esc_html( $settings['email_header_lbl'] )); ?>"
                                               placeholder="<?php esc_html_e('Raffle Tickets Info', 'raffle-play-woo'); ?>"
                                            />                                                                         
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " style='display: inline-block'> 
                                            <?php esc_html_e('Include Raffle Name', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" style=''>                               
                                            <input type="checkbox"  data-toggle="toggle" data-size='small' <?php if( $settings['inc_raffle_name']) echo "checked";?> id='rpwoo_inc_name'
                                            data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>"  data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" />  
                                                
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " style='display: inline-block'> 
                                            <?php esc_html_e('Body Tickets', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" style='display: inline-block'>                               
                                            <input type="text"  id="rpwoo_email_body_lbl" 
                                             value="<?php echo stripslashes( esc_html( $settings['email_body_lbl'] )); ?>" 
                                             placeholder="<?php esc_html_e('Tickets Purchased', 'raffle-play-woo'); ?>" 
                                            />                                                                         
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " style='display: inline-block'> 
                                            <?php esc_html_e('Extra Line Info', 'raffle-play-woo' );?> 
                                            <span data-toggle='tooltip' 
                                                title='<?php esc_html_e('Extra info about raffle displayed on next table row. Leave empty to skip. Eg: Raffle draw is on 25th of June 2021. Good Luck!', 'raffle-play-woo' ); ?>'> 
                                            <i class="fa fa-info-circle text-info"></i> </span>
                                        </div>
                                    
                                        <div class="col-sm-7" style='display: inline-block'>                               
                                            <input type="text" placeholder="<?php echo stripslashes( esc_html__('Eg: Raffle draw is on 25th of June 2021','raffle-play-woo')); ?>"
                                            id="rpwoo_email_body_extra_txt"  value="<?php echo $settings['email_extra'];?>" />                                                                         
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " style='display: inline-block'> 
                                            <?php esc_html_e('Ticket Info Position', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" style='display: inline-block'>                               
                                        <label for="rpwoo_email_pos_one">
                                            <input type="radio"  <?php if( $settings['email_pos'] == '1') echo 'checked'; ?>  id="rpwoo_email_pos_one" name='rpwoo_email_data_pos'  value="1" />  
                                            <?php esc_html_e('Before Order Info', 'raffle-play-woo' ); ?>                                                                       
                                        </label>
                                            <br/>
                                        <label for="rpwoo_email_pos_two">
                                            <input type="radio" <?php if( $settings['email_pos'] == '2') echo 'checked'; ?>  id="rpwoo_email_pos_two" name='rpwoo_email_data_pos'  value="2" /> 
                                            <?php esc_html_e('Between Order Info and Billing Address', 'raffle-play-woo' ); ?>                                                                          
                                        </label>
                                            <br/>
                                        <label for="rpwoo_email_pos_three">
                                            <input type="radio" <?php if( $settings['email_pos'] == '3') echo 'checked'; ?>  id="rpwoo_email_pos_three" name='rpwoo_email_data_pos'  value="3" />  
                                            <?php esc_html_e('After Billing Address', 'raffle-play-woo' ); ?>                                                                         
                                        </label>
                                        </div>
                                    </div>
                            
                                </div>

                                <!-- end of email -->

                                <!-- messages -->
                                <div class="tab-pane fade" id="v-pills-messages" role="tabpanel" aria-labelledby="v-pills-messages-tab">  
                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-12" > 
                                        
                                            <p class='h5 text-center text-danger'>
                                                ***
                                                <?php esc_html_e('Very IMPORTANT to setup messages', 'raffle-play-woo' );?> 
                                                ***
                                            </p>
                                            <p class='h6'>
                                                <?php esc_html_e('Display information to user when raffle is terminated, or there are no more tickets, or raffle hasnt started etc.', 'raffle-play-woo' );?>  
                                            </p>

                                            <p class='h6'>
                                                <?php esc_html_e('Below messages are displayed in the raffle product page (when adding to cart), and in the cart page (when updating cart)', 'raffle-play-woo' );?>  
                                            </p>
                                           
                                        </div>
                                    

                                    </div>                        
                                                       
                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                        
                                        </div>
                                    
                                        <div class="col-sm-7" style='font-weight: 500' >                               
                                           ( <?php esc_html_e("%s - 2, 3 uses date replacer; %d - 5, 6 uses numeric replacer; If deleted won't replace the values") ?>)
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                           1. <?php esc_html_e('Raffle is Terminated', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="text" id="msg_terminate"  value="<?php echo $settings['msg_terminate']; ?>" 
                                            placeholder="<?php esc_html_e('(Your Message) The raffle has finished', 'raffle-play-woo' );?>"
                                            />
                                        </div>
                                    </div>
                                    
                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                           2. <?php esc_html_e("Raffle hasn't started (start date - %s)", 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="text" id="msg_startdate"  value="<?php echo $settings['msg_startdate']; ?>" 
                                              placeholder="<?php esc_html_e('(Your Message) The raffle will start on %s', 'raffle-play-woo'); ?>"
                                            />
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                           3. <?php esc_html_e('Raffle has ended (end date - %s)', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="text" id="msg_enddate"  value="<?php echo $settings['msg_enddate']; ?>" 
                                            placeholder="<?php esc_html_e('(Your Message) The raffle has finished on %s', 'raffle-play-woo' ); ?>"
                                            />
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                           4. <?php esc_html_e('Raffle will end (end date - %s)', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="text" id="msg_will_enddate"  value="<?php echo $settings['msg_will_enddate']; ?>" 
                                            placeholder="<?php esc_html_e('(Your Message) The raffle will end on %s', 'raffle-play-woo' ); ?>"
                                            />
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                           5. <?php esc_html_e('Add To Cart (limit on - no tickets left)', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="text" id="msg_add_to_cart"  value="<?php echo $settings['msg_add_to_cart']; ?>" 
                                            placeholder="<?php esc_html_e('(Your Message) All raffle tickets have been sold', 'raffle-play-woo'); ?>"
                                            />
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                           6.  <?php esc_html_e('Add To Cart (limit on - exceeding tickets - %d)', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="text" id="msg_add_to_cart_ex" 
                                            placeholder="<?php esc_html_e('(Your Message) There are only %d tickets left', 'raffle-play-woo') ?>" 
                                                 value="<?php echo $settings['msg_add_to_cart_ex']; ?>" />
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                           7. <?php esc_html_e('Update Cart (limit on - exceeding tickets - %d)', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="text" id="msg_update_cart_ex" 
                                                placeholder="<?php esc_html_e('(Your Message) There are only %d tickets left', 'raffle-play-woo') ?>" 
                                                 value="<?php echo $settings['msg_update_cart_ex']; ?>" />
                                        </div>
                                    </div>


                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <b> <?php esc_html_e('Messages Shortcode', 'raffle-play-woo' );?> <br/> </b>
                                            <i>
                                                <?php esc_html_e('To display messages in custom page, copy the shortcode, change the it to match the raffle id and paste it in custom page', 'raffle-play-woo' );?>
                                            </i>
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="text" style='min-width: 205px;' readonly id="msg_shortcode"  value="<?php echo $settings['msg_shortcode']; ?>" />
                                            <?php esc_html_e("To show raffle name add (show_raffle_name='1') in the shortcode", 'raffle-play-woo' );?> 
                                        </div>
                                    </div>



                                </div>
                                <!-- end of messages -->

                                <!-- multiple-->
                                <div class="tab-pane fade" id="v-pills-multiple" role="tabpanel" aria-labelledby="v-pills-multiple-tab">                                 
                            
                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('One Raffle tickets at checkout.', 'raffle-play-woo' );?> 
                                            <span data-toggle='tooltip' 
                                                title="<?php esc_html_e('Limit order per raffle tickets. Avoid mixing raffle tickets per order. The check is made on add to cart event.', 'raffle-play-woo' ); ?>" > 
                                                <i class="fa fa-info-circle text-info"></i> 

                                            </span>
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="checkbox" id="limit_order_per_raffle" data-toggle='toggle' data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>" 
                                            data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" <?php if($settings['limit_order_per_raffle'] ) echo 'checked'; ?> data-size='small'/>
                                            <br/>
                                            <input style='margin-top: 3px; width: 100%;' id='limit_order_per_raffle_txt' type="text" 
                                            placeholder="(Your Message) Only One raffle tickets allowed per order" id="" data-toggle='toggle'
                                            value="<?php echo $settings['limit_order_per_raffle_txt'];?>" />
                                        </div>
                                    </div>
                                    

                                </div>
                                <!-- end of multiple -->

                                <!-- pdf attachment settings -->
                                <div class="tab-pane fade" id="v-pills-pdf" role="tabpanel" aria-labelledby="v-pills-pdf-tab">                                 

   
                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                        <h5> <?php esc_html_e('Works only with PHP version 7.1, and above', 'raffle-play-woo');?> </h5>
                                            <?php

                                                if( version_compare( phpversion(), '7.1' ) < 0 ){
                                                    echo "<p style='color:red;'> ";
                                                    esc_html_e( 'Your PHP version is less than 7.1, therefore this feature wont work' , 'raffle-play-woo' );
                                                    echo "</p>";
                                                }
                                            ?>
                                           
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <?php
                                                $link_documentation =  esc_html__("View PDF Attachment Documentation ", 'raffle-play-woo') . "<a href='https://tuskcode.com/raffle-play-woo/raffle-play-woo-premium/' target='_blank'> HERE </a>";    
                                                echo( $link_documentation );
                                            ?>
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('Enable PDF Email Attachment', 'raffle-play-woo' );?> 
                                            <span data-toggle='tooltip' 
                                                title="<?php esc_html_e('Create a pdf attachment with the raffle info. Attached to the email', 'raffle-play-woo' ); ?>" > 
                                                <i class="fa fa-info-circle text-info"></i> 

                                            </span>
                                           
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="checkbox" id="enable_pdf_att" data-toggle='toggle'
                                            <?php if( version_compare( phpversion(), '7.1' ) < 0 ){ echo "disabled"; } ?>
                                            data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>" 
                                            data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" <?php if($settings['enable_pdf_att'] ) echo 'checked'; ?> data-size='small'/>
                                            <span> <i><?php esc_html_e('(PDFs are only generated for processing, invoice, and completed orders)', 'raffle-play-woo' );?></i></span>
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' style='display: none;' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('Restrict attachment only for Orders with: ', 'raffle-play-woo' );?> 
                                            <span data-toggle='tooltip' 
                                                title="<?php esc_html_e('Restrict attachement only for Order with raffle products, or let all orders to have pdf attachment', 'raffle-play-woo' ); ?>" > 
                                                <i class="fa fa-info-circle text-info"></i> 

                                            </span>
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="checkbox" id="pdf_restrict" data-toggle='toggle'                                         
                                            data-on="<?php esc_html_e('Raffle', 'raffle-play-woo');?>" 
                                            data-off="<?php esc_html_e('No Restrict', 'raffle-play-woo');?>" <?php if($settings['pdf_restrict'] ) echo 'checked'; ?> 
                                            data-size='small' data-width='110' />

                                        </div>
                                    </div>
                                    
                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5" > 
                                            <?php esc_html_e('PDF Filename', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <p>
                                                <label for="pdf_filename_guid">
                                                    <input type="radio" id="pdf_filename_guid" name='pdf_filename_name'
                                                    <?php if($settings['pdf_filename_type'] == 'guid' ) echo 'checked'; ?> />
                                                    <?php esc_html_e('Order Id + GUID (eg: 5_ADFE2345ADEFEF-42ADFG-34TERE.pdf) ***RECOMMENDED***', 'raffle-play-woo' ); ?>
                                                </label>
                                            </p>

                                            <p>
                                                <label for="pdf_filename_name">
                                                    <input type="radio" id="pdf_filename_name"  name='pdf_filename_name'
                                                    <?php if( $settings['pdf_filename_type']  == 'name') echo 'checked'; ?> />
                                                    <?php esc_html_e('Order Id + Customer First Name + Customer Last Name (eg: 5_John_Silva.pdf)', 'raffle-play-woo' ); ?>
                                                </label>
                                            </p>

                                        </div>                                     
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('PDF Template', 'raffle-play-woo' );?>
                                           
                                        </div>
                                    
                                        <div class="col-sm-7" >                                                               
                                            <select name="pdf_template" id="pdf_template">                                           
                                                <option value="one" <?php if( $settings['pdf_template'] == 'one') echo 'selected'; ?> ><?php esc_html_e('One', 'raffle-play-woo');?> </option>
                                                <option value="two" <?php if( $settings['pdf_template'] == 'two') echo 'selected'; ?> ><?php esc_html_e('Two', 'raffle-play-woo');?> </option>
                                               
                                            </select>
                                            <i> <b> <?php esc_html_e('(can be found and edited (styled) under plugin folder /includes/templates )', 'raffle-play-woo' );?> </b> </i> 
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('Include Product Name & Quantity', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="checkbox" id="pdf_inc_prod" data-toggle='toggle' data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>" 
                                            data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" <?php if($settings['pdf_inc_prod'] ) echo 'checked'; ?> data-size='small'/>
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('Include Billing Info', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="checkbox" id="pdf_inc_add" data-toggle='toggle' data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>" 
                                            data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" <?php if($settings['pdf_inc_add'] ) echo 'checked'; ?> data-size='small'/>
                                        </div>
                                    </div>


                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5" > 
                                            <?php esc_html_e('Page Orientation', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <p>
                                                <label for="pdf_ori_port">
                                                    <input type="radio" id="pdf_ori_port" name='pdf_orientation'
                                                    <?php if($settings['pdf_page_or'] == 'portrait' ) echo 'checked'; ?> />
                                                    <?php esc_html_e('Portrait', 'raffle-play-woo' ); ?>
                                                </label>
                                            </p>

                                            <p>
                                                <label for="pdf_ori_land">
                                                    <input type="radio" id="pdf_ori_land"  name='pdf_orientation'
                                                    <?php if( $settings['pdf_page_or']  == 'landscape') echo 'checked'; ?> />
                                                    <?php esc_html_e('Landscape', 'raffle-play-woo' ); ?>
                                                </label>
                                            </p>

                                        </div>                                     
                                    </div>


                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('Header Logo Image (only .jpeg)', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >  
                                            <button class='button button-primary' id='pdf_load_img' style='display: inline; height: 34px;' ><?php esc_html_e('Library', 'raffle-play-woo' ); ?></button>                             
                                            <div style='display: inline;'>
                                                <input type="text" id="pdf_header_image"  style='width:80%' style='display: inline;'
                                                placeholder="https://yourdomain.com/images/header-image.jpeg"
                                                value="<?php echo esc_url_raw( $settings['pdf_header_img'] ); ?>" />
                                            </div>
                                        </div>
                                    </div>

                                    <?php 
                                        $company_info = $settings['pdf_business_info'];
                                        $footer_info  = $settings['pdf_footer_info'];
                                        $pdf_extra_css = $settings['pdf_extra_css'];

                                        if( $company_info == 'empty' ){       
                                            $company_data = array(
                                                "<div>",
                                                "<h3> My Company / Shop Name </h3>",
                                                "<p>44, Midlands Street </p>",
                                                "<p>County Neverland  </p>",
                                                "<p>Company Number:  2332425  </p>",
                                                "<p>Vat Number: A3453345 </p> ",
                                                "<p>Email: shoe@shine.com </p>",
                                                "</div>"

                                            );    
       
                                            $company_info = implode('br_nl', $company_data );
                                        }
                                    
                                        if( $footer_info == 'empty'){
                                            $footer_data = array(
                                                "<div style='text-align: center;'>",
                                                "<p> <strong> Copyright @%year% Company Name. All Rights Reserved</strong> </p>",                            
                                                "</div>"
                                            );

                                           $footer_info = implode('br_nl', $footer_data );
                                        }

                                        if( $pdf_extra_css == 'empty'){
                                            $pdf_extra_css_data = array(
                                                ".main h3{",
                                                    "font-size: 15px;    /* comment: header info */",
                                                "}",
                                                ".main p, .billing-info-data{   /* comment: table data */",
                                                    "font-size: 13px;",
                                                "}",                                        
                                                "table th, .raffle-info-header{   /* comment: table header */ ",
                                                    "font-size: 15px !important;",
                                                "}",                                        
                                                "table td{    /*comment: table data */",
                                                    "font-size: 13px !important;",
                                                "}",
                                                ".header-business-info p{   /* comment: business info paragraphs */",                        
                                                    "font-size: 12px;",
                                                "}"                                
                                            );
                                            $pdf_extra_css = implode('br_nl', $pdf_extra_css_data );
                                        }

                                        $company_info = str_replace("br_nl", "\n", $company_info );
                                        $footer_info = str_replace("br_nl", "\n", $footer_info );
                                        $pdf_extra_css = str_replace("br_nl", "\n",  $pdf_extra_css );
                                    
                                    ?>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('Business Info Header (html)', 'raffle-play-woo' );?>
                                           <p class='text-danger'> <?php esc_html_e('Be aware: inproper html manipulation will break the pdf file');?></p>
                                        </div>
                                    
                                        <div class="col-sm-7" >  
                                         
                                            <textarea 
                                                autocomplete='false' autocorrect='false' autocapitalize='false' spellcheck='false'
                                                class="form-control" id="pdf_business_info" cols="30" rows="6"><?php echo( $company_info );?></textarea>
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('Extra Info Footer (html)', 'raffle-play-woo' );?> 
                                            <p class='text-danger'> <?php esc_html_e('Be aware: inproper html manipulation will break the pdf file');?></p>
                                        </div>
                                    
                                        <div class="col-sm-7" >  
                                            <textarea 
                                                autocomplete='false' autocorrect='false' autocapitalize='false' spellcheck='false'
                                                class="form-control" id="pdf_footer_info" cols="30" rows="6"><?php echo $footer_info;?> </textarea>
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('Footer Height (px)', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >  
                                            <input type="number" name="" style='width: 100px;' value="<?php esc_html_e( $settings['pdf_footer_height']);?>"  min=0 id="pdf_footer_height" />px
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('Extra Style (CSS)', 'raffle-play-woo' );?> 
                                            <p class='text-danger'> <?php esc_html_e('Be aware: inproper css manipulation will break the pdf file');?></p>
                                        </div>
                                    
                                        <div class="col-sm-7" >  
                                            <textarea 
                                                autocomplete='false' autocorrect='false' autocapitalize='false' spellcheck='false'
                                                class="form-control" id="pdf_extra_css" cols="30" rows="6"><?php echo $pdf_extra_css;?> </textarea>
                                        </div>
                                    </div>
                                                                
                                </div>
                                <!-- end of pdf attachment settings -->

                                <!-- extra-->
                                <div class="tab-pane fade" id="v-pills-extra" role="tabpanel" aria-labelledby="v-pills-extra-tab">                                 
                            
                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('Hide Terminated Raffles in the Product->Raffles List', 'raffle-play-woo' );?> 
                                            <span data-toggle='tooltip' 
                                                title="<?php esc_html_e('In the product settings. Hide Terminated Raffles from the raffles list. This is convenient when you have a long list of raffles. Beaware that the product might be linked to the any of the hidden terminated raffle.', 'raffle-play-woo' ); ?>" > 
                                                <i class="fa fa-info-circle text-info"></i> 

                                            </span>
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="checkbox" id="hide_terminated_raffles" data-toggle='toggle' data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>" 
                                            data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" <?php if( $settings['hide_terminated_raffles'] ) echo 'checked'; ?> data-size='small'/>
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('Show Raffle Tickets in Woocommerce Orders Table View', 'raffle-play-woo' );?> 
                                            <span data-toggle='tooltip' 
                                                title="<?php esc_html_e('Quick view of the raffle tickets in the Orders Table View', 'raffle-play-woo' ); ?>" > 
                                                <i class="fa fa-info-circle text-info"></i> 

                                            </span>
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="checkbox" id="show_orders_table" data-toggle='toggle' data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>" 
                                            data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" <?php if( $settings['show_orders_table'] == 'yes' ) echo 'checked'; ?> data-size='small'/>
                                        </div>
                                    </div>

                                    <div class='bmp-set-row'>
                                        <div class='row'>
                                            <div class="col-sm-5 " > 
                                                <?php esc_html_e('Show Tickets Number with Raffle image in background (Thank you Page / Email )', 'raffle-play-woo' );?> 
                                                <span data-toggle='tooltip' 
                                                    title="<?php esc_html_e('Raffle image will be placed in the background of the ticket number. Custom images can be used, or customized in the template', 'raffle-play-woo' ); ?>" > 
                                                    <i class="fa fa-info-circle text-info"></i> 

                                                </span>
                                            </div>
                                                                            
                                            <div class="col-sm-7" >                               
                                                <input type="checkbox" id="show_ticket_image" data-toggle='toggle' data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>" 
                                                data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" <?php if( $settings['ticket_image_raffles']['0']->show === 'yes' ) echo 'checked'; ?> data-size='small'/>
                                            </div>

                                        </div>
                                    
                                        
                                        <div class='row' >
                                            <div class="col-sm-5 " style='display: inline-block'> 
                                                
                                            </div>                                    
                                        
                                            <div class="col-sm-7" style='display: inline-block;'>
                                                <p class='h6'><?php  esc_html_e('Select image for background ticket. (Select custom to add your own)', 'raffle-play-woo' );?> </p>  
                                                <select name="select_ticket_image" id="select_ticket_image">
                                                    <option value="blue" <?php if( $settings['ticket_image_raffles']['0']->ticket_image == 'blue') echo 'selected'; ?> ><?php esc_html_e('Blue', 'raffle-play-woo' ); ?> </option>
                                                    <option value="gold-one" <?php if( $settings['ticket_image_raffles']['0']->ticket_image == 'gold-one') echo 'selected'; ?> ><?php esc_html_e('Gold', 'raffle-play-woo' ); ?> </option>
                                                    <option value="gold-two" <?php if( $settings['ticket_image_raffles']['0']->ticket_image == 'gold-two') echo 'selected'; ?> ><?php esc_html_e('Gold Lines', 'raffle-play-woo' ); ?> </option>
                                                    <option value="gray" <?php if( $settings['ticket_image_raffles']['0']->ticket_image == 'gray') echo 'selected'; ?> ><?php esc_html_e('Gray', 'raffle-play-woo' ); ?> </option>
                                                    <option value="orange" <?php if( $settings['ticket_image_raffles']['0']->ticket_image == 'orange') echo 'selected'; ?> ><?php esc_html_e('Orange', 'raffle-play-woo' ); ?> </option>
                                                    <option value="purple" <?php if( $settings['ticket_image_raffles']['0']->ticket_image == 'purple') echo 'selected'; ?> ><?php esc_html_e('Purple', 'raffle-play-woo' ); ?> </option>
                                                    <option value="red" <?php if( $settings['ticket_image_raffles']['0']->ticket_image == 'red') echo 'selected'; ?> ><?php esc_html_e('Red', 'raffle-play-woo' ); ?> </option>
                                                    <option value="custom" <?php if( $settings['ticket_image_raffles']['0']->ticket_image == 'custom') echo 'selected'; ?> ><?php esc_html_e('Custom', 'raffle-play-woo' ); ?> </option>                                                
                                                </select>
                                                
                                                <img id='ticket_img_show' data-src="<?php echo RAFFLE_PLAY_WOO_URL . '/';?>" src="" style='width: 80px;' alt="">

                                                <div class='row' style='margin-top: 12px' >
                                                
                                                    <div class="col-sm-12 div-custom-ticket-img" style='display: none' >  
                                                        <button class='button button-primary' id='load_ticket_img' style='display: inline; height: 34px;' >
                                                        <?php esc_html_e('Library', 'raffle-play-woo' ); ?></button>                             
                                                        <div style='display: inline;'>
                                                            <input type="text" id="ticket_image_url"  style='width:80%' style='display: inline;'
                                                            placeholder="https://yourdomain.com/images/raffle-ticket-image.png"
                                                            value="<?php echo esc_url_raw( $settings['ticket_image_raffles']['0']->ticket_image_url ); ?>" />
                                                        </div>
                                                    </div>
                                                </div>
        
                                            </div>
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('Customize how raffle ticket will show in Thank you Page / Email', 'raffle-play-woo' );?> 
                                            <span data-toggle='tooltip' 
                                                title="<?php esc_html_e('Change width, height, color, text size of the raffle ticket view in Thank you / Email', 'raffle-play-woo' ); ?>" > 
                                                <i class="fa fa-info-circle text-info"></i> 

                                            </span>
                                        </div>
                                    
                                        <div class="col-sm-7" >   
                                            <div class="row">
                                                <p class='text-danger'>
                                                    <?php esc_html_e('If you are increasing the ticket Width, you must increase the Height and Line Height', 'raffle-play-woo') ?> 
                                                </p>
                                            </div>                            
                                            <div class="row">
                                                <label for="inputTicketWidth" class="col-sm-5 col-form-label" > 
                                                    <?php esc_html_e('Ticket Width', 'raffle-play-woo') ?> (px)
                                                </label>
                                                <div class="col-sm-3">
                                                    <input type="number" class="form-control" id="inputTicketWidth" 
                                                        value='<?php echo esc_html( $settings['ticket_image_raffles']['ticket']->ticket_width); ?>' >
                                                </div>
                                            </div>
                                            

                                            <p></p>

                                            <div class="row">
                                                <label for="inputTicketHeight" class="col-sm-5 col-form-label"> 
                                                    <?php esc_html_e('Ticket Height', 'raffle-play-woo') ?> (px) 
                                                </label>
                                                <div class="col-sm-3">
                                                    <input type="number" class="form-control" id="inputTicketHeight" 
                                                        value='<?php echo esc_html( $settings['ticket_image_raffles']['ticket']->ticket_height); ?>' >
                                                </div>
                                            </div>

                                            <p></p>

                                            <div class="row">
                                                <label for="inputTicketHeight" class="col-sm-5 col-form-label"> 
                                                    <?php esc_html_e('Line Height', 'raffle-play-woo') ?> (px) 
                                                </label>
                                                <div class="col-sm-3">
                                                    <input type="number" class="form-control" id="inputLineHeight" 
                                                        value='<?php echo esc_html( $settings['ticket_image_raffles']['ticket']->line_height); ?>' >
                                                </div>
                                            </div>

                                            <p></p>

                                            <div class="row">
                                                <label for="inputTextSize" class="col-sm-5 col-form-label"> 
                                                    <?php esc_html_e('Text Size', 'raffle-play-woo') ?> (px) 
                                                </label>
                                                <div class="col-sm-3">
                                                    <input type="number" class="form-control" id="inputTextSize"  
                                                        value='<?php echo esc_html( $settings['ticket_image_raffles']['ticket']->text_size); ?>'>
                                                </div>
                                            </div>

                                            <p></p>

                                            <div class="row">
                                                <label for="inputTextColor" class="col-sm-5 col-form-label"> 
                                                    <?php esc_html_e('Text Color', 'raffle-play-woo') ?> 
                                                </label>
                                                <div class="col-sm-3">
                                                    <input type="text" class="form-control" id="inputTextColor"  
                                                        value='<?php echo esc_html( $settings['ticket_image_raffles']['ticket']->text_color); ?>' >
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    

                                </div>
                                <!-- end of extra -->

                                
                                 <!--  woocommerce account -->
                                 <div class="tab-pane fade" id="v-pills-acc" role="tabpanel" 
                                    aria-labelledby="v-pills-acc-tab">   

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <b><?php esc_html_e('Enable Raffle Tab in Woocommerce Account', 'raffle-play-woo' );?> </b>
                                            <br />
                                            <i style='font-size: 0.9rem'>
                                                <?php esc_html_e('If Enabled go to Settings ->
                                                     Permalinks and click on Save Changes for the Tab to show up in the Woocommerce Account - Do it once ', 'raffle-play-woo' );?> 
                                            </i>
                                            
                                        </div>

                                        <div class="col-sm-7" >                               
                                            <input type="checkbox" id="show_acc_tab" data-toggle='toggle' 
                                            data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>" 
                                            data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" 
                                            <?php 
                                                if( $settings['show_acc_tab'] === 'yes' )
                                                    echo 'checked'; 
                                            ?> 
                                            data-size='small'/>
                                        </div>
                                    </div>

                                    <hr/>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('Tab Name', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="text" id="acc_tab_info_tab"  
                                                value="<?php esc_html_e( $settings['acc_tab_info']['tab']); ?>" 
                                                />                                            
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('Tab Location', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >                                                                          

                                            <select id='acc_tab_info_loc'>
                                            <?php 
                                                $tab_raffle_location = array(
                                                    'dashboard'     =>      esc_html__('Before Dashboard', 'raffle-play-woo'),
                                                    'orders'        =>      esc_html__('Before Order', 'raffle-play-woo'),
                                                    'downloads'     =>      esc_html__('Before Downloads', 'raffle-play-woo'),
                                                    'edit-address'  =>      esc_html__('Before Addresses', 'raffle-play-woo'),
                                                    'payment-methods' =>    esc_html__('Before Payments Methods', 'raffle-play-woo'),
                                                    'edit-account'  =>      esc_html__('Before Account Details', 'raffle-play-woo'),
                                                    'customer-logout' =>    esc_html__('Before Logout', 'raffle-play-woo'),
                                                );
                                                foreach( $tab_raffle_location as $key=>$loc ){
                                                    if( $key == $settings['acc_tab_info']['loc'] )
                                                        echo "<option selected value='$key'> $loc </option>";
                                                    else
                                                        echo "<option value='$key'> $loc </option>";
                                                }
                                            ?>
                                            </select>                                           
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('Content Display - Raffle Tickets', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >                                                                          
                                            <?php esc_html_e('Show Tickets Grouped by:', 'raffle-play-woo'); ?> <br/>
                                            <select id='acc_tab_info_con'>
                                            <?php 
                                                $tab_raffle_con = array(
                                                    'order' => esc_html__('Order', 'raffle-play-woo'),
                                                    'raffle' => esc_html__('Raffle', 'raffle-play-woo') 
                                                );
                                                foreach( $tab_raffle_con as $key=>$loc ){
                                                    if( $key == $settings['acc_tab_info']['con'] )
                                                        echo "<option selected value='$key'> $loc </option>";
                                                    else
                                                        echo "<option value='$key'> $loc </option>";
                                                }
                                            ?>
                                            </select>                                            
                                        </div>
                                    </div>

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('No Raffle Tickets to display - message', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="text" id="acc_tab_info_mes"  class='form-control'
                                                value="<?php esc_html_e( $settings['acc_tab_info']['mes']); ?>" 
                                                />
                                            
                                        </div>
                                    </div>

                                </div>
                                <!-- end of test -->


                                <!-- shortcode -->
                                <div class="tab-pane fade" id="v-pills-shortinfo" role="tabpanel" aria-labelledby="v-pills-shortinfo-tab">                                 

                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-5 " > 
                                            <?php esc_html_e('Shortcode Info Raffle Data', 'raffle-play-woo' );?> 
                                        </div>
                                    
                                        <div class="col-sm-7" >                               
                                            <input type="text" id="" readonly style='width: 400px;'
                                                value="[raffle name='info' id='0' productid='' tags='']" />
                                        </div>
                                    </div>
                                    
                                    <div class='row bmp-set-row' >
                                        <div class="col-sm-12" > 
                                            <p><?php esc_html_e('With this shortcode you can retrieve the primary attributes of any raffle. 
                                                            It can be used to display raffle information or integrate it with other plugins. Check the link below to the youtube video.', 'raffle-play-woo' );?> </p>

                                            <p> productid="55" (product id = 55) <?php esc_html_e(' is optional, if productid is added, the raffle linked to that product will be retrieved.', 'raffle-play-woo' );?> </p>
                                            <p> tags="custom-code1, custom-code2" <?php esc_html_e(' is optional, used to filter the code, if the shortcode is present in multiple pages (Dedicated keyword. Do not use keyword ".', 'raffle-play-woo' );?>product") </p>
                                            <p> <?php echo( sprintf( esc_html__('Watch explanation %s and %s on this youtube videos I made', 'raffle-play-woo' ), 
                                                        "<a href='https://youtu.be/o_8aZ4IV9XE' target='_blank'> HERE One </a>",
                                                        "<a href='https://youtu.be/FW8LdN85ujc' target='_blank'> HERE Two </a>" )); ?> </p>
                                            <p> <?php echo( sprintf( esc_html__('The code with other plugin integration is found ', 'raffle-play-woo' ), "<a href='https://tuskcode.com/version-5-6-2/' target='_blank'> HERE </a>" )); ?> </p>
                                            <p><?php esc_html_e('1. Copy the shortcode and paste it in the page/post/etc', 'raffle-play-woo' );?> </p>
                                            <p><?php esc_html_e('2. In the functions.php of your child theme add following filter hook', 'raffle-play-woo' );?> </p>
<pre> 
    <code> 
        add_filter('raffle_info_filter', 'funct_raffle_filter', 10, 2 );
        function funct_raffle_filter( $content, $raffle_obj ){
            // $raffle_obj is of type associative array and it has the following keys
            // $raffle_id           = $raffle_obj['raffle_id'];         //raffle id
            // $raffle_name         = $raffle_obj['raffle_name'];       //raffle name
            // $start_ticket        = $raffle_obj['start_ticket'];      //raffle starting number
            // $limit_tickets       = $raffle_obj['limit_tickets'];     //number of total tickets if not 'unlimited', else number
            // $sold_tickets        = $raffle_obj['sold_tickets'];      //number of sold tickets
            // $last_sold_ticket    = $raffle_obj['last_sold_ticket'];  //last sold ticket
            // $last_sold_prefixed  = $raffle_obj['last_sold_prefixed'];    //last sold with prefix
            // $prefix              = $raffle_obj['prefix'];            //prefix 
            // $start_datetime      = $raffle_obj['start_datetime'];    //1690911878, 0
            // $end_datetime        = $raffle_obj['end_datetime'];      //1690921878
            // $start_date_string   = $raffle_obj['start_date_string']; //Tue, 01 Aug 2023 17:44:36 GMT
            // $end_date_string     = $raffle_obj['end_date_string'];
            // $is_terminated       = $raffle_obj['is_terminated'];     // true/false
            // $is_raffle           = $raffle_obj['is_raffle']; 
            // productid            = $raffle_obj['productid'];
            // tags                 = $raffle_obj['tags'];

            $content = "Today is a great day.";

            return $content;
        }
    </code> 
</pre>
                                          
                                        </div>
                                    

                                    </div>



                                </div>
                                <!-- end of shortcode -->

                    <!-- test-->
                    <div class="tab-pane fade" id="v-pills-countdown" role="tabpanel" aria-labelledby="v-pills-countdown-tab">                                 
                            
                            <h5>                                        
                                <?php
                                    esc_html_e('Customize Countdown', 'raffle-play-woo');
                                ?>
                            </h5>                            
                            
                            <div>

                                <div class='row bmp-set-row' >
                                        <div class="col-sm-5" style='display: inline-block'> 
                                            <label for="countdown_hide_cart"> <?php esc_html_e('Hide "Add To Cart" Button', 'raffle-play-woo' );?> </label>
                                            <br/>
                                            <i><span style='font-size: .9rem;'> (<?php esc_html_e("If Raffle hasn't started, it's finished or terminated", 'raffle-play-woo' );?>)</span></i>
                                        </div>
                                    
                                        <div class="col-sm-7" style=''>       
                                            <div class="checkbox">                        
                                                <input type="checkbox"  data-toggle="toggle" data-size='small' 
                                                    <?php if( $settings['countdown']['hide_cart'] == 'yes'){ echo "checked";}?> id='countdown_hide_cart'
                                                    data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>"  
                                                    data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" />       
                                            </div>
                                            <i><span style='font-size: .9rem;'> (<?php esc_html_e("***IMPORTANT*** If this option is YES (Hide Cart), the position to display the countdown only works for the first 3 top positions (Before Single Product, Before Single Product Summary, Top of Single Product Summary), the other positions will be hidden by woocommerce", 'raffle-play-woo' );?>)</span></i>
                                        </div>
                                    </div>
                                
                                <div class='row bmp-set-row' >
                                    <div class="col-sm-5 " > 
                                        <?php esc_html_e('Background Color', 'raffle-play-woo' );?> 
                                    </div>
                                
                                    <div class="col-sm-7" >                               
                                        <input type="text" id="countdown_bg"  value="<?php echo esc_html($settings['countdown']['bg']);?>" />
                                    </div>
                                </div>

                                <div class='row bmp-set-row' >
                                    <div class="col-sm-5 " > 
                                        <?php esc_html_e('Color', 'raffle-play-woo' );?> 
                                    </div>
                                
                                    <div class="col-sm-7" >                               
                                        <input type="text" id="countdown_color"  value="<?php echo esc_html($settings['countdown']['color']);?>" />
                                    </div>
                                </div>

                                <div class='row bmp-set-row' >
                                    <div class="col-sm-5 " > 
                                        <?php esc_html_e('Days Label', 'raffle-play-woo' );?> 
                                    </div>
                                
                                    <div class="col-sm-7" >                               
                                        <input type="text" id="countdown_days"  value="<?php echo esc_html($settings['countdown']['days']);?>" />
                                    </div>
                                </div>

                                <div class='row bmp-set-row' >
                                    <div class="col-sm-5 " > 
                                        <?php esc_html_e('Hours Label', 'raffle-play-woo' );?> 
                                    </div>
                                
                                    <div class="col-sm-7" >                               
                                        <input type="text" id="countdown_hours"  value="<?php echo esc_html($settings['countdown']['hours']);?>" />
                                    </div>
                                </div>

                                <div class='row bmp-set-row' >
                                    <div class="col-sm-5 " > 
                                        <?php esc_html_e('Minutes Label', 'raffle-play-woo' );?> 
                                    </div>
                                
                                    <div class="col-sm-7" >                               
                                        <input type="text" id="countdown_mins"  value="<?php echo esc_html($settings['countdown']['mins']);?>" />
                                    </div>
                                </div>

                                <div class='row bmp-set-row' >
                                    <div class="col-sm-5 " > 
                                        <?php esc_html_e('Seconds Label', 'raffle-play-woo' );?> 
                                    </div>
                                
                                    <div class="col-sm-7" >                               
                                        <input type="text" id="countdown_secs"  value="<?php echo esc_html($settings['countdown']['secs']);?>" />
                                    </div>
                                </div>


                                <div class='row bmp-set-row' >
                                    <div class="col-sm-5 " > 
                                        <?php esc_html_e('Starts In Label', 'raffle-play-woo' );?> 
                                    </div>
                                
                                    <div class="col-sm-7" >                               
                                        <input type="text" id="countdown_starts"  value="<?php echo esc_html($settings['countdown']['starts']);?>" />
                                    </div>
                                </div>

                                <div class='row bmp-set-row' >
                                    <div class="col-sm-5 " > 
                                        <?php esc_html_e('Ends In Label', 'raffle-play-woo' );?> 
                                    </div>
                                
                                    <div class="col-sm-7" >                               
                                        <input type="text" id="countdown_ends"  value="<?php echo esc_html($settings['countdown']['ends']);?>" />
                                    </div>
                                </div>

                                <hr />

                                <p>
                                    <?php esc_html_e('The above settings are used to display the raffle countdown in the product page', 'raffle-play-woo' );?> 
                                </p>

                                <p>
                                    <?php esc_html_e('Do you want to display a countdown in the home page? or any other page?', 'raffle-play-woo' );?> 
                                </p>

                                <p>
                                 <?php esc_html_e('Here is an example on how to display a custom counter on any page with tuskcode countdwon', 'raffle-play-woo' );?> 
                                   <?php
                                        echo RafflePlayWoo_Countdown::$SHORTCODE_NAME;
                                   ?>
                                </p>
                        
<code>
<textarea rows='2' style='width: 100%;' editable='false' readonly>
<?php echo '[' .RafflePlayWoo_Countdown::$SHORTCODE_NAME . ' ' .
'datetime="2025-12-25 00:00:00" ' .
'bgcolor="red" '.
'color="#fff" ' .
'days="DD" ' .
'hours="HH" ' .
'minutes="MM" ' .
'seconds="SS" ' .
'header="' . esc_html__('Days left until Christmas 2025', 'raffle-play-woo').'"]';

?>
</textarea>
</code>

                                <p>
                                    <?php esc_html_e('How it works.', 'raffle-play-woo' );?> 
                                </p>

                                <p>
                                    <?php esc_html_e('Copy the shortcode on any page or post, and change the values. Datetime can be of timestamp or format yyyy-mm-dd hh:mm:ss. Color and bgcolor can be of hex or rgb. The rest are just labels.', 'raffle-play-woo' );?> 
                                </p>
                            

                                <hr />
                                
                                <p>
                                    <?php
                                        echo do_shortcode('['. RafflePlayWoo_Countdown::$SHORTCODE_NAME .' 
                                            datetime="2025-12-25 00:00:00"
                                            bgcolor="red"
                                            color="#fff"
                                            days="DD"
                                            hours="HH"
                                            minutes="MM"
                                            seconds="SS"
                                            header="' . esc_html__('Days left until Christmas 2025', 'raffle-play-woo').'"
                                            ]'
                                        );
                                    ?>

                                </p>



                            </div>

                        </div>
                        <!-- end of countdown -->

                        <!-- progress bar-->
                        <div class="tab-pane fade" id="v-pills-progressbar" role="tabpanel" aria-labelledby="v-pills-progressbar-tab">                                 
                            <h5>                                        
                                <?php
                                    esc_html_e('Customize Progress Bar', 'raffle-play-woo');
                                ?>
                            </h5> 

                            <div class='row bmp-set-row' >
                                <div class="col-sm-5 " > 
                                    <?php esc_html_e('Hide Progress Bar if the product is not purchasable', 'raffle-play-woo'); ?> <br/>
                                    <i>
                                        <?php esc_html_e('eg: raffle is terminated, raffle hasn\'t started, raffle has ended', 'raffle-play-woo' );?> 
                                    </i>
                                    <span data-toggle='tooltip' 
                                        title="<?php esc_html_e('Progress Bar would be hidden if the raffle not running.', 'raffle-play-woo' ); ?>" > 
                                        <i class="fa fa-info-circle text-info"></i> 

                                    </span>
                                </div>
                            
                                <div class="col-sm-7" >                               
                                    <input type="checkbox" id="pb_hide" data-toggle='toggle' data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>" 
                                    data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" <?php if( $settings['pb']['hide'] == 'yes' ) echo 'checked'; ?> data-size='small'/>
                                </div>
                            </div>

                            <div class='row bmp-set-row' >
                                <div class="col-sm-5 " > 
                                    <?php esc_html_e('Show Progress Bar only for limited raffle tickets', 'raffle-play-woo'); ?> <br/>
                                    <i>
                                        <?php esc_html_e('eg: Raffle has 1000 tickets available, the progress will show.', 'raffle-play-woo' );?> 
                                    </i>

                                </div>
                            
                                <div class="col-sm-7" >                               
                                    <input type="checkbox" id="pb_only_limited" data-toggle='toggle' data-on="<?php esc_html_e('Yes', 'raffle-play-woo');?>" 
                                    data-off="<?php esc_html_e('No', 'raffle-play-woo');?>" <?php if( $settings['pb']['only_limited'] == 'yes' ) echo 'checked'; ?> data-size='small'/>
                                </div>
                            </div>
                          
                            <div class='row bmp-set-row' >
                                <div class="col-sm-5 " style='display: inline-block'> 
                                    <?php esc_html_e('Text to display', 'raffle-play-woo' );?> 
                                </div>                                    
                            
                                <div class="col-sm-7">  
                                    <input type="text" id="pb_text" style='width: 100%' value="<?php echo esc_html($settings['pb']['text']);?>" />
                                    <p> <b> [sold] </b> - <?php esc_html_e(' keyword to display sold tickets'); ?></p>
                                    <p> <b> [total] </b> - <?php esc_html_e(' keyword for total number of tickets'); ?></p>
                                    <p> <b> [remaining] </b> - <?php esc_html_e(' keyword for remaining tickets'); ?></p>
                                    <p> <b> [percentage] </b> - <?php esc_html_e(' keyword for percentage sold'); ?></p>
                                    <p> <?php esc_html_e('The keywords will be replaced with the numbers when displayed', 'raffle-play-woo'); ?> </p>
                                    <p> <b> <?php esc_html_e('eg: 20/100 tickets sold - 80 left', 'raffle-play-woo'); ?> </b> </p>
                                </div>
                            </div>

                            <div class='row bmp-set-row' >
                                <div class="col-sm-5 " style='display: inline-block'> 
                                    <?php esc_html_e('Text Color', 'raffle-play-woo' );?> 
                                </div>                                    
                            
                                <div class="col-sm-7">  
                                    <input type="text" id="pb_color"  value="<?php echo esc_html($settings['pb']['color']);?>" />
                                </div>
                            </div>

                            <div class='row bmp-set-row' >
                                <div class="col-sm-5 " style='display: inline-block'> 
                                    <?php esc_html_e('Progress Bar Color', 'raffle-play-woo' );?> 
                                </div>                                    
                            
                                <div class="col-sm-7">  
                                    <input type="text" id="pb_bar_color"  value="<?php echo esc_html($settings['pb']['bar_color']);?>" />
                                </div>
                            </div>

                            <div class='row bmp-set-row' >
                                <div class="col-sm-5 " style='display: inline-block'> 
                                    <?php esc_html_e('Background Color', 'raffle-play-woo' );?> 
                                </div>                                    
                            
                                <div class="col-sm-7">  
                                    <input type="text" id="pb_bg_color"  value="<?php echo esc_html($settings['pb']['bg_color']);?>" />
                                </div>
                            </div>

                            <div class='row bmp-set-row' >
                                <div class="col-sm-5 " style='display: inline-block'> 
                                    <?php esc_html_e('Custom HTML classes', 'raffle-play-woo' );?> <br/>
                                    <span> &#x1F6C8 <i> <?php esc_html_e('Use spaces as delimiter', 'raffle-play-woo' );?> </i> &#x1F6C8</span>
                                </div>                                    
                            
                                <div class="col-sm-7">  
                                    <input type="text" id="pb_html_class" style='width: 100%' value="<?php echo esc_html($settings['pb']['html_class']);?>" />
                                </div>
                            </div>

                            <div class='row bmp-set-row' >
                                <div class="col-sm-5 " style='display: inline-block'> 
                                    <?php esc_html_e('Custom Progress Bar Shortcode', 'raffle-play-woo' );?> <br/>
                                    
                                </div>                                    
                            
                                <div class="col-sm-7">  
                                    <p><?php esc_html_e('You can place custom progress bar on any page with the following shortcode - if options left empty will pick the default setting set above.', 'raffle-play-woo'); ?></p>
                                    <p> <?php esc_html_e( 'Optional settings');?></p>
                                    <ul>
                                        <li> <p> <b> raffle_id="0" </b>  - <?php esc_html_e('Raffle id, swap 0 to your desired raffle id', 'raffle-play-woo');?> </p></li>
                                        <li> <p> <b> bar_color="red"</b> - <?php esc_html_e('Bar color of the progress, text, hex, rgb, and rgba accepted.', 'raffle-play-woo');?> </p></li>
                                        <li> <p> <b> bg_color="rgba(100, 200, 100, 0.3)" </b> -
                                                <?php esc_html_e('Background color of the progress, text, hex, rgb, and rgba accepted.', 'raffle-play-woo');?>
                                            <p>
                                        </li>
                                        <li> <p> <b> text="Sold %sold% - Percentage %percentage% - Remaining %remaining% - Total %total%" </b> -
                                            <?php esc_html_e('Text to display, for shortcode use the following text replaces', 'raffle-play-woo');?>
                                            </p>
                                        </li>
                                        <li> <p> <b> html_class="custom-class" </b> - <?php esc_html_e('Custom html class', 'raffle-play-woo');?> </p> </li>
                                        
                                    </ul>
                                    <code>
                                        [RAFFLE_PROGRESSBAR raffle_id="0" bar_color="red" bg_color="rgba(100, 200, 100, 0.3)" text="Sold %sold% - Percentage %percentage% - Remaining %remaining% - Total %total%" html_class="custom-class"]  
                                    </code>
                                </div>
                            </div>
                            

                        </div>
                        <!-- end of progress bar-->

                        <!-- Generate Raffle Tickets at Checkout -->
                            <?php include_once( 'main/W_RafflePlayWoo_Main_GenCheckout.php'); ?>
                        <!-- end of generate raffle tickets at checkout -->

                        <!-- Generate Raffle Tickets at Checkout -->
                        <?php include_once( 'main/W_RafflePlayWoo_Main_SearchTickets.php'); ?>
                        <!-- end of generate raffle tickets at checkout -->

                        <!-- Generate Raffle Tickets at Checkout -->
                        <?php include_once( 'main/W_RafflePlayWoo_Main_ProductTab.php'); ?>
                        <!-- end of generate raffle tickets at checkout -->

                        <!-- User Picks tickets at checkout -->
                        <?php include_once( 'main/W_RafflePlayWoo_Main_UserPicks.php'); ?>
                        <!-- end of User Picks tickets at checkout -->

                            </div>
                        </div>
                    </div>

                    <?php wp_nonce_field( 'nonce_field_form_rpr', 'nonce_field_form_rpr' ); ?>
                   
                    <input type='submit' class="button button-primary rdp_save_settings" value="<?php esc_html_e('Save', 'raffle-play-woo' );?>" />  
                  

            </div> <!-- /container-fluid -->
        </div> <!-- /wrap -->

      <?php  
    }

?>