<?php

namespace W_RafflePlayWoo_Lucky;

if( ! defined('ABSPATH')) exit;

include_once( RAFFLE_PLAY_WOO_DIR_PATH . '/includes/RafflePlayWoo_Includes.php');

class W_RafflePlayWoo_Lucky{

    public static function drp_luckyPage( $data ){

        \RafflePlayWoo_Includes::rpwoo_loading_screen();
        $none_lbl = esc_html__('None', 'raffle-play-woo');       
        $data['products'][0] = $none_lbl;

        $ticket_image = array(
            'none'      => $none_lbl,
            'blue'      => esc_html__('Blue', 'raffle-play-woo'),
            'gold-one'  => esc_html__('Gold', 'raffle-play-woo'),
            'gold-two'  => esc_html__('Gold Lines', 'raffle-play-woo'),
            'gray'      => esc_html__('Gray', 'raffle-play-woo'),
            'orange'    => esc_html__('Orange', 'raffle-play-woo'),
            'purple'    => esc_html__('Purple', 'raffle-play-woo'),
            'red'       => esc_html__('Red', 'raffle-play-woo'),
            'custom'    => esc_html__('Custom', 'raffle-play-woo'),
        )
     
    ?> 
    
        <script>
            var     rpwoo_data        = <?php echo json_encode( $data['data'] );?>;  
            const   rpwoo_raffles     = <?php echo json_encode( $data['raffles'] );?>;       
            const   rpwoo_symbol    = "<?php echo $data['currency']; ?>";
            const   raffle_icon     = "<?php echo esc_url( $data['raffle_icon']);?>";
            const   categories      = <?php echo json_encode( $data['categories'] );?>;  
            const   rpwoo_products   = <?php echo json_encode( $data['products'] );?>; 
            const   rpwoo_ticket_img = <?php echo json_encode( $ticket_image );?>; 
            const   rpwoo_url        = "<?php echo esc_url(RAFFLE_PLAY_WOO_URL) . '/';?>";
            const   gen_at_checkout   =  <?php echo json_encode( $data['gen_at_checkout'] );?>; 
            const   rpwoo_admin_url   = "<?php echo get_admin_url(); ?>";
        </script>

        <style>
            .lbl-ava-ticket{
                min-width: 80px;
                cursor: pointer;
            }

            .tooltip_div {
                position: relative;
                display: inline-block;            
            }

            .tooltip_div .tooltiptext {
                visibility: hidden;
                min-width: 120px;
                padding: 5px;
                background-color: #555;
                color: #fff;
                text-align: center;
                border-radius: 6px;
                padding: 5px 0;
                position: absolute;
                z-index: 1;
                bottom: 125%;
                left: 50%;
                margin-left: -60px;
                opacity: 0;
                transition: opacity 0.3s;
            }

            .tooltip_div .tooltiptext::after {
                content: "";
                position: absolute;
                top: 100%;
                left: 50%;
                margin-left: -5px;
                border-width: 5px;
                border-style: solid;
                border-color: #555 transparent transparent transparent;
            }

            .tooltip_div:hover .tooltiptext {
                visibility: visible;
                opacity: 1;
            }
        </style>


        <?php wp_nonce_field( 'nonce_field_form_rpr', 'nonce_field_form_rpr' ); ?>

        <div class='wrap lucky-page'>

            <div class="container-fluid" 
                ref='main_container' style='visibility: hidden;'>

                <?php
                    \RafflePlayWoo_Includes::rpwoo_contact_link();
                ?>

                <div class="bmp-set-row">

                    <h3 class='h4'> <?php esc_html_e('Lucky Numbers (Instant Wins)', 'raffle-play-woo'); ?> </h3>

                    <p style='font-size: .85rem;'> 
                        <i> 
                            <?php esc_html_e('While running a raffle reward your customers with smaller prizes as instant wins', 'raffle-play-woo'); ?> 
                        </i> 
                    </p>

                    <p style='font-size: .85rem; margin-top: -7px;'> 
                        <i>
                            <?php esc_html_e('You can define a winning number or let the system pick one. It only works with Random Tickets', 'raffle-play-woo'); ?> 
                        </i> 
                    </p>

                    <p style='font-size: .9rem; margin-top: -7px; font-weight: 600;'> 
                        <i>
                            <a href="https://youtu.be/Ypyw8KzWyd4" target='_blank'>
                                <?php esc_html_e('Watch setup video here', 'raffle-play-woo'); ?> 
                            </a>
                        </i> 
                    </p>

                    <div class='content-lucky'>


                        <div class="row">

                            <div class="col-md-3">
                                <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">

                                    
                                    <a v-for="item in raffles" :class="( item.id == last_raffle_active ) ? 'nav-link active' : 'nav-link'"
                                        :id="'v-pills-' + item.id + '-tab'" data-toggle="pill" @click="raffle_tab( item.id )"
                                        :href="'#v-pills-' + item.id" role="tab" :aria-selected="(item.id == 0) ? 'true' : ''" >
                                            {{item.name}}
                                    </a>
                                    
                                </div>
                            </div>

                            <div class="col-md-9">

                            <div class="add_edit_delete">

                                <span  title="<?php esc_html_e('Add', 'raffle-play-woo');?>" v-show="this.action == '' && (reason.length == 0) " >
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" @click='action_control("new")'
                                       
                                        fill="currentColor" style='cursor:pointer'
                                        class="bi bi-plus-square-fill" viewBox="0 0 16 16">
                                        <path d="M2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2zm6.5 4.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3a.5.5 0 0 1 1 0"/>
                                    </svg>
                                </span>

                                <p class='h6 text-warning' v-show="reason.length > 0">
                                    <?php esc_html_e('Cannot create lucky numbers for this raffle.', 'raffle-play-woo'); ?>
                                    <br/>

                                    <p v-for="reason_item in reason" class='text-danger'> 
                                        {{reason_item}}
                                    </p>
                                </p>

                                <span title="<?php esc_html_e('Save', 'raffle-play-woo');?>" v-show="this.action != '' " >
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" 
                                        @click='action_control("save")'
                                        
                                        style='cursor:pointer; margin-left: 10px;'
                                        class="bi bi-check-square" viewBox="0 0 16 16">
                                        <path d="M14 1a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1zM2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2z"/>
                                        <path d="M10.97 4.97a.75.75 0 0 1 1.071 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425z"/>
                                    </svg>
                                </span>

                                <span title="<?php esc_html_e('Cancel', 'raffle-play-woo');?>" v-show="this.action != ''" >
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" 
                                        @click='action_control("cancel")'
                                        
                                        style='cursor:pointer; margin-left: 10px;'
                                        class="bi bi-x-square" viewBox="0 0 16 16">
                                        <path d="M14 1a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1zM2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2z"/>
                                        <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708"/>
                                    </svg>
                                </span>

                                <span style='float: right; margin-top: -40px; font-size : 0.8rem;'>
                                    <?php esc_html_e('Shortcode to display Lucky Numbers', 'raffle-play-woo');?>
                                    <br/>
                                    <code>
                                        [<?php echo $data['shortcode_lucky'];?> raffle_id="{{raffle_id}}"]
                                    </code>
                                </span>

                                <p></p>

                                <hr />

                                <div class="col-12 bmp-set-row" v-show="action == ''">
                                        <label for='lucky_concentrate' style='cursor:pointer'>
                                            <?php esc_html_e('Concentrate Number (pool)', 'raffle-play-woo'); ?>
                                            <input type="number" name="" min='0' readonly  id="lucky_concentrate" style='width: 100px'
                                                v-model="raffles_data[ raffle_id ].concentrate">
                                            
                                            <div class="tooltip_div"  >
                                                
                                                <svg xmlns="http://www.w3.org/2000/svg"
                                                    width="20" height="20" fill="currentColor" 
                                                    class="bi bi-info-circle-fill" viewBox="0 0 16 16"
                                                    style='cursor: pointer;'
                                                    >
                                                    <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
                                                </svg>

                                                <span class="tooltiptext" style='min-width: 350px'>
                                                    <i>
                                                        <?php esc_html_e('Example: Concentrate number is 100, customer buys 20 tickets, and there are 4 lucky numbers not won. The pool to draw one winning number is 124. Changes to win is 4/124 for each number drawn from 24 purchased. (Extremely high to win)', 'raffle-play-woo');?>
                                                    </i>
                                                </span>
                                            </div>
        
                                        </label>
                                </div>   

                                <div v-show="action !== ''">

                                    <div class="row col-12 bmp-set-row" v-show='lucky.is_won'>

                                            <span  class='text-success h5 text-center'>
                                                ***
                                                <?php esc_html_e('Won Ticket', 'raffle-play-woo'); ?>
                                                ***
                                            </span>
                                            
                                    </div>

                                    <p></p>

                                    <div class="row col-12 bmp-set-row">
                                        <label for='lucky_concentrate' style='cursor:pointer'>
                                            <?php esc_html_e('Concentrate Number (Set per raffle)', 'raffle-play-woo'); ?>
                                            <input type="number" name="" min='0'  id="lucky_concentrate" style='width: 100px'
                                                v-model="raffles_data[ raffle_id ].concentrate">
                                            
                                        </label>
                                    </div>                                        

                                    <p></p>

                                    <div class="row col-12 bmp-set-row">
                                        <label for='lucky_active' style='cursor:pointer'>
                                            <input type="checkbox" name=""  id="lucky_active"
                                                v-model="lucky.active">
                                            <?php esc_html_e('Active', 'raffle-play-woo'); ?>
                                        </label>
                                    </div>

                                    <p></p>

                                    <div class="row col-12 bmp-set-row">

                                        <div class="col-md-5">
                                            <?php esc_html_e('Lucky Number Name', 'raffle-play-woo'); ?>
                                        </div>

                                        <div class="col-md-5">
                                            <input type="text" name="" id="" class="form-control" v-model="lucky.name" />
                                        </div>

                                    </div>

                                    <p></p>


                                    <div class="row col-12 bmp-set-row">

                                        <div class="col-md-5">
                                            <?php esc_html_e('Lukcy Number', 'raffle-play-woo'); ?>
                                        </div>
                                        <div class="col-md-7">
                                            <label for="system_pick_number" v-show='false'>
                                                <input type="radio"  value='random' 
                                                    id="system_pick_number" v-model="lucky.type" />
                                                <?php esc_html_e('Let the System pick the number randomly when tickets are generated', 'raffle-play-woo'); ?>
                                            </label>

                                            <p></p>

                                            <label for="manual_pick_number">
                                                <input type="radio"  value='manual' :checked='true'
                                                    id="manual_pick_number" v-model="lucky.type" />
                                                <?php esc_html_e('Pick the number manually', 'raffle-play-woo'); ?>
                                            </label>

                                            <p v-show="lucky.type == 'manual' ">
                                                <input type="text" v-model="lucky.number"
                                                    @input="checkAboveNumber()" :readonly="lucky.is_won ? true : false" 
                                                     id='lucky_number_input' style='width: 80px; display: inline-block;' />
                                                <button class='button button-secondary' ref='btn_select_number'
                                                    :disabled="lucky.is_won ? true : false" 
                                                    @click='selectNumber' style='margin-left: 5px; display: inline-block;'> 
                                                    <?php esc_html_e('Look up Available Numbers', 'raffle-play-woo');?>
                                                    <div ref='btn_div' class='' 
                                                        style='display: inline-block; margin-left: 5px;'></div>
                                                </button>
                                                <p >
                                                    (<?php esc_html_e('Up to 1000 random numbers displayed. Want more? Use filter ', 'raffle-play-woo');?> 
                                                    <code> raffle_availabe_random_tickets </code> )
                                                </p>
                                            </p>                                                    

                                            <div class="btns-control-pick" v-show="(lucky.type == 'manual') && controls.show_numbers">
                                                <div style='margin-bottom: 10px;'>

                                                    <span @click="hideNumbers" title="<?php esc_html_e('Close', 'raffle-play-woo'); ?>">
                                                        <svg xmlns="http://www.w3.org/2000/svg" style='cursor: pointer;'
                                                            width="24" height="24" fill="currentColor" 
                                                            class="bi bi-x-circle" viewBox="0 0 16 16">
                                                            <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
                                                            <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708"/>
                                                        </svg>
                                                    </span>

                                                    <span @click="getRandom" title="<?php esc_html_e('Get Random', 'raffle-play-woo'); ?>">
                                                        <svg xmlns="http://www.w3.org/2000/svg" style='cursor: pointer;'
                                                            width="24" height="24" fill="currentColor" 
                                                            class="bi bi-shuffle ms-3" viewBox="0 0 16 16">
                                                            <path fill-rule="evenodd" d="M0 3.5A.5.5 0 0 1 .5 3H1c2.202 0 3.827 1.24 4.874 2.418.49.552.865 1.102 1.126 1.532.26-.43.636-.98 1.126-1.532C9.173 4.24 10.798 3 13 3v1c-1.798 0-3.173 1.01-4.126 2.082A9.6 9.6 0 0 0 7.556 8a9.6 9.6 0 0 0 1.317 1.918C9.828 10.99 11.204 12 13 12v1c-2.202 0-3.827-1.24-4.874-2.418A10.6 10.6 0 0 1 7 9.05c-.26.43-.636.98-1.126 1.532C4.827 11.76 3.202 13 1 13H.5a.5.5 0 0 1 0-1H1c1.798 0 3.173-1.01 4.126-2.082A9.6 9.6 0 0 0 6.444 8a9.6 9.6 0 0 0-1.317-1.918C4.172 5.01 2.796 4 1 4H.5a.5.5 0 0 1-.5-.5"/>
                                                            <path d="M13 5.466V1.534a.25.25 0 0 1 .41-.192l2.36 1.966c.12.1.12.284 0 .384l-2.36 1.966a.25.25 0 0 1-.41-.192m0 9v-3.932a.25.25 0 0 1 .41-.192l2.36 1.966c.12.1.12.284 0 .384l-2.36 1.966a.25.25 0 0 1-.41-.192"/>
                                                        </svg>
                                                    </span>


                                                </div>
                                             
                                            </div>
                                          

                                        </div>

                                        <div class='div-select-number col-12' v-show="(lucky.type == 'manual') && controls.show_numbers"  >

                                                <div class="block-show-numbers"
                                                    style='max-height: 150px; overflow: auto; padding: 20px;' 
                                                    ref='block_numbers'>

                                                </div>
                                        </div>

                                    </div>

                                    <p></p>

                                    <div class="row col-12 bmp-set-row">

                                        <div class="col-md-5">
                                            <?php esc_html_e('Include in draw after tickets purchased', 'raffle-play-woo'); ?>
                                            <?php esc_html_e('(at least)', 'raffle-play-woo'); ?>
                                        </div>
                                        <div class="col-md-7">
                                            <div class="col-lg-3">
                                                <input type="number" 
                                                    style="width: 150px"
                                                    name="" value='0' min='0' id="" v-model="lucky.purchased"  id='input_lucky_purchased'                                                   
                                                    class="form-control"  @input="checkAbovePurchased()" />
                                            </div>
                                            <div class="col-lg-12">
                                                <span
                                                    style="display: inline-block; float: right; margin-top: -30px; "    
                                                >
                                                    (<?php esc_html_e('Sold', 'raffle-play-woo'); ?> 
                                                    - {{ soldRaffleTickets() }}
                                                     )
                                                </span>
                                            </div>
                                        </div>

                                    </div>

                                    <p></p>

                                                                                
                                    <div class="row col-12 bmp-set-row">

                                        <div class="col-md-5">
                                            <?php esc_html_e('Linked to Product', 'raffle-play-woo'); ?>
                                            <?php esc_html_e('(Winning Product)', 'raffle-play-woo'); ?>
                                        </div>
                                        <div class="col-md-5">
                                            <select name="lucky_product" id="lucky_product" v-model="lucky.product_id" >
                                                <option v-for='( prod_name, prod_id ) of products' :value="prod_id">
                                                    {{prod_name}}
                                                </option>
                                            </select>  
                                        </div>

                                    </div>

                                    <p></p>

                                    <div class='row col-12 bmp-set-row' >
                                        <div class="col-sm-5 " style='display: inline-block'> 
                                            <?php esc_html_e('Background Image', 'raffle-play-woo'); ?> 
                                        </div>                                    

                                        <div class="col-sm-7" style='display: inline-block;'>
                                            <p class='h6'><?php  esc_html_e('Select image for background ticket. (Select custom to add your own)', 'raffle-play-woo' );?> </p>  
                                            <select name="select_ticket_image" id="select_ticket_image" @change="imgChanged"
                                                v-model="lucky.bg_img">
                                                <option v-for="(img_name, img_id) of tickets_img" :value="img_id"> 
                                                    {{img_name}}
                                                </option>                                               
                                            </select>
                                            
                                            <img id='ticket_img_show' ref="ticket_img_show" class='ms-3' v-show="lucky.bg_img != 'none'"
                                                 src="" style='width: 80px;' alt="">

                                            <div class='row' style='margin-top: 12px' >
                                            
                                                <div class="col-sm-12 div-custom-ticket-img" v-show="lucky.bg_img == 'custom'" >                             
                                                    <div style='display: inline;'>
                                                        <input type="text" id="ticket_image_url" v-model="lucky.custom_img" @input="imgChanged"  style='width:80%' style='display: inline;'
                                                        placeholder="https://yourdomain.com/images/raffle-ticket-image.png"
                                                        value="" />
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>

                                    <p></p>

                                    <div class="row col-12 bmp-set-row">

                                        <div class="col-md-12">
                                            <?php esc_html_e('Winning Message', 'raffle-play-woo'); ?>
                                        - 
                                            <?php esc_html_e('Use', 'raffle-play-woo'); ?>
                                            <strong> %product_link%  </strong>
                                            <?php esc_html_e('to display link to product (Thank you page / Email)', 'raffle-play-woo'); ?>
                                        </div>

                                        <div class="col-md-12">
                                            <input type="text" name="" id="" class="form-control" v-model="lucky.message" />
                                        </div>

                                    </div>

                                </div>
                            </div>

                                <div class="tab-content" id="v-pills-tabContent">

                                    <div v-for="item in raffles" :class="(item.id == last_raffle_active ) ? 'tab-pane fade show active' : 'tab-pane fade show'" 
                                        :id="'v-pills-' + item.id" role="tabpanel" 
                                        aria-labelledby="'v-pills-' + item.id + '-tab'">                                     
                                

                                        <table class='table table-bordered'>
                                            <thead>
                                                <th> <?php esc_html_e('Action', 'raffle-play-woo'); ?>  </th>
                                                <th> <?php esc_html_e('Active', 'raffle-play-woo'); ?>  </th>
                                                <th> <?php esc_html_e('Name', 'raffle-play-woo'); ?>    </th>                                                                                                
                                                <th> <?php esc_html_e('Number', 'raffle-play-woo'); ?>  </th>
                                                <th style='width: 130px'> <?php esc_html_e('After Sold', 'raffle-play-woo'); ?> </th>
                                                <th> <?php esc_html_e('Product', 'raffle-play-woo'); ?>  </td>
                                                <th> <?php esc_html_e('Won', 'raffle-play-woo'); ?>     </th>
                                            </thead>

                                            <tbody>
                                                <tr v-for="lucky in raffles_data[item.id].lucky" 
                                                    :class="(lucky.is_won == true) ? 'tr-lucky-won-number' : ''">
                                                    
                                                    <td> 
                                                        <span title="<?php esc_html_e('Edit', 'raffle-play-woo');?>" 
                                                            @click="edit_lucky( lucky.id )"    
                                                            style='cursor : pointer' 
                                                        >
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"                                                                                                                            
                                                                fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                                                <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
                                                                <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z"/>
                                                            </svg>
                                                        </span>  
                                                        
                                                        <span
                                                            class='ms-3'
                                                            title="<?php esc_html_e('Delete', 'raffle-play-woo'); ?>"
                                                            @click="delete_lucky( lucky.id )"  
                                                            style='cursor : pointer'  
                                                        >
                                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" 
                                                                fill="currentColor" class="bi bi-trash3" viewBox="0 0 16 16">
                                                                <path d="M6.5 1h3a.5.5 0 0 1 .5.5v1H6v-1a.5.5 0 0 1 .5-.5M11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3A1.5 1.5 0 0 0 5 1.5v1H1.5a.5.5 0 0 0 0 1h.538l.853 10.66A2 2 0 0 0 4.885 16h6.23a2 2 0 0 0 1.994-1.84l.853-10.66h.538a.5.5 0 0 0 0-1zm1.958 1-.846 10.58a1 1 0 0 1-.997.92h-6.23a1 1 0 0 1-.997-.92L3.042 3.5zm-7.487 1a.5.5 0 0 1 .528.47l.5 8.5a.5.5 0 0 1-.998.06L5 5.03a.5.5 0 0 1 .47-.53Zm5.058 0a.5.5 0 0 1 .47.53l-.5 8.5a.5.5 0 1 1-.998-.06l.5-8.5a.5.5 0 0 1 .528-.47M8 4.5a.5.5 0 0 1 .5.5v8.5a.5.5 0 0 1-1 0V5a.5.5 0 0 1 .5-.5"/>
                                                            </svg>
                                                        </span>
                                                    
                                                    </td>
                                                    <td>                                                 
                                                        <span :class="lucky.active ? 'lucky-active-yes' : 'lucky-active-no'">
                                                        </span>

                                                        {{lucky.active ? 'Yes' : 'No'}}

                                                    </td>
                                                    <td> {{lucky.name}}</td>                                                   
                                                    <td style='width: 140px;'> 
                                                        {{lucky.number}} 

                                                        <img  class='ms-3' 
                                                            v-show="lucky.bg_img != 'none'"
                                                            :src="getImg( lucky )" style='width: 50px; float: right;' alt="">

                                                    </td>
                                                    <td style='max-width: 70px;'> 
                                                        {{lucky.purchased}}
                                                    </td>

                                                    <td>
                                                        {{getProductName( lucky.product_id )}}
                                                    </td>
                                                    <td> 
                                                        {{lucky.is_won ? 'Yes' : 'No'}}
                                                        <span v-show="lucky.is_won">
                                                            - <a :href="admin_url +'admin.php?page=wc-orders&action=edit&id=' + lucky.order_id_won"> {{lucky.order_id_won }} </a>
                                                        </span>

                                                        <div class='tooltip_div ms-3' v-show="lucky.is_won" > 

                                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                                width="20" height="20" fill="currentColor" 
                                                                class="bi bi-info-circle-fill" viewBox="0 0 16 16"
                                                                style='cursor: pointer;'
                                                                >
                                                                <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
                                                            </svg>

                                                            <span class="tooltiptext"> 
                                                                <p>
                                                                    {{lucky.winner.first_name }} {{ lucky.winner.last_name }}
                                                                </p>

                                                                <p>
                                                                    {{lucky.winner.email }}
                                                                </p>

                                                                <p>
                                                                    {{lucky.winner.phone }}
                                                                </p>
                                                            </span>
                                                        </div>
                                                    </td>

                                                </tr>

                                            </tbody>

                                        </table>

                                    </div>
                                    
                                </div>
                            </div>

                        </div>

                    </div>

                </div>




                <!-- Modal -->

                <!-- /.modal -->   


            </div> <!-- /container-fluid -->
        </div> <!-- /wrap -->

      <?php  
    
    }
}