<?php
   if( ! defined( 'ABSPATH') ){ die('No access to this page'); }

    function drp_InfoPage( $settings ){
             
    ?>    
    

        <div class='wrap'>

            <div class="container-fluid">  

                <?php
           
                    $license_active = esc_html__( 'No', 'raffle-play-woo' );
                    $license_domain = '';
                    $support_expiry = '';
                    $message_license = '';
                    $latest_version  = '';

                    if( ( $settings['license'] != '') && isset( $settings['license']->data->licenseKey ) ){ 
                        $license_active = esc_html__( 'Yes', 'raffle-play-woo' );
                    }
                    if( ( $settings['license'] != '' )  && (  isset( $settings['license']->data->url) )){
                        $license_domain = esc_html( $settings['license']->data->url );
                    }
                    if( ( $settings['license'] != '') && isset( $settings['license']->data->expiresAt ) ){
                        $support_expiry =  esc_html( $settings['license']->data->expiresAt );
                    }

                    if( ( $settings['license'] != '') && isset( $settings['license']->data->latest_version ) ){
                        $latest_version =  esc_html( $settings['license']->data->latest_version );
                    }

                    if( ( $settings['license'] != '') && isset( $settings['license']->message ) ){
                        $message_license =  esc_html( $settings['license']->message );
                    }

                ?>
              

                <div class="row">
                    <div class="col-3">
                        <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">

                        <a  class="nav-link active" id="v-pills-license-tab" data-toggle="pill" href="#v-pills-license"
                            role="tab" aria-controls="v-pills-license" aria-selected="true">
                            <?php esc_html_e('License',  'raffle-play-woo' ); ?>
                        </a>

                        <a class="nav-link" id="v-pills-install-tab" data-toggle="pill" href="#v-pills-install" role="tab" aria-controls="v-pills-install" aria-selected="false">
                            <?php esc_html_e('Doc - Installation',  'raffle-play-woo' ); ?>
                        </a>

                        <a class="nav-link" id="v-pills-default-tab" data-toggle="pill" href="#v-pills-default" role="tab" aria-controls="v-pills-default" aria-selected="false">
                            <?php esc_html_e('Doc - Default Raffle Setup',  'raffle-play-woo' ); ?>
                        </a>

                        <a class="nav-link" id="v-pills-raffles-tab" data-toggle="pill" href="#v-pills-raffles" role="tab" aria-controls="v-pills-raffles" aria-selected="false">
                            <?php esc_html_e('Doc - Raffles Setup',  'raffle-play-woo' ); ?>
                        </a>

                        <a class="nav-link" id="v-pills-winners-tab" data-toggle="pill" href="#v-pills-winners" role="tab" aria-controls="v-pills-winners" aria-selected="false">
                            <?php esc_html_e('Doc - Winners Page',  'raffle-play-woo' ); ?>
                        </a>

                        <a class="nav-link" id="v-pills-reports-tab" data-toggle="pill" href="#v-pills-reports" role="tab" aria-controls="v-pills-reports" aria-selected="false">
                            <?php esc_html_e('Doc - Reports Page',  'raffle-play-woo' ); ?>
                        </a>

                        <a class="nav-link" id="v-pills-pdf-tab" data-toggle="pill" href="#v-pills-pdf" role="tab" aria-controls="v-pills-pdf" aria-selected="false">
                            <?php esc_html_e('Doc - Email PDF Attachment',  'raffle-play-woo' ); ?>
                        </a>

                        </div>
                    </div>

                    <div class="col-9 div-container-right">

                        <div class="tab-content" id="v-pills-tabContent">
                            <!-- license tab -->
                            <div class="tab-pane fade show active" id="v-pills-license" role="tabpanel" aria-labelledby="v-pills-license-tab">     
                            <div class='row'>
                                <form method="post">
                                    <div class='row'>

                                        <div class='col-sm-6'>
                                            <?php esc_html_e('License (paste it here)', 'raffle-play-woo' ); ?>
                                            <input type="text" class='form-control' value='<?php esc_html_e( $settings['license_txt'] ); ?>' 
                                            name="license_txt" id="input_license"
                                            placeholder="<?php esc_html_e('Enter the license number', 'raffle-play-woo' ); ?>"
                                            /> 
                                            <div class='col text-danger h5'>
                                                <?php echo esc_html(  $message_license ); ?>
                                            </div>
                                                                                
                                            <div class='col-sm-6'>
                                                    <?php esc_html_e('Licensing Server Url', 'raffle-play-woo' ); ?>
                                                <input type="text" class='form-control' value='<?php echo(  esc_url( $settings['server_url'] ) ); ?>' 
                                                name="server_url" id="server_url"
                                                placeholder="<?php esc_html_e('Licensing Server Url', 'raffle-play-woo' ); ?>"
                                                /> 
                                                <div class='col text-danger h5'>
                                                    <?php echo esc_html(  $message_license ); ?>
                                                </div>
                                            </div>

                                        </div>                                       
                                        
                                        <div class="col-sm-6">

                                            <div class="row">
                                                <div class="col-sm-6">
                                                    <?php esc_html_e('License Version', 'raffle-play-woo' ); ?> 
                                                </div>              
                                                <div class="col-sm-6">
                                                    <input type="text" name="" readonly id="" 
                                                    value="<?php esc_html_e( $settings['version'] ) ;?>" />
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                    <?php esc_html_e('License Active', 'raffle-play-woo' ); ?> 
                                                </div>              
                                                <div class="col-sm-6">
                                                    <input type="text" name="" readonly id="" 
                                                    value="<?php echo $license_active; ?>" />
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                    <?php esc_html_e('Domain License', 'raffle-play-woo' ); ?> 
                                                </div>              
                                                <div class="col-sm-6">


                                                    <?php if( str_contains( $license_domain, ';') ) : 

                                                            $ld = explode(';', $license_domain );
                                                    ?>
                                                            <textarea name="" id="" cols="23" readonly
                                                            rows="<?php echo count($ld);?>"><?php echo implode( '&#13;&#10;', $ld );?></textarea>

                                                    <?php else: ?>

                                                            <input type="text" readonly name="" id="" 
                                                            value="<?php echo $license_domain; ?>" />

                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-sm-6">
                                                    <?php esc_html_e('Support & Updates End Date', 'raffle-play-woo' ); ?> 
                                                </div>              
                                                <div class="col-sm-6">
                                                    <input type="text" name="" readonly id=""
                                                    value="<?php echo $support_expiry;?>">
                                                </div>
                                            </div>

                                            <div class="row">

                                                <div class="col-sm-6">
                                                    <?php esc_html_e('Latest Version Available', 'raffle-play-woo' ); ?> 
                                                </div>              
                                                <div class="col-sm-6">
                                                    <input type="text" name="" readonly id="" 
                                                    value="<?php echo $latest_version; ?>" />

                                                    <?php
                                                        if( ($latest_version != '') && ( $latest_version != $settings['version']  ) ){
                                                            $view = esc_html__('View', 'raffle-play-woo' );
                                                            echo sprintf( "<a href='http://tuskcode.com' target='_blank'>%s</a>", $view  );
                                                        }
                                                    ?>
                                                </div>
                                            </div>


                                            
                                            <div class="row">

                                                <div class="col-sm-6">
                                                    <?php esc_html_e('License Date last checked', 'raffle-play-woo' ); ?> 
                                                </div>              
                                                <div class="col-sm-6">
                                                    <input type="text" name="" readonly id="" 
                                                    value="<?php echo $settings['last_checked']; ?>" />


                                                </div>
                                            </div>

                                            <div class="row text-success font-weight-bold ">
                                                <div class="col-sm-12 h5">                                                 
                                                        <?php
                                                            if( $settings['valid_license'] == true ){
                                                                esc_html_e('License is valid. Thank you for using our product. We much appreciate it.', 'raffle-play-woo' );
                                                            }
                                                        ?>                                                    
                                                </div>
                                                <div class="col-sm-12">
                                                    <?php

                                                        try {
                                                            RafflePlayWoo_Includes::rpwoo_contact_link();
                                                        } catch (\Throwable $th) {
                                                            //throw $th;
                                                        }
                                                    ?>
                                                </div>
                                            </div>

                                        </div>
                                    
                                        <p></p>

                                        <div >
                                            <input class='button button-primary' type="submit" value="<?php esc_html_e('Validate License', 'raffle-play-woo'); ?>">
                                        </div>


                                        <?php wp_nonce_field( 'nonce_field_form_license', 'nonce_field_form_license' ); ?>
                                    </div>
                                </form>
                                </div>
                            </div>

                            <!-- Installation tab -->
                            <div class="tab-pane fade show " id="v-pills-install" role="tabpanel" aria-labelledby="v-pills-install-tab">     
                                <?php
                                    include_once( RAFFLE_PLAY_WOO_DIR_PATH . '/includes/docs/RafflePlayWoo_Docs_Installation.php');
                                ?>
                            </div>

                            <!-- Default Raffle Setup tab -->
                            <div class="tab-pane fade show " id="v-pills-default" role="tabpanel" aria-labelledby="v-pills-default-tab">     
                                <?php
                                    include_once( RAFFLE_PLAY_WOO_DIR_PATH . '/includes/docs/RafflePlayWoo_Docs_DefaultRaffle.php');
                                ?>
                            </div>

                            <!-- Raffles Setup tab -->
                            <div class="tab-pane fade show " id="v-pills-raffles" role="tabpanel" aria-labelledby="v-pills-raffles-tab">     
                                <?php
                                    include_once( RAFFLE_PLAY_WOO_DIR_PATH . '/includes/docs/RafflePlayWoo_Docs_RafflesSetup.php');
                                ?>
                            </div>

                            <!-- Winners tab -->
                            <div class="tab-pane fade show" id="v-pills-winners" role="tabpanel" aria-labelledby="v-pills-winners-tab">     
                                <?php
                                    include_once( RAFFLE_PLAY_WOO_DIR_PATH . '/includes/docs/RafflePlayWoo_Docs_Winners.php');
                                ?>
                            </div>     

                             <!-- Reports tab -->
                            <div class="tab-pane fade show" id="v-pills-reports" role="tabpanel" aria-labelledby="v-pills-reports-tab">     
                                <?php
                                    include_once( RAFFLE_PLAY_WOO_DIR_PATH . '/includes/docs/RafflePlayWoo_Docs_Reports.php');
                                ?>
                            </div>   
                            
                             <!-- PDF Attachment tab -->
                            <div class="tab-pane fade show" id="v-pills-pdf" role="tabpanel" aria-labelledby="v-pills-pdf-tab">     
                                <?php
                                    include_once( RAFFLE_PLAY_WOO_DIR_PATH . '/includes/docs/RafflePlayWoo_Docs_Pdf_Attachment.php');
                                ?>
                            </div> 

                        </div>


                    </div>


                </div>

            </div> <!-- /container-fluid -->
        </div> <!-- /wrap -->
        
      <?php  
    }

?>