<?php

defined('ABSPATH') || exit;

//BE AWARE WHEN EDITING THIS TEMPLATE FOR NOT BREAKING IT

/* HOW TO USE CUSTOM CODE WITHOUT BREAKING WHEN UPDATING THE PLUGIN
   STEP 1: MOVE THIS FILE TO YOUR CHILD THEME/WOOCOMMERCE/INCLUDES/TEMPLATES/ 
   SETP 2: MAKE CHANGES TO THE FILE 
*/

/*
Variables that can be unsed in progres bar

    $raffle_id = it's the id number of the raffl
    $text = text set for the progress bar
    $color = color chosen on the admin page
    $bar_color = bar color chosen in the admin page
    $bg_color  = bg color chosen in the admin page
    $width     = as default is 50
    $sold       = number of raffle tickets sold
    $total      = total number of raffle tickets
    $remaining  = number of remaining raffle tickets 
    $is_limited = is the raffle limited in tickets or unlimited.

*/


//php code to control input
if( empty( $bg_color )) $bg_color = '#4a6741';
if( empty( $color )) $color = 'black';
if( empty( $bar_color )) $bar_color = 'rgba(11, 127, 171, 0.7)';

if( ! empty( $html_class )){
    $html_class = ' ' . $html_class;
}

$percentage = -1;

if( $is_limited ){
    
    if( $sold >= $total ){
        $remaining = 0;
        $width = 100;
        $sold = $total;
        $percentage = 100;
    }else{
        $remaining = $total - $sold;
        $width = (int) $sold / $total * 100;
        $percentage = round( $sold / $total * 10000 );
        $percentage = $percentage / 100;
    }
   
}else{
    $total      = esc_html__('unlimited', 'raffle-play-woo');
    $remaining  = esc_html__('unlimited', 'raffle-play-woo');
    $width = 100;
}


   
$text = str_replace(['[sold]', '%sold%'], $sold, $text );
$text = str_replace(['[total]', '%total%'], $total, $text );
$text = str_replace(['[remaining]', '%remaining%'], $remaining, $text );

if( $percentage > -1 ){
    $text = str_replace( ['[percentage]', '%percentage%'], $percentage . '%', $text );    
}else{
    $text = str_replace([ '[percentage]', '%percentage%'], '', $text );
}

?>

<style>
    .tuskcode-progress {
        border: 1px solid #B0B0B0;
        width: 100%;
        min-width: 150px;
        border-radius: 4px;
        box-shadow: 0 0 3px #B0B0;
        backdrop-filter: blur(2px) brightness(101%);
        display: flex;
        margin-bottom: 10px;
        margin-top: 5px;
        background: <?php echo esc_html( $bg_color );?>;
    }
    
    .tuskcode-bar {
        width: 20em;
        box-shadow: inset 0px 12px 1.7px #FFFFFF33;
        border-radius: 3px;        
        text-align: center;
        min-height: 28px;
        background: <?php echo esc_html( $bar_color ); ?>;
    }

    .tuskcode-progress 
    .tuskcode-bar 
    span{
        white-space: nowrap;
        color:  <?php echo esc_html( $color ); ?>;
        font-weight: 600;
        position: absolute;
        left: 0;
        right: 0;
    }
</style>



<div class='tuskcode-progress<?php echo esc_html( $html_class );?>'>                     
    <div class='tuskcode-bar' style="width:<?php echo $width; ?>%">    
        <span> <?php echo esc_html( $text ) ?></span> 
    </div>
</div>