<?php

defined('ABSPATH') || exit;

//BE AWARE WHEN EDITING THIS TEMPLATE FOR NOT BREAKING IT

/* HOW TO USE CUSTOM CODE WITHOUT BREAKING WHEN UPDATING THE PLUGIN
   STEP 1: MOVE THIS FILE TO YOUR CHILD THEME/WOOCOMMERCE/INCLUDES/TEMPLATES/ 
   SETP 2: MAKE CHANGES TO THE FILE 
*/

$show_customer_name     = $prt['show_customer_name'] == 'yes';
$show_customer_city     = $prt['show_customer_city'] == 'yes';
$show_customer_country  = $prt['show_customer_country'] == 'yes';
$show_purchased_at      = $prt['show_purchased_at'] == 'yes';

?>
<style>

.product-raffle-tab-table
    .div-ticket-wrapper{
        background-repeat: no-repeat;
        background-size: 100%;       
        text-align: center; 
        display: inline-block;     
        margin-left: 6px;
        height: 20px;  
        width:  30px; 
        line-height:20px;  
        transform: rotate( -25deg );  
        margin-top: 2px;
        margin-bottom: 2px;
        text-wrap: nowrap;   
        position: relative;
        top: 4px;     
    }

.product-raffle-tab-table
    .div-tickets-no{
        display: inline-block;
        min-width: 25px;
        max-width: 50px;
    }

.product-raffle-tab-table
    .td-tickets{    
        text-align: center !important;
        width: 150px !important;
    }

.product-raffle-tab-table
    .td-purchased{   
        text-align: center !important; 
        width: 200px !important;
    }
#content-area 
    table td{
        padding: 0.457em 0.387em;
        max-width: 100%;  
    }


</style>

<section class='woocommerce-order-details'>

<table style='width: 100%; margin-bottom:40px; font-weight: 600; border-collapse: collapse;' 
        class='product-raffle-tab-table additional_info raffle-table-tab compact stripe' id="raffle_sold_tickets_table_<?php echo $raffle_id;?>">

    <thead>
        <tr>
            <th style='text-align: center;'><?php echo esc_html( $prt['labels']['tickets'] ); ?></th>
            
            <?php if( $show_customer_name ) : ?> <th style='text-align: left;'><?php echo esc_html( $prt['labels']['customer_name'] ); ?></th> <?php endif; ?>
            <?php if( $show_customer_city ) : ?> <th style='text-align: left;'><?php echo esc_html( $prt['labels']['city'] ); ?></th> <?php endif; ?> 
            <?php if( $show_customer_country ) : ?> <th style='text-align: left;'><?php echo esc_html( $prt['labels']['country'] ); ?></th> <?php endif; ?>
            <?php if( $show_purchased_at ) : ?> <th style='text-align: center;'><?php echo esc_html( $prt['labels']['purchased'] ); ?></th> <?php endif; ?>
        </tr>
    </thead>
    <tbody>
        <?php        

            $table_data     = ""; 
            
            $current_time   = current_time( 'timestamp');
            $wp_date_format = get_option('date_format');
            $wp_time_format = get_option('time_format');

            $ticket_image_str = "";

            if( isset( $ticket_image[ $raffle_id ] ) && $ticket_image[ $raffle_id ]->show == 'yes' ){

                $bg_image = '';
                $ticket_image_obj = $ticket_image[ $raffle_id ];
                $ticket_image_sel = '';
        
                if( $ticket_image_obj->ticket_image == 'custom' )
                    $ticket_image_sel = $ticket_image_obj->ticket_image_url;
                else
                    $ticket_image_sel = RAFFLE_PLAY_WOO_URL . '/images/ticket-image-' . $ticket_image_obj->ticket_image . '.png';            
                
                $ticket_image_sel = esc_url( $ticket_image_sel );

                $ticket_image_str .= "<div class='div-ticket-wrapper'" . 
                    " style=\"background-image: url('{$ticket_image_sel}');\" >             
                </div>";
            }
        
            foreach( $raffle_data as $obj ){

                $table_data .= "<tr>";

                    $country = isset($countries[ $obj->country ] ) ? $countries[ $obj->country ] : $obj->country; //translate code  

                    $str_purchased = '';
                    $purchased_date_int = 0;

                    if( $show_purchased_at ){

                        $time_purchased = strtotime( $obj->purchased_at );
                        $purchased_date_int = $time_purchased;

                        $one_hour_above = $time_purchased + ( 60 * 60 );
                        $one_day_above  = $time_purchased + ( 24 * 60 * 60 );

                        if( $one_hour_above > $current_time ){
                            $time_purchased = (int) ceil( $current_time - $time_purchased );
                            $str_purchased = (int)date( 'i', $time_purchased );                       
                            $str_purchased =  sprintf( $prt['labels']['sold_time_mins'], $str_purchased );
                        }else if( $one_day_above > $current_time ){
                            $time_purchased = (int) ceil( $current_time - $time_purchased );
                            $str_purchased = (int)date( 'H', $time_purchased );
                            $str_purchased =  sprintf( $prt['labels']['sold_time_hours'], $str_purchased );
                        }else{
                            $str_purchased = date( $wp_date_format . ' ' . $wp_time_format, $time_purchased );
                        }
                    }

                    $table_data .= "<td class='td-tickets dt-left' data-order='" . esc_html( $obj->tickets_total ) ."'> <div class='div-tickets-no'>" .  esc_html( $obj->tickets_total ) . "</div> $ticket_image_str </td>";

                    if( $show_customer_name ){
                        $table_data .= "<td class='td-customer_name' >" . esc_html( ucfirst( $obj->first_name ) . " " . strtoupper( $obj->last_name[0] ) ?? '' ) . "</td>";
                    }

                    if( $show_customer_city ){
                        $table_data .= "<td class='td-customer_city'>" . esc_html( $obj->city ) . "</td>";                  
                    }

                    if( $show_customer_country ){
                        $table_data .= "<td class='td-customer_country' >" . esc_html( $country ) . "</td>";
                    }

                    if( $show_purchased_at ){
                        $table_data .= "<td class='td-purchased' data-order='$purchased_date_int'>" . esc_html( $str_purchased ) . "</td>";
                    }

                $table_data .= "</tr>";
            }

            echo $table_data;

        ?>
    </tbody>
</table>

</section>
    <?php

    if( $data_table == 'yes') :
            /* can I change to my own data tables style?
            ** yes, change the below scripts to your data tables format
            ** see https://datatables.net/download/index
            */
    ?>
        <link href="https://cdn.datatables.net/v/dt/dt-2.1.0/datatables.min.css" rel="stylesheet">        
        <script src="https://cdn.datatables.net/v/dt/dt-2.1.0/datatables.min.js"></script>

    <?php endif; ?>

<script>

    <?php if( $data_table == 'yes') :
        //translations
        $_info_lng      = sprintf( esc_html__( 'Showing page %s of %s', 'raffle-play-woo' ), '_PAGE_', '_PAGES_' );
        $_search_lng    = esc_html__( 'Search', 'raffle-play-woo' );
        $_not_found_lng = esc_html__( 'No records found', 'raffle-play-woo' );
        $_menu_lng      = sprintf( esc_html__( '%s entries per page', 'raffle-play-woo' ), '_MENU_' );
   
     ?>   
     ( function(){     
        new DataTable('#raffle_sold_tickets_table_<?php echo $raffle_id;?>', {   
            order: [[-1, 'desc']],       
            autoWidth: false,
            language : {
                info        : "<?php echo $_info_lng; ?>",
                search      : "<?php echo $_search_lng; ?>",
                zeroRecords : "<?php echo $_not_found_lng; ?>",
                lengthMenu  : "<?php echo $_menu_lng; ?>",        
            }
        });
    })();

    <?php endif; ?>
    
</script>