<?php

defined('ABSPATH') || exit;

//BE AWARE WHEN EDITING THIS TEMPLATE
//ANY INVALID HTML WONT BE PARSED BY THE PDF OBJECT, THEREFORE IT WONT DISPLAY
//MISSING CLOSING ATTRIBUTES CAN BREAK THE PAGE,


?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <style type='text/css'>

        table{
            --bs-table-bg: transparent;
            --bs-table-accent-bg: transparent;
            --bs-table-striped-color: #212529;
            --bs-table-striped-bg: rgba(0, 0, 0, 0.05);
            --bs-table-active-color: #212529;
            --bs-table-active-bg: rgba(0, 0, 0, 0.1);
            --bs-table-hover-color: #212529;
            --bs-table-hover-bg: rgba(0, 0, 0, 0.075);
            width: 100%;
            margin-bottom: 1rem;
            color: #212529;
            vertical-align: top;
            border-color: #dee2e6;

        /*    width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border:1px solid black; */
        }

        .header{
            margin-top: 5px;
        }  

        body{
            font-family: "Times	New	Roman",	Times,	serif;	
        }

        .header-logo, .header-business-info{
            width: 49.9%;           
        }
        .header-logo{
            float: left;
        }

        .header-business-info{
            float: right;
            text-align: right;   
        }
      
        .header-business-info p{
           padding: 4px 0;
           margin: 0px;
        }

        .header-business-info h3{
            margin: 0;
            padding: 0;
            font-size: 15px;
        }

        .clear{
            clear: both;
            height: 2px;        
        }

        .td {          
            border: 1px solid #dee2e6;
            vertical-align: middle;          
        }

        .spacer-10{
            height: 10px;
        }

        .spacer-5{
            height: 5px;
        }

        .vertical-line{
            border-bottom: 1px solid #dee2e6;            
        }
        table tr{
            background-color: #ffffff;
            box-shadow: 0px 0px 9px 0px rgba(0,0,0,0.1);
            margin-top: 3px;
        }

        footer{  
            position: fixed; 
            bottom: -60px; 
            left: 0px; 
            right: 0px;  
            text-align: center;            
            border-top: 1px solid gray;
            line-height: 3px;
        }

        .billing-info-header{
            border-bottom: 1px solid #dee2e6; 
            width: 100%;
        }

        <?php
           if( $pdf_extra_css != 'empty') echo str_replace('br_nl', '', $pdf_extra_css );
        ?>


    </style>
</head>
<body>
    <!-- header -->
    <header>
        <?php 
            //unique hook before the header info, takes one argument - order object
            do_action('raffle_play_woo_pdf_before_header_two', $order );
            
        ?>
        <div class='header'>
            <!-- header image control -->   
            <div class='header-logo'>
                <?php if( $header_img !== '' ): ?>

                    <div class='header-img'>
                        <img src="<?php echo esc_url_raw( $header_img ); ?>" style='max-width: 330px;'  alt="header image"  />
                    </div>

                <?php endif; ?>
            </div> 

            <div class='header-business-info header-business-info-two' >

                <?php  if( $pdf_business_info !== '' && $pdf_business_info !== 'empty' ) : ?>
                                    
                    <div class='header-business-text header-business-text-two'>
                        <?php 
                            $pdf_business_info = str_replace('br_nl', '', $pdf_business_info );
                            echo html_entity_decode( $pdf_business_info );
                        ?>
                    </div>
                        
                <?php endif; ?>
            </div>

        </div>

    </header>
 

    <div class='clear'> </div>
       <!-- block to clear floating, nothing to add here --> 
    <!-- end of header control -->
    <?php 
        //unique hook before the header info, takes one argument - order object
        do_action('raffle_play_woo_pdf_after_header_two', $order );  
    ?>

    <!-- footer -->
    <?php if( trim( $pdf_footer_info ) != '' && $pdf_footer_info !== 'empty' ) : ?>
    <footer style="height: <?php echo(  esc_html( $pdf_footer_height ) . 'px' );?>;" >
      <!--  <div class="footer-info"> -->
            <?php 
                
                $footer_info = str_replace( 'br_nl', '<br/>', $pdf_footer_info);
                $year = date( 'Y' );
                $footer_info = str_replace( '%year%', $year, $footer_info );
                echo wp_specialchars_decode( $footer_info );
            
            
            ?>
   <!--     </div>  -->
 
    </footer>

    <?php endif; ?>

 

    <!-- end of footer -->
   
    <!-- main -->

    <div class="main main-two">
      
        <!-- billing address control -->
        <?php if( $pdf_inc_add ): ?>
            
                <div class='billing-info billing-info-two'>
                    <h3 class='billing-info-header'> Billing Info </h3>
                    <div class='billing-info-data billing-info-data-two'>
                        <?php
                            if( $first_name !== '' ){
                                esc_html_e( $first_name );
                            }
                            
                            if( $last_name !== '' ){
                                esc_html_e( $last_name );
                                echo '<br />';
                            }


                            if( $address_one !== '' ){
                                esc_html_e( $address_one ) . ', ' . esc_html_e( $address_two ); 
                                echo '<br />';
                            }                        

                            if( $city !== '' ){
                                esc_html_e( $city ); 
                                echo '<br />';
                            }

                            if( $state !== '' ){
                                esc_html_e( $state ); 
                                echo '<br />';
                            }

                            if( $phone !== '' ){
                                esc_html_e( $phone ); 
                                echo '<br />';
                            }

                            if( $email !== '' ){
                                esc_html_e( $email ); 
                                echo '<br />';
                            }
                            
                        ?>  
                    </div>
                </div>

            </div>
            
            <div class="spacer-10"> </div>
        <?php 
            //unique hook before the header info, takes one argument - order object
            do_action('raffle_play_woo_pdf_after_billing_info_two', $order );
            
        ?>

        <?php endif; ?>
        <!-- end billing address control -->
    
        <!-- product display control -->
        <?php if( $pdf_inc_prod ) :
                    $text_align = is_rtl() ? 'right' : 'left';   
                    $text_align = 'left';     
            ?>

            <div class="div-table-product-two" style="margin-bottom: 40px;">

                <table class="td table-data-two" cellspacing="0" cellpadding="6" style="" >
                    <thead>
                        <tr>
                            <th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Product', 'woocommerce' ); ?></th>
                            <th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Quantity', 'woocommerce' ); ?></th>
                            <th class="td" scope="col" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Price', 'woocommerce' ); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                    
                        $sent_to_admin = false;
                        $plain_text = false;

                        echo wc_get_email_order_items( 
                            $order,
                            array(
                                'show_sku'      => $sent_to_admin,
                                'show_image'    => false,
                                'image_size'    => array( 32, 32 ),
                                'plain_text'    => $plain_text,
                                'sent_to_admin' => $sent_to_admin,
                            )
                        );
                    
                        ?>
                    </tbody>
                    <tfoot>
                        <?php
                    
                        $item_totals = $order->get_order_item_totals();

                        if ( $item_totals ) {
                            $i = 0;
                            foreach ( $item_totals as $total ) {
                                $i++;
                                ?>
                                <tr>
                                    <th class="td" scope="row" colspan="2" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?php echo wp_kses_post( $total['label'] ); ?></th>
                                    <td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; <?php echo ( 1 === $i ) ? 'border-top-width: 4px;' : ''; ?>"><?php echo wp_kses_post( $total['value'] ); ?></td>
                                </tr>
                                <?php
                            }
                        }
                        if ( $order->get_customer_note() ) {
                            ?>
                            <tr>
                                <th class="td" scope="row" colspan="2" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php esc_html_e( 'Note:', 'woocommerce' ); ?></th>
                                <td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>;"><?php echo wp_kses_post( nl2br( wptexturize( $order->get_customer_note() ) ) ); ?></td>
                            </tr>
                            <?php
                        }
                    
                        ?>
                    </tfoot>
                </table>
            </div>

        <?php endif; ?>
        <!-- end product display control -->
        
        <?php 
            //unique hook before the header info, takes one argument - order object
            do_action('raffle_play_woo_pdf_after_after_product_display_two', $order );
            
        ?>

        <!-- raffle table info, if no raffle present nothing is displayed -->
        <?php
            // RAFFLE INFO IS EXTRACTED FROM TEMPLATE PDF_RAFFLE_INFO.PHP
            // ANY CHANGES PLEASE EDIT PDF_RAFFLE_INFO.PHP, DO NOT MISTAKE IT WITH THE EMAIL RAFFLE INFO
            echo  $raffle_table_info_from_template;
        ?>

        <!-- end raffle table info-->

        <?php 
            //unique hook before the header info, takes one argument - order object
            do_action('raffle_play_woo_pdf_after_after_raffle_info_two', $order );
            
        ?>

    </div>

</body>
</html>