<?php

defined('ABSPATH') || exit;

//BE AWARE WHEN EDITING THIS TEMPLATE FOR NOT BREAKING IT

$text_align = is_rtl() ? 'right' : 'left';  

if( ($email_header !== '') && ( $type != 'admin') )
        echo "<h3 class='raffle-info-header'>".esc_html( $email_header )."</h3>";

?>
<style type='text/css'>
    .td-raffle, .th-raffle, .td-extra {          
        border: 1px solid #dee2e6;
        vertical-align: middle;  
        text-align: <?php echo esc_attr( $text_align ); ?>;
        padding: 8px;            
    }
    .th-raffle{
        font-weight: 600; 
    }
    .raffle-info-table{
        width: 100%;
        border: 1px solid #dee2e6;
        border-spacing: 2px;
        border-collapse: collapse;
    }

    .td-extra{
        text-align: center;
    }
    .raffle-info-header{
        border-bottom: 1px solid #dee2e6; 
        width: 100%;
    }

    
</style>

<table class='raffle-info-table'>
    <tbody>
        <?php

        $ticket_info = ""; 

        foreach( $info_data as $raffle=>$tickets_row ){
            
            $tickets_str        = '';
            $extra_row_email    = '';
            $raffle_tickets     = array();
            $ticket_prefix      = $tickets_row['prefix'];
            $leading_zeros      = $tickets_row['leading_zeros'];  
            $lucky_won          = "";   
            $raffle_id          = $tickets_row['id'];                  

            if( is_array( $tickets_row['tickets_no'] ) ){
                foreach( $tickets_row['tickets_no'] as $ticket_no ){

                    try {
                                                 
                        $ticket_no = (int) $ticket_no; 
                                                                        
                        $ticket_no = str_pad( $ticket_no, $leading_zeros, '0', STR_PAD_LEFT);

                        $ticket_no = $ticket_prefix . $ticket_no;

                    } catch (\Throwable $th) {
                        RafflePlayWoo_error_log( $th.getMessage() );                            
                    }

                    $raffle_tickets[] = $ticket_no;
                }
            }

            //check lucky numbers 
            if( isset( $lucky_data->$raffle_id) ){


                foreach( $lucky_data->$raffle_id->lucky as $lucky_obj ){

                    if( $lucky_obj->order_id_won == $order_id && $lucky_obj->is_won ){

                        try {

                            $lucky_name     = esc_html( $lucky_obj->name );
                            $lucky_ticket_image_sel = '';
                            $lucky_number   = esc_html( $lucky_obj->number );

                            $lucky_number = str_pad( $lucky_number, $leading_zeros, '0', STR_PAD_LEFT);

                            $lucky_number = $ticket_prefix . $lucky_number;
                    
                            $product_link = '';
                            if( $lucky_obj->product_id != 0 ){
                                $product_link = get_permalink( $lucky_obj->product_id );
                            }

                            if( $product_link  ){
                                $product_link = esc_url( $product_link );
                                $lucky_name = "<p class='raffle-lucky-name' > <a href='$product_link'>" . $lucky_name . " </a> </p>";
                            }else{
                                $lucky_name = "<p> " . $lucky_name . "</p>";
                            } 
                            

                            $message = '';
                            if( $lucky_obj->message != '' ){

                                $message = $lucky_obj->message;

                                if( $product_link != '' ){
                                    $product = wc_get_product( $lucky_obj->product_id );
                                    if( $product != null ){
                                        $product_name = $product->get_name();
                                        $message = str_replace('%product_link%', "<a href='$product_link'> $product_name </a>", $message);
                                    }
                                }else{
                                    $message = str_replace('%product_link%', '', $message );
                                }

                                $message = "<p> " . $message . " </p>";
                            }

                            $lucky_won .= "
                                    <div class='div-wrapper'>
                                        $lucky_name 

                                        <div class='ticket-image-container'>                                            
                                            {$lucky_number}                                            
                                        </div>

                                        $message
                                    </div>";  
                                
                                                         
                        } catch (\Throwable $th) {
                            RafflePlayWoo_error_log( 'pdf winner ticket ' . $th->getMessage() );
                        }
                        
                    }
                }
            }
            //end of lucky numbers check


            $tickets_str = implode( ', ', $raffle_tickets );


            $extra_row_email = stripslashes( esc_html( $tickets_row['email_extra'] ) ); 

        
            $ticket_info .= "<tr>";
                    
               
            if( $inc_raffle_name ) { 
                $ticket_info .= "<th class='th-raffle'>" .
                                esc_html( $raffle ). "</th>";
            }            
                    

            if( $email_body != '' ){
                $ticket_info .= "<th class='th-raffle'>"
                            . esc_html( $email_body) . "</th>";
            }    
            $ticket_info .= "<td class='td-raffle' > "
                            . $tickets_str . "</td>";                                

            $ticket_info .= "</tr>";
            
            
            if( $lucky_won != '' ){
                $ticket_info .= "<tr class='tr-tickets'>
                                    <td colspan='$col_span' style='border:1px solid #e5e5e5;vertical-align:middle;padding:12px;text-align:center;' >                                        
                                        $lucky_won                                         
                                    </td> 
                                </tr>";
            }  
            
            if( $extra_row_email !== '' ){
                $ticket_info .= " <tr> ".                            
                                    "<td class='td-extra' colspan='$col_span'>" 
                                    . esc_html( $extra_row_email ) . "</td>"
                                . "</tr>";
                    
            }
                                
        }
        
        echo $ticket_info;
                                
        ?>
    </tbody>
</table>