<?php

defined('ABSPATH') || exit;

//BE AWARE WHEN EDITING THIS TEMPLATE FOR NOT BREAKING IT

/* HOW TO USE CUSTOM CODE WITHOUT BREAKING WHEN UPDATING THE PLUGIN
   STEP 1: MOVE THIS FILE TO YOUR CHILD THEME/WOOCOMMERCE/INCLUDES/TEMPLATES/ 
   SETP 2: MAKE CHANGES TO THE FILE 
*/

?>


<style>
    .raffle-table
    .div-ticket-wrapper{
        background-repeat: no-repeat;
        background-size: 100%;       
        text-align: center; 
        display: inline-block;     
        margin-left: 6px;
        height: <?php echo esc_html($ticket_image['ticket']->ticket_height);?>px;  
        width:  <?php echo esc_html($ticket_image['ticket']->ticket_width);?>px; 
        line-height: <?php echo esc_html($ticket_image['ticket']->line_height);?>px;  
        transform: rotate( 0deg );  
        margin-top: 2px;
        margin-bottom: 2px;
        text-wrap: nowrap;        
    }

    .raffle-table
    .div-wrapper{
        display: inline-block;
    }

    .raffle-table
    .ticket-image-container{
        font-weight: 600;
    }
    .raffle-table
    .tr-tickets 
    td{
        font-size: <?php echo esc_html($ticket_image['ticket']->text_size);?>px;  
        color:  <?php echo esc_html($ticket_image['ticket']->text_color);?>;          
    }

    .wp-block-woocommerce-checkout
    .div-tr-tickets,
    .woocommerce-checkout
    .div-tr-tickets{
        min-height: 80px;
        overflow-y: auto;
    }


    .div-cross-won{
        position: relative;
        width:  <?php echo esc_html($ticket_image['ticket']->ticket_width);?>px; 
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .div-cross-won::before,
    .div-cross-won::after {
        position: absolute;
        content: '';
        width: 75%;
        height: 1px; /* cross thickness */
        background-color: red;
        left: 0;
        right: 0;
        margin: auto;    
    }

    .div-cross-won::before {
        transform: rotate(45deg);
    }

    .div-cross-won::after {
        transform: rotate(-45deg);
    }
</style>

    <?php          
        $tickets_str        = "";
        $not_won_tickets    = "";
        $won_tickets        = "";          

        $ticket_prefix = $raffle_data->get_prefix();
        $leading_zeros = $raffle_data->get_leadingZeros();
        $raffle_name   = $raffle_data->get_name();
    

        if( isset( $data->$raffle_id ) && count( $data->$raffle_id->lucky ) > 0 ){

            foreach(  $data->$raffle_id->lucky as $lucky_data  ){         

                if( ! $lucky_data->active ){ continue; }

                $ticket_no = esc_html( $lucky_data->number ); 

                $is_won = $lucky_data->is_won;
                                                                        
                $ticket_no = str_pad( $ticket_no, $leading_zeros, '0', STR_PAD_LEFT);

                $ticket_no = esc_html( $ticket_prefix . $ticket_no );

                if( $lucky_data->type == 'random' && $lucky_data->number == 0 ){
                    if( $leading_zeros == 0 ) $leading_zeros = 1;
                    $ticket_no = str_pad( '', $leading_zeros, '?', STR_PAD_LEFT);
                }

                $lucky_name = esc_html( $lucky_data->name );

                $order_id_won = esc_html( $lucky_data->order_id_won );

                $winner_first_name = '';
                $winner_last_name  = '';

              
                $img_url = esc_url( $lucky_data->custom_img );
                if( $lucky_data->custom_img == '' ){
                    $img_url = esc_url( RAFFLE_PLAY_WOO_URL . '/images/ticket-image-' . esc_html($lucky_data->bg_img) . '.png' );
                }else if( $lucky_data->bg_img == '' ){
                    $img_url = '';
                }

                $style_img = "style=\"background-image: url('{$img_url}');\"";

                if( $img_url == '' ){ $style_img = '';}

                $product_link = '';
                if( $lucky_data->product_id != 0 ){
                    $product_link = get_permalink( $lucky_data->product_id );
                }


                if( $product_link  ){
                    $product_link = esc_url( $product_link );
                    $lucky_name = "<p class='raffle-lucky-name' > <a href='$product_link'>" . $lucky_name . " </a> </p>";
                }else{
                    $lucky_name = "<p> " . $lucky_name . "</p>";
                }

                $winner_name = '';

                if( $is_won && $order_id_won > 0 ){

                    $order = wc_get_order( $order_id_won );

                    if( $order != null ){

                        try {

                            $winner_first_name = trim( $order->get_billing_first_name() );
                            $winner_last_name  = trim( $order->get_billing_last_name() );                            
    
                            if( strlen( $winner_last_name ) > 0){                              
                                $winner_last_name = strtoupper( substr( $winner_last_name, 0, 1) );                              
                            }
        
                            if( $winner_first_name != '' && $winner_last_name !=  '' ){
                                $winner_name = "<p class='lucky-winner-name'>" . esc_html( $winner_first_name ) . ' ' . esc_html( $winner_last_name ) . '</p>';                     
                            }

                        } catch (\Throwable $th) {
                            RafflePlayWoo_error_log( 'template - get order info - ' . $th->getMessage() );
                        }

                    }
                }

                $won_class = "div-cross-won";

                if( ! $is_won ){ $won_class = '';}

                $ticket_image_str = "
                    <div class='div-wrapper'>

                        $lucky_name 

                        <div class='div-ticket-wrapper' 
                        {$style_img} > 

                            <div class='ticket-image-container $won_class'> 
                                {$ticket_no} 
                            </div>


                         </div>

                        $winner_name
                    </div>";

                if( $lucky_data->is_won ){
                    $won_tickets .=  $ticket_image_str;
                }else{
                    $not_won_tickets .= $ticket_image_str;
                }

                
                                                       
            }
        }

    ?>

<section class='woocommerce-order-details'>
    <table style='width: 100%; margin-bottom:40px; font-weight: 600; border-collapse: collapse;'
        class='shop_table additional_info raffle-table'>
    <tbody>
        <?php

        if( $won_tickets !=  '' || $not_won_tickets !=  '' ){
            $tickets_str .= "<tr><td style='font-weight: 600; border:1px 
                solid #e5e5e5;vertical-align:middle;padding:12px;text-align:center;'>" .
                esc_html( $raffle_name ). "</td></tr>";
        }

        if( $not_won_tickets != '' ){

            $tickets_str .=  "<tr class='tr-tickets'>
                                <td style='border:1px solid #e5e5e5;vertical-align:middle;padding:12px;text-align:center;' > 
                                    <div class='div-tr-tickets'> "
                                        . $not_won_tickets .                                  
                                    "</div>
                                </td> 
                            </tr>"; 

        }

        if( $won_tickets != '' ){
        
            $tickets_str .=  "<tr class='tr-tickets'>
                                <td style='border:1px solid #e5e5e5;vertical-align:middle;padding:12px;text-align:center;' > 
                                    <div class='div-tr-tickets'> "
                                        . $won_tickets .                                  
                                    "</div>
                                </td> 
                            </tr>";
        }

        echo $tickets_str;
              
                                
        ?>
    </tbody>
</table>

</section>