<?php

defined('ABSPATH') || exit;

//BE AWARE WHEN EDITING THIS TEMPLATE FOR NOT BREAKING IT

/* HOW TO USE CUSTOM CODE WITHOUT BREAKING WHEN UPDATING THE PLUGIN
   STEP 1: MOVE THIS FILE TO YOUR CHILD THEME/WOOCOMMERCE/INCLUDES/TEMPLATES/ 
   SETP 2: MAKE CHANGES TO THE FILE 
*/

?>
    <section class='woocommerce-order-details'>
<?php


if( ($email_header !== '') && ( $type != 'admin') )
        echo "<h3 class='woocommerce-order-details__title'>".esc_html( $email_header )."</h3>";
?>

<style>
    .raffle-table
    .div-ticket-wrapper,
    #section_user_pick_tickets   
    .div-ticket-wrapper{
        background-repeat: no-repeat;
        background-size: 100%;       
        text-align: center; 
        display: inline-block;     
        margin-left: 6px;
        height: <?php echo esc_html($ticket_image['ticket']->ticket_height);?>px;  
        width:  <?php echo esc_html($ticket_image['ticket']->ticket_width);?>px; 
        line-height: <?php echo esc_html($ticket_image['ticket']->line_height);?>px;  
        transform: rotate( 0deg );  
        margin-top: 2px;
        margin-bottom: 2px;
        text-wrap: nowrap;        
    }

    .raffle-table
    .ticket-image-container{
        font-weight: 600;
    }
    .raffle-table
    .tr-tickets 
    td,
    #section_user_pick_tickets
    .div-ticket-wrapper{
        font-size: <?php echo esc_html($ticket_image['ticket']->text_size);?>px;  
        color:  <?php echo esc_html($ticket_image['ticket']->text_color);?>;          
    }

    .wp-block-woocommerce-checkout
    .div-tr-tickets,
    .woocommerce-checkout
    .div-tr-tickets{
        min-height: 55px;
        overflow-y: auto;
    }

    .raffle-form-control{
        display: block;
        width: 100%;
        padding: .375rem .75rem;
        font-size: 1rem;
        line-height: 1.5;
        color: #495057;
        background-color: #fff;
        background-clip: padding-box;
        border: 1px solid #ced4da;
        border-radius: .25rem;
        transition: border-color .15s ease-in-out,box-shadow .15s ease-in-out;
    }
    
    #section_user_pick_tickets{      
        min-height: 270px; 
        background-color: #fff;
        z-index: 100001;
        padding: 10px;
        border-radius: 4px;
        box-shadow: rgba(50, 50, 93, 0.25) 0px 30px 60px -12px inset, rgba(0, 0, 0, 0.3) 0px 18px 36px -18px inset;
    }
    .body-user-pick{
        border-top: 1px solid rgba(50, 50, 93, 0.25);
        border-bottom: 1px solid rgba(50, 50, 93, 0.25);
        min-height: 270px;
        clear: both;
        margin-top: 5px;
    }

    .header-user-search{
        padding: 15px;
    }

    .div_header-user-search-btn{
        display: inline-block;
    }

    .header-user-search-btn{     
        border-radius: 5px;   
        margin-right: 5px; 
        height: 42px !important;  
    }
    .header-user-change-btn{ 
        width: 100%;
        border-radius: 5px;
    }
    
    .lds-dual-ring,
    .lds-dual-ring:after {
        box-sizing: border-box;
    }
    .lds-dual-ring {
        display: inline-block;
        width: 60px;
        height: 60px;
    }
    .lds-dual-ring:after {
        content: " ";
        display: block;
        width: 44px;
        height: 44px;
        margin: 8px;
        border-radius: 50%;
        border: 6.4px solid currentColor;
        border-color: currentColor transparent currentColor transparent;
        animation: lds-dual-ring 1.2s linear infinite;
    }

    .footer-user-pick_prev_btn,
    .footer-user-pick_next_btn,
    .footer-user-pick_cancel_btn{
        width: 45%;
        border-radius: 5px;
    }

    .footer-user-pick{
        text-align: center;
    }

    .footer-user-pick_div_cancel_btn{
        margin-top: 10px;
        text-align: center;
    }

    @keyframes lds-dual-ring {
    0% {
        transform: rotate(0deg);
    }
    100% {
        transform: rotate(360deg);
    }
    }

    #user_pick_search_tickets{
        width: 170px;
        display: inline-block;
        min-height: 42px;
        border-radius: 5px;
    }

    .header-user-close
    .header-user-close-svg{
        cursor: pointer;
        float: right;
        margin: 5px;
        position: relative;
        left: 37px;
        top: -36px;
        opacity: 1;
        background: aliceblue;
        border-radius: 50%;
    }
    /*
    .header-user-close{
        position: relative;
        right:21px;
    }
        */

    #div_search_tickets{
        display: inline-block;
        float: right;
    }

    .header-user-change-table,
    .header-user-change-table tr,
    .header-user-change-table tr td{
        border: 0 !important;
    }

    #search_tickets_eraser{
        position: absolute;
        margin-top: 15px;
        margin-left: 10px;
    }


</style>

<div id='section_user_pick_tickets' style='display: none; margin: 0 8px 5px 8px;'>

    <input type="hidden" name="user_pick_ticket_raffle_id" id='user_pick_ticket_raffle_id' value='' />
    <input type="hidden" name="user_pick_ticket_old_ticket" id='user_pick_ticket_old_ticket' value='' />
    <input type="hidden" name="user_pick_ticket_img_url" id='user_pick_ticket_img_url' value='' />
    <input type="hidden" name="user_pick_ticket_prefix" id='user_pick_ticket_prefix' value='' />
    <input type="hidden" name="user_pick_ticket_leading" id='user_pick_ticket_zeros' value='' />
    <input type="hidden" name="user_pick_counter_index" id='user_pick_counter_index' value='0' />

    <div class='header-user-pick'>  

        <div class="header-user-close"  onclick="raffle_user_pick_close()">
            <svg xmlns="http://www.w3.org/2000/svg" class='header-user-close-svg'  width="24" height="24" fill="red" class="bi bi-x-circle" viewBox="0 0 16 16">
                <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
                <path d="M4.646 4.646a.5.5 0 0 1 .708 0L8 7.293l2.646-2.647a.5.5 0 0 1 .708.708L8.707 8l2.647 2.646a.5.5 0 0 1-.708.708L8 8.707l-2.646 2.647a.5.5 0 0 1-.708-.708L7.293 8 4.646 5.354a.5.5 0 0 1 0-.708"/>
            </svg>
        </div>

        <div class="header-user-message"></div>

        <div class="header-user-search">
          
            <div>

                <div class='div_header-user-search-btn'>
                    <button class='header-user-search-btn wc-block-components-button wp-element-button wc-block-components-checkout-place-order-button contained'
                        onclick='raffle_search_btn_click( event, this );'> 
                        <?php 
                            echo esc_html( $user_pick_lbls['search_btn']);
                        ?>
                    </button>  
                </div>   
                
                <div id='div_search_tickets'>
                    <input type="number" 
                        name="search_tickets" id="user_pick_search_tickets" onkeydown="user_pick_search_tickets_key_down(event);"
                        placeholder="<?php echo esc_html( $user_pick_lbls['placeholder_search_input']); ?>" class='raffle-form-control'/>
                
                    <svg id='search_tickets_eraser' onclick='search_ticket_clear();' style='cursor: pointer' xmlns="http://www.w3.org/2000/svg" 
                        width="16" height="16" fill="currentColor" class="bi bi-eraser-fill" viewBox="0 0 16 16">
                        <path d="M8.086 2.207a2 2 0 0 1 2.828 0l3.879 3.879a2 2 0 0 1 0 2.828l-5.5 5.5A2 2 0 0 1 7.879 15H5.12a2 2 0 0 1-1.414-.586l-2.5-2.5a2 2 0 0 1 0-2.828zm.66 11.34L3.453 8.254 1.914 9.793a1 1 0 0 0 0 1.414l2.5 2.5a1 1 0 0 0 .707.293H7.88a1 1 0 0 0 .707-.293z"/>
                    </svg>
                </div>
            </div>
                
        </div>

        <div class="header-user-change" style='display: none;'>
            <table class='header-user-change-table'>
                <tr>
                    <td class="header-user-change-from" ></td>
                    <td style='text-align: center' class='header-user-change-text'> <span>
                        <?php 
                            echo esc_html( $user_pick_lbls['change_to']);
                        ?>
                    </span></td>
                    <td class="header-user-change-to" ></td>
                </tr>
                <tr>                     
                    <td colspan='3'>
                        <button 
                            id='header_user_change_btn' data-message='' onclick='header_user_change_btn_click( event, this );'
                            class='header-user-change-btn wc-block-components-button wp-element-button wc-block-components-checkout-place-order-button contained'>
                                <?php 
                                    echo esc_html( $user_pick_lbls['change_btn']);
                                ?>  
                        </button>
                    </td>                                     
                </tr>

                <tr class='header-user-messages-tr' style='display:none'>
                    <td colspan='3'>
                        <p class='header-user-messages' style='text-align: center; font-weight: 700;'> Message </p>
                    </td>
                </tr>
                
            </table>
            
        </div>

        <div>
            
        </div>
    </div>

    <div class='body-user-pick' style='margin-top: 20px; margin-bottom: 15px; max-height: 300px; overflow-y: auto;'>
        
    </div>

    <div class="data-container"></div>

    <div class="footer-user-pick">
        <button 
            onclick='footer_user_pick_prev_btn_click( event, this );'
            class='footer-user-pick_prev_btn wc-block-components-button wp-element-button wc-block-components-checkout-place-order-button contained'
        >
            <?php 
                echo esc_html( sprintf( $user_pick_lbls['prev_btn'], $user_pick_lbls['max_show_no']) );
            ?>
        </button>

        <button 
            onclick='footer_user_pick_next_btn_click( event, this);'
            style='float: right'
            class='footer-user-pick_next_btn wc-block-components-button wp-element-button wc-block-components-checkout-place-order-button contained'
        >
            <?php                
                echo esc_html( sprintf( $user_pick_lbls['next_btn'], $user_pick_lbls['max_show_no']) );
            ?>
        </button>

        <div class='footer-user-pick_div_cancel_btn'>
            <button onclick='footer_user_pick_cancel_btn_action( event );'
                class='footer-user-pick_cancel_btn wc-block-components-button wp-element-button wc-block-components-checkout-place-order-button contained'
            >
                <?php 
                    echo esc_html( $user_pick_lbls['cancel_btn']);
                ?>
            </button>
        </div>
    </div>
</div>

<table style='width: 100%; margin-bottom:40px; font-weight: 600; border-collapse: collapse;' class='shop_table additional_info raffle-table'>
    <tbody>
        <?php        

        $ticket_info    = "";   
        $global_user_can_pick = false;       

        foreach( $info_data as $raffle=>$raffle_info ){
            
            $tickets_str        = '';
            $extra_row_email    = '';
            $ticket_image_str   = '';
            $lucky_won          = "";

            $raffle_id          = $raffle_info['id'];

            $ticket_prefix = isset( $raffle_info['prefix'] ) ? $raffle_info['prefix'] : '';
            $leading_zeros = $raffle_info['leading_zeros'];  

            $raffle_tickets = array();
            $user_can_pick = '';
            $user_can_pick = isset( $user_pick[ $raffle_id ] ) && $user_pick[ $raffle_id ] == 'yes';

            if( $user_can_pick && $is_checkout ) $global_user_can_pick = true;

            $edit_pen_svg = '';
            $edit_css_hand = '';
            $edit_on_click = '';

            if( $is_checkout && $user_can_pick ){
                $edit_pen_svg = '<svg style="position: absolute; right: 0;" xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil" viewBox="0 0 16 16">
                                    <path d="M12.146.146a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1 0 .708l-10 10a.5.5 0 0 1-.168.11l-5 2a.5.5 0 0 1-.65-.65l2-5a.5.5 0 0 1 .11-.168zM11.207 2.5 13.5 4.793 14.793 3.5 12.5 1.207zm1.586 3L10.5 3.207 4 9.707V10h.5a.5.5 0 0 1 .5.5v.5h.5a.5.5 0 0 1 .5.5v.5h.293zm-9.761 5.175-.106.106-1.528 3.821 3.821-1.528.106-.106A.5.5 0 0 1 5 12.5V12h-.5a.5.5 0 0 1-.5-.5V11h-.5a.5.5 0 0 1-.468-.325"/>
                                </svg>';
                $edit_css_hand = "cursor: pointer;";                

            }

            if( is_array( $raffle_info['tickets_no'] ) ){

                foreach( $raffle_info['tickets_no'] as $ticket_no ){

                    try {
                                                 
                        $ticket_no = (int) $ticket_no; 
                        $orig_ticket_no = $ticket_no;
                                                                        
                        $ticket_no = str_pad( $ticket_no, $leading_zeros, '0', STR_PAD_LEFT);

                        $ticket_no = esc_html( $ticket_prefix . $ticket_no );

                    } catch (\Throwable $th) {
                        RafflePlayWoo_error_log( 'tickets_no ' . $th.getMessage() );                            
                    }

                    $raffle_tickets[] = $ticket_no;

                    if( $user_can_pick && $is_checkout ){
                        $edit_on_click = " onclick='raffle_change_ticket($raffle_id, $orig_ticket_no, this)' ";
                    }

                    if( isset( $ticket_image[ $raffle_id ] ) && $ticket_image[ $raffle_id ]->show == 'yes' ){

                        $bg_image = '';
                        $ticket_image_obj = $ticket_image[ $raffle_id ];
                        $ticket_image_sel = '';
                
                        if( $ticket_image_obj->ticket_image == 'custom' )
                            $ticket_image_sel = $ticket_image_obj->ticket_image_url;
                        else
                            $ticket_image_sel = RAFFLE_PLAY_WOO_URL . '/images/ticket-image-' . $ticket_image_obj->ticket_image . '.png';            
                        
                        $ticket_image_sel = esc_url( $ticket_image_sel );
                        $ticket_id = 'raffle_ticket_' . $raffle_id . '_' . $orig_ticket_no;
        
                        $ticket_image_str .= "<div id='$ticket_id'
                                                    data-imgurl='{$ticket_image_sel}'  
                                                    data-prefix='{$ticket_prefix}' 
                                                    data-zeros='{$leading_zeros}' 
                                                    data-ticket_no='{$orig_ticket_no}'
                                                    class='div-ticket-wrapper'  
                                                    $edit_on_click " . 
                                            " style=\"background-image: url('{$ticket_image_sel}'); $edit_css_hand \" >   {$edit_pen_svg}" .
                                            "<div class='ticket-image-container' >                              
                                                {$ticket_no} 
                                            </div>" .
                                        "</div>";
                    }
                    
                }
            }

            //check lucky numbers 
            if( isset( $lucky_data->$raffle_id) ){
                foreach( $lucky_data->$raffle_id->lucky as $lucky_obj ){
                    if( $lucky_obj->order_id_won == $order_id && $lucky_obj->is_won ){

                        try {

                            $lucky_name     = esc_html( $lucky_obj->name );
                            $lucky_ticket_image_sel = '';
                            $lucky_number   = esc_html( $lucky_obj->number );

                            $lucky_number = str_pad( $lucky_number, $leading_zeros, '0', STR_PAD_LEFT);

                            $lucky_number = esc_html( $ticket_prefix . $lucky_number );
                    
                            if( $lucky_obj->bg_img == 'custom' ){
                                $lucky_ticket_image_sel = $lucky_obj->custom_img;
                            }else if( $lucky_obj->bg_img != 'none'){
                                $lucky_ticket_image_sel = RAFFLE_PLAY_WOO_URL . '/images/ticket-image-' . $lucky_obj->bg_img . '.png';            
                            }
                            
                            $lucky_ticket_image_sel = esc_url( $lucky_ticket_image_sel );

                            $style_img = "";
                            if( $lucky_obj->bg_img != 'none' ){
                                $style_img = " style=\"background-image: url('{$lucky_ticket_image_sel}');\" ";
                            }

                            $product_link = '';
                            if( $lucky_obj->product_id != 0 ){
                                $product_link = get_permalink( $lucky_obj->product_id );
                            }

                            if( $product_link  ){
                                $product_link = esc_url( $product_link );
                                $lucky_name = "<p class='raffle-lucky-name' > <a href='$product_link'>" . $lucky_name . " </a> </p>";
                            }else{
                                $lucky_name = "<p> " . $lucky_name . "</p>";
                            } 
                            

                            $message = '';
                            if( $lucky_obj->message != '' ){

                                $message = $lucky_obj->message;

                                if( $product_link != '' ){
                                    $product = wc_get_product( $lucky_obj->product_id );
                                    if( $product != null ){
                                        $product_name = $product->get_name();
                                        $message = str_replace('%product_link%', "<a href='$product_link'> $product_name </a>", $message);
                                    }
                                }else{
                                    $message = str_replace('%product_link%', '', $message );
                                }

                                $message = "<p> " . $message . " </p>";
                            }
                                            
                            $lucky_won .= "
                                    <div class='div-wrapper'>

                                        $lucky_name 

                                        <div class='div-ticket-wrapper' 
                                        {$style_img} > 

                                            <div class='ticket-image-container'> 
                                                {$lucky_number} 
                                            </div>

                                        </div>

                                        $message
                                    </div>";

                                                           
                        } catch (\Throwable $th) {
                            RafflePlayWoo_error_log( 'email lucky numbers ' . $th->getMessage() ); 
                        }
                      
                    }
                }
            }
            //end of lucky numbers check

            if( $ticket_image_str === '' ){
                if( is_array( $raffle_tickets)){
                    $tickets_str = implode( ', ', $raffle_tickets );
                }
            }else{
                $tickets_str = $ticket_image_str;
            }                     

            $extra_row_email = stripslashes( esc_html( $raffle_info['email_extra'] ) ); 
                           
            if( $inc_raffle_name ) { 

                $ticket_info .= "<tr><td style='font-weight: 600; border:1px 
                                solid #e5e5e5;vertical-align:middle;padding:12px;text-align:center;'>" .
                                esc_html( $raffle ). "</td></tr>";
            }            
                    
          
            if( $email_body != '' ){
                $ticket_info .= "<tr><td style='font-weight: 600; border:1px solid #e5e5e5;vertical-align:middle;padding:12px;text-align:center;'>"
                            . esc_html( $email_body) . "</td></tr>";
            } 
            
            $border_bottom = ( $extra_row_email == '' && $lucky_won == '') ? " border-bottom: 2px solid #000; " : '';

            $ticket_info .= "<tr class='tr-tickets'>
                                <td style='border:1px solid #e5e5e5;vertical-align:middle;padding:12px;text-align:center; $border_bottom' > 
                                    <div class='div-tr-tickets'> "
                                    . $tickets_str . " 
                                    </div>
                                </td> 
                            </tr>";

            if( $lucky_won != '' ){
                $border_bottom =  ( $extra_row_email == '') ? " border-bottom: 2px solid #000; " : '';
                $ticket_info .= "<tr class='tr-tickets'>
                                    <td style='border:1px solid #e5e5e5;vertical-align:middle;padding:12px;text-align:center; $border_bottom' > 
                                        <div class='div-tr-tickets'>
                                            $lucky_won 
                                        </div>
                                    </td> 
                                </tr>";
            }                             
                                            
          
            if( $extra_row_email !== '' ){
                $ticket_info .= " <tr> ".                            
                                    "<td style='border:1px solid #e5e5e5;vertical-align:middle;padding:12px;text-align:center; border-bottom: 2px solid #000;' colspan='$col_span'>" 
                                    . esc_html( $extra_row_email ) . "</td>"
                                . "</tr>";
                    
            }
                                
        }
        
        echo $ticket_info;
                                
        ?>
    </tbody>
</table>

<?php 
    if( $global_user_can_pick ){
    //    echo "<div id='section_user_pick_tickets' style='display: none; width: 100%; min-height: 120px; background-color: red;'></div>";
    }   
?>

</section>