<?php

defined('ABSPATH') || exit;

//BE AWARE WHEN EDITING THIS TEMPLATE FOR NOT BREAKING IT

/* HOW TO USE CUSTOM CODE WITHOUT BREAKING WHEN UPDATING THE PLUGIN
   STEP 1: COPY THIS FILE TO YOUR CHILD THEME/WOOCOMMERCE/INCLUDES/TEMPLATES/ 
   SETP 2: MAKE CHANGES TO THE FILE 
*/

// if you want custom label to display on the form
$search_labels = array(
    'order_id'      => esc_html__('Order id', 'raffle-play-woo'), 
    'email'         => esc_html__('Correo electronico', 'raffle-play-woo'),
    'first_name'    => esc_html__('First Name', 'raffle-play-woo'),
    'last_name'     => esc_html__('Last Name', 'raffle-play-woo'),
    'phone'         => esc_html__('Phone Number', 'raffle-play-woo'),
    'btn_search'    => esc_html__('Busca tus Boletos', 'raffle-play-woo'),    
    'required_txt'  => esc_html__('is required field', 'raffle-play-woo'),    
);


// MODIFY TO BELOW ARRAY ONLY IF YOU KNOW WHAT YOU ARE DOING
// this array is for required field message
// Order is required to be filled in
$req_names = array(
    'order_id'      => $search_labels['order_id'] . ' ' . $search_labels['required_txt'],
    'email'         => $search_labels['email'] . ' ' . $search_labels['required_txt'],
    'phone'         => $search_labels['phone'] . ' ' . $search_labels['required_txt'],
    'first_name'    => $search_labels['first_name'] . ' ' . $search_labels['required_txt'],
    'last_name'     => $search_labels['last_name'] . ' ' . $search_labels['required_txt'], 
    'invalid_email' => esc_html__('Invalid Email', 'raffle-play-woo')   
);

?>

<form id='form_raffle_search'>

    <div>

        <?php if( $email == 'yes' ): ?>
            <p class='p_raffle_search_email'>
                <label for="raffle_search_email">
                    <input type="email" name="raffle_search_email" id="raffle_search_email" required />
                        <?php 
                            echo esc_html( $search_labels['email']);                
                        ?> *
                </label>
            </p>
        <?php endif; ?>

        <?php if( $phone == 'yes' ): ?>
            <p class='p_raffle_search_phone'>
                <label for="raffle_search_phone">
                    <input type="text" name="raffle_search_phone" id="raffle_search_phone" required />
                        <?php 
                            echo esc_html( $search_labels['phone']);                
                        ?> *
                </label>
            </p>
        <?php endif; ?>        

        <?php if( $order_id == 'yes' ): ?>
            <p class='p_raffle_search_order_id'>
                <label for="raffle_search_order_id">
                    <input type="number" id='raffle_search_order_id' name='raffle_search_order_id' required />
                    <?php 
                        echo esc_html( $search_labels['order_id']);                                            
                    ?> *
                </label>
            </p>
        <?php endif; ?>

        <?php if( $first_name == 'yes' ): ?>
            <p class='p_raffle_search_first_name'>
                <label for="raffle_search_first_name">
                    <input type="text" name="raffle_search_first_name" id="raffle_search_first_name" required />
                        <?php 
                            echo esc_html( $search_labels['first_name']);                                                
                        ?> *
                </label>
            </p>
        <?php endif; ?>

        <?php if( $last_name == 'yes' ): ?>  
            <p class='p_raffle_search_last_name'> 
                <label for="raffle_search_last_name">
                    <input type="text" name="raffle_search_last_name" id="raffle_search_last_name" required />
                        <?php 
                            echo esc_html( $search_labels['last_name']);                                                
                        ?> *
                </label>
            </p>
        <?php endif; ?>

        <p>
            <button type='submit' class='btn_raffle_search_tickets'>
                <?php 
                    echo esc_html( $search_labels['btn_search']);                     
                ?> 
                <span class=''></span>
            </button>
        </p>

        <input type="hidden" name="search_by" id='raffle_search_id' value='' />

    </div>

</form>

<div class='tickets_show_content'></div>

<style>
    #form_raffle_search input[type='text'],
    #form_raffle_search input[type='number'],
    #form_raffle_search input[type='email']{
        float: right;
        display: block;
        width: 70%;
        padding: .375rem .75rem;
        font-size: 1rem;
        font-weight: 400;
        line-height: 1.5;
        color: #212529;
        background-color: #fff;
        background-clip: padding-box;
        border: 1px solid #ced4da;
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
        border-radius: .25rem;
        transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;        
      
    }

    #form_raffle_search p{
        margin: 10px;
    }

    #form_raffle_search button{
        border: 1px solid #af9f6e;
        color: #fff;   
        display: inline-block;
        font-weight: 400;
        line-height: 1.5;
        color: #212529;
        text-align: center;
        text-decoration: none;
        vertical-align: middle;
        cursor: pointer;
        -webkit-user-select: none;
        -moz-user-select: none;
        user-select: none;
        padding: .375rem .75rem;
        font-size: 1rem;
        border-radius: .25rem;
        transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
    }

    #form_raffle_search button:hover{
        background-color: #ffc107;
    }

    .warning_required{
        color: #000;
        background-color: #f8d7da;
        padding: 10px;
    }

    @keyframes spinner {
        to {transform: rotate(360deg);}
    }
    
    .spinner_loader:before {
        content: '';
        box-sizing: border-box;
        margin-left: 15px;
        margin-top: 3px;
        display: block;
        top: 50%;
        left: 50%;
        float: right;
        width: 20px;
        height: 20px;
        border-radius: 50%;
        border: 2px solid #ccc;
        border-top-color: #000;
        animation: spinner .6s linear infinite;
    }

</style>


<script>
    ( function(){

        <?php 

            $nonce = wp_create_nonce("raffle_user_search_nonce");
	        $admin_url = admin_url('admin-ajax.php?action=drp_raffle_search_tickets_show&id='. $id.'&search_by=' . $search_by .'&nonce='.$nonce);
        ?>

        const raffle_search_admin_url = "<?php echo $admin_url; ?>";
        const raffle_search_by = "<?php echo $search_by; ?>";
        const raffle_req_fields =  <?php echo wp_json_encode( $req_names ); ?>;

        if( raffle_search_by !== '' ){
            let arr_search_by = raffle_search_by.split(',');
            let get_admin_url = '';

            let order_id = raffle_search_by.indexOf('order_id') > -1;
            let email = raffle_search_by.indexOf('email') > -1;

            let first_name = raffle_search_by.indexOf('first_name') > -1;
            let last_name = raffle_search_by.indexOf('last_name') > -1;

            let phone   = raffle_search_by.indexOf('phone') > -1;

            let btn_raffle = document.querySelector('.btn_raffle_search_tickets');
            let raffle_content_show = document.querySelector('.tickets_show_content');
            let btn_submit = document.querySelector('.btn_raffle_search_tickets');
            let btn_span = btn_submit.querySelector('span');
            let email_obj = document.querySelector('#raffle_search_email');


            if( btn_raffle !== null ){                

                btn_raffle.addEventListener('click', ( e )=>{
                    e.preventDefault();
                    let alert_msg = '';
                    let vals_post = '';                    

                    if( email_obj !== null && email_obj.value.trim() !== '' && ! ValidateEmail( email_obj.value ) ){
                        alert_msg += '<p class="warning_required"> * ' + raffle_req_fields[ 'invalid_email' ] +'</p>';                      
                    }else{
                        alert_msg = '';
                    }

                    for( let i = 0; i < arr_search_by.length; i++ ){
                        let item = arr_search_by[i].trim();
                        let val = document.querySelector('#raffle_search_' + item.trim() );
                        if( val !==  null ){
                            val = val.value.trim();

                            if( val == '' ){
                                alert_msg += '<p class="warning_required"> * ' + raffle_req_fields[ item ] +'</p>';
                            }else{
                                vals_post += "&" + item + "="+val;
                            }
                        }else{
                            console.log( 'Object not found ' + item );
                            return false;
                        }
                    }

                    if( alert_msg !== '' ){
                        raffle_content_show.innerHTML = alert_msg ; 
                    }else{
                        raffle_content_show.innerHTML = '';

                        get_admin_url = raffle_search_admin_url + vals_post;                                                                                  

                        btn_submit.disabled = true;
                        btn_span.classList.add("spinner_loader");

                        fetch( get_admin_url,{
                            method : 'GET',                            
                            cache: "default",                            
                            headers: {
                                'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8'
                            },
                        })
                        .then( response => response.text() )
                        .then( data => {                                                                 
                            raffle_content_show.innerHTML = data;
                            btn_submit.disabled = false;
                            btn_span.classList.remove("spinner_loader");
                        })
                        .catch( error =>{
                            alert( 'Error ' + error );
                            btn_submit.disabled = false;
                            btn_span.classList.remove("spinner_loader");
                        })
                    }
                    
                });
            }
        }

        function ValidateEmail(email) {
            return String(email)
                .toLowerCase()
                .match(
                /^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|.(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/
                );
        }
        
    })();
</script>