<?php

defined('ABSPATH') || exit;

//BE AWARE WHEN EDITING THIS TEMPLATE FOR NOT BREAKING IT

/* HOW TO USE CUSTOM CODE WITHOUT BREAKING WHEN UPDATING THE PLUGIN
   STEP 1: COPY THIS FILE TO YOUR CHILD THEME/WOOCOMMERCE/INCLUDES/TEMPLATES/ 
   SETP 2: MAKE CHANGES TO THE FILE 
*/

// if you want custom label to display on the form
$search_labels = array(
    'order_id'      => esc_html__('Order id', 'raffle-play-woo'), 
    'email'         => esc_html__('Email', 'raffle-play-woo'),
    'first_name'    => esc_html__('First Name', 'raffle-play-woo'),
    'last_name'     => esc_html__('Last Name', 'raffle-play-woo'),
    'phone'         => esc_html__('Phone Number', 'raffle-play-woo'),
    'btn_search'    => esc_html__('Search', 'raffle-play-woo'),    
    'required_txt'  => esc_html__('is required field', 'raffle-play-woo'),    
);

$nonce = wp_create_nonce("raffle_user_pick_tickets_nonce");
$admin_url_pick_tickets = admin_url('admin-ajax.php?nonce='.$nonce);
$action_load = 'drp_raffle_load_tickets_checkout';
$action_change_ticket = 'drp_raffle_change_ticket_checkout';
?>

<script> 
    const raffle_block_location     = '<?php echo $location_block;?>';
    const raffle_block_admin_url    = '<?php echo $admin_url;?>';
    const raffle_timeout_refresh    = '<?php echo $timeout;?>';   
    const raffle_admin_url_load_tickets         = '<?php echo $admin_url_pick_tickets . '&action=' . $action_load;?>';
    const raffle_admin_url_change_tickets       = '<?php echo $admin_url_pick_tickets . '&action=' . $action_change_ticket;?>';
    const raffle_text_loading_msg               = '<?php echo esc_html( $user_pick_lbls['loading_msg']);?>';
    const raffle_text_not_found_msg             = '<?php echo esc_html( $user_pick_lbls['not_found_msg']);?>';
    const raffle_text_not_available_anymore     = '<?php echo esc_html( $user_pick_lbls['not_available_anymore']);?>';
    const raffle_text_changing_btn              = '<?php echo esc_html( $user_pick_lbls['changing_btn']);?>';
    const raffle_text_change_btn                = '<?php echo esc_html( $user_pick_lbls['change_btn']);?>';
    const raffle_text_search_btn                = '<?php echo esc_html( $user_pick_lbls['search_btn']);?>';     
    const raffle_text_no_ticket_selected_msg    = '<?php echo esc_html( $user_pick_lbls['no_ticket_selected_msg']);?>';  
    const raffle_ticket_max_show_no             = parseInt('<?php echo esc_html( $user_pick_lbls['max_show_no']);?>');      
</script>

<style>
    .raffle-tickets-generated-checkout 
    .raffle-tr-checkout > td{
        padding: 0 !important;  
        border: 0px !important;   
    }

    .div-ticket-wrapper,
    .div-ticket-wrapper input{
        cursor: pointer;
    }

    .container-raffle-pagination 
    .single-item{
        display: inline-block;
    }
</style>


<script>   
    var $j = jQuery;
    let $raffle_width_set       = false;
    let search_key_up_timed     = 0;;
    let raffle_tickets_data     = [];
    let raffle_page_no          = 1;

    function raffle_change_ticket( $raffle_id, $ticket_no_sel, $el ){
        
        if( ! $raffle_width_set ){
            let width = $j('').find('.raffle-table').width();
            $j('#section_user_pick_tickets').css('width', parseInt(width) + 10);
            $raffle_width_set = true;
        }

        $j('#user_pick_counter_index').val( 0 );
        
        $j('#section_user_pick_tickets .header-user-change').hide();
        $ticket_no_sel = $j( $el ).attr('data-ticket_no');      
       
        $j('#section_user_pick_tickets #user_pick_ticket_raffle_id').val( $raffle_id );
        $j('#section_user_pick_tickets #user_pick_ticket_old_ticket').val( $ticket_no_sel ); 
        $j('#section_user_pick_tickets #user_pick_ticket_img_url').val( $j( $el ).data('imgurl') ); 
        $j('#section_user_pick_tickets #user_pick_ticket_prefix').val( $j( $el ).data('prefix') ); 
        $j('#section_user_pick_tickets #user_pick_ticket_zeros').val( $j( $el ).data('zeros') );         

        $j('#section_user_pick_tickets #user_pick_search_tickets').val('');    
        
        $j('#section_user_pick_tickets').show();
        $j('#section_user_pick_tickets .body-user-pick').html("<div style='text-align: center; width: 100%;' > <div class=\"lds-dual-ring\"></div> <h3> " + raffle_text_loading_msg + "</h3> </div>");    

        raffle_init_tickets( $raffle_id, $el, $ticket_no_sel );      
    }

    function user_pick_search_tickets_key_down( e ){        
        if( e.keyCode == 13 ){
            $j('#section_user_pick_tickets .header-user-search .header-user-search-btn').trigger('click');
        }
    }

    function footer_user_pick_cancel_btn_action( event ){
        event.preventDefault();
        $j('#section_user_pick_tickets .header-user-close').trigger('click');
    }

    function raffle_init_tickets( $raffle_id, $el, $ticket_no_sel ){

        let url = raffle_admin_url_load_tickets + '&raffle_id=' + $raffle_id;

        let img_url         = $j( $el ).data('imgurl');
        let prefix          = $j( $el ).data('prefix');
        let leading_zeros   = $j( $el ).data('zeros'); 

        $j.get( url , function( $data ){                
            try {
                $data = JSON.parse( $data );
                raffle_tickets_data = $data;
            } catch (error) {
                $j('#section_user_pick_tickets .body-user-pick').html( "<p> Error parsing the data </p>" );
                return false;
            }
            let start = 0;
            let end = raffle_ticket_max_show_no;
            let $data_radios    = raffle_build_tickets( raffle_tickets_data, img_url, leading_zeros, start, end );
    

            $j('#section_user_pick_tickets .header-user-change-from').html(  "<div class='div-ticket-wrapper' style=\"background-image: url('" + img_url + "'); \" >" +
                            "<div class='ticket-image-container'>" +
                                $ticket_no_sel +
                            "</div>" +
                        "</div>" );

            $j('#section_user_pick_tickets .header-user-change-to').html(  "<div class='div-ticket-wrapper' style=\"background-image: url('" + img_url + "'); \" >" +
                            "<div class='ticket-image-container'> </div></div>" );

            if( $data_radios.length > 0 ){
                $j('#section_user_pick_tickets .body-user-pick').html(  $data_radios.join('') );
            }else{
                $j('#section_user_pick_tickets .body-user-pick').html( "<p>" + raffle_text_not_found_msg +"</p>" );
            }

            $j('#section_user_pick_tickets .header-user-change').show();

            $j('#section_user_pick_tickets #user_pick_search_tickets').focus();            
        });
    }

    function raffle_build_tickets( tickets_data, img_url, leading_zeros, start, end, search = false ){

        let $data_radios = [];

        if( Array.isArray( tickets_data ) ){

            if( tickets_data.length > 0 ){

                let ticket_no = '';
                let ticket_id = '';
                let ticket_str = '';
                let ticket_radio = '';
            //    let $end = (raffle_ticket_max_show_no > tickets_data.length) ?  tickets_data.length : raffle_ticket_max_show_no;

                if( start < 0 || start > tickets_data.length ){
                    start = 0;
                }

                if( end > tickets_data.length ){
                    end = tickets_data.length;                  
                }

                if(search){
                    start = 0; 
                    end = tickets_data.length;
                }

                for( let i = start; i < end; i++ ){

                    ticket_no = tickets_data[i];
                    ticket_id = "raffle_select_ticket_"+ ticket_no;
                                            
                    ticket_str = raffle_ticket_label( ticket_no, ticket_id, img_url, leading_zeros );

                    $data_radios.push( ticket_str );
                }
            }
        }

        return $data_radios;
    }

    function raffle_ticket_label( ticket_no, ticket_id, img_url, leading_zeros ){
        let ticket_no_leading = ticket_no.toString().padStart( leading_zeros, '0' );

        return "<label  for='"+ ticket_id +"'><div data-ticket='" + ticket_no +"' class='div-ticket-wrapper' style=\"background-image: url('" + img_url + "'); \" >" +
                            "<div class='ticket-image-container'>" +
                            "<input class='radio_ticket_raffle' onchange='radio_ticket_raffle_change( this );' name='radio_ticket_raffle' type='radio' value='" + 
                                ticket_no + "' id='" + ticket_id + "' />" +
                                ticket_no +
                            "</div>" +
                        "</div>" +
                "</label>";                         
    }
     

    function raffle_user_pick_close(){
        $j('#section_user_pick_tickets').hide();  
        $j('#section_user_pick_tickets .header-user-change').hide();
        $j('#section_user_pick_tickets .header-user-messages-tr').hide();
    }

    function search_ticket_clear(){
        $j('#section_user_pick_tickets #user_pick_search_tickets').val('');
        $j('#section_user_pick_tickets .header-user-search-btn').trigger('click');
    }

    function raffle_search_btn_click( event, _this ){   

        event.preventDefault();

        let search_val      = $j.trim( $j('#section_user_pick_tickets #user_pick_search_tickets').val() );

        if( search_val == '' ){
            raffle_reset_search();
            return false;
        }
        
        _this.textContent   = 'Searching';
        _this.disabled      = true;
        let new_data        = [];
        
        let ticket = '';

        for( let i = 0; i < raffle_tickets_data.length; i++ ){
            ticket = raffle_tickets_data[ i ].toString();       
            if( ticket.indexOf( search_val ) > -1 ){
                new_data.push( ticket );
            }
        }
       

        if( new_data.length > 0 ){

            let img_url         = $j('#user_pick_ticket_img_url').val();
            let leading_zeros   = $j('#user_pick_ticket_zeros').val();
            let $data_radios    = raffle_build_tickets( new_data, img_url, leading_zeros, 0, 1, true );  

            if( $data_radios.length > 0 ){
                $j('#section_user_pick_tickets .body-user-pick').html(  $data_radios.join('') );
            }else{
                $j('#section_user_pick_tickets .body-user-pick').html( "<p>" + raffle_text_not_found_msg +"</p>" );
            }  
        }else{
            $j('#section_user_pick_tickets .body-user-pick').html( "<p>" + raffle_text_not_found_msg +"</p>" );   
        }

        _this.textContent = raffle_text_search_btn;
        _this.disabled = false;
    }

    function raffle_search_input_ticket( _this ){

        search_key_up_timed = setTimeout(function() {
            var value = $j(_this).val().toLowerCase();
            $j("#section_user_pick_tickets .body-user-pick .div-ticket-wrapper").filter(function( el ) {          
                let ticket = $j( this ).data('ticket');        
                $j(this).toggle( ticket.toString().indexOf( value ) > -1)
            });
         }, 250);         
         
    }

    function raffle_search_key_down( _this ){
        clearTimeout( search_key_up_timed );
    }

    function radio_ticket_raffle_change( _this ){
      
        $j('#section_user_pick_tickets').find('.header-user-change-to .ticket-image-container').text( _this.value );
    }

    function raffle_ticket_complete( $prefix, $leading_zeros, $ticket_no){

        try {
            if( $leading_zeros != '' ){
                $leading_zeros = parseInt( $leading_zeros );
            }
            $ticket_no = $ticket_no.padStart( $leading_zeros, '0');
            $ticket_no = $prefix + $ticket_no;
        } catch (error) {
            console.error( error );  
        }

        return $ticket_no;
    }

    function header_user_change_btn_click(event,  _this ){

        event.preventDefault();

        let selected = $j("#section_user_pick_tickets .body-user-pick input[type='radio']:checked");

        if( selected.length > 0 ){
            let new_ticket = selected.val();
            let old_ticket = $j('#section_user_pick_tickets #user_pick_ticket_old_ticket').val();
            let raffle_id = $j('#section_user_pick_tickets #user_pick_ticket_raffle_id').val();
         
            if( old_ticket == null || old_ticket == ''){
                console.log( 'old ticket not found');
                return;
            }
            
            _this.textContent = raffle_text_changing_btn;
            _this.disabled = true;           
            let url = raffle_admin_url_change_tickets + '&old='+ old_ticket + '&new='+ new_ticket +'&raffle_id=' + raffle_id;

            $j.get( url, function( data ){                
              
                data = JSON.parse( data );                
                
                if( ( typeof data.ok !== 'undefined') && (data.ok == true ) ){
                   
                    let $raffle_id = $j('#user_pick_ticket_raffle_id').val();
                    let $img_url   = $j('#user_pick_ticket_img_url').val();
                    let $prefix    = $j('#user_pick_ticket_prefix').val();
                    let $zeros     = $j('#user_pick_ticket_zeros').val();
                    let $old_ticket = $j('#user_pick_ticket_old_ticket').val();

                    let $ticket_id = 'raffle_ticket_' + $raffle_id + '_' + $old_ticket;
                    
                    let $new_ticket_id = 'raffle_ticket_' + $raffle_id + '_' + new_ticket;

                    let updated_ticket = raffle_ticket_complete( $prefix, $zeros, new_ticket );

                    _this.textContent = raffle_text_change_btn;
                           
                    $j('.raffle-table').find( '#' + $ticket_id + ' .ticket-image-container').text( updated_ticket );
                    $j('.raffle-table').find( '#' + $ticket_id ).attr('data-ticket_no', new_ticket);
                    $j('.raffle-table').find( '#' + $ticket_id ).attr( 'id', $new_ticket_id );

                    $j(' #section_user_pick_tickets').hide();

                }else if( data.ok == false ){

                    if( typeof data.reason !== 'undefined' && data.reason == 'ticket_taken'){
                        alert( raffle_text_not_available_anymore );
                    }else{
                        alert( data.message );
                    }
                    $j(' #section_user_pick_tickets').hide();
                }

            }).done( function(){                
                _this.disabled = false; 
                _this.textContent = raffle_text_change_btn;              

            }).fail( function( error ){
                console.error( error );
                alert( error );
                _this.disabled = false; 
                $j(' #section_user_pick_tickets').hide();   
            });

        }else{            
            $j('.header-user-messages').text( raffle_text_no_ticket_selected_msg );
            $j('.header-user-messages-tr').show().delay( 3000 ).fadeOut();
        }
    }

    function raffle_reset_search(){

        let page = parseInt( $j('#user_pick_counter_index').val() );

        if( page < 0 ) page = 0;
        //raffle_ticket_max_show_no
        let img_url = $j('#section_user_pick_tickets #user_pick_ticket_img_url').val();        
        let leading_zeros = $j('#section_user_pick_tickets #user_pick_ticket_zeros').val(); 

        let start   = page * raffle_ticket_max_show_no;
        let end     = start + raffle_ticket_max_show_no;

        if( start < 0 ) start = 0;

        $j('#user_pick_counter_index').val( page );

        let $data_radios    = raffle_build_tickets( raffle_tickets_data, img_url, leading_zeros, start, end );

        if( $data_radios.length > 0 ){
            $j('#section_user_pick_tickets .body-user-pick').html(  $data_radios.join('') );
        }else{
            $j('#section_user_pick_tickets .body-user-pick').html( "<p>" + raffle_text_not_found_msg +"</p>" );
        }   
    }

    function footer_user_pick_prev_btn_click( event, _this ){

        event.preventDefault();

        let page = parseInt( $j('#user_pick_counter_index').val() );

        page = page - 1;
        if( page < 0 ) page = 0;
        //raffle_ticket_max_show_no
        let img_url = $j('#section_user_pick_tickets #user_pick_ticket_img_url').val();        
        let leading_zeros = $j('#section_user_pick_tickets #user_pick_ticket_zeros').val(); 
       
        let start   = page * raffle_ticket_max_show_no;
        let end     = start + raffle_ticket_max_show_no;

        if( start < 0 ) start = 0;

        $j('#user_pick_counter_index').val( page );

        let $data_radios    = raffle_build_tickets( raffle_tickets_data, img_url, leading_zeros, start, end );

        if( $data_radios.length > 0 ){
            $j('#section_user_pick_tickets .body-user-pick').html(  $data_radios.join('') );
        }else{
            $j('#section_user_pick_tickets .body-user-pick').html( "<p>" + raffle_text_not_found_msg +"</p>" );
        }

    }

    function footer_user_pick_next_btn_click( event, _this ){
        event.preventDefault();
        //raffle_ticket_max_show_no
        let page = parseInt( $j('#user_pick_counter_index').val() );
      
        if( (page * raffle_ticket_max_show_no) > raffle_tickets_data.length ){
            page = parseInt( raffle_tickets_data.length / raffle_ticket_max_show_no ) - 1;           
        }else
            page = page + 1;

        //raffle_ticket_max_show_no
        let img_url = $j('#section_user_pick_tickets #user_pick_ticket_img_url').val();        
        let leading_zeros = $j('#section_user_pick_tickets #user_pick_ticket_zeros').val(); 
       
        let start   = page * raffle_ticket_max_show_no;
        let end     = start + raffle_ticket_max_show_no;

        if( start < 0 ) start = 0;

        $j('#user_pick_counter_index').val( page );
        let $data_radios    = raffle_build_tickets( raffle_tickets_data, img_url, leading_zeros, start, end );

        if( $data_radios.length > 0 ){
            $j('#section_user_pick_tickets .body-user-pick').html(  $data_radios.join('') );
        }else{
            $j('#section_user_pick_tickets .body-user-pick').html( "<p>" + raffle_text_not_found_msg +"</p>" );
        }

    }

</script>
                
              