<?php

if( ! defined( 'ABSPATH') ){ die('No access to this page'); }

include_once( RAFFLE_PLAY_WOO_DIR_PATH. 'includes/external/dompdf/autoload.inc.php');
include_once( WP_PLUGIN_DIR .'/woocommerce/src/Utilities/OrderUtil.php');
use Dompdf\Dompdf;
use Dompdf\Options;
use Automattic\Woocommerce\Utilities\OrderUtil;

class RafflePlayWoo_Reports{

    private $db;
    private $tickets_tbl;
    private $customer_table;
    private $order_stats_table;
    private $future_date;
    private $past_date;
    private $intern;
    private $posts_table;
    private $posts_meta_table;
    private $currency;
    private $order_status;
    private $order_status_query;
    private $date_format;
    private $raffle_id;
    private $wc_orders;
    private $wc_order_addr;
    
    function __construct(){
        global $wpdb;

        $this->db = $wpdb;
        $this->tickets_tbl          = $wpdb->prefix . 'raffleplaywoo_main';
        $this->customer_table       = $wpdb->prefix . 'wc_customer_lookup';
        $this->order_stats_table    = $wpdb->prefix . 'wc_order_stats';
        $this->posts_table          = $wpdb->prefix . 'posts';
        $this->posts_meta_table     = $wpdb->prefix . 'postmeta';
        $this->future_date          = '2100-12-12 00:00:00';
        $this->past_date            = '1990-01-01 00:00:00';
        $this->order_status_query   = array();
        $this->date_format          = array( 
                                        '%d/%m/%Y',
                                        '%Y/%m/%d',
                                        '%d-%m-%Y',   
                                        '%Y-%m-%d',
                                        '%d/%m/%y',
                                        '%d-%m-%y',
                                        '%y/%m/%d',
                                        '%y-%m-%d',
                                        );
        $this->raffle_id            = 0;   
        
        $this->wc_orders            = $wpdb->prefix . 'wc_orders';  
        $this->wc_order_addr        = $wpdb->prefix . 'wc_order_addresses';    
    }

    function get_report( $from, $to, $type, $extra ){
        //dates should be already set in format yyyy-mm-dd, not hh:mm:ms
        $from = sanitize_text_field( $from );
        $to   = sanitize_text_field( $to );
        $dates = '';  
        $original_from = $from;
        $original_to   = $to;
        $dates_text = '';   
        $this->raffle_id = intval( $extra['raffle_id'] );
          
        $this->currency = $extra['currency'];
        $this->order_status = htmlspecialchars( $extra['order_status'], ENT_QUOTES );       
        
        if( strlen( trim($this->order_status) )  === 0 ){
            exit;
        }

        $order_status_keys = array_keys( wc_get_order_statuses() );
        foreach( $order_status_keys as $order_key ){
            if( strpos( $this->order_status, $order_key ) !== false ){
                array_push( $this->order_status_query, $order_key );
            }
        }
        
        if( sizeof( $this->order_status_query ) > 0){
            $this->order_status_query = implode( "','", $this->order_status_query );
        }else{
            exit;
        }

        $this->order_status_query = "'". $this->order_status_query ."'";        
                
        if( trim( $from ) !== '' ){
            $from_arr = explode( '-', $from );
            if( isset( $from_arr[2] ) ){
                $from = $from_arr[2];
            }
            if( isset( $from_arr[1] ) ){
                $from .= '-' . $from_arr[1];
            }
            if( isset( $from_arr[0] ) ){
                $from .= '-' . $from_arr[0];
            }         
                
        }else{         
            $original_from = '01-01-2000';
        }

        if( trim( $to ) !== '' ){
            $to_arr = explode( '-', $to );
            if( isset( $to_arr[2] ) ){
                $to = $to_arr[2];
            }
            if( isset( $to_arr[1] ) ){
                $to .= '-' . $to_arr[1];
            }
            if( isset( $from_arr[0] ) ){
                $to .= '-' . $to_arr[0];
            }
        }else{
            $original_to = '01-01-2100';
        }



        if( trim( $to ) !== '' ){
            $to .= ' 23:59:59 ';
        }else{
            $to = $this->future_date;
        }

        if( trim( $from ) !== '' ){
            $from .= ' 00:00:00 '; 
        }else{
            $from = $this->past_date;
        }

        if( $type === 1 ){ //report by daily sales                  
            $filename =   esc_html__('Daily Sales', 'raffle-play-woo') .'(' . $original_from . '##'. $original_to . ').csv';
            $this->report_by_day( $from, $to, $filename, $extra );

        }else if ( $type === 2 ){ //report by weekly sales
            $filename= esc_html__('Weekly Sales', 'raffle-play-woo') .'(' . $original_from . '##'. $original_to . ').csv';
            $this->report_by_week( $from, $to, $filename, $extra);
        }else if( $type === 3 ){ //report by monthly sales
            $filename= esc_html__('Monthly Sales', 'raffle-play-woo') .'(' . $original_from . '##'. $original_to . ').csv';
            $this->report_by_month( $from, $to, $filename, $extra);  
        }else if( $type === 4 ){ //report by region
            $filename =   esc_html__('Sales by Region/County', 'raffle-play-woo') . '(' . $original_from . '##'. $original_to . ').csv';
            $this->report_by_region( $from, $to, $filename, $extra );
        }else if( $type === 5 ){ //report by country/county
            $filename = esc_html__('Sales by Country and County', 'raffle-play-woo') . '(' . $original_from . '##'. $original_to . ').csv';
            $this->report_by_country( $from, $to, $filename, $extra );
        }else if( $type === 6){ //report by product
            $filename =  esc_html__('Sales by Product', 'raffle-play-woo' ) . '(' . $original_from . '##'. $original_to . ').csv';
            $this->report_by_product( $from, $to, $filename, $extra );
        }else if ( $type === 7 ){ //report by raffle ticket
            $filename = esc_html__('By Raffle Ticket', 'raffle-play-woo') . '(' . $original_from . '##'. $original_to . ').csv';

            $this->report_by_raffle_ticket( $from, $to, $filename, $extra );
        }
    }

    //----------------- report by day ---------------------------
    private function report_by_day( $from , $to, $filename, $extra ){       

        $group_by = " posts.ID ";

        if( $extra['product_sale'] === 1 )
            $group_by = "posts.post_date, posts.ID, raffle.product_id ";
        
        if( ! OrderUtil::custom_orders_table_usage_is_enabled() ){ 
            $this->db->query( "DROP TEMPORARY TABLE if EXISTS RPR_REPORT_ONE;");
            $this->db->query( "CREATE TEMPORARY TABLE RPR_REPORT_ONE (
                                                SELECT posts.ID AS id, 
                                                DATE(posts.post_date) AS date_order, 
                                                raffle.catid_one as raffle_id,  
                                                raffle.total_price as raffle_total, 
                                                raffle.product_id as prod_id,                                  
                                                MAX( CASE WHEN meta.meta_key='_order_total' THEN meta.meta_value END ) AS sale_total
                                                FROM {$this->posts_table} AS posts    
                                                INNER JOIN {$this->tickets_tbl} as raffle 
                                                ON raffle.order_id = posts.id
                                                INNER JOIN {$this->posts_meta_table} AS meta 
                                                ON posts.id = meta.post_id
                                                WHERE ( (posts.post_type = 'shop_order') 
                                                        AND ( posts.post_status IN ( {$this->order_status_query} ) )
                                                        AND (raffle.live_order = 1) 
                                                        AND (raffle.deleted = 0)
                                                        AND (raffle.catid_one = {$this->raffle_id} ) ) 
                                                GROUP BY {$group_by}  );");
        }else{
            //HPOS
            $group_by = " orders.id, date_order, raffle.product_id ";
            $this->db->query( "DROP TEMPORARY TABLE if EXISTS RPR_REPORT_ONE;");
            $this->db->query( "CREATE TEMPORARY TABLE RPR_REPORT_ONE (
                                                SELECT orders.id AS id, 
                                                DATE(orders.date_created_gmt) AS date_order, 
                                                raffle.catid_one as raffle_id,  
                                                raffle.total_price as raffle_total, 
                                                raffle.product_id as prod_id,                                  
                                                orders.total_amount AS sale_total
                                                FROM {$this->tickets_tbl} as raffle
                                                INNER JOIN {$this->wc_orders} as orders
                                                ON raffle.order_id = orders.id
                                                WHERE ( (orders.type = 'shop_order') 
                                                        AND ( orders.status IN ( {$this->order_status_query} ) )
                                                        AND (raffle.live_order = 1) 
                                                        AND (raffle.deleted = 0)
                                                        AND (raffle.catid_one = {$this->raffle_id} ) ) 
                                                GROUP BY {$group_by}  );");
        }
        
        $query = null;

        if( $extra['product_sale'] === 1 ){
            $query = $this->db->get_results( $this->db->prepare(" SELECT *, SUM( raffle_total ) AS sales 
                                                              FROM RPR_REPORT_ONE
                                                              WHERE ( date_order BETWEEN %s AND %s  AND ( raffle_id = %d ) )  
                                                              GROUP by date_order", $from, $to, $this->raffle_id ));
        }else{
       
            $query = $this->db->get_results( $this->db->prepare(" SELECT *, SUM(sale_total) AS sales 
                                                              FROM RPR_REPORT_ONE
                                                              WHERE ( date_order BETWEEN %s AND %s  AND ( raffle_id = %d ) )  
                                                              GROUP by date_order;", $from, $to, $this->raffle_id ));
        }
        //get total   AND ( raffle_id = %d )


        $total = 0;      

        foreach( $query as $line ){
            $total += $line->sales;
        };    

        $total_arr = array(
            'date_order' => ' ',
            'sales' => $total
        );  

        $header = array(
            esc_html__("Order Date", 'raffle-play-woo'),
            esc_html__("Total", 'raffle-play-woo')
        );

        $total_arr = (object)$total_arr;
        array_push( $query, $total_arr );

        $this->csv_report_by_day( $header, $query, $filename );
       
    }

    private function csv_report_by_day( $header, $query, $filename ){
         
        $this->report_header( $filename );

        $table_data = $query;        
        // file creation 
        $file = fopen('php://output', 'w');
        $arr = array();
        fputcsv($file, $header);
        foreach ($table_data as $line ) {
            unset( $arr );
            $arr = array();
            array_push( $arr, $line->date_order );
            $str = iconv('UTF-8', 'CP1252', $this->currency . $line->sales); 
            array_push( $arr, $str );
            fputcsv($file, $arr );
        }
        
        fclose($file);
        ob_end_flush();
        exit; 
    }


    // ---------------- report by week ----------------------
    private function report_by_week( $from, $to, $filename, $extra ){
        // with a Monday in this year (1-53)

        $group_by = " posts.id ";
        if( $extra['product_sale'] === 1  ){
            $group_by = " raffle.product_id, posts.id ";
        }

        $this->db->query( "DROP TEMPORARY TABLE if EXISTS RPR_REPORT_ONE;");

        if( ! OrderUtil::custom_orders_table_usage_is_enabled() ){
       
            $this->db->query( " CREATE TEMPORARY TABLE RPR_REPORT_ONE (
                SELECT posts.ID AS id, 
                DATE(posts.post_date) AS date_order, 
                YEAR( posts.post_date ) as year_no,
                WEEK( posts.post_date, 7 ) as week_no,
                raffle.catid_one as raffle_id,   
                raffle.total_price as raffle_total, 
                raffle.product_id as prod_id,                                      
                MAX( CASE WHEN meta.meta_key='_order_total' THEN meta.meta_value END ) AS sale_total
                FROM {$this->posts_table} AS posts 
                INNER JOIN {$this->posts_meta_table} AS meta 
                ON posts.id = meta.post_id
                INNER JOIN {$this->tickets_tbl} as raffle 
                ON raffle.order_id = posts.id
                WHERE (  (posts.post_type = 'shop_order') 
                         AND (raffle.live_order = 1) 
                         AND ( raffle.deleted = 0 )
                         AND ( posts.post_status IN ( {$this->order_status_query} ) )
                         AND (raffle.catid_one = {$this->raffle_id} )
                          )
                GROUP BY {$group_by} );");

        }else{
            //HPOS
            $group_by = " orders.id, raffle.product_id ";        
            $this->db->query( " CREATE TEMPORARY TABLE RPR_REPORT_ONE (
                SELECT orders.id AS id, 
                DATE( orders.date_created_gmt ) AS date_order, 
                YEAR( orders.date_created_gmt ) as year_no,
                WEEK( orders.date_created_gmt, 7 ) as week_no,
                raffle.catid_one as raffle_id,   
                raffle.total_price as raffle_total, 
                raffle.product_id as prod_id,  
                orders.total_amount AS sale_total
                FROM {$this->tickets_tbl} as raffle
                INNER JOIN {$this->wc_orders} as orders
                ON raffle.order_id = orders.id
                WHERE ( (orders.type = 'shop_order') 
                        AND ( orders.status IN ( {$this->order_status_query} ) )
                        AND ( raffle.live_order = 1 ) 
                        AND ( raffle.deleted = 0 )
                        AND ( raffle.catid_one = {$this->raffle_id} ) ) 
                GROUP BY {$group_by}  );");
        }

        $query = null;
        if( $extra['product_sale'] === 1 ){
            $query = $this->db->get_results( $this->db->prepare(" SELECT *, 
                                                                SUM(raffle_total) AS sales
                                                                FROM RPR_REPORT_ONE
                                                                WHERE ( (date_order BETWEEN %s AND %s) AND ( raffle_id = %d ))
                                                                GROUP by  week_no, year_no;",
                                                                 $from, $to, $this->raffle_id ));
        }else{                                         
            $query = $this->db->get_results( $this->db->prepare(" SELECT *, SUM(sale_total) AS sales 
                                                                FROM RPR_REPORT_ONE
                                                                WHERE ( ( date_order BETWEEN %s AND %s) AND ( raffle_id = %d) )
                                                                GROUP by week_no, year_no;", $from, $to, $this->raffle_id ));
        }
        //get total   
        $total = 0;

        foreach( $query as $line ){
            $total += $line->sales;
        };    

        $total_arr = array(
            'date_order' => ' ',
            'sales' => $total
        );  

        $header = array(           
            esc_html__("Week", 'raffle-play-woo'),
            esc_html__("Total", 'raffle-play-woo')
        );

        $total_arr = (object)$total_arr;
        array_push( $query, $total_arr );
        $this->csv_report_by_week( $header, $query, $filename );
    }

    private function csv_report_by_week( $header, $query, $filename ){
         
        $this->report_header( $filename );
        $wp_date_format = get_option('date_format');
        $table_data = $query;        
        // file creation 
        $file = fopen('php://output', 'w');
        $arr = array();
        fputcsv($file, $header);
        foreach ($table_data as $line ) {
            unset( $arr );
            $arr = array();

            if( isset( $line->week_no )){
                //find first week with monday
                $date = new DateTime( $line->year_no . '-01 monday');
                $date_str = $date->format('Y-m-d');
                $from_week = ( $line->week_no - 1) * 7;
                $to_week = ($line->week_no  * 7) - 1;                           
                $date_format_from = date( $wp_date_format, strtotime( $date_str . " + $from_week days") );
                $date_format_to   = date( $wp_date_format, strtotime( $date_str . " + $to_week days") );
                array_push( $arr, '(' . $date_format_from . ') - (' . $date_format_to . ')' );
            }else
                array_push( $arr, '' );

            $str = iconv('UTF-8', 'CP1252', $this->currency . $line->sales); 
            array_push( $arr, $str );
            fputcsv($file, $arr );
        }
        
        fclose($file);
        ob_end_flush();
        exit; 
    }

    //--------------------------------- monthly report ------------------------------------
    public function report_by_month( $from, $to, $filename, $extra ){

        $group_by = " posts.id ";
        if( $extra['product_sale'] === 1  ){
            $group_by = " raffle.product_id, posts.id ";
        }

        $this->db->query( "DROP TEMPORARY TABLE if EXISTS RPR_REPORT_ONE;");

        if( ! OrderUtil::custom_orders_table_usage_is_enabled() ){          
            $this->db->query( " CREATE TEMPORARY TABLE RPR_REPORT_ONE (
                                                SELECT posts.ID AS id, 
                                                DATE(posts.post_date) AS date_order, 
                                                raffle.catid_one as raffle_id,   
                                                raffle.total_price as raffle_total, 
                                                raffle.product_id as prod_id,                                                                                      
                                                MAX( CASE WHEN meta.meta_key='_order_total' THEN meta.meta_value END ) AS sale_total
                                                FROM {$this->posts_table} AS posts 
                                                INNER JOIN {$this->posts_meta_table} AS meta 
                                                ON posts.id = meta.post_id
                                                INNER JOIN {$this->tickets_tbl} as raffle 
                                                ON raffle.order_id = posts.id
                                                WHERE ( (posts.post_type = 'shop_order')  
                                                        AND ( raffle.live_order = 1 ) 
                                                        AND ( raffle.deleted = 0 )
                                                        AND ( posts.post_status IN ( {$this->order_status_query} ) ) 
                                                        AND ( raffle.catid_one = {$this->raffle_id} ) )
                                                GROUP BY {$group_by} );");
        }else{
            $group_by = " orders.id, raffle.product_id ";    

            $this->db->query( " CREATE TEMPORARY TABLE RPR_REPORT_ONE (
                                                SELECT orders.id AS id, 
                                                DATE(orders.date_created_gmt) AS date_order, 
                                                raffle.catid_one as raffle_id,   
                                                raffle.total_price as raffle_total, 
                                                raffle.product_id as prod_id,            
                                                orders.total_amount AS sale_total
                                                FROM {$this->tickets_tbl} as raffle
                                                INNER JOIN {$this->wc_orders} as orders
                                                ON raffle.order_id = orders.id
                                                WHERE ( (orders.type = 'shop_order') 
                                                        AND ( orders.status IN ( {$this->order_status_query} ) )
                                                        AND ( raffle.live_order = 1 ) 
                                                        AND ( raffle.deleted = 0 )
                                                        AND ( raffle.catid_one = {$this->raffle_id} ) ) 
                                                GROUP BY {$group_by}  );");

        }
 
        $query = null;
        if( $extra['product_sale'] === 1 ){
            $query = $this->db->get_results( $this->db->prepare(" SELECT *, SUM(raffle_total) AS sales, 
                                                                 MONTH( date_order ) as month_no,
                                                                 YEAR( date_order ) as year_no
                                                                 FROM RPR_REPORT_ONE
                                                                 WHERE ( (date_order BETWEEN %s AND %s) AND ( raffle_id = %d ))
                                                                 GROUP by month_no, year_no;", $from, $to, $this->raffle_id ));
        }else{                                         
            $query = $this->db->get_results( $this->db->prepare(" SELECT *, SUM(sale_total) AS sales, 
                                                                 MONTH( date_order ) as month_no,
                                                                 YEAR( date_order ) as year_no
                                                                 FROM RPR_REPORT_ONE
                                                                 WHERE ( ( date_order BETWEEN %s AND %s) AND ( raffle_id = %d) )
                                                                 GROUP by month_no, year_no;", $from, $to, $this->raffle_id ));
        }
        //get total   
        $total = 0;

        foreach( $query as $line ){
                $total += $line->sales;
        };    

        $total_arr = array(
            'date_order' => ' ',
            'sales' => $total
        );  

        $header = array(        
            esc_html__("Month", 'raffle-play-woo'),
            esc_html__("Total", 'raffle-play-woo')
        );

        $total_arr = (object)$total_arr;
        array_push( $query, $total_arr );
        $this->csv_report_by_month( $header, $query, $filename );       
    }

    private function csv_report_by_month( $header, $query, $filename ){

        $months_str = array(
            esc_html__('None', 'raffle-play-woo' ),
            esc_html__('January', 'raffle-play-woo' ),
            esc_html__('February', 'raffle-play-woo' ),
            esc_html__('March', 'raffle-play-woo' ),
            esc_html__('April', 'raffle-play-woo' ),
            esc_html__('May', 'raffle-play-woo' ),
            esc_html__('June', 'raffle-play-woo' ),
            esc_html__('July', 'raffle-play-woo' ),
            esc_html__('August', 'raffle-play-woo' ),
            esc_html__('September', 'raffle-play-woo' ),
            esc_html__('October', 'raffle-play-woo' ),
            esc_html__('November', 'raffle-play-woo' ),
            esc_html__('December', 'raffle-play-woo' )
        );
         
        $this->report_header( $filename );
        $wp_date_format = get_option('date_format');
        $table_data = $query;        
        // file creation 
        $file = fopen('php://output', 'w');
        $arr = array();
        fputcsv($file, $header);
        foreach ($table_data as $line ) {
            unset( $arr );
            $arr = array();

            if( isset( $line->month_no )){
                $m_no = intval( $line->month_no ); 

                if( isset( $line->year_no ) )               
                    $month_s = $months_str[ $m_no ] . ' ' . $line->year_no;
                else
                    $month_s = $months_str[ $m_no ];

                array_push( $arr, $month_s  );
            }else
                array_push( $arr, '' );

            $str = iconv('UTF-8', 'CP1252', $this->currency . $line->sales); 
            array_push( $arr, $str );
            fputcsv($file, $arr );
        }
        
        fclose($file);
        ob_end_flush();
        exit; 
    }

    //--------------------------------- region report -----------------------------------
    private function report_by_region( $from, $to, $filename, $extra ){
        global $countries;
        global $states;
        $header = array(
            esc_html__("Country", 'raffle-play-woo'), 
            esc_html__("County", 'raffle-play-woo'),
            esc_html__("Total", 'raffle-play-woo')
        );

        $group_by = " posts.id ";
        if( $extra['product_sale'] === 1  ){
            $group_by = " raffle.product_id, posts.id ";
        }
    
        $this->db->query( "DROP TEMPORARY TABLE if EXISTS RPR_REPORT_ONE;");

        if( ! OrderUtil::custom_orders_table_usage_is_enabled() ){ 
             
            $this->db->query( " CREATE TEMPORARY TABLE RPR_REPORT_ONE (
                                    SELECT posts.ID AS id, Date( posts.post_date ) AS date_order,  
                                    raffle.catid_one as raffle_id,   
                                    raffle.total_price as raffle_total, 
                                    raffle.product_id as prod_id,                                                
                                    MAX( CASE WHEN meta.meta_key='_order_total' THEN meta.meta_value END ) AS sale_total,
                                    MAX( CASE WHEN meta.meta_key='_billing_country' THEN meta.meta_value END ) AS country,
                                    MAX( CASE WHEN meta.meta_key='_billing_state' THEN meta.meta_value END ) AS county
                                    FROM {$this->posts_table} AS posts 
                                    INNER JOIN {$this->posts_meta_table} AS meta 
                                    ON posts.id = meta.post_id
                                    INNER JOIN {$this->tickets_tbl} as raffle 
                                    ON raffle.order_id = posts.id
                                    WHERE ( (posts.post_type = 'shop_order')                                                          
                                            AND ( raffle.live_order = 1) 
                                            AND ( raffle.deleted = 0)
                                            AND ( posts.post_status IN ( {$this->order_status_query}) )
                                            AND ( raffle.catid_one = {$this->raffle_id} )
                                                )
                                    GROUP BY {$group_by});");
        }else{

            $group_by = " orders.id, raffle.product_id ";   
            $this->db->query( " CREATE TEMPORARY TABLE RPR_REPORT_ONE (
                                    SELECT orders.id AS id, 
                                    Date( orders.date_created_gmt ) AS date_order,  
                                    raffle.catid_one as raffle_id,   
                                    raffle.total_price as raffle_total, 
                                    raffle.product_id as prod_id,                                                
                                    order_addr.country as country,
                                    order_addr.state as county,
                                    orders.total_amount AS sale_total
                                    FROM {$this->tickets_tbl} as raffle
                                    INNER JOIN {$this->wc_orders} as orders
                                    ON raffle.order_id = orders.id
                                    INNER join {$this->wc_order_addr} as order_addr
                                    ON orders.id = order_addr.order_id
                                    WHERE ( (orders.type = 'shop_order') 
                                            AND ( orders.status IN ( {$this->order_status_query} ) )
                                            AND ( raffle.live_order = 1 ) 
                                            AND ( raffle.deleted = 0 )
                                            AND ( raffle.catid_one = {$this->raffle_id} ) ) 
                                    GROUP BY {$group_by}  );");

        }

        if( $extra['product_sale'] === 1 ){
            $query = $this->db->get_results( $this->db->prepare(" SELECT *, SUM(raffle_total) AS sales 
                                                    FROM RPR_REPORT_ONE 
                                                    WHERE ( date_order BETWEEN %s AND %s ) 
                                                    GROUP by country, county;", $from, $to )); 
        }else{                                         

            $query = $this->db->get_results( $this->db->prepare(" SELECT *, SUM(sale_total) AS sales 
                                                              FROM RPR_REPORT_ONE 
                                                              WHERE ( date_order BETWEEN %s AND %s ) 
                                                              GROUP by country, county;", $from, $to ));
        }
        //get total   
        $total = 0;
        try{    
            $countries_obj   = new WC_Countries();
            $countries       = $countries_obj->__get('countries');
            $states          = $countries_obj->__get('states');
            
            foreach( $query as $line ){
                $line->county  = isset($states[ $line->country ][ $line->county ] ) ? $states[ $line->country ][ $line->county ] : $line->county;  //translate code to string 
                $line->country = isset($countries[ $line->country ] ) ? $countries[ $line->country ] : $line->country; //translate code              
                $total += $line->sales;
            };    
        }catch(Exception $e){ } 

        $total_arr = array(
            'country' => '',
            'county' => '',
            'sales' => $total
        ); 
      

        $total_arr = (object)$total_arr;
        array_push( $query, $total_arr );

        $this->csv_report_by_region( $header, $query, $filename);
        
    }

    private function csv_report_by_region( $header, $query, $filename ){

        $this->report_header( $filename );
        $table_data = $query;

        // file creation 
        $file = fopen('php://output', 'w');
        $arr = array();
        fputcsv($file, $header);
        foreach ($table_data as $line ) {
            unset( $arr );
            $arr = array();
          
            $str = iconv('UTF-8', 'CP1252', $this->currency . $line->sales); 
            array_push( $arr, $line->country, $line->county, $str );
            fputcsv($file, $arr );
        }
        
        fclose($file);
        ob_end_flush();
        exit; 

    }

    //=================== end of region report ===============================
    //-------------------- sales by country ----------------------------------
    private function report_by_country( $from, $to, $filename, $extra ){
        global $countries;
        global $states;
        $header = array(
            esc_html__("Country", 'raffle-play-woo'), 
            esc_html__("County", 'raffle-play-woo'),
            esc_html__("Total", 'raffle-play-woo')
        );

        $group_by = " posts.id ";
        if( $extra['product_sale'] === 1  ){
            $group_by = " raffle.product_id, posts.id ";
        }

        $country_code_lower = "";
        $country_code_upper = "";

        if( $extra['country'] != ''){
            $country_code_lower = trim( strtolower( $extra['country'] ) );
            $country_code_upper = trim( strtoupper( $extra['country'] ) );
        }       

        $this->db->query( "DROP TEMPORARY TABLE if EXISTS RPR_REPORT_FIVE;");

        if( ! OrderUtil::custom_orders_table_usage_is_enabled() ){ 
           
            $this->db->query( $this->db->prepare( 
                                    "CREATE TEMPORARY TABLE RPR_REPORT_FIVE (
                                    SELECT posts.ID AS id,
                                    Date( posts.post_date ) AS date_order,    
                                    raffle.catid_one as raffle_id,   
                                    raffle.total_price as raffle_total, 
                                    raffle.product_id as prod_id,                                          
                                    MAX( CASE WHEN meta.meta_key='_order_total' THEN meta.meta_value END ) AS sale_total,
                                    MAX( CASE WHEN meta.meta_key='_billing_country' THEN meta.meta_value END ) AS country,
                                    MAX( CASE WHEN meta.meta_key='_billing_state' THEN meta.meta_value END ) AS county
                                    FROM {$this->posts_table} AS posts 
                                    INNER JOIN {$this->posts_meta_table} AS meta 
                                    ON posts.id = meta.post_id
                                    INNER JOIN {$this->tickets_tbl} as raffle 
                                    ON raffle.order_id = posts.id
                                    WHERE (     ( posts.post_type = 'shop_order' ) 
                                            AND ( raffle.live_order = 1 )
                                            AND ( raffle.deleted = 0)
                                            AND ( posts.post_status IN ( {$this->order_status_query}) ) 
                                            AND ( posts.post_date BETWEEN %s and %s )
                                            AND ( raffle.catid_one = {$this->raffle_id} )
                                            )
                                    GROUP BY {$group_by});", $from, $to ));
        }else{
           
            $group_by = " orders.id, raffle.product_id ";  
            $this->db->query( $this->db->prepare( 
                                    "CREATE TEMPORARY TABLE RPR_REPORT_FIVE (
                                    SELECT orders.id AS id, 
                                    Date( orders.date_created_gmt ) AS date_order,    
                                    raffle.catid_one as raffle_id,   
                                    raffle.total_price as raffle_total, 
                                    raffle.product_id as prod_id,                                          
                                    order_addr.country as country,
                                    order_addr.state as county,
                                    orders.total_amount AS sale_total
                                    FROM {$this->tickets_tbl} as raffle
                                    INNER JOIN {$this->wc_orders} as orders
                                    ON raffle.order_id = orders.id
                                    INNER join {$this->wc_order_addr} as order_addr
                                    ON orders.id = order_addr.order_id
                                    WHERE ( (orders.type = 'shop_order') 
                                            AND ( orders.status IN ( {$this->order_status_query} ) )
                                            AND ( raffle.live_order = 1 ) 
                                            AND ( orders.date_created_gmt BETWEEN %s and %s )
                                            AND ( raffle.deleted = 0 )
                                            AND ( raffle.catid_one = {$this->raffle_id} ) ) 
                                    GROUP BY {$group_by}  );", $from, $to ));
        }

        $query = array();
        $query_others = array();                                                    
        if( $extra['product_sale'] === 1 ){

            $query = $this->db->get_results( $this->db->prepare( "SELECT *, SUM(raffle_total) AS sales 
                                                FROM RPR_REPORT_FIVE 
                                                WHERE ( country IN ( %s, %s ) )                                                         
                                                GROUP by county;", $country_code_lower, $country_code_upper ) );
                      


            if( $extra['group_country'] === 1){
                $query_others =  $this->db->get_results( $this->db->prepare( "SELECT *, SUM(raffle_total) AS sales 
                                    FROM RPR_REPORT_FIVE 
                                    WHERE ( country NOT IN ( %s, %s ) )                                                             
                                    GROUP by country", $country_code_lower, $country_code_upper ));  
            }
        
        }else{

            $query = $this->db->get_results( $this->db->prepare( "SELECT *, SUM(sale_total) AS sales 
                                          FROM RPR_REPORT_FIVE 
                                          WHERE ( country IN ( %s, %s ) )                                                              
                                          GROUP by county;", $country_code_lower, $country_code_upper ) );
                                                    

            if( $extra['group_country'] === 1){
                $query_others =  $this->db->get_results( $this->db->prepare( "SELECT *, SUM(sale_total) AS sales 
                                                  FROM RPR_REPORT_FIVE 
                                                  WHERE ( country NOT IN ( %s, %s )  )                                                              
                                                  GROUP by country", $country_code_lower, $country_code_upper ));  
            }
        }                                                 

        //get total 

        $total = 0;
        try{    
            $countries_obj   = new WC_Countries();
            $countries       = $countries_obj->__get('countries');
            $states          = $countries_obj->__get('states');
            
            foreach( $query as $line ){
                $line->county  = isset($states[ $line->country ][ $line->county ] ) ? $states[ $line->country ][ $line->county ] : $line->county;  //translate code to string 
                $line->country = isset($countries[ $line->country ] ) ? $countries[ $line->country ] : $line->country; //translate code              
                $total += $line->sales;
            }; 
            
            foreach( $query_others as $line ){                
                $line->country = isset($countries[ $line->country ] ) ? $countries[ $line->country ] : $line->country; //translate code                          
                $total += $line->sales; 
            }

        }catch(Exception $e){ } 

        $total_arr = array(
            'country' => '',
            'county' => '',
            'sales' => $total
        ); 
      
  
        $total_arr = (object)$total_arr;
        array_push( $query_others, $total_arr );

        $this->csv_report_by_country( $header, $query, $query_others, $filename);

    }

    private function csv_report_by_country( $header, $query, $query_others, $filename ){
        $this->report_header( $filename );
        $table_data = $query;

        // file creation 
        $file = fopen('php://output', 'w');
        $arr = array();
        fputcsv($file, $header);
        foreach ($table_data as $line ) {
            unset( $arr );
            $arr = array();
          
            $str = iconv('UTF-8', 'CP1252', $this->currency . $line->sales); 
            array_push( $arr, $line->country, $line->county, $str );
            fputcsv($file, $arr );
        }

        foreach( $query_others as $line ){
            unset( $arr );
            $arr = array();
            $str = iconv('UTF-8', 'CP1252', $this->currency . $line->sales); 
            array_push( $arr, $line->country, $line->country, $str );
            fputcsv($file, $arr );
        }
        
        fclose($file);
        ob_end_flush();
        exit;   
    }
    //===================== end of sales by country ===========================

    //------------------- start report_by_product  ----------------------------
    private function report_by_product( $from, $to, $filename, $extra ){

        $header = array(
            esc_html__("Product Name", 'raffle-play-woo'), 
            esc_html__("Total", 'raffle-play-woo') );


        $group_by = " raffle.product_id, posts.id ";
       
        $this->db->query( "DROP TEMPORARY TABLE if EXISTS RPR_REPORT_PRODUCT;");

        if( ! OrderUtil::custom_orders_table_usage_is_enabled() ){ 
            $this->db->query( " CREATE TEMPORARY TABLE RPR_REPORT_PRODUCT
                                                SELECT posts.ID AS id, 
                                                raffle.product_id as product_id, 
                                                raffle.ticket as ticket_no,
                                                raffle.catid_one as raffle_id,
                                                Date( posts.post_date ) AS date_order,
                                                raffle.total_price as raffle_total, 
                                                MAX( CASE WHEN meta.meta_key='_order_total' THEN meta.meta_value END ) AS sale_total
                                                FROM {$this->posts_table} AS posts 
                                                INNER JOIN {$this->posts_meta_table} AS meta 
                                                ON posts.id = meta.post_id
                                                inner JOIN {$this->tickets_tbl} as raffle 
                                                ON posts.id = raffle.order_id
                                                WHERE ( (posts.post_type = 'shop_order')
                                                    AND ( raffle.live_order = 1 )
                                                    AND ( raffle.deleted = 0)
                                                    AND ( posts.post_status IN ( {$this->order_status_query} )) 
                                                    AND ( raffle.catid_one = {$this->raffle_id} )
                                                    )
                                                GROUP BY {$group_by}");
        }else{
            $group_by = " orders.id, raffle.product_id ";  
            $this->db->query( " CREATE TEMPORARY TABLE RPR_REPORT_PRODUCT
                                                SELECT orders.id AS id, 
                                                raffle.product_id as product_id, 
                                                raffle.ticket as ticket_no,
                                                raffle.catid_one as raffle_id,
                                                Date( orders.date_created_gmt ) AS date_order,
                                                raffle.total_price as raffle_total, 
                                                orders.total_amount AS sale_total
                                                FROM {$this->tickets_tbl} as raffle
                                                INNER JOIN {$this->wc_orders} as orders
                                                ON raffle.order_id = orders.id
                                                WHERE ( (orders.type = 'shop_order') 
                                                        AND ( orders.status IN ( {$this->order_status_query} ) )
                                                        AND (raffle.live_order = 1) 
                                                        AND (raffle.deleted = 0)
                                                        AND (raffle.catid_one = {$this->raffle_id} ) 
                                                      ) 
                                                GROUP BY {$group_by};");
 

        }

        if( $extra['product_sale'] === 1 ){
            $query = $this->db->get_results( $this->db->prepare(" SELECT *, sum( raffle_total ) AS sales,
                                                            (SELECT post_title FROM $this->posts_table WHERE Id = product_id) AS product_name
                                                            FROM RPR_REPORT_PRODUCT 
                                                            WHERE 
                                                            (date_order BETWEEN %s AND %s)                                                          
                                                            GROUP BY product_id;", $from, $to ));
        }else{
            $query = $this->db->get_results( $this->db->prepare(" SELECT *, sum( sale_total ) AS sales,
                                                            (SELECT post_title 
                                                                FROM $this->posts_table  
                                                                WHERE id = product_id) AS product_name
                                                            FROM RPR_REPORT_PRODUCT 
                                                            WHERE 
                                                            (date_order BETWEEN %s AND %s)                                                            
                                                            GROUP BY product_id;", $from, $to ));
        }


        //get total           
        $total = 0;
        try{                
            foreach( $query as $line ){            
                $total += $line->sales;
            };    
        }catch(Exception $e){ } 

        $total_arr = array(
            'product_name' => '',
            'sales' => $total
        ); 
 
        $total_arr = (object)$total_arr;
        array_push( $query, $total_arr );

        $this->csv_report_by_product_name( $header, $query, $filename);
    
    }

    private function csv_report_by_product_name( $header, $query, $filename ){
        $this->report_header( $filename );
        $table_data = $query;

        // file creation 
        $file = fopen('php://output', 'w');
        $arr = array();
        fputcsv($file, $header);
        foreach ($table_data as $line ) {
            unset( $arr );
            $arr = array();
           
            $str = iconv('UTF-8', 'CP1252', $this->currency . $line->sales); 
            array_push( $arr, $line->product_name, $str );
            fputcsv($file, $arr );
        }
        
        fclose($file);
        ob_end_flush();

        exit; 
    }

    //======================== end of report_product_name ================================
    //-------------------------- report by raffle ticket ---------------------------------
    private function report_by_raffle_ticket( $from, $to, $filename, $cols_info ){

        $cols_text = array(
            'ticket_no'     => esc_html__('Raffle Ticket No', 'raffle-play-woo'),
            'order_id'      => esc_html__('Order No', 'raffle-play-woo'),
            'first_name'    => esc_html__('First Name', 'raffle-play-woo'),
            'last_name'     => esc_html__('Last Name', 'raffle-play-woo'),
            'address_one'   => esc_html__('Address One', 'raffle-play-woo'),
            'address_two'   => esc_html__('Address Two', 'raffle-play-woo'),
            'city'          => esc_html__('City', 'raffle-play-woo'),
            'post_code'     => esc_html__('Post Code', 'raffle-play-woo'),
            'country'       => esc_html__('Country', 'raffle-play-woo'),
            'county'        => esc_html__('County', 'raffle-play-woo'),
            'email'         => esc_html__('Email', 'raffle-play-woo'),
            'phone'         => esc_html__('Phone', 'raffle-play-woo'),
            'order_total'   => esc_html__('Order Total', 'raffle-play-woo'),
            'order_status'  => esc_html__('Order Status', 'raffle-play-woo'),
            'order_date'    => esc_html__('Order Date', 'raffle-play-woo')
        );
        
        $default_metadata = array(
            '_billing_first_name',
            '_billing_last_name',
            '_billing_address_1',
            '_billing_address_2',
            '_billing_city',
            '_billing_postcode',
            '_billing_country',
            '_billing_state',
            '_billing_email',
            '_billing_phone',
            'order_id',
            'order_status',
            'order_date',
            'ticket_no'
        );

        $header = array();
        $col_info_arr = json_decode( stripslashes( $cols_info['custom_cols'] ) );       
    
        $extra_fields = '';
        foreach(  $col_info_arr as $col ){
            array_push( $header, esc_html( $col->text ) );
            if( ( $col->custom == 1) && ( ! isset( $default_metadata[ $col->name ] ) ) ){
                $col_name = esc_sql( $col->name );
                $extra_fields .= " MAX(CASE WHEN meta_key='{$col_name}' THEN meta_value END)  AS {$col_name}, ";
            }
        }

        $sale_total = "  MAX(CASE WHEN meta.meta_key='_order_total' THEN meta.meta_value END ) AS order_total, ";

        if( $cols_info['product_sale'] == 1 )
            $sale_total = " tickets.total_price as order_total, ";

        $this->db->query( "DROP TEMPORARY TABLE if EXISTS RPR_REPORT_ONE;");

        if( ! OrderUtil::custom_orders_table_usage_is_enabled() ){ 

            if( $cols_info['tickets_group'] === true ){
                $view_order_tickets = " ( SELECT group_concat( t.ticket SEPARATOR ', ' ) from {$this->tickets_tbl} AS t WHERE ((t.order_id = posts.id ) AND ( t.catid_one = {$this->raffle_id} )) )  as ticket_no, ";
                $group_by = 'tickets.order_id';
            }else{
                $view_order_tickets = " tickets.ticket as ticket_no,";
                $group_by = 'tickets.id';
            }            

            $this->db->query( $this->db->prepare( " CREATE TEMPORARY TABLE RPR_REPORT_ONE
                                                SELECT 
                                                {$view_order_tickets}
                                                posts.ID AS order_id, 
                                                posts.post_status AS order_status,
                                                posts.post_date AS order_date,
                                                {$sale_total}
                                                {$extra_fields}
                                                MAX(CASE WHEN meta_key='_billing_first_name' THEN meta_value END)  AS first_name,
                                                MAX(CASE WHEN meta_key='_billing_last_name' THEN meta_value END) AS last_name,
                                                MAX(CASE WHEN meta_key='_billing_address_1' THEN meta_value END) AS address_one,
                                                MAX(CASE WHEN meta_key='_billing_address_2' THEN meta_value END) AS address_two,
                                                MAX(CASE WHEN meta_key='_billing_city' THEN meta_value END) AS city,
                                                MAX(CASE WHEN meta_key='_billing_postcode' THEN meta_value END) AS post_code,
                                                MAX(CASE WHEN meta_key='_billing_country' THEN meta_value END) AS country,
                                                MAX(CASE WHEN meta_key='_billing_state' THEN meta_value END) AS county,
                                                MAX(CASE WHEN meta_key='_billing_email' THEN meta_value END) AS email ,
                                                MAX(CASE WHEN meta_key='_billing_phone' THEN meta_value END) AS phone                                                                                             
                                                FROM {$this->tickets_tbl} as tickets
                                                left outer JOIN {$this->posts_table} as posts
                                                ON tickets.order_id = posts.id
                                                INNER join {$this->posts_meta_table} as meta
                                                ON posts.id = meta.post_id
                                                WHERE ( (posts.post_type = 'shop_order')
                                                  AND ( posts.post_status IN ( {$this->order_status_query} ))
                                                  AND ( Date( posts.post_date ) BETWEEN %s AND %s )
                                                  AND ( tickets.catid_one = %d) ) 
                                                  AND ( tickets.deleted = 0)
                                                  AND ( tickets.live_order = 1 ) 
                                                GROUP BY $group_by;", $from, $to, $this->raffle_id ));
        }else{
          
            $sale_total = " orders.total_amount AS order_total, ";

            if( $cols_info['product_sale'] == 1 )
                $sale_total = " tickets.total_price as order_total, ";

            if( $cols_info['tickets_group'] === true ){
                $view_order_tickets = " ( SELECT group_concat( t.ticket SEPARATOR ', ' ) from {$this->tickets_tbl} AS t WHERE ((t.order_id = orders.id ) AND ( t.catid_one = {$this->raffle_id} )) )  as ticket_no, ";
                $group_by = 'tickets.order_id';
            }else{
                $view_order_tickets = " tickets.ticket as ticket_no,";
                $group_by = 'tickets.id';
            }    

            $this->db->query( $this->db->prepare( " CREATE TEMPORARY TABLE RPR_REPORT_ONE
                                                SELECT 
                                                {$view_order_tickets}
                                                orders.id AS order_id, 
                                                orders.status AS order_status,                                               
                                                orders.date_created_gmt AS order_date,                                               
                                                {$sale_total}
                                                {$extra_fields}
                                                orders.billing_email as email,  
                                                order_addr.first_name as first_name,
                                                order_addr.last_name as last_name,
                                                order_addr.address_1 as address_one,
                                                order_addr.address_2 as address_two,
                                                order_addr.city as city,
                                                order_addr.postcode as post_code,
                                                order_addr.country as country,
                                                order_addr.state as county,
                                                order_addr.phone as phone                                              
                                                FROM {$this->tickets_tbl} as tickets
                                                INNER JOIN  {$this->wc_orders}  as orders                                               
                                                ON tickets.order_id = orders.id
                                                INNER join {$this->wc_order_addr} as order_addr
                                                ON orders.id = order_addr.order_id
                                                LEFT OUTER JOIN {$this->posts_meta_table} as meta
                                                ON orders.id = meta.post_id
                                                WHERE ( (orders.type = 'shop_order')  
                                                        AND ( orders.status IN ( {$this->order_status_query} ))
                                                        AND ( Date( orders.date_created_gmt ) BETWEEN %s AND %s ) 
                                                        AND ( tickets.live_order = 1 ) 
                                                        AND ( tickets.deleted = 0)
                                                        AND ( tickets.catid_one = %d ) 
                                                    )  
                                                GROUP BY {$group_by} ORDER BY order_id ASC;", 
                                                $from, $to,  $this->raffle_id  ));


        }

        $query = $this->db->get_results( "SELECT * FROM RPR_REPORT_ONE;");
                                         

        $this->csv_report_by_raffle_ticket( $header, $query, $filename, $col_info_arr,  );
    }

    private function csv_report_by_raffle_ticket( $header, $query, $filename, $cols){
        $this->report_header( $filename );
        $table_data = $query;

        // file creation 
        $file = fopen('php://output', 'w');

        $countries_obj   = new WC_Countries();
        $countries       = $countries_obj->__get('countries');
        $states          = $countries_obj->__get('states');
        $order_status    = wc_get_order_statuses();

        fputcsv($file, $header);
        foreach ($table_data as $line ) {
            $arr_values = array();

            foreach( $cols as $col ){
            
                if( property_exists( $line, $col->name )){
                    $value = '';
                    if( $col->name == 'county'){
                        $value = isset($states[ $line->country ][ $line->county ] ) ? $states[ $line->country ][ $line->county ] : $line->county;  //translate code to string      
                    }else if( $col->name == 'country'){
                        $value = isset($countries[ $line->country ] ) ? $countries[ $line->country ] : $line->country; //translate code  
                    }else if ( $col->name == 'order_total'){
                        $value = iconv('UTF-8', 'CP1252', $this->currency . $line->order_total);    
                    }else if ( $col->name == 'order_status'){
                        $value = $order_status[ $line->order_status ];
                    }else{
                        $col_name = $col->name;                     
                        $value = $line->$col_name;
                    }
                    array_push( $arr_values, $value );
                }
            }

            fputcsv($file, $arr_values );
        }
        
        fclose($file);
        ob_end_flush();

        exit; 

    }

    //======================   end of report by raffle ticket ==============================

    private function report_header(  $filename ){
        // file name 
        ob_end_clean();      
        header("Content-Description: File Transfer");
        header("Content-Disposition: attachment; filename=$filename");
        header("Content-Type: application/csv; charset=UTF-8");
        header("Expires: 0" );
        header("Pragma: public");               
    }
    
}

?>