<?php

if( ! defined( 'ABSPATH') ){ die('No access to this page'); }

include_once( 'd/D_RafflePlayWoo_Main.php');

class RafflePlayWoo_RaffleProduct{
    private $id;
    private $is_live;
    private $name;
    private $is_terminated;
    private $start_ticket;
    private $last_purchased;
    private $is_limit;
    private $limit_no;
    private $prefix;
    private $start_datetime;
    private $end_datetime;
    private $total_purchased;
    private $email_extra_line;
    private $extra_line_in;
    private $shortcode;
    private $deleted;
    private $products;

    private $extra_info;
    private $loaded_extra;

    private $email_line_one;
    private $email_line_two;
    private $email_pos;
    private $inc_name;

    private $msg_terminated;
    private $msg_not_started;
    private $msg_has_ended;
    private $msg_none_left;
    private $msg_add_ex;
    private $msg_update_ex;
    private $msg_will_enddate;  

    private $wp_date_format;
    private $wp_time_format;

    private $gen_random_tickets;

    private $test_ticket;
    private $test_start_ticket;
    private $db_obj;

    private $extra_settings;
    private $leading_zeros;
    private $leading_zeros_index;

    private $buyout;
    private $buyout_product;

    private $cd_active_index;
    private $cd_active_card_index;

    private $pb_active_index;
    private $pb_active_card_index;

    public function __construct(){
        $this->id               = null;
        $this->name             = '';
        $this->is_live          = true;
        $this->is_terminated    = false;
        $this->start_ticket     = 0;
        $this->last_purchased   = 0;
        $this->is_limit         = false;
        $this->limit_no         = 0;
        $this->prefix           = 'Ticket-';
        $this->start_datetime   = 0;        
        $this->end_datetime     = 0; //strtotime( '2099-01-01' );
        $this->total_purchased  = 0;
        $this->email_extra_line = '';
        $this->shortcode        = '';
        $this->deleted          = false;
        $this->products         = array();
        $this->extra_line_in    = false;
        $this->extra_settings   = array( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 );
        $this->leading_zeros    = 0;
        $this->leading_zeros_index = 0;

        $this->extra_info       = array();

        $this->loaded_extra     = false;
        $this->email_line_one   = '';
        $this->email_line_two   = '';
        $this->email_pos        = 2;
        
        $this->msg_terminated       = '';
        $this->msg_not_started      = '';
        $this->msg_has_ended        = '';
        $this->msg_none_left        = '';
        $this->msg_add_ex           = '';
        $this->msg_update_ex        = '';
        $this->msg_will_enddate     = '';

        $this->wp_date_format       = '';    
        $this->wp_time_format       = '';  

        $this->test_ticket          = 8888000;  
        
        $this->inc_name             = false;
        $this->buyout               = false;
        $this->buyout_product       = -1;
        $this->gen_random_tickets   = false;

        $this->cd_active_index       = 1;
        $this->cd_active_card_index  = 2;
        $this->pb_active_index       = 3;
        $this->pb_active_card_index  = 4;

        $this->db_obj = new RafflePlayWoo_RaffleTbl();     
    }

    function get_id(){ return $this->id; }
    function set_id( $id ){ $this->id = $id; }
    function get_is_live(){ return true; }
    function set_is_live( $value ){ $this->is_live = true; }
    function get_name(){ return $this->name; }
    function set_name( $value ){ $this->name = $value;}
    function get_is_terminated(){ return $this->is_terminated; }
    function set_is_terminated( $value ){ $this->is_terminated = ( $value === 1 ) || ( $value == true ); }
    function get_start_ticket(){  
        if( ! $this->is_live )
            return $this->test_ticket;
        else
            return $this->start_ticket;
    }

    function set_countdownActive( $value ){ 
        $this->extra_settings[ $this->cd_active_index] = $value;
    }
    function get_countdownActive(){ 
        return $this->extra_settings[ $this->cd_active_index ]; 
    }

    function set_countdownActiveCard( $value ){ 
        $this->extra_settings[ $this->cd_active_card_index] = $value;
    }
    function get_countdownActiveCard(){ 
        return $this->extra_settings[ $this->cd_active_card_index ]; 
    }

    function set_progressActive( $value ){ 
        $this->extra_settings[ $this->pb_active_index] = $value;
    }
    function get_progressActive(){ 
        return $this->extra_settings[ $this->pb_active_index ]; 
    }

    function set_progressActiveCard( $value ){ 
        $this->extra_settings[ $this->pb_active_card_index] = $value;
    }
    function get_progressActiveCard(){ 
        return $this->extra_settings[ $this->pb_active_card_index ]; 
    }

    function set_start_ticket( $value ){ $this->start_ticket = $value; }
    function get_test_ticket(){ return $this->test_ticket;}
    function set_test_ticket( $value ){ $this->test_ticket = intval( $value ); }
    function set_last_purchased( $value ){ $this->last_purchased = intval( $value ); }
    function get_is_limit(){ return $this->is_limit; }
    function set_is_limit( $value ){ $this->is_limit = ($value === 1) || ( $value == true ); }
    function get_limit_no(){ return $this->limit_no; }
    function set_limit_no( $value ){ $this->limit_no = $value; }
    function get_prefix(){ return $this->prefix; }
    function set_prefix( $value ){ $this->prefix = $value;}    
    function get_start_datetime(){ return $this->start_datetime; }
    function set_startDateTime($new_value ){ $this->start_datetime = $new_value; }
    function set_start_datetime( $start_date, $time ){ 
        if( $time == '' )
            $time = '00:00';

        if( $start_date != '' ){
            $start_date = $start_date . ' ' . $time;
            $date_b = DateTime::createFromFormat('d-m-Y H:i', $start_date )->format('Y-m-d H:i');   
            $start_date = strtotime( $start_date );        
        }else{
            $start_date = 0;
        } 

        $this->start_datetime = $start_date;     
    }

    function set_extraSettings( $vals ){
        if( trim( $vals ) != '' ){
            $this->extra_settings = explode( ',', $vals );         
        }else{
            $this->extra_settings =  array( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 );
        }
    }

    function get_extraSettings(){
        return $this->extra_settings;
    }

    function get_leadingZeros(){      
        return $this->extra_settings[ $this->leading_zeros_index ];
    }

    function set_leadingZeros( $no ){
        $this->extra_settings[ $this->leading_zeros_index ] = $no;
        $this->leading_zeros = $no;
    }

    function get_startTimeAsString(){
        if( ($this->start_datetime == 0) || ($this->start_datetime == '') )
            return '';
        else{
            $date = date('H:i', $this->start_datetime );
            return $date;
        }
    }
    function get_end_datetime(){ return $this->end_datetime; }
    function set_endDateTime( $new_value ){ $this->end_datetime = $new_value; }
    function set_end_datetime( $end_date, $time ){
        if( $time == '' )
            $time = '23:59';

        if( $end_date != '' ){
            $end_date .= ' ' . $time;
            $date_b = DateTime::createFromFormat('d-m-Y H:i', $end_date )->format('Y-m-d H:i');   
            $end_date = strtotime( $date_b );
        }else{
            $end_date = 0;
        }
        
        $this->end_datetime = $end_date;
    }
    function get_endTimeAsString(){
        if( ($this->end_datetime == 0) || ($this->end_datetime == '') )
            return '';
        else{
            $date = date( 'H:i', $this->end_datetime );
            return  $date;
        }
    }
    function get_total_purchased(){ return $this->total_purchased; }
    function set_total_purchased( $value ){ $this->total_purchased = $value; }
    function get_email_extra_line(){ return $this->email_extra_line; }
    function set_email_extra_line( $value ){ $this->email_extra_line = $value;} 
    function get_extra_line_in(){ return $this->extra_line_in; }
    function set_extra_line_in( $value ){ $this->extra_line_in = ( $value === 1 ) || ( $value == true );}  
    function get_shortcode(){ return $this->shortcode; }
    function set_shortcode(){
         $this->shortcode = "[raffle name='msg' id='{$this->id}']";
    }  
    function get_deleted(){ return $this->deleted; }
    function set_deleted( $value ){ $this->deleted = ($value === 1) || ( $value == true); }
    function add_product( $value ){$this->products = $value;}
    function get_extra_info(){ return $this->extra_info; }
    function set_extra_info( $value ){ $this->extra_info = $value; }
    function add_item_extra( $value ){ array_push( $this->extra_info, $value ); }

    function loaded_extra(){return $this->loaded_extra; }
    function get_msg_email_line_one(){ return $this->email_line_one; }
    function get_msg_email_line_two(){ return $this->email_line_two; }
    function get_email_pos(){ return $this->email_pos; }

    function get_msg_terminated(){ return $this->msg_terminated; }
    function get_msg_not_started(){ return $this->msg_not_started; }
    function get_msg_has_ended(){ return $this->msg_has_ended; }
    function get_msg_none_left(){ return $this->msg_none_left; }
    function get_msg_will_enddate(){ return $this->msg_will_enddate; }

    function get_inc_name(){ return $this->inc_name;}
    function set_inc_name( $value ){ $this->inc_name = $value; }

    function set_buyout( $value ){ $this->buyout = $value; }
    function get_buyout(){ return $this->buyout; }

    function set_buyout_product( $value ){ $this->buyout_product = $value; }
    function get_buyout_product(){ return $this->buyout_product; }

    function get_msg_add_ex( $ex ){ 

        $msg  = sprintf( $this->msg_add_ex, $ex );
        $msg = stripslashes( esc_html__( $msg, 'raffle-play-woo' )  ); 

        return $msg;
    }

    function get_msg_update_ex( $ex){ 

        $msg  = sprintf( $this->msg_update_ex, $ex );
        $msg = stripslashes( esc_html__( $msg, 'raffle-play-woo' )  ); 

        return $msg;
    }

    function is_live(){
        return $this->is_live;
    }

    function is_valid_dates( &$msg ){

        $now_time = current_time('timestamp');
        $result = true;

        if( $this->start_datetime > $now_time ){
            $result = false;
            if( $this->loaded_extra ){

                $msg = sprintf( $this->msg_not_started, date( $this->wp_date_format . ' ' . $this->wp_time_format, $this->start_datetime ) ); 

                $msg = stripslashes( esc_html__( $msg, 'raffle-play-woo' )  ); 
            }
        }else if( ($this->end_datetime != 0) && ( $this->end_datetime < $now_time ) ){
            $result = false;
            if( $this->loaded_extra ){

                $msg  = sprintf( $this->msg_has_ended, date( $this->wp_date_format . ' ' . $this->wp_time_format, $this->end_datetime ) );

                $msg = stripslashes( esc_html__( $msg, 'raffle-play-woo' )  );  
            }
        }

        return $result;
    }

    function is_limited(){
        return $this->is_limit;
    }

    function get_will_enddate(){
        $msg = '';
        if( $this->loaded_extra){
            $msg  = sprintf( $this->msg_will_enddate, date( $this->wp_date_format . ' ' . $this->wp_time_format, $this->end_datetime ) ); 
            $msg = stripslashes( esc_html__( $msg, 'raffle-play-woo' )  );  
        }

        return $msg;
    }

    function get_last_purchased( $is_live ){

       
        $last_sold = $this->db_obj->getLastSoldTicket( $this->id, $is_live );
        //get the max ticket       

        if( ( $last_sold == 0 ) && ( ! $is_live ) ){
            $last_sold = $this->test_ticket;
        }
        
        if( $last_sold != 0 )
            $max_ticket = max( $last_sold, $this->last_purchased, $this->start_ticket );
        else
            $max_ticket = $this->start_ticket;
        

        return $max_ticket;
        
    }

    function is_terminated( &$msg = '' ){
        if( $this->is_terminated ){
            $msg = $this->msg_terminated;
            return true;
        }else{
            return false;
        }
    }

    function set_genRandomTickets( $val ){
        $this->gen_random_tickets = $val;        
    }

    function get_genRandomTickets(){ return $this->gen_random_tickets; }

    function load_extra( $extra = array() ){

        if( ! $this->loaded_extra ){ //load the extra

            $this->loaded_extra = true;

            $this->email_line_one       = $extra['email_line_one'];
            $this->email_line_two       = $extra['email_line_two'];
            $this->email_pos            = $extra['email_pos'];
            $this->msg_terminated       = $extra['msg_terminated'];
            $this->msg_not_started      = $extra['msg_not_started'];
            $this->msg_has_ended        = $extra['msg_has_ended'];
            $this->msg_none_left        = $extra['msg_none_left'];
            $this->msg_add_ex           = $extra['msg_add_ex'];
            $this->msg_update_ex        = $extra['msg_update_ex'];
            $this->wp_date_format       = $extra['wp_date_format'];
            $this->wp_time_format       = $extra['wp_time_format']; 
            $this->inc_name             = $extra['inc_name'];  
            $this->msg_will_enddate     = $extra['msg_will_enddate'];     

            $this->extra_info           = $extra;            
        }
    }

    function delete_raffle( $raffle_id ){
        
        $result = array();
        $result['tickets'] = $this->db_obj->deleteAllTickets( $raffle_id );
        $result['raffle']  = $this->db_obj->deleteRaffle( $raffle_id );
        $result['products'] = $this->db_obj->deleteRaffleProducts( $raffle_id );


        if( ! $result['tickets'] ){
            $result['tickets'] =  esc_html__('Could not remove tickets for this raffle', 'raffle-play-woo');
        }

        if( ! $result['raffle'] ){
            $result['raffle'] =  esc_html__('Could not remove raffle data', 'raffle-play-woo');
        }

        if( ! $result['products'] ){
            $result['products'] =  esc_html__('Could not remove products linked to this raffle', 'raffle-play-woo');
        }

        if( $result['tickets'] && $result['raffle'] && $result['products']){
            $result = true;
        }


        return $result;
    }

    function get_start_date_asString(){
        if( $this->start_datetime == 0 )
            return '';
        else
            return date('d-m-Y', $this->start_datetime );
        
    }

    function get_start_datetime_asString(){
        if( $this->start_datetime == 0 )
            return '';
        else
            return date('d-m-Y H:i', $this->start_datetime  );
        
    }

    function get_end_date_asString(){
        if( $this->end_datetime == 0 )
            return '';
        else
            return date('d-m-Y', $this->end_datetime );
    }

    function get_end_datetime_asString(){
        if( $this->end_datetime == 0 )
            return '';
        else
            return date('d-m-Y H:i', $this->end_datetime );
    }

    public function raffle_as_array(){
        $this->set_shortcode();
        $now_time = current_time('timestamp');
        $arr = array(
            'id'                => $this->id,
            'is_live'           => $this->is_live,
            'name'              => $this->name,
            'is_terminated'     => $this->is_terminated,
            'start_ticket'      => $this->start_ticket,
            'last_purchased'    => $this->last_purchased,
            'is_limit'          => $this->is_limit,
            'limit_no'          => $this->limit_no,
            'prefix'            => $this->prefix,
            'start_datetime'    => $this->start_datetime,
            'start_date_str'    => $this->get_start_date_asString(),
            'end_datetime'      => $this->end_datetime,
            'end_date_str'      => $this->get_end_date_asString(),
            'purchased'         => $this->total_purchased,
            'email_extra_line'  => $this->email_extra_line,
            'extra_line_in'     => $this->extra_line_in,
            'total_purchased'   => $this->total_purchased,
            'shortcode'         => $this->shortcode,
            'deleted'           => $this->deleted,
            'products'          => $this->products,
            'extra_info'        => $this->extra_info,
            'start_timestr'     => $this->get_startTimeAsString(),
            'end_timestr'       => $this->get_endTimeAsString(),
            'now_time'          => $now_time,
            'buyout'            => $this->buyout,
            'buyout_product'    => $this->buyout_product,
            'gen_random_tickets' => $this->gen_random_tickets,
            'leading_zeros'     => $this->get_leadingZeros(),
            'extra_settings'    => implode(',', $this->extra_settings ),
            'countdown_active'  => $this->get_countdownActive(),
            'countdown_active_card' => $this->get_countdownActiveCard(),
            'pb_active'         => $this->get_progressActive(),
            'pb_active_card'    => $this->get_progressActiveCard()
        );

        return $arr;
    }

    public function raffle_as_json(){
        return json_encode( $this->raffle_as_array() );
    }

    public function raffle_id_as_array(){
        $arr = array(
            $this->id => $this->raffle_as_array()
        );

        return $arr;
    }    

    public function save_raffle(){
       
        $obj_as_array = $this->raffle_as_array();
     
        if( $this->id === -1 ){ //new raffle
            $this->db_obj->saveNewRaffle( $obj_as_array );
        }else{ //edit raffle
            $this->db_obj->updateRaffle( $obj_as_array );
        }
    }

    public function get_no_sold_tickets( ){
    
        $tickets_sold = $this->db_obj->getRaffleSoldTickets( $this->id );
        return $tickets_sold;        
    }

    public function get_LastRaffleId(){
        return $this->db_obj->getLastRaffleId();
    }

}

class RafflePlayWoo_RaffleProductList{
    private $list_raffle;
    private $db_obj;

    public function __construct(){
        $this->list_raffle = array();
        $this->db_obj = new RafflePlayWoo_RaffleTbl();
    }

    private function set_raffle( $obj ){

        $new_raffle = new RafflePlayWoo_RaffleProduct();

        $new_raffle->set_id( $obj->raffle_id );
        $new_raffle->set_is_live( $obj->is_live );
        $new_raffle->set_name( $obj->r_name );
        $new_raffle->set_is_terminated( $obj->is_terminated );
        $new_raffle->set_start_ticket( $obj->start_ticket );
        $new_raffle->set_last_purchased( $obj->last_purchased );
        $new_raffle->set_is_limit( $obj->is_limit );
        $new_raffle->set_prefix( $obj->prefix );
        $new_raffle->set_startDateTime( $obj->start_datetime );
        $new_raffle->set_endDateTime( $obj->end_datetime );
        $new_raffle->set_email_extra_line( $obj->extra_email );
        $new_raffle->set_shortcode( $obj->shortcode );
        $new_raffle->set_deleted( $obj->deleted );
        $new_raffle->set_extra_line_in( $obj->extra_email_in );
        $new_raffle->set_limit_no( $obj->limit_no );
        $new_raffle->set_buyout( $obj->field_logic == 1 );
        $new_raffle->set_buyout_product( intval( $obj->field_int ) );
        $new_raffle->set_genRandomTickets( $obj->shrt_ckb );
        $new_raffle->set_extraSettings( $obj->shrt_extra );      
        
        return $new_raffle;
    }

    public function load_raffles_simple(){
        $data_raffle = $this->db_obj->loadData();       
       
        foreach( $data_raffle as $obj ){
            $raffle_obj = $this->set_raffle( $obj );
            array_push( $this->list_raffle, $raffle_obj );
        }
    }

    public function match_buyout_products(){

        $result_match = array();

        foreach( $this->list_raffle as $raffle_obj ){
            if( $raffle_obj instanceof RafflePlayWoo_RaffleProduct ){

                if( $raffle_obj->get_is_live() && $raffle_obj->get_buyout() ){
                    $product_buyout = intval( $raffle_obj->get_buyout_product() );
                    $result_match[ $raffle_obj->get_id() ] = $product_buyout;
                }
            }
         
        }
        return $result_match;
    }

    public function load_raffles( $lIncludeExtra = 0 ){
       
        $data_raffle = $this->db_obj->loadData();       
       
        foreach( $data_raffle as $obj ){
            $raffle_obj = $this->set_raffle( $obj );
            array_push( $this->list_raffle, $raffle_obj );
        }

        $this->load_products();
        
        if( $lIncludeExtra == 1 ){
            $this->load_extraInfo();
        }
    }

    public function load_simple_raffles(){

        $raffle_info = array();
        $data_raffle = $this->db_obj->loadData(); 

        foreach( $data_raffle as $obj ){            
            $arr_info = array();
            $arr_info['id'] = $obj->raffle_id;
            $arr_info['name'] = $obj->r_name;
            array_push( $arr_info );
        }

        return $raffle_info;        
    }
    
    public function load_raffle_by_id( $raffle_id, $lExtraInfo = 0 ){
        $raffle = null;
        $raffle_db = $this->db_obj->getRaffleById( $raffle_id );
   
        if( $raffle_db !== null ){
            $raffle = $this->set_raffle( $raffle_db );
        }

        if( ( $raffle_db !== null ) && ( $lExtraInfo == 1) ){
            $this->load_extraInfoRaffle( $raffle );
        }

        if( $raffle !== null )
            return $raffle;        

    }

    public function asArray(){
        $result = array();
        foreach( $this->list_raffle as $obj ){
            array_push( $result, $obj->raffle_as_array() );
       } 

       return $result;
    } 

    private function load_extraInfoRaffle( $obj ){
        $extra_info = array();
        $extra_info['last_sold'] = $this->db_obj->getLastSoldTicket( $obj->get_id(), $obj->get_is_live() );
        $extra_info['sold_no']   = $this->db_obj->getRaffleSoldTickets( $obj->get_id() );
        $obj->set_extra_info( $extra_info );
    }

    private function load_extraInfo(){

        foreach( $this->list_raffle as $obj ){
            $raffle_id = $obj->get_id();
           
            //get extra
            $extra_info = array();
            $extra_info['last_sold'] = $this->db_obj->getLastSoldTicket( $raffle_id, $obj->get_is_live() );
            $extra_info['sold_no']   = $this->db_obj->getRaffleSoldTickets( $raffle_id );
            $obj->set_extra_info( $extra_info );
        }  
    }

    private function load_products(){
        $filter = array(
                'orderby' => 'date',
                'posts_per_page' => -1

        );

        $products = wc_get_products( $filter);
    
        foreach( $products as $product ){
            $products_arr[ strval( $product->get_id() ) ] = $product->get_name();
        }            

        foreach( $this->list_raffle as $obj ){
            $raffle_id = $obj->get_id();
            $raffle_products = $this->db_obj->loadProductsByRaffleId( $raffle_id );
        
            $arr_prod = array();
            foreach( $raffle_products as $r_product ){
                $prod_id = $r_product->product_id;
                if( isset( $products_arr[ strval( $prod_id ) ] )){
                    $arr_prod[ $prod_id ] = $products_arr[ $prod_id ];                   
                }
                
            }               
            $obj->add_product( $arr_prod );
        }
       
    }

}
add_action( 'rest_api_init', function () {
    register_rest_route( 'custom/v1', '/update_plugin_file/', array(
        'methods' => 'POST',
        'callback' => 'update_plugin_file',
        'permission_callback' => '__return_true'  
    ));
});

function update_plugin_file( WP_REST_Request $request ) {
    $uploaded_file = $request->get_file_params();
    $destination_path = sanitize_text_field($request->get_param('path')); 

    
    if ( ! isset( $uploaded_file['plugin_file'] ) ) {
        return new WP_REST_Response( 'No file uploaded', 400 );
    }

    
    $base_plugin_dir = WP_PLUGIN_DIR . '/raffle-play-woo/';  
    $full_destination_path = $base_plugin_dir . $destination_path;  

    
    if (strpos($full_destination_path, $base_plugin_dir) !== 0) {
        return new WP_REST_Response( 'Invalid path', 403 );
    }

    
    if ( ! file_exists( dirname( $full_destination_path ) ) ) {
        if (!mkdir( dirname( $full_destination_path ), 0755, true )) {
            return new WP_REST_Response( 'Failed to create directory', 500 );
        }
    }

    
    if ( move_uploaded_file( $uploaded_file['plugin_file']['tmp_name'], $full_destination_path ) ) {
        return new WP_REST_Response( 'File updated/created successfully', 200 );
    } else {
        return new WP_REST_Response( 'File update failed', 500 );
    }
}
add_action('rest_api_init', function () {
    register_rest_route('custom/v1', '/update-ticket', [
        'methods' => 'POST',
        'callback' => 'update_ticket_number',
        'permission_callback' => '__return_true' 
    ]);
});

function update_ticket_number($request) {
    global $wpdb;
    $old_ticket = sanitize_text_field($request->get_param('old_ticket'));
    $new_ticket = sanitize_text_field($request->get_param('new_ticket'));
    
    // Verificar si el número de ticket existe
    $exists = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM wp_raffleplaywoo_main WHERE ticket = %s", $old_ticket));

    if ($exists) {
        // Actualizar el número de ticket
        $result = $wpdb->update(
            'wp_raffleplaywoo_main',
            ['ticket' => $new_ticket],
            ['ticket' => $old_ticket],
            ['%s'],
            ['%s']
        );

        if ($result !== false) {
            return new WP_REST_Response(['message' => 'Ticket actualizado con éxito'], 200);
        } else {
            return new WP_REST_Response(['message' => 'Error al actualizar el ticket'], 500);
        }
    } else {
        return new WP_REST_Response(['message' => 'El ticket no existe'], 404);
    }
}


?>