<?php
namespace RafflePlayWoo_Lucky;

if( ! defined( 'ABSPATH') ){ die('No access to this page'); }

class RafflePlayWoo_Lucky{

    public function __construct(){

    }

    public function getLuckyTicketsByRaffleId($lucky_data, &$lucky_tickets, &$unlucky_tickets, $raffle_id, $tickets_purchased ){

        if( ! isset( $lucky_tickets[ $raffle_id ] ) ){
            $lucky_tickets[ $raffle_id ] = array();
        }

        if( ! isset( $unlucky_tickets[ $raffle_id ] ) ){
            $unlucky_tickets[ $raffle_id ] = array();
        }


        if( $lucky_data == null || ( ! isset( $lucky_data->$raffle_id )) ){
            return;
        }
        
        foreach( $lucky_data->$raffle_id->lucky as $lucky ){
                           
            if( $lucky->active && (! $lucky->is_won) && ( $lucky->order_id_won == 0 ) ){

                $valid_to_add = false;

                if( $lucky->purchased > 0  ){

                    if( $lucky->purchased <= $tickets_purchased ){                                
                        $valid_to_add = true;
                    }

                }else{
                    $valid_to_add = true;                            
                }

                $availabe_number = (object) array(
                    'id' => $lucky->id,
                    'number' => $lucky->number,  
                    'won'   => false                  
                );

                if( $valid_to_add ){ 
                    array_push( $lucky_tickets[ $raffle_id ], $availabe_number ); 
                }else{
                    array_push( $unlucky_tickets[ $raffle_id ], $lucky->number );
                }
                
            }else{
                array_push( $unlucky_tickets[ $raffle_id ], $lucky->number );
            }
        }

    }


    public function getConcentrateByRaffleId( $lucky_data, $raffle_id ){

        $result = 0;

        if( isset( $lucky_data->$raffle_id) && isset( $lucky_data->$raffle_id->concentrate )){
            $result = $lucky_data->$raffle_id->concentrate;
        }

        return $result;
    }

    public function setLuckyWon( &$lucky_data, $raffle_id, $lucky_id, $order_id ){
        $result = false;
        if( isset( $lucky_data->$raffle_id ) ){

            foreach( $lucky_data->lucky as $item ){

                if( $item->id == $lucky_id ){

                    $item->is_won = true;
                    $item->order_id_won = $order_id;
                    $result = true;

                }
            }
        }

        return $result;
    }

    public function putLuckyNumbersInArray( $lucky_arr ){
        $result = array();

        foreach( $lucky_arr as $obj ){
            $result[] = (int) $obj->number;
        }

        return count( $result ) > 0 ? $result : null;
    }

    public function getAllLuckyNumbersForRaffle( $lucky_data, $raffle_id ){
        
        $result = array();
        
        if( isset( $lucky_data->$raffle_id )){
            foreach( $lucky_data->$raffle_id->lucky as $lucky_obj ){
                $result[] = (int) $lucky_obj->number;
            }
        }

        return $result;
    }

    public function updateNewDataLucky( &$data, $old_lucky_data ){
        try {
            //update winners data
    
            foreach( $data as $raffle_id=>$lucky_data ){
                foreach( $lucky_data->lucky as $obj ){
                    if( isset( $old_lucky_data->$raffle_id )){
                        foreach( $old_lucky_data->$raffle_id->lucky  as $old_obj ){
                            if( $obj->id == $old_obj->id ){
                                $obj->is_won = $old_obj->is_won;
                                $obj->order_id_won = $old_obj->order_id_won;
                                break;
                            }
                        }
                    }
                }
            }

        } catch (\Throwable $th) {
            RafflePlayWoo_error_log( $th->getMessage() );
        }
    }
    
}