<?php
namespace RafflePlayWoo_Countdown;

if( ! defined('ABSPATH') )
    exit();

class RafflePlayWoo_Countdown{

    private static $instance = null; 
    public static $SHORTCODE_NAME = 'TUSKCODE_RAFFLE_COUNTDOWN';

    public static function init() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

    private function __construct() {
		$this->hooks();
	}

    private function hooks() {
		add_action( 'init', array( $this, 'raffle_countdown_timer_shortcode' ) );
        add_action( 'wp_enqueue_scripts', array( $this, 'front_assets' ) );
    }

    public function raffle_countdown_timer_shortcode() {
		add_shortcode( self::$SHORTCODE_NAME , array( $this, 'raffle_countdown_shortcode' ) );
	}

    public function front_assets() {

        wp_enqueue_style( 'raffle-front-flipdown-css', RAFFLE_PLAY_WOO_URL . '/css/counter-flipdown.min.css', 
                    array(), RAFFLE_PLAY_WOO_VERSION, 'all' );

    //    wp_enqueue_script( 'raffle-front-countdown-timer-js', RAFFLE_PLAY_WOO_URL. '/js/front-countdown-timer-raffle.min.js',
    //                array( 'jquery' ), RAFFLE_PLAY_WOO_VERSION, array('strategy' => 'defer', 'in_footer' => true) );                
                  
	}

    public function raffle_countdown_shortcode( $attrs ){

		if ( empty( $attrs['datetime'] ) ) {
			return '';
		}

        $classes    = isset( $attrs['classes'] ) ? sanitize_text_field( wp_unslash( $attrs['classes'] ) ) . ' gpls-wpsctr' : 'gpls-wpsctr';
        $color      = isset( $attrs['color'] ) ? sanitize_text_field( wp_unslash( $attrs['color'] ) ) : '#fff';
        $bgcolor    = isset( $attrs['bgcolor'] ) ? sanitize_text_field( wp_unslash( $attrs['bgcolor'] ) ) : '#f58661';

        $days       = isset( $attrs['days'] ) ? sanitize_text_field( wp_unslash( $attrs['days'] ) ) : esc_html__('Days', 'raffle-play-woo');
        $hours      = isset( $attrs['hours'] ) ? sanitize_text_field( wp_unslash( $attrs['hours'] ) ) : esc_html__( 'Hours', 'raffle-play-woo');
        $mins       = isset( $attrs['minutes'] ) ? sanitize_text_field( wp_unslash( $attrs['minutes'] ) ) : esc_html__('Minutes', 'raffle-play-woo');
        $secs       = isset( $attrs['seconds'] ) ? sanitize_text_field( wp_unslash( $attrs['seconds'] ) ) : esc_html__('Seconds', 'raffle-play-woo');

        $headerMessage     = isset( $attrs['header'] ) ? sanitize_text_field( wp_unslash( $attrs['header'] ) ) : '';

        $time_zone = (float) get_option( 'gmt_offset' );
        $hours_ = (int) $time_zone;

        $target_time   = sanitize_text_field( wp_unslash( $attrs['datetime'] ) );
		$current_time  = current_time('timestamp') - ( 60 * 60 * $hours_ ); // ( current_datetime()->getTimestamp() );
		$timer_id      = ! empty( $attrs['id'] ) ? sanitize_title( sanitize_text_field( wp_unslash( $attrs['id'] ) ) ) : sanitize_title( wp_generate_password( 8, false, false ) );

        //check if target time is date format (yyyy-mm-dd HH:mm:ss )
        if( str_contains( $target_time, '-') ){
            $target_time = strtotime($target_time);
            if( $target_time === false ){
                return '';
            }
        }else{
            $target_time = (int)$target_time;
        }

		if ( ! is_numeric( $target_time ) || (int) $target_time !== $target_time ) {
			return '';
		}

		if ( $current_time >= $target_time ) {
			return '';
		}       

        ob_start();

		?>

        <script>
            
            var raffle_countdown_timer_localized_data = {
                    "ajaxUrl":"https:\/\/localhost\/june\/wp-admin\/admin-ajax.php",
                        "prefix":"gpls-wpsctr-simple-countdown-timer",
                        "classes_prefix":"gpls-wpsctr",
                        "labels":{
                            "flipDownHeading":
                                            {   
                                                "days":"<?php echo $days;?>",
                                                "hours":"<?php echo $hours;?>",
                                                "minutes":"<?php echo $mins;?>",
                                                "seconds":"<?php echo $secs;?>"
                                            },                                      
                                },
                                "nonce":"d42d652583",
                                "submitFormAction":"gpls-wpsctr-subscribe-form-submit"
                        };
       
        </script>


     
		<div id="<?php echo esc_attr( $classes . '-countdown-timer-' . $timer_id ); ?>"
			 class="<?php echo esc_attr(  $classes . '-countdown-timer-container ' . $classes . '-quick-countdown-timer' ); ?>">
             
			<div class="<?php echo esc_attr( $classes . '-countdown-timer-wrapper' ); ?>">
                <?php echo "<span class='countdown-header-message'> $headerMessage </span>"; ?>
				<div
					class="flipdown <?php echo esc_attr( $classes . '-flipper' ); ?> flipper-dark <?php echo esc_attr(  $classes . '-flipdown' ); ?>"
					data-datetime="<?php echo esc_attr( $target_time ); ?>"
					data-template="ddd|HH|ii|ss"
					data-labels="Days|Hours|Minutes|Seconds"
					data-now="<?php echo esc_attr( $current_time ); ?>"
				>
				</div>
			</div>
		</div>

        <script defer src="<?php echo RAFFLE_PLAY_WOO_URL. '/js/front-countdown-timer-raffle.js?v='.RAFFLE_PLAY_WOO_VERSION;?> "></script>
        <style>

            .flipdown.flipdown__theme-dark .rotor, 
            .flipdown.flipdown__theme-dark .rotor-top, 
            .flipdown.flipdown__theme-dark .rotor-leaf-front, 
            .flipdown.flipdown__theme-dark .rotor-bottom, 
            .flipdown.flipdown__theme-dark .rotor-leaf-rear {
                color: <?php echo $color;?> !important;
                background-color: <?php echo $bgcolor;?> !important;
            }
            .flipdown{
                margin-top: 0 !important;
            }
            .countdown-header-message{
                display: block;
                text-align: center;
            }

            .flipdown.flipdown__theme-dark .rotor:after{
                border-top: 1px solid <?php echo $color;?> !important;
            }
        </style>
		<?php

		return ob_get_clean();

    }

}