<?php
/**
 * Checkout Fees for WooCommerce - Country Functions
 *
 * @version 2.5.0
 * @since   2.0.0
 * @author  Tyche Softwares
 *
 * @package checkout-fees-for-woocommerce/Functions
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! function_exists( 'alg_checkout_fees_get_country_set_countries' ) ) {
	/**
	 * Alg_checkout_fees_get_country_set_countries.
	 *
	 * @version 2.5.0
	 * @since   2.4.0
	 */
	function alg_checkout_fees_get_country_set_countries() {
		return array(
			'EU'                    => array( 'AT', 'BE', 'BG', 'CY', 'CZ', 'DE', 'DK', 'EE', 'ES', 'FI', 'FR', 'GB', 'GR', 'HU', 'HR', 'IE', 'IT', 'LT', 'LU', 'LV', 'MT', 'NL', 'PL', 'PT', 'RO', 'SE', 'SI', 'SK' ),
			'Europe'                => array( 'AD', 'AL', 'AT', 'AX', 'BA', 'BE', 'BG', 'BY', 'CH', 'CZ', 'DE', 'DK', 'EE', 'ES', 'FI', 'FO', 'FR', 'FX', 'GB', 'GG', 'GI', 'GR', 'HR', 'HU', 'IE', 'IM', 'IS', 'IT', 'JE', 'LI', 'LT', 'LU', 'LV', 'MC', 'MD', 'ME', 'MK', 'MT', 'NL', 'NO', 'PL', 'PT', 'RO', 'RS', 'RU', 'SE', 'SI', 'SJ', 'SK', 'SM', 'TR', 'UA', 'VA' ),
			'Europe-excluding-EU'   => array( 'AD', 'AL', 'AX', 'BA', 'BY', 'CH', 'FO', 'FX', 'GG', 'GI', 'IM', 'IS', 'JE', 'LI', 'MC', 'MD', 'ME', 'MK', 'NO', 'RS', 'RU', 'SJ', 'SM', 'TR', 'UA', 'VA' ),
			'Eurozone'              => array( 'AD', 'AT', 'BE', 'CY', 'EE', 'FI', 'FR', 'DE', 'GR', 'IE', 'IT', 'LV', 'LT', 'LU', 'MT', 'MC', 'NL', 'PT', 'SM', 'SI', 'SK', 'ES', 'VA' ),
			'Africa'                => array( 'AO', 'BF', 'BI', 'BJ', 'BW', 'CD', 'CF', 'CG', 'CI', 'CM', 'CV', 'DJ', 'DZ', 'EG', 'EH', 'ER', 'ET', 'GA', 'GH', 'GM', 'GN', 'GQ', 'GW', 'YT', 'KE', 'KM', 'LY', 'LR', 'LS', 'MA', 'MG', 'ML', 'MR', 'MU', 'MW', 'MZ', 'NA', 'NE', 'NG', 'RE', 'RW', 'SC', 'SD', 'SH', 'SL', 'SN', 'SO', 'ST', 'SZ', 'TD', 'TG', 'TN', 'TZ', 'UG', 'ZA', 'ZM', 'ZW' ),
			'Asia'                  => array( 'AE', 'AF', 'AM', 'AP', 'AZ', 'BD', 'BH', 'BN', 'BT', 'CC', 'CY', 'CN', 'CX', 'GE', 'HK', 'ID', 'IL', 'IN', 'IO', 'IQ', 'IR', 'YE', 'JO', 'JP', 'KG', 'KH', 'KP', 'KR', 'KW', 'KZ', 'LA', 'LB', 'LK', 'MY', 'MM', 'MN', 'MO', 'MV', 'NP', 'OM', 'PH', 'PK', 'PS', 'QA', 'SA', 'SG', 'SY', 'TH', 'TJ', 'TL', 'TM', 'TW', 'UZ', 'VN' ),
			'Australia-and-Oceania' => array( 'AS', 'AU', 'CK', 'FJ', 'FM', 'GU', 'KI', 'MH', 'MP', 'NC', 'NF', 'NR', 'NU', 'NZ', 'PF', 'PG', 'PN', 'PW', 'SB', 'TK', 'TO', 'TV', 'UM', 'VU', 'WF', 'WS' ),
			'Central-America'       => array( 'AG', 'AI', 'AN', 'AW', 'BB', 'BL', 'BM', 'BS', 'BZ', 'CR', 'CU', 'DM', 'DO', 'GD', 'GL', 'GP', 'GT', 'HN', 'HT', 'JM', 'KY', 'KN', 'LC', 'MF', 'MQ', 'MS', 'NI', 'PA', 'PM', 'PR', 'SV', 'TC', 'TT', 'VC', 'VG', 'VI' ),
			'North-America'         => array( 'CA', 'MX', 'US' ),
			'South-America'         => array( 'AR', 'BO', 'BR', 'CL', 'CO', 'EC', 'FK', 'GF', 'GY', 'PE', 'PY', 'SR', 'UY', 'VE' ),
		);
	}
}

if ( ! function_exists( 'alg_checkout_fees_get_countries_sets' ) ) {
	/**
	 * Get all countries sets array.
	 *
	 * @version 2.4.0
	 * @since   2.4.0
	 * @return  array
	 */
	function alg_checkout_fees_get_countries_sets() {
		return array(
			'Africa'                => __( 'Africa', 'checkout-fees-for-woocommerce' ),
			'Asia'                  => __( 'Asia', 'checkout-fees-for-woocommerce' ),
			'Australia-and-Oceania' => __( 'Australia & Oceania', 'checkout-fees-for-woocommerce' ),
			'Central-America'       => __( 'Central America', 'checkout-fees-for-woocommerce' ),
			'EU'                    => __( 'European Union', 'woocommerce' ),
			'Europe'                => __( 'Europe', 'woocommerce' ),
			'Europe-excluding-EU'   => __( 'Europe excluding EU', 'checkout-fees-for-woocommerce' ),
			'Eurozone'              => __( 'Eurozone', 'checkout-fees-for-woocommerce' ),
			'North-America'         => __( 'North America', 'checkout-fees-for-woocommerce' ),
			'South-America'         => __( 'South America', 'checkout-fees-for-woocommerce' ),
		);
	}
}

if ( ! function_exists( 'alg_checkout_fees_get_countries' ) ) {
	/**
	 * Get all countries array.
	 *
	 * @version 2.4.0
	 * @return  array
	 */
	function alg_checkout_fees_get_countries() {
		return array(
			'AF' => __( 'Afghanistan', 'woocommerce' ),
			'AX' => __( '&#197;land Islands', 'woocommerce' ),
			'AL' => __( 'Albania', 'woocommerce' ),
			'DZ' => __( 'Algeria', 'woocommerce' ),
			'AD' => __( 'Andorra', 'woocommerce' ),
			'AO' => __( 'Angola', 'woocommerce' ),
			'AI' => __( 'Anguilla', 'woocommerce' ),
			'AQ' => __( 'Antarctica', 'woocommerce' ),
			'AG' => __( 'Antigua and Barbuda', 'woocommerce' ),
			'AR' => __( 'Argentina', 'woocommerce' ),
			'AM' => __( 'Armenia', 'woocommerce' ),
			'AW' => __( 'Aruba', 'woocommerce' ),
			'AU' => __( 'Australia', 'woocommerce' ),
			'AT' => __( 'Austria', 'woocommerce' ),
			'AZ' => __( 'Azerbaijan', 'woocommerce' ),
			'BS' => __( 'Bahamas', 'woocommerce' ),
			'BH' => __( 'Bahrain', 'woocommerce' ),
			'BD' => __( 'Bangladesh', 'woocommerce' ),
			'BB' => __( 'Barbados', 'woocommerce' ),
			'BY' => __( 'Belarus', 'woocommerce' ),
			'BE' => __( 'Belgium', 'woocommerce' ),
			'PW' => __( 'Belau', 'woocommerce' ),
			'BZ' => __( 'Belize', 'woocommerce' ),
			'BJ' => __( 'Benin', 'woocommerce' ),
			'BM' => __( 'Bermuda', 'woocommerce' ),
			'BT' => __( 'Bhutan', 'woocommerce' ),
			'BO' => __( 'Bolivia', 'woocommerce' ),
			'BQ' => __( 'Bonaire, Saint Eustatius and Saba', 'woocommerce' ),
			'BA' => __( 'Bosnia and Herzegovina', 'woocommerce' ),
			'BW' => __( 'Botswana', 'woocommerce' ),
			'BV' => __( 'Bouvet Island', 'woocommerce' ),
			'BR' => __( 'Brazil', 'woocommerce' ),
			'IO' => __( 'British Indian Ocean Territory', 'woocommerce' ),
			'VG' => __( 'British Virgin Islands', 'woocommerce' ),
			'BN' => __( 'Brunei', 'woocommerce' ),
			'BG' => __( 'Bulgaria', 'woocommerce' ),
			'BF' => __( 'Burkina Faso', 'woocommerce' ),
			'BI' => __( 'Burundi', 'woocommerce' ),
			'KH' => __( 'Cambodia', 'woocommerce' ),
			'CM' => __( 'Cameroon', 'woocommerce' ),
			'CA' => __( 'Canada', 'woocommerce' ),
			'CV' => __( 'Cape Verde', 'woocommerce' ),
			'KY' => __( 'Cayman Islands', 'woocommerce' ),
			'CF' => __( 'Central African Republic', 'woocommerce' ),
			'TD' => __( 'Chad', 'woocommerce' ),
			'CL' => __( 'Chile', 'woocommerce' ),
			'CN' => __( 'China', 'woocommerce' ),
			'CX' => __( 'Christmas Island', 'woocommerce' ),
			'CC' => __( 'Cocos (Keeling) Islands', 'woocommerce' ),
			'CO' => __( 'Colombia', 'woocommerce' ),
			'KM' => __( 'Comoros', 'woocommerce' ),
			'CG' => __( 'Congo (Brazzaville)', 'woocommerce' ),
			'CD' => __( 'Congo (Kinshasa)', 'woocommerce' ),
			'CK' => __( 'Cook Islands', 'woocommerce' ),
			'CR' => __( 'Costa Rica', 'woocommerce' ),
			'HR' => __( 'Croatia', 'woocommerce' ),
			'CU' => __( 'Cuba', 'woocommerce' ),
			'CW' => __( 'Cura&Ccedil;ao', 'woocommerce' ),
			'CY' => __( 'Cyprus', 'woocommerce' ),
			'CZ' => __( 'Czech Republic', 'woocommerce' ),
			'DK' => __( 'Denmark', 'woocommerce' ),
			'DJ' => __( 'Djibouti', 'woocommerce' ),
			'DM' => __( 'Dominica', 'woocommerce' ),
			'DO' => __( 'Dominican Republic', 'woocommerce' ),
			'EC' => __( 'Ecuador', 'woocommerce' ),
			'EG' => __( 'Egypt', 'woocommerce' ),
			'SV' => __( 'El Salvador', 'woocommerce' ),
			'GQ' => __( 'Equatorial Guinea', 'woocommerce' ),
			'ER' => __( 'Eritrea', 'woocommerce' ),
			'EE' => __( 'Estonia', 'woocommerce' ),
			'ET' => __( 'Ethiopia', 'woocommerce' ),
			'FK' => __( 'Falkland Islands', 'woocommerce' ),
			'FO' => __( 'Faroe Islands', 'woocommerce' ),
			'FJ' => __( 'Fiji', 'woocommerce' ),
			'FI' => __( 'Finland', 'woocommerce' ),
			'FR' => __( 'France', 'woocommerce' ),
			'GF' => __( 'French Guiana', 'woocommerce' ),
			'PF' => __( 'French Polynesia', 'woocommerce' ),
			'TF' => __( 'French Southern Territories', 'woocommerce' ),
			'GA' => __( 'Gabon', 'woocommerce' ),
			'GM' => __( 'Gambia', 'woocommerce' ),
			'GE' => __( 'Georgia', 'woocommerce' ),
			'DE' => __( 'Germany', 'woocommerce' ),
			'GH' => __( 'Ghana', 'woocommerce' ),
			'GI' => __( 'Gibraltar', 'woocommerce' ),
			'GR' => __( 'Greece', 'woocommerce' ),
			'GL' => __( 'Greenland', 'woocommerce' ),
			'GD' => __( 'Grenada', 'woocommerce' ),
			'GP' => __( 'Guadeloupe', 'woocommerce' ),
			'GT' => __( 'Guatemala', 'woocommerce' ),
			'GG' => __( 'Guernsey', 'woocommerce' ),
			'GN' => __( 'Guinea', 'woocommerce' ),
			'GW' => __( 'Guinea-Bissau', 'woocommerce' ),
			'GY' => __( 'Guyana', 'woocommerce' ),
			'HT' => __( 'Haiti', 'woocommerce' ),
			'HM' => __( 'Heard Island and McDonald Islands', 'woocommerce' ),
			'HN' => __( 'Honduras', 'woocommerce' ),
			'HK' => __( 'Hong Kong', 'woocommerce' ),
			'HU' => __( 'Hungary', 'woocommerce' ),
			'IS' => __( 'Iceland', 'woocommerce' ),
			'IN' => __( 'India', 'woocommerce' ),
			'ID' => __( 'Indonesia', 'woocommerce' ),
			'IR' => __( 'Iran', 'woocommerce' ),
			'IQ' => __( 'Iraq', 'woocommerce' ),
			'IE' => __( 'Republic of Ireland', 'woocommerce' ),
			'IM' => __( 'Isle of Man', 'woocommerce' ),
			'IL' => __( 'Israel', 'woocommerce' ),
			'IT' => __( 'Italy', 'woocommerce' ),
			'CI' => __( 'Ivory Coast', 'woocommerce' ),
			'JM' => __( 'Jamaica', 'woocommerce' ),
			'JP' => __( 'Japan', 'woocommerce' ),
			'JE' => __( 'Jersey', 'woocommerce' ),
			'JO' => __( 'Jordan', 'woocommerce' ),
			'KZ' => __( 'Kazakhstan', 'woocommerce' ),
			'KE' => __( 'Kenya', 'woocommerce' ),
			'KI' => __( 'Kiribati', 'woocommerce' ),
			'KW' => __( 'Kuwait', 'woocommerce' ),
			'KG' => __( 'Kyrgyzstan', 'woocommerce' ),
			'LA' => __( 'Laos', 'woocommerce' ),
			'LV' => __( 'Latvia', 'woocommerce' ),
			'LB' => __( 'Lebanon', 'woocommerce' ),
			'LS' => __( 'Lesotho', 'woocommerce' ),
			'LR' => __( 'Liberia', 'woocommerce' ),
			'LY' => __( 'Libya', 'woocommerce' ),
			'LI' => __( 'Liechtenstein', 'woocommerce' ),
			'LT' => __( 'Lithuania', 'woocommerce' ),
			'LU' => __( 'Luxembourg', 'woocommerce' ),
			'MO' => __( 'Macao S.A.R., China', 'woocommerce' ),
			'MK' => __( 'Macedonia', 'woocommerce' ),
			'MG' => __( 'Madagascar', 'woocommerce' ),
			'MW' => __( 'Malawi', 'woocommerce' ),
			'MY' => __( 'Malaysia', 'woocommerce' ),
			'MV' => __( 'Maldives', 'woocommerce' ),
			'ML' => __( 'Mali', 'woocommerce' ),
			'MT' => __( 'Malta', 'woocommerce' ),
			'MH' => __( 'Marshall Islands', 'woocommerce' ),
			'MQ' => __( 'Martinique', 'woocommerce' ),
			'MR' => __( 'Mauritania', 'woocommerce' ),
			'MU' => __( 'Mauritius', 'woocommerce' ),
			'YT' => __( 'Mayotte', 'woocommerce' ),
			'MX' => __( 'Mexico', 'woocommerce' ),
			'FM' => __( 'Micronesia', 'woocommerce' ),
			'MD' => __( 'Moldova', 'woocommerce' ),
			'MC' => __( 'Monaco', 'woocommerce' ),
			'MN' => __( 'Mongolia', 'woocommerce' ),
			'ME' => __( 'Montenegro', 'woocommerce' ),
			'MS' => __( 'Montserrat', 'woocommerce' ),
			'MA' => __( 'Morocco', 'woocommerce' ),
			'MZ' => __( 'Mozambique', 'woocommerce' ),
			'MM' => __( 'Myanmar', 'woocommerce' ),
			'NA' => __( 'Namibia', 'woocommerce' ),
			'NR' => __( 'Nauru', 'woocommerce' ),
			'NP' => __( 'Nepal', 'woocommerce' ),
			'NL' => __( 'Netherlands', 'woocommerce' ),
			'AN' => __( 'Netherlands Antilles', 'woocommerce' ),
			'NC' => __( 'New Caledonia', 'woocommerce' ),
			'NZ' => __( 'New Zealand', 'woocommerce' ),
			'NI' => __( 'Nicaragua', 'woocommerce' ),
			'NE' => __( 'Niger', 'woocommerce' ),
			'NG' => __( 'Nigeria', 'woocommerce' ),
			'NU' => __( 'Niue', 'woocommerce' ),
			'NF' => __( 'Norfolk Island', 'woocommerce' ),
			'KP' => __( 'North Korea', 'woocommerce' ),
			'NO' => __( 'Norway', 'woocommerce' ),
			'OM' => __( 'Oman', 'woocommerce' ),
			'PK' => __( 'Pakistan', 'woocommerce' ),
			'PS' => __( 'Palestinian Territory', 'woocommerce' ),
			'PA' => __( 'Panama', 'woocommerce' ),
			'PG' => __( 'Papua New Guinea', 'woocommerce' ),
			'PY' => __( 'Paraguay', 'woocommerce' ),
			'PE' => __( 'Peru', 'woocommerce' ),
			'PH' => __( 'Philippines', 'woocommerce' ),
			'PN' => __( 'Pitcairn', 'woocommerce' ),
			'PL' => __( 'Poland', 'woocommerce' ),
			'PT' => __( 'Portugal', 'woocommerce' ),
			'QA' => __( 'Qatar', 'woocommerce' ),
			'RE' => __( 'Reunion', 'woocommerce' ),
			'RO' => __( 'Romania', 'woocommerce' ),
			'RU' => __( 'Russia', 'woocommerce' ),
			'RW' => __( 'Rwanda', 'woocommerce' ),
			'BL' => __( 'Saint Barth&eacute;lemy', 'woocommerce' ),
			'SH' => __( 'Saint Helena', 'woocommerce' ),
			'KN' => __( 'Saint Kitts and Nevis', 'woocommerce' ),
			'LC' => __( 'Saint Lucia', 'woocommerce' ),
			'MF' => __( 'Saint Martin (French part)', 'woocommerce' ),
			'SX' => __( 'Saint Martin (Dutch part)', 'woocommerce' ),
			'PM' => __( 'Saint Pierre and Miquelon', 'woocommerce' ),
			'VC' => __( 'Saint Vincent and the Grenadines', 'woocommerce' ),
			'SM' => __( 'San Marino', 'woocommerce' ),
			'ST' => __( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe', 'woocommerce' ),
			'SA' => __( 'Saudi Arabia', 'woocommerce' ),
			'SN' => __( 'Senegal', 'woocommerce' ),
			'RS' => __( 'Serbia', 'woocommerce' ),
			'SC' => __( 'Seychelles', 'woocommerce' ),
			'SL' => __( 'Sierra Leone', 'woocommerce' ),
			'SG' => __( 'Singapore', 'woocommerce' ),
			'SK' => __( 'Slovakia', 'woocommerce' ),
			'SI' => __( 'Slovenia', 'woocommerce' ),
			'SB' => __( 'Solomon Islands', 'woocommerce' ),
			'SO' => __( 'Somalia', 'woocommerce' ),
			'ZA' => __( 'South Africa', 'woocommerce' ),
			'GS' => __( 'South Georgia/Sandwich Islands', 'woocommerce' ),
			'KR' => __( 'South Korea', 'woocommerce' ),
			'SS' => __( 'South Sudan', 'woocommerce' ),
			'ES' => __( 'Spain', 'woocommerce' ),
			'LK' => __( 'Sri Lanka', 'woocommerce' ),
			'SD' => __( 'Sudan', 'woocommerce' ),
			'SR' => __( 'Suriname', 'woocommerce' ),
			'SJ' => __( 'Svalbard and Jan Mayen', 'woocommerce' ),
			'SZ' => __( 'Swaziland', 'woocommerce' ),
			'SE' => __( 'Sweden', 'woocommerce' ),
			'CH' => __( 'Switzerland', 'woocommerce' ),
			'SY' => __( 'Syria', 'woocommerce' ),
			'TW' => __( 'Taiwan', 'woocommerce' ),
			'TJ' => __( 'Tajikistan', 'woocommerce' ),
			'TZ' => __( 'Tanzania', 'woocommerce' ),
			'TH' => __( 'Thailand', 'woocommerce' ),
			'TL' => __( 'Timor-Leste', 'woocommerce' ),
			'TG' => __( 'Togo', 'woocommerce' ),
			'TK' => __( 'Tokelau', 'woocommerce' ),
			'TO' => __( 'Tonga', 'woocommerce' ),
			'TT' => __( 'Trinidad and Tobago', 'woocommerce' ),
			'TN' => __( 'Tunisia', 'woocommerce' ),
			'TR' => __( 'Turkey', 'woocommerce' ),
			'TM' => __( 'Turkmenistan', 'woocommerce' ),
			'TC' => __( 'Turks and Caicos Islands', 'woocommerce' ),
			'TV' => __( 'Tuvalu', 'woocommerce' ),
			'UG' => __( 'Uganda', 'woocommerce' ),
			'UA' => __( 'Ukraine', 'woocommerce' ),
			'AE' => __( 'United Arab Emirates', 'woocommerce' ),
			'GB' => __( 'United Kingdom (UK)', 'woocommerce' ),
			'US' => __( 'United States (US)', 'woocommerce' ),
			'UY' => __( 'Uruguay', 'woocommerce' ),
			'UZ' => __( 'Uzbekistan', 'woocommerce' ),
			'VU' => __( 'Vanuatu', 'woocommerce' ),
			'VA' => __( 'Vatican', 'woocommerce' ),
			'VE' => __( 'Venezuela', 'woocommerce' ),
			'VN' => __( 'Vietnam', 'woocommerce' ),
			'WF' => __( 'Wallis and Futuna', 'woocommerce' ),
			'EH' => __( 'Western Sahara', 'woocommerce' ),
			'WS' => __( 'Western Samoa', 'woocommerce' ),
			'YE' => __( 'Yemen', 'woocommerce' ),
			'ZM' => __( 'Zambia', 'woocommerce' ),
			'ZW' => __( 'Zimbabwe', 'woocommerce' ),

			'FX' => __( 'France, Metropolitan', 'checkout-fees-for-woocommerce' ),
			'AP' => __( 'African Regional Industrial Property Organization', 'checkout-fees-for-woocommerce' ),
			'AS' => __( 'American Samoa', 'checkout-fees-for-woocommerce' ),
			'GU' => __( 'Guam', 'checkout-fees-for-woocommerce' ),
			'MP' => __( 'Northern Mariana Islands', 'checkout-fees-for-woocommerce' ),
			'UM' => __( 'United States Minor Outlying Islands', 'checkout-fees-for-woocommerce' ),
			'PR' => __( 'Puerto Rico', 'checkout-fees-for-woocommerce' ),
			'VI' => __( 'Virgin Islands, U.S.', 'checkout-fees-for-woocommerce' ),
		);
	}
}
