.elementor-sticky{
	overflow: visible !important;
}

{% if disable_page_scroll_when_menu_opened == "true" %}
  body.menu-opened,
  html.menu-opened{
  	overflow: hidden;
  }	 
{% endif %}	


#{{uc_id}} * {
  box-sizing: border-box;
}
#{{uc_id}} a,
#{{uc_id}} a:visited,
#{{uc_id}} a:hover,
#{{uc_id}} a:active {
  text-decoration: none;
}


#{{uc_id}} .ue-input-wrapper{
  position:relative;  
}

#{{uc_id}} .ue-input-wrapper-align{
  display:flex;
}

#{{uc_id}} .ue_hamburger *{
  transition: all 200ms;
}

#{{uc_id}} .ue_hamburger_custom_open svg{
  height:1em;
  width:1em;
}

#{{uc_id}} .ue_hamburger_custom_close svg{
  height:1em;
  width:1em;
}

#{{uc_id}} .uc_hamburger{
  display: inline-block;  
}

#{{uc_id}} .uc_line{
  transition: all .3s;
}

#{{uc_id}}{
  position:relative;
  z-index:99998;
}

#{{uc_id}} .checkbox-toggle {
  position: absolute;
  z-index: 100000000;
  cursor: pointer;
  opacity: 0;
  top:0px;
}

#{{uc_id}} .checkbox-toggle:checked + .ue_hamburger > div:after {
  opacity: 0;
}

#{{uc_id}}.menu-opened .ue_menu {
  pointer-events: auto;
}

#{{uc_id}}.menu-opened .ue_menu > div.ue_inner_menu {
      visibility: visible;
  -webkit-transition-duration: 0.75s;
          transition-duration: 0.75s;
}

#{{uc_id}}.menu-opened .ue_menu > div.ue_inner_menu > div > div {
  opacity: 1;
  transition: opacity 0.4s ease 0.4s;
}

/* start open transition animations */
{% if open_transition == "zoom_in" %}
#{{uc_id}} .ue_menu .ue_inner_menu {
transform: scale(0);
}

#{{uc_id}}.menu-opened .ue_menu > div.ue_inner_menu {
  -webkit-transform: scale(1);
          transform: scale(1);
  -webkit-transition-duration: 0.75s;
          transition-duration: 0.75s;
}
{% endif %}	

{% if open_transition == "slide_from_left" %}
#{{uc_id}} .ue_menu .ue_inner_menu {
transform: translate(-100%, 0);
}

#{{uc_id}}.menu-opened .ue_menu > div.ue_inner_menu {
  -webkit-transform: translate(0, 0);
          transform: translate(0, 0);
}
{% endif %}	

{% if open_transition == "slide_from_top" %}
#{{uc_id}} .ue_menu .ue_inner_menu {
transform: translate(0, -100%);
}
#{{uc_id}}.menu-opened .ue_menu > div.ue_inner_menu {
  -webkit-transform: translate(0, 0);
          transform: translate(0, 0);
}
{% endif %}	

{% if open_transition == "slide_from_right" %}
#{{uc_id}} .ue_menu .ue_inner_menu {
transform: translate(100%, 0);
}
#{{uc_id}}.menu-opened .ue_menu > div.ue_inner_menu {
  -webkit-transform: translate(0, 0);
          transform: translate(0, 0);
}
{% endif %}	

{% if open_transition == "slide_from_bottom" %}
#{{uc_id}} .ue_menu .ue_inner_menu {
transform: translate(0, 100%);
}
#{{uc_id}}.menu-opened .ue_menu > div.ue_inner_menu {
  -webkit-transform: translate(0, 0);
          transform: translate(0, 0);
}
{% endif %}	

{% if open_transition == "fade_in_left" %}
#{{uc_id}} .ue_menu .ue_inner_menu {
transform: translate(-100%, 0);
 opacity: 0;
}
#{{uc_id}}.menu-opened .ue_menu > div.ue_inner_menu {
  opacity: 1;
  transition: opacity .7s ease, transform .7s ease;
  -webkit-transform: translate(0, 0);
          transform: translate(0, 0);
}
{% endif %}	

{% if open_transition == "fade_in_top" %}
#{{uc_id}} .ue_menu .ue_inner_menu {
transform: translate(0, -100%);
  opacity: 0;
}
#{{uc_id}}.menu-opened .ue_menu > div.ue_inner_menu {
  opacity: 1;
  transition: opacity .7s ease, transform .7s ease;
  -webkit-transform: translate(0, 0);
          transform: translate(0, 0);
}
{% endif %}	

{% if open_transition == "fade_in_right" %}
#{{uc_id}} .ue_menu .ue_inner_menu {
transform: translate(100%, 0);
  opacity: 0;
}
#{{uc_id}}.menu-opened .ue_menu > div.ue_inner_menu {
  opacity: 1;
  transition: opacity .7s ease, transform .7s ease;
  -webkit-transform: translate(0, 0);
          transform: translate(0, 0);
}
{% endif %}	

{% if open_transition == "fade_in_bottom" %}
#{{uc_id}} .ue_menu .ue_inner_menu {
transform: translate(0, 100%);
  opacity: 0;
}
#{{uc_id}}.menu-opened .ue_menu > div.ue_inner_menu {
  opacity: 1;
  transition: opacity .7s ease, transform .7s ease;
  -webkit-transform: translate(0, 0);
          transform: translate(0, 0);
}
{% endif %}	
/* end open transition animations */

#{{uc_id}} .ue_hamburger {
  top: 0;
  cursor: pointer;
  transition: 0.4s;
  backface-visibility: hidden;
  display: flex;
  align-items: center;
  justify-content: center;
  position:absolute;
  z-index:99999999;
}

{% if type == "regular" %}

  {% if effects == "def" %}
    #{{uc_id}} .checkbox-toggle:checked + .ue_hamburger > div {
              transform: rotate(135deg);
    }
    #{{uc_id}} .checkbox-toggle:checked + .ue_hamburger > div:before,
    #{{uc_id}} .checkbox-toggle:checked + .ue_hamburger > div:after {
      top: 0;
      -webkit-transform: rotate(90deg);
              transform: rotate(90deg);
    }
    #{{uc_id}} .checkbox-toggle:checked:hover + .ue_hamburger > div {
              transform: rotate(225deg);
    }
    #{{uc_id}} .ue_hamburger > div {
      position: relative;
      -webkit-box-flex: 0;
              flex: none;
      width: 100%;
      height: 2px;
      transition: all 0.4s ease;
      display: flex;
              align-items: center;
              justify-content: center;
      background-color:{{hamburger_icon_color}};
    }

    #{{uc_id}} .checkbox-toggle:checked + .ue_hamburger > div {
              color:{{hamburger_icon_color}};
              background-color:{{hamburger_icon_active_color}};
    }

    #{{uc_id}} input:hover + .ue_hamburger > div{
      background-color:{{hamburger_icon_color_hover}};
    }

    #{{uc_id}} .ue_hamburger > div:before,
    #{{uc_id}} .ue_hamburger > div:after {
      content: '';
      position: absolute;
      z-index: 1;
      top: -10px;
      left: 0;
      width: 100%;
      height: 2px;
      background: inherit;
    }

    #{{uc_id}} .ue_hamburger > div:after {
      top: 10px;
    }
  {% endif %}/* end effects == "def" */

{% endif %}


#{{uc_id}} .ue_menu {
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  pointer-events: none;
  visibility: hidden;       
  backface-visibility: hidden;
  outline: none;
  display: flex;
  align-items: center;
  justify-content: center;
}

/* start protection from doubled fixed section in elementor */
.uc-hidden #{{uc_id}} .ue_menu{
   opacity: 0;
   pointer-events: none;
}
.uc-visible #{{uc_id}} .ue_menu{
   opacity: 1;
   pointer-events: all;
}
/* end protection from doubled fixed section in elementor */

#{{uc_id}} .ue_menu .ue_inner_menu {
  color: #fff;
  transition: all 0.4s ease;
  height: 100vh;
  overflow-y: auto;
  overflow-x: hidden;
  display: flex;
}
#{{uc_id}} .ue_inner_menu-box{
  {% if vertical_position == "center" %}
  margin-top: auto;
  {% endif %}	
  margin-bottom: auto;
  width: 100vw;
  flex: none;
  backface-visibility: hidden;
  display: flex;
  flex-direction: column;
  align-items: center;
}
#{{uc_id}} .ue_menu > div > div > div {
  max-width: 90vw;
  width: 100%;
  opacity: 0;
  -webkit-transition: opacity 0.4s ease;
  transition: opacity 0.4s ease;
  overflow-y: auto;
  flex: none;
  display: flex;
  align-items: center;
}
#{{uc_id}} ul:not(#{{uc_id}} section ul) {
  list-style: none;
  margin: 0;
  display: block;
  padding:0px;
}
#{{uc_id}} .ue_menu  div  div  ul li {
  padding: 0;
  display: block;
}
#{{uc_id}} .ue_menu  div  div  ul  li a {
  position: relative;
  display: inline-flex;
  align-items: center;
  cursor: pointer;
  transition: color 0.4s ease;
}

{% if underline_hover_effect == "true" %}
	
#{{uc_id}} .ue_menu  div  div  ul  li a:hover:after {
  width: 100%;
}
#{{uc_id}} .ue_menu  div  div  ul  li  a:after {
  content: '';
  position: absolute;
  z-index: 1;
  bottom: 0;
  left: 0;
  width: 0;
  height: 2px;
  transition: width 0.4s ease;
}

{% endif %}	

.ue_menu_wrapper{
  position:relative;
}

{% if type == "custom" %}
	.ue_hamburger_custom_close    {
      display:none;
    }

	#{{uc_id}} .checkbox-toggle:checked + .ue_hamburger div.ue_hamburger_custom_close {
          display:block;
     }
     
     #{{uc_id}} .checkbox-toggle:checked + .ue_hamburger div.ue_hamburger_custom_open     {
       display:none;
     }

	 #{{uc_id}} input:hover + .ue_hamburger > div      {
        color:{{hamburger_icon_color_hover}};
      }

#{{uc_id}} .ue_hamburger > div {
  color:{{hamburger_icon_color}};
}

{% endif %}


#{{uc_id}} .ue_menu-social-icons a{
  display:inline-block;
  line-height:1em;
}

#{{uc_id}} .ue_menu-social-icons a svg{
  height:1em;
  width:1em;
}

#{{uc_id}} .sub-menu{
transition: 0.5s;
overflow: hidden;
height: auto;
}

{% if (show_expand_collapse_icon) == "true" %}
#{{uc_id}} .collapsed i::before,
#{{uc_id}} .expanded i::before{
    font-weight: 900;
  	font-size: {{expand_collapse_icon_size}}px;
    line-height:1em;
  	display: inline-block;
    vertical-align: middle;
}
#{{uc_id}} .uc-menu-item-pointer{
  	position: absolute;
  	pointer-events: all;
    {% if expand_collapse_icon_position == 'start' %}
       left: -15px; 
  	   transform: translate(-{{expand_collapse_icon_size}}px,0);
    {% else %}
       right: -15px;
  	   transform: translate({{expand_collapse_icon_size}}px,0);
    {% endif %}
}

#{{uc_id}} .uc-menu-item-pointer > *{
  pointer-events: none;
}

#{{uc_id}} .uc-menu-item-pointer svg{
	width: {{expand_collapse_icon_size}}px;
  	height: {{expand_collapse_icon_size}}px;
}
{% endif %}

{% if type == "regular" %}
#{{uc_id}} .ue_hamburger > div, 
#{{uc_id}} .ue_hamburger > div:before, 
#{{uc_id}}  .ue_hamburger > div:after{
 outline: {{icon_thickness}} solid {{hamburger_icon_color}};
}
#{{uc_id}} input:hover + .ue_hamburger > div, 
#{{uc_id}} input:hover + .ue_hamburger > div:before, 
#{{uc_id}} input:hover + .ue_hamburger > div:after{
 outline: {{icon_thickness}} solid {{hamburger_icon_color_hover}};
}
{% endif %}