{{ ucfunc("put_docready_start") }}
  {% if fix_broken_layout == 'true' %} jQuery('#{{uc_id}}').imagesLoaded( function() { {% endif %}
		
   var objCarousel = jQuery('#{{uc_id}}');
    var objClonedItems;
    var g_useFancybox = objCarousel.data("lightbox");
    
    function getUnits(string){
      var units;
      
      if(string.indexOf("px") != -1)
        units = "px";
            
      if(string.indexOf("vh") != -1)
        units = "vh";
      
      if(string.indexOf("rem") != -1)
        units = "rem";
    
      return(units);
    }

    function setImageSize(objImgHeight, sizeRatio, objImg, objItem){

      //check if constant width on mobile is on
      var	dataConstantWidth = objCarousel.data('constant-width');

      if(dataConstantWidth == true && window.matchMedia("(max-width: 767px)").matches == true)
      return(false);
      
      var units = getUnits('{{image_height}}');

      if(window.matchMedia("(max-width: 1024px)").matches == true){
      	objImgHeight = parseInt('{{image_height_tablet}}');
        units = getUnits('{{image_height_tablet}}');
      }      

      if(window.matchMedia("(max-width: 767px)").matches == true){
      	objImgHeight = parseInt('{{image_height_mobile}}'); 
        units = getUnits('{{image_height_mobile}}');
      }

      var objImgWidth = (sizeRatio * objImgHeight).toFixed(2);

      objImg.attr('data-width', objImgWidth);

      objImg.css({'width': '100%', 'height': 'auto'});

      objItem.css({'width': objImgWidth + units});

    }

    function initCarousel(){

      //cloned items fancybox fix
      var objItems = objCarousel.find('.ue-item');      
      var itemsNum = objItems.length;

      //set data index for each origin item
      for(let i=0; i<itemsNum; i++){

        var objItem = objItems.eq(i);
        
        {% if show_item_title_in_lightbox == "true" %}
          var objTitle = objItem.find(".item_title");

          if(objTitle && objTitle.length > 0){
              var titleText = objTitle.text();
              var objLink = objItem.find('.ue-link');
              objLink.attr('data-caption', titleText);
          }
        {% endif %}
        
        objItem.attr('data-fancy-index', i);        
      }

      var imgItem = objCarousel.find('img');

      imgItem.each(function(){

        var objImg = jQuery(this);
        var objItem = objImg.parents('.item');

        var objImgDefaultWidth = parseInt(objImg.attr('width'));
        var objImgDefaultHeight = parseInt(objImg.attr('height'));

        if(!objImgDefaultWidth){
            objImg.css({'width': 'auto'});
            return(true);
        }

        var sizeRatio = objImgDefaultWidth / objImgDefaultHeight;

        var objImgHeight = parseInt('{{image_height}}');

        //set image size
        jQuery(window).on('resize', function(){          
           setImageSize(objImgHeight, sizeRatio, objImg, objItem)        
        });

        setImageSize(objImgHeight, sizeRatio, objImg, objItem)

      });


      objCarousel.owlCarousel({
          margin:{{margin_between_items}},
          loop:{{loop}},
          navText: ["<i class='{{left_arrow}}'></i>","<i class='{{right_arrow}}'></i>"],
          nav: {{show_arrows}},
          rtl: {{rtl}},
          navigation:true,
          autoWidth:true,
          center:{{center}},
          autoplay:{{autoplay}},
          autoplayTimeout:{{autoplay_interval}},
		  autoplayHoverPause:{{autoplay_hover_pause}},
          smartSpeed: {{transition_speed}},     
          slideTransition: "{{slide_transition}}",                    
          responsive: {
            0 : {
                {% if constant_width_on_mobile == 'true' %}
                   autoWidth:false,           
                   items: 1,
                   paddingType: '{{padding_type}}',           
                {% endif %}
                {% if padding_type != "none" %}
                   stagePadding: {{stage_padding}},
                {% endif %}               
            },
            767 : {
                items:4       
            }
          }     
      });

      //wait while carousel init
      setTimeout(function(){

        var g_useFancybox = objCarousel.data("lightbox");

        if(g_useFancybox == false)
        return(false);

        //init fancybox only on non cloned items
        var fancyLink = objCarousel.find(".owl-item:not(.cloned) .ue-link");

        fancyLink.attr("data-fancybox", "gallery")

        fancyLink.fancybox({
            loop: true,
            arrows : true,
            backfocus: false,
            btnTpl: {
              arrowLeft: `<button data-fancybox-prev class="fancybox-button fancybox-button--arrow_left" title="prev">` +
              `<div>{{previous_arrow_icon_html|raw}}</div>` +
              `</button>`,
              arrowRight: `<button data-fancybox-next class="fancybox-button fancybox-button--arrow_right" title="next">` +
              `<div>{{next_arrow_icon_html|raw}}</div>` +
              `</button>`,
            },
            {% if disable_zoom_in_after_lightbox_image_click == "true" %}
              clickContent: "next",
            {% endif %}
        });
        
        //for cloned items find origin items and trigger it
        objClonedItems = objCarousel.find(".owl-item.cloned");

        objClonedItems.on('click', function() {

          var objClonedItem = jQuery(this);
          var objClonedItemChild = objClonedItem.find('.ue-item');
          var clickedDataFancyIndex = objClonedItemChild.data('fancy-index');
          var objOriginItem = objCarousel.find('.owl-item:not(.cloned) [data-fancy-index='+clickedDataFancyIndex+'] .ue-link');
          var objOriginOwlItem = objOriginItem.parent('.owl-item');

          objOriginItem.trigger('click');

          //do nothing with clicked cloned item https://obu.edu/_resources/ldp/galleries/fancybox/
          return(false);

        });

      },400);

      /*
      * use only elementors lightbox
      */
      function openElementorLightboxOnly() {

          var dataUseElementorLightbox = objCarousel.data("use-elementor-lightbox");

          if (dataUseElementorLightbox == false)
          return(true);

          if(g_useFancybox == false)
          return(true);

          setTimeout(function () {

              var objElementorLightBox = jQuery(".elementor-lightbox");

              if (!objElementorLightBox.length)
              return(true);

              var objFancybox = jQuery(".fancybox-container");

              if (!objFancybox.length)
              return(true);

              objFancybox.remove();

              //remove fancy classes from body
              jQuery("body").removeClass("fancybox-active compensate-for-scrollbar");

          }, 10);
      }

      var objLightbox = objCarousel.find(".ue-link");

      objLightbox.on("click", openElementorLightboxOnly);


    }  

    initCarousel();

    {{ucfunc("put_remote_parent_js","objCarousel")}}  

    objCarousel.on("uc_ajax_refreshed",function(){      
          objCarousel.trigger('destroy.owl.carousel');      
          initCarousel();      
    });
        
    {% if fix_broken_layout == 'true' %}});{% endif %}	
{{ ucfunc("put_docready_end") }}