function ueQuantityIncrementButtons(widgetId, addToCartId){  
  
  //classes
  var addedClass, g_classDefaultInput, g_addToCartClass1, g_addToCartClass2, g_widgetClass;
  
  //selectors
  var g_plusSelector, g_minusSelector, g_addToCartSelector1, g_addToCartSelector2, g_addToCartSelector3, g_inputNumberSelector, g_widgetSelector;
  
  //objects
  var g_objButtonsWidget, g_objMessage, g_objInputNumber, g_objFilterableGrid, g_objBody, g_objPlusButton, g_objMinusButton;
  
  //custom attr
  var g_dataQuatity;
  
  //helpers
  var g_productQuantity;
  
  /**
  * find which parent has add to cart btn
  */
  function getProductItemParent(objButton) {
    var objParent = objButton.parent();
  
    while (objParent.length > 0) {
      
      var addToCartNum1 = objParent.find(g_addToCartSelector1).length;
      var addToCartNum2 = objParent.find(g_addToCartSelector2).length;
      var addToCartNum3 = objParent.find(g_addToCartSelector3).length;     
      var objOutOfStock1 = objParent.find(".stock.out-of-stock");
      var objOutOfStock2 = objParent.find(".outofstock");
      
      if(objOutOfStock1 && objOutOfStock1.length > 0 || objOutOfStock2 && objOutOfStock2.length > 0)
        g_objButtonsWidget.hide();

      if (addToCartNum1 > 0) 
        return(objParent); 
      
      if (addToCartNum2 > 0) 
        return(objParent);    
      
      objParent = objParent.parent();
    }
    
    //show error: no "add to cart" button found
    g_objMessage.show();
    
    return(null);
  }
  
  /**
  * get add to cart button
  */
  function getAddToCart(objParentItem){
    var objAddToCartButton = objParentItem.find(g_addToCartSelector1);
    
    if(!objAddToCartButton.length)
      objAddToCartButton = objParentItem.find(g_addToCartSelector2);
    
    if(!objAddToCartButton.length)
      objAddToCartButton = objParentItem.find(g_addToCartSelector3);

    if(!objAddToCartButton.length)
      objAddToCartButton = jQuery(`#${addToCartId}`).find(g_addToCartSelector1);

    if(!objAddToCartButton.length)
      objAddToCartButton = jQuery(`#${addToCartId}`).find(g_addToCartSelector2);

    if(!objAddToCartButton.length)
      objAddToCartButton = jQuery(`#${addToCartId}`).find(g_addToCartSelector3);
    
    return(objAddToCartButton);
  }
  
  /**
  * on plus
  */
  function plusItem(objButton){
    var objParentItem = getProductItemParent(objButton);    
    var objAddToCartButton = getAddToCart(objParentItem);
    
    g_productQuantity++;
    
    g_objInputNumber.val(g_productQuantity);
    
    var objDefaultInput = getDefaultInput();
    
    if(objDefaultInput != false)
      objDefaultInput.val(g_productQuantity);
    
    objAddToCartButton.attr(g_dataQuatity, g_productQuantity); 
    
    g_objMinusButton.prop('disabled', false); 
  } 
  
  /**
  * on minus
  */
  function minusItem(objButton){
    var objParentItem = getProductItemParent(objButton);    
    var objAddToCartButton = getAddToCart(objParentItem);
    
    g_productQuantity--;
    
    if(g_productQuantity <= 0)
      return(true);
    
    g_objInputNumber.val(g_productQuantity);
    
    var objDefaultInput = getDefaultInput();
    
    if(objDefaultInput != false)
      objDefaultInput.val(g_productQuantity)
    
    objAddToCartButton.attr(g_dataQuatity, g_productQuantity);
    
    if(g_productQuantity == 1)
      g_objMinusButton.prop('disabled', true);
  }
  
  /**
  * on quantity input change
  */
  function onQuantityInputChange(objInput){
    var objParentItem = getProductItemParent(objInput);    
    var objAddToCartButton = getAddToCart(objParentItem);   
    
    //get custom value
    g_productQuantity = parseInt(objInput.val());
    
    //update data-quantity attribute
    objAddToCartButton.attr(g_dataQuatity, g_productQuantity); 
    
    //enable click on minus button
    g_objMinusButton.prop('disabled', false); 
    
    var objDefaultInput = getDefaultInput();
    
    if(objDefaultInput != false)
      objDefaultInput.val(g_productQuantity)
    
    if(g_productQuantity <= 1){
      g_objMinusButton.prop('disabled', true);
      
      g_productQuantity = 1;
      
      //update data-quantity attribute
      objAddToCartButton.attr(g_dataQuatity, g_productQuantity); 
      
      inputElement.val(g_productQuantity);
      
      if(objDefaultInput != false)
        objDefaultInput.val(g_productQuantity)
    }      
  }
  
  /**
  * on added to cart body event
  */
  function onAddedToCart(){
    var objParentItem = getProductItemParent(g_objInputNumber);    
    var objAddToCartButton = getAddToCart(objParentItem);
    
    g_productQuantity = 1;
    g_objInputNumber.val(g_productQuantity);
    
    //update data-quantity attribute
    objAddToCartButton.attr(g_dataQuatity, g_productQuantity); 
    
    if(objAddToCartButton.hasClass(addedClass) == true)
      objAddToCartButton.hide();    
    
    var objDefaultInput = getDefaultInput();
    
    if(objDefaultInput != false)
      objDefaultInput.val(g_productQuantity)
  }
  
  /**
  * get default input
  */
  function getDefaultInput(){
    var objParentItem = getProductItemParent(g_objInputNumber);    
    var objAddToCartButton = getAddToCart(objParentItem);
    var objDefaultInput = objAddToCartButton.prev().find("input");
    
    if(!objDefaultInput.length)
      return(false);
    
    // var isDefaultInput = objDefaultInput.hasClass(g_classDefaultInput) == true;
    
    // if(isDefaultInput == false)
    // return(false);
    
    return(objDefaultInput);
  }
  
  /**
  * check if default input is visible
  */
  function hideDefaultInput(){
    var objDefaultInput = getDefaultInput();
    
    if(!objDefaultInput.length)
      return(false);
    
    objDefaultInput.hide();
  }
  
  /**
  * unbind events
  */
  function removeEventHandlers(){
    g_objPlusButton.unbind('click');
    g_objMinusButton.unbind('click');
    g_objInputNumber.unbind('input');
    g_objBody.unbind("added_to_cart", onAddedToCart);
  }
  
  /**
  * reset data-auantity
  */
  function resetDataQuantity(){
    var objParentItem = getProductItemParent(g_objInputNumber);    
    var objAddToCartButton = getAddToCart(objParentItem);
    
    g_productQuantity = 1;
    g_objInputNumber.val(g_productQuantity);
    
    objAddToCartButton.attr(g_dataQuatity, g_productQuantity);
    
    var objDefaultInput = getDefaultInput();
    
    if(objDefaultInput != false)
      objDefaultInput.val(g_productQuantity)
  }
  
  /**
  * init vars
  */
  function initVars(){
    //classes
    addedClass = "added";
    g_classDefaultInput = "wcmmq-qty-input-box";
    
    var plusClass = "ue-count-buttons-plus";
    var minusClass = "ue-count-buttons-minus";
    var inputNumberClass = "ue-count-buttons-input";
    var addToCartClass1 = "add_to_cart_button";
    var addToCartClass2 = "single_add_to_cart_button";    
    var messageClass = "ue-message";
    var filterableGridClass = "uc-filterable-grid";
    
    //custom attr
    g_dataQuatity = "data-quantity";
    
    //selectors
    var messageSelector = "."+messageClass;
    var filterableGridSelector = "."+filterableGridClass;
    
    g_plusSelector = "."+plusClass;
    g_minusSelector = "."+minusClass;
    g_addToCartSelector1 = "."+addToCartClass1;
    g_addToCartSelector2 = "."+addToCartClass2;
    g_addToCartSelector3 = '[name="add-to-cart"]';
    g_inputNumberSelector = "."+inputNumberClass;
    
    //helpers
    g_productQuantity = 1;
    
    //objects    
    g_objButtonsWidget = jQuery("#"+widgetId);  
    g_objMessage = g_objButtonsWidget.find(messageSelector);  
    g_objInputNumber = g_objButtonsWidget.find(g_inputNumberSelector);
    g_objFilterableGrid = g_objButtonsWidget.parents(filterableGridSelector); 
    g_objPlusButton = g_objButtonsWidget.find(g_plusSelector);
    g_objMinusButton = g_objButtonsWidget.find(g_minusSelector);
    g_objBody = jQuery("body"); 
    
    //set 1 as default value in input
    g_objInputNumber.val(g_productQuantity);
    
    //hide default input if exist
    hideDefaultInput();
    
    //reset data-quantity
    resetDataQuantity();
  }
  
  /**
  * init events
  */
  function initEvents(){
    g_objBody.on("added_to_cart", onAddedToCart);
    
    g_objPlusButton.on('click', function(){
      plusItem(jQuery(this));
    });
    
    g_objMinusButton.on('click', function(){
      minusItem(jQuery(this));
    });
    
    g_objInputNumber.on('input', function(){
      onQuantityInputChange(jQuery(this));
    });
  }
  
  /**
  * check if parent grid has filter operates through filters
  */
  function onAjaxRefreshed(){    
    removeEventHandlers();
    //    setTimeout(initQuantityButtons, 500);
  }
  
  /*
  * init buttons
  */
  function initQuantityButtons(){
    //init vars
    initVars();
    
    //init events
    initEvents();       
  }
  
  //init widget
  initQuantityButtons();
  
  if(!g_objFilterableGrid.length)
    return(false);
  
  g_objFilterableGrid.on("uc_ajax_refreshed", onAjaxRefreshed);
  
}